/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project;

import java.util.Iterator;
import net.sourceforge.plantuml.project.GanttDiagram;
import net.sourceforge.plantuml.project.lang.Complement;
import net.sourceforge.plantuml.project.lang.Subject;
import net.sourceforge.plantuml.project.time.Day;

public class DaysAsDates
implements Subject,
Complement,
Iterable<Day> {
    private final Day date1;
    private final Day date2;

    public DaysAsDates(Day date1, Day date2) {
        this.date1 = date1;
        this.date2 = date2;
    }

    public DaysAsDates(GanttDiagram gantt, Day date1, int count) {
        this.date1 = date1;
        Day tmp = date1;
        while (count > 0) {
            if (gantt.isOpen(tmp)) {
                --count;
            }
            tmp = tmp.next();
        }
        this.date2 = tmp;
    }

    @Override
    public Iterator<Day> iterator() {
        return new MyIterator(this.date1);
    }

    class MyIterator
    implements Iterator<Day> {
        private Day current;

        public MyIterator(Day current) {
            this.current = current;
        }

        @Override
        public boolean hasNext() {
            return this.current.compareTo(DaysAsDates.this.date2) <= 0;
        }

        @Override
        public Day next() {
            Day result = this.current;
            this.current = this.current.next();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

