/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.EntityUtils;
import net.sourceforge.plantuml.cucadiagram.GroupHierarchy;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.cucadiagram.SuperGroup;
import net.sourceforge.plantuml.cucadiagram.dot.DotData;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockEmpty;
import net.sourceforge.plantuml.graphic.TextBlockWidth;
import net.sourceforge.plantuml.graphic.TextBlockWidthAdapter;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.svek.CucaDiagramFileMakerSvek2InternalImage;
import net.sourceforge.plantuml.svek.DotMode;
import net.sourceforge.plantuml.svek.GeneralImageBuilder;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.InnerStateAutonom;
import net.sourceforge.plantuml.svek.image.EntityImageState;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public final class GroupPngMakerState {
    private final CucaDiagram diagram;
    private final IGroup group;
    private final StringBounder stringBounder;
    private final Rose rose = new Rose();

    public GroupPngMakerState(CucaDiagram diagram, IGroup group, StringBounder stringBounder) {
        this.diagram = diagram;
        this.stringBounder = stringBounder;
        this.group = group;
        if (!group.isGroup()) {
            throw new IllegalArgumentException();
        }
    }

    private List<Link> getPureInnerLinks() {
        ArrayList<Link> result = new ArrayList<Link>();
        for (Link link : this.diagram.getLinks()) {
            if (!EntityUtils.isPureInnerLink12(this.group, link)) continue;
            result.add(link);
        }
        return result;
    }

    public IEntityImage getImage() {
        Display display = this.group.getDisplay();
        ISkinParam skinParam = this.diagram.getSkinParam();
        TextBlock title = display.create(new FontConfiguration(skinParam, FontParam.STATE, this.group.getStereotype()), HorizontalAlignment.CENTER, this.diagram.getSkinParam());
        if (this.group.size() == 0 && this.group.getChildren().size() == 0) {
            return new EntityImageState(this.group, this.diagram.getSkinParam());
        }
        List<Link> links = this.getPureInnerLinks();
        DotData dotData = new DotData(this.group, links, this.group.getLeafsDirect(), this.diagram.getUmlDiagramType(), skinParam, new InnerGroupHierarchy(), this.diagram.getColorMapper(), this.diagram.getEntityFactory(), this.diagram.isHideEmptyDescriptionForState(), DotMode.NORMAL, this.diagram.getNamespaceSeparator(), this.diagram.getPragma());
        GeneralImageBuilder svek2 = new GeneralImageBuilder(false, dotData, this.diagram.getEntityFactory(), this.diagram.getSource(), this.diagram.getPragma(), this.stringBounder, SName.stateDiagram);
        if (this.group.getGroupType() == GroupType.CONCURRENT_STATE) {
            return svek2.buildImage(null, new String[0]);
        }
        if (this.group.getGroupType() != GroupType.STATE) {
            throw new UnsupportedOperationException(this.group.getGroupType().toString());
        }
        HColor borderColor = this.group.getColors(skinParam).getColor(ColorType.LINE);
        if (borderColor == null) {
            borderColor = this.getColor(ColorParam.stateBorder, this.group.getStereotype());
        }
        Stereotype stereo = this.group.getStereotype();
        HColor backColor = this.group.getColors(skinParam).getColor(ColorType.BACK) == null ? this.getColor(ColorParam.stateBackground, stereo) : this.group.getColors(skinParam).getColor(ColorType.BACK);
        TextBlockWidth attribute = this.getAttributes(skinParam);
        Stereotype stereotype = this.group.getStereotype();
        boolean withSymbol = stereotype != null && stereotype.isWithOOSymbol();
        boolean containsOnlyConcurrentStates = this.containsOnlyConcurrentStates(dotData);
        IEntityImage image = containsOnlyConcurrentStates ? this.buildImageForConcurrentState(dotData) : svek2.buildImage(null, new String[0]);
        UStroke stroke = this.group.getColors(skinParam).getSpecificLineStroke();
        if (stroke == null) {
            stroke = new UStroke(1.5);
        }
        return new InnerStateAutonom(image, title, attribute, borderColor, backColor, skinParam.shadowing(this.group.getStereotype()), this.group.getUrl99(), withSymbol, stroke);
    }

    private TextBlockWidth getAttributes(ISkinParam skinParam) {
        List<String> details = this.group.getBodier().getRawBody();
        if (details.size() == 0) {
            return new TextBlockEmpty();
        }
        FontConfiguration fontConfiguration = new FontConfiguration(skinParam, FontParam.STATE_ATTRIBUTE, null);
        Display display = null;
        for (String s : details) {
            if (display == null) {
                display = Display.getWithNewlines(s);
                continue;
            }
            display = display.addAll(Display.getWithNewlines(s));
        }
        TextBlock result = display.create(fontConfiguration, HorizontalAlignment.LEFT, skinParam);
        return new TextBlockWidthAdapter(result, 0.0);
    }

    private IEntityImage buildImageForConcurrentState(DotData dotData) {
        ArrayList<IEntityImage> inners = new ArrayList<IEntityImage>();
        for (ILeaf inner : dotData.getLeafs()) {
            inners.add(inner.getSvekImage());
        }
        return new CucaDiagramFileMakerSvek2InternalImage(inners, dotData.getTopParent().getConcurrentSeparator(), dotData.getSkinParam(), this.group.getStereotype());
    }

    private boolean containsOnlyConcurrentStates(DotData dotData) {
        for (ILeaf leaf : dotData.getLeafs()) {
            if (!(leaf instanceof IGroup)) {
                return false;
            }
            if (((IGroup)((Object)leaf)).getLeafType() == LeafType.STATE_CONCURRENT) continue;
            return false;
        }
        return true;
    }

    private HColor getColor(ColorParam colorParam, Stereotype stereo) {
        ISkinParam skinParam = this.diagram.getSkinParam();
        return this.rose.getHtmlColor(skinParam, stereo, colorParam);
    }

    class InnerGroupHierarchy
    implements GroupHierarchy {
        InnerGroupHierarchy() {
        }

        @Override
        public Set<SuperGroup> getAllSuperGroups() {
            throw new UnsupportedOperationException();
        }

        @Override
        public IGroup getRootGroup() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SuperGroup getRootSuperGroup() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Collection<IGroup> getChildrenGroups(IGroup parent) {
            if (EntityUtils.groupRoot(parent)) {
                return GroupPngMakerState.this.diagram.getChildrenGroups(GroupPngMakerState.this.group);
            }
            return GroupPngMakerState.this.diagram.getChildrenGroups(parent);
        }

        @Override
        public boolean isEmpty(IGroup g) {
            return GroupPngMakerState.this.diagram.isEmpty(g);
        }
    }
}

