/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.wire;

import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOptional;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.wire.WireDiagram;

public class CommandComponent
extends SingleLineCommand2<WireDiagram> {
    public CommandComponent() {
        super(false, CommandComponent.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandComponent.class.getName(), RegexLeaf.start(), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("TYPE", "component"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("NAME", "([\\w]+)"), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceOneOrMore(), new RegexLeaf("\\["), new RegexLeaf("WIDTH", "([\\d]+)"), new RegexLeaf("[x*]"), new RegexLeaf("HEIGHT", "([\\d]+)"), new RegexLeaf("\\]"))), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(WireDiagram diagram, LineLocation location, RegexResult arg) {
        String name = arg.get("NAME", 0);
        String width = arg.get("WIDTH", 0);
        String height = arg.get("HEIGHT", 0);
        if (width != null) {
            return diagram.addComponent(name, Integer.parseInt(width), Integer.parseInt(height));
        }
        return diagram.addComponent(name);
    }
}

