/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.io.export.api;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import org.openide.NotificationLineSupport;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.util.ImageUtilities;
import org.openide.util.Utilities;

class TopDialog
extends JDialog {
    final NotifyDescriptor nd;
    private Component messageComponent;
    private final JPanel buttonPanel;
    private final Object[] closingOptions;
    private final ActionListener buttonListener;
    private boolean haveFinalValue = false;
    private Color nbErrorForeground;
    private Color nbWarningForeground;
    private Color nbInfoForeground;
    private JLabel notificationLine;
    private static final int MSG_TYPE_ERROR = 1;
    private static final int MSG_TYPE_WARNING = 2;
    private static final int MSG_TYPE_INFO = 3;

    protected TopDialog(JDialog parent, String title, boolean modal, NotifyDescriptor nd, Object[] closingOptions, ActionListener buttonListener) {
        super(parent, title, modal);
        this.nd = nd;
        this.closingOptions = closingOptions;
        this.buttonListener = buttonListener;
        this.getContentPane().setLayout(new BorderLayout());
        this.setDefaultCloseOperation(2);
        this.updateMessage();
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new FlowLayout(2));
        this.updateOptions();
        this.getContentPane().add(this.buttonPanel, "South", 1);
        KeyStroke k = KeyStroke.getKeyStroke(27, 0);
        String actionKey = "cancel";
        this.getRootPane().getInputMap(1).put(k, actionKey);
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                TopDialog.this.cancel();
            }
        };
        this.getRootPane().getActionMap().put(actionKey, cancelAction);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent ev) {
                if (!TopDialog.this.haveFinalValue) {
                    TopDialog.this.nd.setValue(NotifyDescriptor.CLOSED_OPTION);
                }
            }
        });
        this.pack();
        Rectangle r = Utilities.getUsableScreenBounds();
        int maxW = r.width * 9 / 10;
        int maxH = r.height * 9 / 10;
        Dimension d = this.getPreferredSize();
        d.width = Math.min(d.width, maxW);
        d.height = Math.min(d.height, maxH);
        this.setBounds(Utilities.findCenterBounds((Dimension)d));
    }

    private void cancel() {
        this.nd.setValue(NotifyDescriptor.CANCEL_OPTION);
        this.haveFinalValue = true;
        this.dispose();
    }

    public void updateMessage() {
        if (this.messageComponent != null) {
            this.getContentPane().remove(this.messageComponent);
        }
        this.messageComponent = TopDialog.message2Component(this.nd.getMessage());
        if (!(this.nd instanceof WizardDescriptor) && this.nd.getNotificationLineSupport() != null) {
            JPanel toAdd = new JPanel(new BorderLayout());
            toAdd.add(this.messageComponent, "Center");
            this.nbErrorForeground = UIManager.getColor("nb.errorForeground");
            if (this.nbErrorForeground == null) {
                this.nbErrorForeground = new Color(255, 0, 0);
            }
            this.nbWarningForeground = UIManager.getColor("nb.warningForeground");
            if (this.nbWarningForeground == null) {
                this.nbWarningForeground = new Color(51, 51, 51);
            }
            this.nbInfoForeground = UIManager.getColor("nb.warningForeground");
            if (this.nbInfoForeground == null) {
                this.nbInfoForeground = UIManager.getColor("Label.foreground");
            }
            this.notificationLine = new FixedHeightLabel();
            NotificationLineSupport nls = this.nd.getNotificationLineSupport();
            if (nls.getInformationMessage() != null) {
                TopDialog.updateNotificationLine(this, 3, nls.getInformationMessage());
            } else if (nls.getWarningMessage() != null) {
                TopDialog.updateNotificationLine(this, 2, nls.getWarningMessage());
            } else if (nls.getErrorMessage() != null) {
                TopDialog.updateNotificationLine(this, 1, nls.getErrorMessage());
            }
            toAdd.add((Component)this.notificationLine, "South");
            this.messageComponent = toAdd;
        }
        this.getContentPane().add(this.messageComponent, "Center");
    }

    public void updateOptions() {
        int i;
        HashSet<Object> addedOptions = new HashSet<Object>(5);
        Object[] options = this.nd.getOptions();
        if (options == null) {
            switch (this.nd.getOptionType()) {
                case -1: 
                case 2: {
                    options = new Object[]{NotifyDescriptor.OK_OPTION, NotifyDescriptor.CANCEL_OPTION};
                    break;
                }
                case 0: {
                    options = new Object[]{NotifyDescriptor.YES_OPTION, NotifyDescriptor.NO_OPTION};
                    break;
                }
                case 1: {
                    options = new Object[]{NotifyDescriptor.YES_OPTION, NotifyDescriptor.NO_OPTION, NotifyDescriptor.CANCEL_OPTION};
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        this.buttonPanel.removeAll();
        JRootPane rp = this.getRootPane();
        for (i = 0; i < options.length; ++i) {
            addedOptions.add(options[i]);
            this.buttonPanel.add(TopDialog.option2Button(options[i], this.nd, this.makeListener(options[i]), rp));
        }
        options = this.nd.getAdditionalOptions();
        if (options != null) {
            for (i = 0; i < options.length; ++i) {
                addedOptions.add(options[i]);
                this.buttonPanel.add(TopDialog.option2Button(options[i], this.nd, this.makeListener(options[i]), rp));
            }
        }
        if (this.closingOptions != null) {
            for (i = 0; i < this.closingOptions.length; ++i) {
                if (!addedOptions.add(this.closingOptions[i])) continue;
                ActionListener l = this.makeListener(this.closingOptions[i]);
                this.attachActionListener(this.closingOptions[i], l);
            }
        }
    }

    private void attachActionListener(Object comp, ActionListener l) {
        Method m;
        if (comp instanceof JButton) {
            JButton b = (JButton)comp;
            b.addActionListener(l);
            return;
        }
        try {
            m = comp.getClass().getMethod("addActionListener", ActionListener.class);
            try {
                m.setAccessible(true);
            }
            catch (SecurityException se) {
                m = null;
            }
        }
        catch (NoSuchMethodException e) {
            m = null;
        }
        catch (SecurityException e2) {
            m = null;
        }
        if (m != null) {
            try {
                m.invoke(comp, l);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private ActionListener makeListener(final Object option) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TopDialog.this.nd.setValue(option);
                if (TopDialog.this.buttonListener != null) {
                    ActionEvent e2 = new ActionEvent(option, e.getID(), e.getActionCommand(), e.getWhen(), e.getModifiers());
                    TopDialog.this.buttonListener.actionPerformed(e2);
                }
                if (TopDialog.this.closingOptions == null || Arrays.asList(TopDialog.this.closingOptions).contains(option)) {
                    TopDialog.this.haveFinalValue = true;
                    TopDialog.this.setVisible(false);
                }
            }
        };
    }

    private static void updateNotificationLine(TopDialog dialog, int msgType, Object o) {
        String msg;
        String string = msg = o == null ? null : o.toString();
        if (msg != null && msg.trim().length() > 0) {
            switch (msgType) {
                case 1: {
                    TopDialog.prepareMessage(dialog.notificationLine, ImageUtilities.loadImageIcon((String)"org/netbeans/modules/dialogs/error.gif", (boolean)false), dialog.nbErrorForeground);
                    break;
                }
                case 2: {
                    TopDialog.prepareMessage(dialog.notificationLine, ImageUtilities.loadImageIcon((String)"org/netbeans/modules/dialogs/warning.gif", (boolean)false), dialog.nbWarningForeground);
                    break;
                }
                case 3: {
                    TopDialog.prepareMessage(dialog.notificationLine, ImageUtilities.loadImageIcon((String)"org/netbeans/modules/dialogs/info.png", (boolean)false), dialog.nbInfoForeground);
                    break;
                }
            }
            dialog.notificationLine.setToolTipText(msg);
        } else {
            TopDialog.prepareMessage(dialog.notificationLine, null, null);
            dialog.notificationLine.setToolTipText(null);
        }
        dialog.notificationLine.setText(msg);
    }

    private static void prepareMessage(JLabel label, ImageIcon icon, Color fgColor) {
        label.setIcon(icon);
        label.setForeground(fgColor);
    }

    private static Component message2Component(Object message) {
        if (message instanceof Component) {
            return (Component)message;
        }
        if (message instanceof Object[]) {
            Object[] sub = (Object[])message;
            JPanel panel = new JPanel();
            panel.setLayout(new FlowLayout());
            for (int i = 0; i < sub.length; ++i) {
                panel.add(TopDialog.message2Component(sub[i]));
            }
            return panel;
        }
        if (message instanceof Icon) {
            return new JLabel((Icon)message);
        }
        String text = message.toString();
        JTextArea area = new JTextArea(text);
        Color c = UIManager.getColor("Label.background");
        if (c != null) {
            area.setBackground(c);
        }
        area.setLineWrap(true);
        area.setWrapStyleWord(true);
        area.setEditable(false);
        area.setTabSize(4);
        area.setColumns(40);
        if (text.indexOf(10) != -1) {
            return new JScrollPane(area);
        }
        return area;
    }

    private static Component option2Button(Object option, NotifyDescriptor nd, ActionListener l, JRootPane rp) {
        boolean defcap;
        String text;
        if (option instanceof AbstractButton) {
            AbstractButton b = (AbstractButton)option;
            b.addActionListener(l);
            return b;
        }
        if (option instanceof Component) {
            return (Component)option;
        }
        if (option instanceof Icon) {
            return new JLabel((Icon)option);
        }
        if (option == NotifyDescriptor.OK_OPTION) {
            text = "OK";
            defcap = true;
        } else if (option == NotifyDescriptor.CANCEL_OPTION) {
            text = "Cancel";
            defcap = false;
        } else if (option == NotifyDescriptor.YES_OPTION) {
            text = "Yes";
            defcap = true;
        } else if (option == NotifyDescriptor.NO_OPTION) {
            text = "No";
            defcap = false;
        } else {
            if (option == NotifyDescriptor.CLOSED_OPTION) {
                throw new IllegalArgumentException();
            }
            text = option.toString();
            defcap = false;
        }
        JButton b = new JButton(text);
        if (defcap && rp.getDefaultButton() == null) {
            rp.setDefaultButton(b);
        }
        b.getAccessibleContext().setAccessibleName(text);
        b.addActionListener(l);
        return b;
    }

    private static final class FixedHeightLabel
    extends JLabel {
        private static final int ESTIMATED_HEIGHT = 16;

        @Override
        public Dimension getPreferredSize() {
            Dimension preferredSize = super.getPreferredSize();
            assert (16 == ImageUtilities.loadImage((String)"org/netbeans/modules/dialogs/warning.gif").getHeight(null)) : "Use only 16px icon.";
            preferredSize.height = Math.max(16, preferredSize.height);
            return preferredSize;
        }
    }
}

