/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channel;
import jnr.posix.FileStat;
import jnr.posix.POSIX;
import org.jruby.util.JRubyFile;
import org.jruby.util.RegularFileResource;
import org.jruby.util.ResourceException;
import org.jruby.util.io.ModeFlags;

public interface FileResource {
    public static FileResource wrap(POSIX posix, JRubyFile file2) {
        return new RegularFileResource(posix, file2, file2.getPathDefault());
    }

    public String absolutePath();

    public String canonicalPath();

    public boolean exists();

    public boolean isDirectory();

    public boolean isFile();

    public boolean canExecute();

    public int errno();

    public long lastModified();

    public long length();

    public boolean canRead();

    public boolean canWrite();

    default public boolean isNull() {
        return false;
    }

    public String[] list();

    public boolean isSymLink();

    public FileStat stat();

    public FileStat lstat();

    public <T> T unwrap(Class<T> var1) throws UnsupportedOperationException;

    @Deprecated
    default public JRubyFile hackyGetJRubyFile() {
        try {
            return this.unwrap(JRubyFile.class);
        }
        catch (UnsupportedOperationException ex) {
            return JRubyFile.DUMMY;
        }
    }

    default public InputStream inputStream() throws ResourceException {
        if (!this.exists()) {
            throw new ResourceException.NotFound(this.absolutePath());
        }
        if (this.isDirectory()) {
            throw new ResourceException.FileIsDirectory(this.absolutePath());
        }
        try {
            return this.openInputStream();
        }
        catch (IOException e) {
            throw new ResourceException.IOError(e);
        }
    }

    public InputStream openInputStream() throws IOException;

    default public Channel openChannel(ModeFlags flags2, int perm) throws ResourceException {
        try {
            return this.openChannel(flags2.getFlags(), perm);
        }
        catch (ResourceException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw new ResourceException.IOError(ex);
        }
    }

    public Channel openChannel(int var1, int var2) throws IOException;
}

