<h1><span><img src="https://github.com/RubixML/RubixML/blob/master/docs/img/rubix-ml-logo.png?raw=true" width="50" height="50" alt="Rubix ML logo" /></span> <span>Rubix ML: Machine Learning for PHP</span></h1>

[![PHP from Packagist](https://img.shields.io/packagist/php-v/rubix/ml.svg?style=flat-square&colorB=8892BF)](https://www.php.net/) [![Latest Stable Version](https://img.shields.io/packagist/v/rubix/ml.svg?style=flat-square&colorB=orange)](https://packagist.org/packages/rubix/ml) [![Downloads from Packagist](https://img.shields.io/packagist/dt/rubix/ml.svg?style=flat-square&colorB=red)](https://packagist.org/packages/rubix/ml) [![Travis](https://img.shields.io/travis/RubixML/RubixML.svg?style=flat-square)](https://travis-ci.org/RubixML/RubixML) [![Documentation Status](https://img.shields.io/readthedocs/rubix-ml.svg?style=flat-square&colorB=blue)](https://rubix-ml.readthedocs.io/en/latest/?badge=latest)

A high-level machine learning and deep learning library for the [PHP](https://php.net) language.

- **Developer-friendly** API is easy and delightful to use
- **Modular** architecture combines power, flexibility, and extensibility
- **40+** modern supervised and unsupervised learning algorithms
- **Open source** and free to use commercially

## Installation
Install Rubix ML into your project using [Composer](https://getcomposer.org/):
```sh
$ composer require rubix/ml
```

### Requirements
- [PHP](https://php.net/manual/en/install.php) 7.2 or above

#### Optional

- [Tensor extension](https://github.com/RubixML/Tensor) for fast Matrix/Vector computing
- [SVM extension](https://php.net/manual/en/book.svm.php) for Support Vector Machine engine (libsvm)
- [GD extension](https://php.net/manual/en/book.image.php) for image manipulation
- [Redis extension](https://github.com/phpredis/phpredis) for persisting to a Redis DB
- [Igbinary extension](https://github.com/igbinary/igbinary) for binary serialization of persistables

## Documentation
Read the latest docs [here](https://docs.rubixml.com).

## What is Rubix ML?
Rubix ML is a free open-source library for the PHP language that allows you to build programs that learn from your data. We provide tools for the entire machine learning life cycle from ETL to training, validation, and production with over 40 supervised and unsupervised learning algorithms.

## Getting Started
If you are new to machine learning, we recommend the section [What is Machine Learning?](https://docs.rubixml.com/en/latest/what-is-machine-learning.html) to get started. If you are already familiar with basic ML concepts, you can browse the [basic introduction](https://docs.rubixml.com/en/latest/basic-introduction.html) for a brief look at a typical Rubix ML project. From there, you can browse the official tutorials below which range from beginner to advanced skill level.

### Tutorials & Example Projects
Check out these example projects using the Rubix ML library. Most come with instructions and a pre-cleaned dataset.

- [CIFAR-10 Image Recognizer](https://github.com/RubixML/CIFAR-10)
- [Color Clusterer](https://github.com/RubixML/Colors)
- [Credit Default Risk Predictor](https://github.com/RubixML/Credit)
- [Divorce Predictor](https://github.com/RubixML/Divorce)
- [Dota 2 Game Outcome Predictor](https://github.com/RubixML/Dota2)
- [Human Activity Recognizer](https://github.com/RubixML/HAR)
- [Housing Price Predictor](https://github.com/RubixML/Housing)
- [Iris Flower Classifier](https://github.com/RubixML/Iris)
- [MNIST Handwritten Digit Recognizer](https://github.com/RubixML/MNIST)
- [Text Sentiment Analyzer](https://github.com/RubixML/Sentiment)

## Funding
Rubix ML is funded entirely by donations from supporters. You can become a patron by making a contribution to one of our funding sources below.

- [Patreon](https://www.patreon.com/rubixml)

## Contributors
[![](https://sourcerer.io/fame/andrewdalpino/RubixML/RubixML/images/0)](https://sourcerer.io/fame/andrewdalpino/RubixML/RubixML/links/0)[![](https://sourcerer.io/fame/andrewdalpino/RubixML/RubixML/images/1)](https://sourcerer.io/fame/andrewdalpino/RubixML/RubixML/links/1)[![](https://sourcerer.io/fame/andrewdalpino/RubixML/RubixML/images/2)](https://sourcerer.io/fame/andrewdalpino/RubixML/RubixML/links/2)[![](https://sourcerer.io/fame/andrewdalpino/RubixML/RubixML/images/3)](https://sourcerer.io/fame/andrewdalpino/RubixML/RubixML/links/3)[![](https://sourcerer.io/fame/andrewdalpino/RubixML/RubixML/images/4)](https://sourcerer.io/fame/andrewdalpino/RubixML/RubixML/links/4)[![](https://sourcerer.io/fame/andrewdalpino/RubixML/RubixML/images/5)](https://sourcerer.io/fame/andrewdalpino/RubixML/RubixML/links/5)[![](https://sourcerer.io/fame/andrewdalpino/RubixML/RubixML/images/6)](https://sourcerer.io/fame/andrewdalpino/RubixML/RubixML/links/6)[![](https://sourcerer.io/fame/andrewdalpino/RubixML/RubixML/images/7)](https://sourcerer.io/fame/andrewdalpino/RubixML/RubixML/links/7)

## Contributing
See [CONTRIBUTING.md](https://github.com/RubixML/RubixML/blob/master/CONTRIBUTING.md) for guidelines.

## License
[MIT](https://github.com/RubixML/RubixML/blob/master/LICENSE.md)
