/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.osm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import net.osmand.osm.MapPoiTypes;
import net.osmand.osm.PoiCategory;
import net.osmand.osm.PoiType;

public abstract class AbstractPoiType {
    protected final String keyName;
    protected final MapPoiTypes registry;
    private List<PoiType> poiAdditionals = null;
    private boolean topVisible;
    private String lang;
    private AbstractPoiType baseLangType;
    private boolean notEditableOsm;

    public AbstractPoiType(String keyName, MapPoiTypes registry) {
        this.keyName = keyName;
        this.registry = registry;
    }

    public void setBaseLangType(AbstractPoiType baseLangType) {
        this.baseLangType = baseLangType;
    }

    public AbstractPoiType getBaseLangType() {
        return this.baseLangType;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public String getLang() {
        return this.lang;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public String getIconKeyName() {
        return this.getKeyName().replace(':', '_');
    }

    public void setTopVisible(boolean topVisible) {
        this.topVisible = topVisible;
    }

    public boolean isTopVisible() {
        return this.topVisible;
    }

    public boolean isAdditional() {
        return this instanceof PoiType && ((PoiType)this).isAdditional();
    }

    public String getTranslation() {
        return this.registry.getTranslation(this);
    }

    public void addPoiAdditional(PoiType tp) {
        if (this.poiAdditionals == null) {
            this.poiAdditionals = new ArrayList<PoiType>();
        }
        this.poiAdditionals.add(tp);
    }

    public List<PoiType> getPoiAdditionals() {
        if (this.poiAdditionals == null) {
            return Collections.emptyList();
        }
        return this.poiAdditionals;
    }

    public boolean isNotEditableOsm() {
        return this.notEditableOsm;
    }

    public void setNotEditableOsm(boolean notEditableOsm) {
        this.notEditableOsm = notEditableOsm;
    }

    public abstract Map<PoiCategory, LinkedHashSet<String>> putTypes(Map<PoiCategory, LinkedHashSet<String>> var1);
}

