/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.plus.resources;

import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.osmand.PlatformUtil;
import net.osmand.ResultMatcher;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.data.LatLon;
import net.osmand.data.TransportRoute;
import net.osmand.data.TransportStop;
import net.osmand.plus.resources.TransportIndexRepository;
import net.osmand.util.MapUtils;
import org.apache.commons.logging.Log;

public class TransportIndexRepositoryBinary
implements TransportIndexRepository {
    private static final Log log = PlatformUtil.getLog(TransportIndexRepositoryBinary.class);
    private final BinaryMapIndexReader file;
    protected List<TransportStop> cachedObjects = new ArrayList<TransportStop>();
    protected double cTopLatitude;
    protected double cBottomLatitude;
    protected double cLeftLongitude;
    protected double cRightLongitude;
    private int cZoom;

    public TransportIndexRepositoryBinary(BinaryMapIndexReader file) {
        this.file = file;
    }

    @Override
    public boolean checkContains(double latitude, double longitude) {
        return this.file.containTransportData(latitude, longitude);
    }

    @Override
    public boolean checkContains(double topLatitude, double leftLongitude, double bottomLatitude, double rightLongitude) {
        return this.file.containTransportData(topLatitude, leftLongitude, bottomLatitude, rightLongitude);
    }

    @Override
    public boolean checkCachedObjects(double topLatitude, double leftLongitude, double bottomLatitude, double rightLongitude, int zoom, List<TransportStop> toFill) {
        return this.checkCachedObjects(topLatitude, leftLongitude, bottomLatitude, rightLongitude, zoom, toFill, false);
    }

    @Override
    public synchronized boolean checkCachedObjects(double topLatitude, double leftLongitude, double bottomLatitude, double rightLongitude, int zoom, List<TransportStop> toFill, boolean fillFound) {
        boolean inside;
        boolean noNeedToSearch = inside = this.cTopLatitude >= topLatitude && this.cLeftLongitude <= leftLongitude && this.cRightLongitude >= rightLongitude && this.cBottomLatitude <= bottomLatitude && this.cZoom == zoom;
        if ((inside || fillFound) && toFill != null) {
            for (TransportStop a : this.cachedObjects) {
                LatLon location = a.getLocation();
                if (!(location.getLatitude() <= topLatitude) || !(location.getLongitude() >= leftLongitude) || !(location.getLongitude() <= rightLongitude) || !(location.getLatitude() >= bottomLatitude)) continue;
                toFill.add(a);
            }
        }
        return noNeedToSearch;
    }

    public List<TransportStop> searchTransportStops(double topLatitude, double leftLongitude, double bottomLatitude, double rightLongitude, int limit, List<TransportStop> stops, ResultMatcher<TransportStop> matcher) {
        long now = System.currentTimeMillis();
        try {
            this.file.searchTransportIndex(BinaryMapIndexReader.buildSearchTransportRequest(MapUtils.get31TileNumberX(leftLongitude), MapUtils.get31TileNumberX(rightLongitude), MapUtils.get31TileNumberY(topLatitude), MapUtils.get31TileNumberY(bottomLatitude), limit, stops));
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Search for %s done in %s ms found %s.", topLatitude + " " + leftLongitude, System.currentTimeMillis() - now, stops.size()));
            }
        }
        catch (IOException e) {
            log.error((Object)"Disk error ", (Throwable)e);
        }
        return stops;
    }

    @Override
    public List<String> getRouteDescriptionsForStop(TransportStop stop, String format) {
        assert (this.acceptTransportStop(stop));
        long now = System.currentTimeMillis();
        MessageFormat f = new MessageFormat(format);
        ArrayList<String> res = new ArrayList<String>();
        try {
            List<TransportRoute> routes = this.file.getTransportRouteDescriptions(stop);
            if (routes != null) {
                for (TransportRoute route : routes) {
                    res.add(f.format(new String[]{route.getRef() + "", route.getType() + "", route.getName() + "", route.getEnName(true) + ""}));
                }
            }
        }
        catch (IOException e) {
            log.error((Object)"Disk error ", (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Search for stop %s done in %s ms found %s.", stop.getId() + "", System.currentTimeMillis() - now, res.size()));
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evaluateCachedTransportStops(double topLatitude, double leftLongitude, double bottomLatitude, double rightLongitude, int zoom, int limit, ResultMatcher<TransportStop> matcher) {
        this.cTopLatitude = topLatitude;
        this.cBottomLatitude = bottomLatitude;
        this.cLeftLongitude = leftLongitude;
        this.cRightLongitude = rightLongitude;
        this.cZoom = zoom;
        ArrayList<TransportStop> tempList = new ArrayList<TransportStop>();
        this.searchTransportStops(this.cTopLatitude, this.cLeftLongitude, this.cBottomLatitude, this.cRightLongitude, limit, tempList, matcher);
        TransportIndexRepositoryBinary transportIndexRepositoryBinary = this;
        synchronized (transportIndexRepositoryBinary) {
            this.cachedObjects.clear();
            this.cachedObjects.addAll(tempList);
        }
    }

    @Override
    public List<TransportIndexRepository.RouteInfoLocation> searchTransportRouteStops(double latitude, double longitude, LatLon locationToGo, int zoom) {
        long now = System.currentTimeMillis();
        final LatLon loc = new LatLon(latitude, longitude);
        double tileNumberX = MapUtils.getTileNumberX(zoom, longitude);
        double tileNumberY = MapUtils.getTileNumberY(zoom, latitude);
        double topLatitude = MapUtils.getLatitudeFromTile(zoom, tileNumberY - 0.5);
        double bottomLatitude = MapUtils.getLatitudeFromTile(zoom, tileNumberY + 0.5);
        double leftLongitude = MapUtils.getLongitudeFromTile(zoom, tileNumberX - 0.5);
        double rightLongitude = MapUtils.getLongitudeFromTile(zoom, tileNumberX + 0.5);
        BinaryMapIndexReader.SearchRequest<TransportStop> req = BinaryMapIndexReader.buildSearchTransportRequest(MapUtils.get31TileNumberX(leftLongitude), MapUtils.get31TileNumberX(rightLongitude), MapUtils.get31TileNumberY(topLatitude), MapUtils.get31TileNumberY(bottomLatitude), -1, null);
        ArrayList<TransportIndexRepository.RouteInfoLocation> listRoutes = new ArrayList<TransportIndexRepository.RouteInfoLocation>();
        try {
            List<TransportStop> stops = this.file.searchTransportIndex(req);
            TIntObjectHashMap stopsToProcess = new TIntObjectHashMap();
            for (TransportStop s : stops) {
                int[] nArray = s.getReferencesToRoutes();
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int ref = nArray[i];
                    TransportStop exist = (TransportStop)stopsToProcess.get(ref);
                    if (exist != null && !(MapUtils.getDistance(loc, s.getLocation()) < MapUtils.getDistance(loc, exist.getLocation()))) continue;
                    stopsToProcess.put(ref, (Object)s);
                }
            }
            TIntObjectHashMap<TransportRoute> transportRoutes = this.file.getTransportRoutes(stopsToProcess.keys());
            for (int ref : stopsToProcess.keys()) {
                TransportRoute route = (TransportRoute)transportRoutes.get(ref);
                TransportStop s = (TransportStop)stopsToProcess.get(ref);
                for (int i = 0; i < 2; ++i) {
                    List<TransportStop> stps;
                    boolean direction = i == 0;
                    List<TransportStop> list = stps = direction ? route.getForwardStops() : route.getBackwardStops();
                    while (!stps.isEmpty() && stps.get(0).getId().longValue() != s.getId().longValue()) {
                        stps.remove(0);
                    }
                    if (stps.isEmpty()) continue;
                    TransportIndexRepository.RouteInfoLocation r = new TransportIndexRepository.RouteInfoLocation();
                    r.setRoute(route);
                    r.setStart(stps.get(0));
                    r.setDirection(direction);
                    if (locationToGo != null) {
                        int distToLoc = Integer.MAX_VALUE;
                        for (TransportStop st : stps) {
                            double ndist = MapUtils.getDistance(locationToGo, st.getLocation());
                            if (!(ndist < (double)distToLoc)) continue;
                            distToLoc = (int)ndist;
                            r.setStop(st);
                            r.setDistToLocation(distToLoc);
                        }
                    }
                    listRoutes.add(r);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Search for routes done in %s ms found %s.", System.currentTimeMillis() - now, listRoutes.size()));
            }
            if (locationToGo != null) {
                Collections.sort(listRoutes, new Comparator<TransportIndexRepository.RouteInfoLocation>(){

                    @Override
                    public int compare(TransportIndexRepository.RouteInfoLocation object1, TransportIndexRepository.RouteInfoLocation object2) {
                        int x = (int)(MapUtils.getDistance(loc, object1.getStart().getLocation()) + (double)object1.getDistToLocation());
                        int y = (int)(MapUtils.getDistance(loc, object2.getStart().getLocation()) + (double)object2.getDistToLocation());
                        return x - y;
                    }
                });
            } else {
                Collections.sort(listRoutes, new Comparator<TransportIndexRepository.RouteInfoLocation>(){

                    @Override
                    public int compare(TransportIndexRepository.RouteInfoLocation object1, TransportIndexRepository.RouteInfoLocation object2) {
                        return Double.compare(MapUtils.getDistance(loc, object1.getStart().getLocation()), MapUtils.getDistance(loc, object2.getStart().getLocation()));
                    }
                });
            }
        }
        catch (IOException e) {
            log.error((Object)"Disk error", (Throwable)e);
        }
        return listRoutes;
    }

    @Override
    public boolean acceptTransportStop(TransportStop stop) {
        return this.file.transportStopBelongsTo(stop);
    }

    @Override
    public void close() {
        try {
            this.file.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

