/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.router;

import gnu.trove.iterator.TIntObjectIterator;
import gnu.trove.iterator.TLongIterator;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import gnu.trove.set.hash.TLongHashSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.osmand.PlatformUtil;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.binary.BinaryMapRouteReaderAdapter;
import net.osmand.binary.RouteDataObject;
import net.osmand.router.BinaryRoutePlanner;
import net.osmand.router.GeneralRouter;
import net.osmand.router.PrecalculatedRouteDirection;
import net.osmand.router.RouteCalculationProgress;
import net.osmand.router.RoutePlannerFrontEnd;
import net.osmand.router.RouteSegmentResult;
import net.osmand.router.RoutingConfiguration;
import net.osmand.router.VehicleRouter;
import org.apache.commons.logging.Log;

public class RoutingContext {
    public static final boolean SHOW_GC_SIZE = false;
    private static final Log log = PlatformUtil.getLog(RoutingContext.class);
    public static final int OPTION_NO_LOAD = 0;
    public static final int OPTION_SMART_LOAD = 1;
    public static final int OPTION_IN_MEMORY_LOAD = 2;
    public final RoutingConfiguration config;
    public final RoutePlannerFrontEnd.RouteCalculationMode calculationMode;
    public final Map<BinaryMapIndexReader, List<BinaryMapRouteReaderAdapter.RouteSubregion>> map = new LinkedHashMap<BinaryMapIndexReader, List<BinaryMapRouteReaderAdapter.RouteSubregion>>();
    public final Map<BinaryMapRouteReaderAdapter.RouteRegion, BinaryMapIndexReader> reverseMap = new LinkedHashMap<BinaryMapRouteReaderAdapter.RouteRegion, BinaryMapIndexReader>();
    public int startX;
    public int startY;
    public int targetX;
    public int targetY;
    public long firstRoadId;
    public int firstRoadDirection;
    public RouteCalculationProgress calculationProgress;
    public boolean leftSideNavigation;
    public List<RouteSegmentResult> previouslyCalculatedRoute;
    public PrecalculatedRouteDirection precalculatedRouteDirection;
    TLongObjectHashMap<List<RoutingSubregionTile>> indexedSubregions = new TLongObjectHashMap();
    TLongObjectHashMap<List<RouteDataObject>> tileRoutes = new TLongObjectHashMap();
    List<RoutingSubregionTile> subregionTiles = new ArrayList<RoutingSubregionTile>();
    ArrayList<BinaryRoutePlanner.RouteSegment> segmentsToVisitPrescripted = new ArrayList(5);
    ArrayList<BinaryRoutePlanner.RouteSegment> segmentsToVisitNotForbidden = new ArrayList(5);
    public TileStatistics global = new TileStatistics();
    public int memoryOverhead = 0;
    long timeNanoToCalcDeviation = 0L;
    long timeToLoad = 0L;
    long timeToLoadHeaders = 0L;
    long timeToFindInitialSegments = 0L;
    long timeToCalculate = 0L;
    int distinctLoadedTiles = 0;
    int maxLoadedTiles = 0;
    int loadedPrevUnloadedTiles = 0;
    int unloadedTiles = 0;
    public float routingTime = 0.0f;
    public int loadedTiles = 0;
    public int visitedSegments = 0;
    public int relaxedSegments = 0;
    BinaryRoutePlanner.RouteSegmentVisitor visitor = null;
    public BinaryRoutePlanner.FinalRouteSegment finalRouteSegment;

    RoutingContext(RoutingContext cp) {
        this.config = cp.config;
        this.map.putAll(cp.map);
        this.calculationMode = cp.calculationMode;
        this.leftSideNavigation = cp.leftSideNavigation;
        this.reverseMap.putAll(cp.reverseMap);
        for (RoutingSubregionTile tl : this.subregionTiles) {
            if (!tl.isLoaded()) continue;
            this.subregionTiles.add(tl);
            Iterator iterator = tl.routes.valueCollection().iterator();
            while (iterator.hasNext()) {
                BinaryRoutePlanner.RouteSegment rs;
                BinaryRoutePlanner.RouteSegment s = rs = (BinaryRoutePlanner.RouteSegment)iterator.next();
                while (s != null) {
                    s.parentRoute = null;
                    s.parentSegmentEnd = 0;
                    s.distanceFromStart = 0.0f;
                    s.distanceToEnd = 0.0f;
                    s = s.next;
                }
            }
        }
    }

    RoutingContext(RoutingConfiguration config, BinaryMapIndexReader[] map, RoutePlannerFrontEnd.RouteCalculationMode calcMode) {
        this.calculationMode = calcMode;
        for (BinaryMapIndexReader mr : map) {
            List<BinaryMapRouteReaderAdapter.RouteRegion> rr = mr.getRoutingIndexes();
            ArrayList<BinaryMapRouteReaderAdapter.RouteSubregion> subregions = new ArrayList<BinaryMapRouteReaderAdapter.RouteSubregion>();
            for (BinaryMapRouteReaderAdapter.RouteRegion r : rr) {
                List<BinaryMapRouteReaderAdapter.RouteSubregion> subregs = calcMode == RoutePlannerFrontEnd.RouteCalculationMode.BASE ? r.getBaseSubregions() : r.getSubregions();
                for (BinaryMapRouteReaderAdapter.RouteSubregion rs : subregs) {
                    subregions.add(new BinaryMapRouteReaderAdapter.RouteSubregion(rs));
                }
                this.reverseMap.put(r, mr);
            }
            this.map.put(mr, subregions);
        }
        this.config = config;
    }

    public BinaryRoutePlanner.RouteSegmentVisitor getVisitor() {
        return this.visitor;
    }

    public int getCurrentlyLoadedTiles() {
        int cnt = 0;
        for (RoutingSubregionTile t : this.subregionTiles) {
            if (!t.isLoaded()) continue;
            ++cnt;
        }
        return cnt;
    }

    public int getCurrentEstimatedSize() {
        return this.global.size;
    }

    public void setVisitor(BinaryRoutePlanner.RouteSegmentVisitor visitor) {
        this.visitor = visitor;
    }

    public void setRouter(GeneralRouter router) {
        this.config.router = router;
    }

    public void setHeuristicCoefficient(float heuristicCoefficient) {
        this.config.heuristicCoefficient = heuristicCoefficient;
    }

    public VehicleRouter getRouter() {
        return this.config.router;
    }

    public boolean planRouteIn2Directions() {
        return this.config.planRoadDirection == 0;
    }

    public int getPlanRoadDirection() {
        return this.config.planRoadDirection;
    }

    public void setPlanRoadDirection(int planRoadDirection) {
        this.config.planRoadDirection = planRoadDirection;
    }

    public int roadPriorityComparator(double o1DistanceFromStart, double o1DistanceToEnd, double o2DistanceFromStart, double o2DistanceToEnd) {
        return BinaryRoutePlanner.roadPriorityComparator(o1DistanceFromStart, o1DistanceToEnd, o2DistanceFromStart, o2DistanceToEnd, this.config.heuristicCoefficient);
    }

    public void initStartAndTargetPoints(BinaryRoutePlanner.RouteSegment start, BinaryRoutePlanner.RouteSegment end) {
        this.initTargetPoint(end);
        this.startX = start.road.getPoint31XTile(start.getSegmentStart());
        this.startY = start.road.getPoint31YTile(start.getSegmentStart());
    }

    public void initTargetPoint(BinaryRoutePlanner.RouteSegment end) {
        this.targetX = end.road.getPoint31XTile(end.getSegmentStart());
        this.targetY = end.road.getPoint31YTile(end.getSegmentStart());
    }

    public void unloadAllData() {
        this.unloadAllData(null);
    }

    public void unloadAllData(RoutingContext except) {
        for (RoutingSubregionTile tl : this.subregionTiles) {
            if (!tl.isLoaded() || except != null && except.searchSubregionTile(tl.subregion) >= 0) continue;
            tl.unload();
            ++this.unloadedTiles;
            this.global.size -= tl.tileStatistics.size;
        }
        this.subregionTiles.clear();
        this.tileRoutes.clear();
        this.indexedSubregions.clear();
    }

    private int searchSubregionTile(BinaryMapRouteReaderAdapter.RouteSubregion subregion) {
        RoutingSubregionTile key = new RoutingSubregionTile(subregion);
        long now = System.nanoTime();
        int ind = Collections.binarySearch(this.subregionTiles, key, new Comparator<RoutingSubregionTile>(){

            @Override
            public int compare(RoutingSubregionTile o1, RoutingSubregionTile o2) {
                if (o1.subregion.left == o2.subregion.left) {
                    return 0;
                }
                return o1.subregion.left < o2.subregion.left ? 1 : -1;
            }
        });
        if (ind >= 0) {
            for (int i = ind; i <= this.subregionTiles.size(); ++i) {
                if (i == this.subregionTiles.size() || this.subregionTiles.get((int)i).subregion.left > subregion.left) {
                    ind = -i - 1;
                    return ind;
                }
                if (this.subregionTiles.get((int)i).subregion != subregion) continue;
                return i;
            }
        }
        this.timeToLoadHeaders += System.nanoTime() - now;
        return ind;
    }

    public void newRoutingPoints() {
        int middleX = this.startX / 2 + this.targetX / 2;
        int middleY = this.startY / 2 + this.targetY;
        ArrayList<RouteDataObject> dataObjects = new ArrayList<RouteDataObject>();
        this.loadTileData(middleX, middleY, 17, dataObjects);
        System.out.println("Size of data objects " + dataObjects.size());
    }

    public BinaryRoutePlanner.RouteSegment loadRouteSegment(int x31, int y31, int memoryLimit) {
        List subregions;
        List routes;
        long tileId = this.getRoutingTile(x31, y31, memoryLimit, 1);
        TLongObjectHashMap excludeDuplications = new TLongObjectHashMap();
        BinaryRoutePlanner.RouteSegment original = null;
        if (this.tileRoutes.containsKey(tileId) && (routes = (List)this.tileRoutes.get(tileId)) != null) {
            for (RouteDataObject ro : routes) {
                for (int i = 0; i < ro.pointsX.length; ++i) {
                    long id2;
                    if (ro.getPoint31XTile(i) != x31 || ro.getPoint31YTile(i) != y31 || excludeDuplications.contains(id2 = RoutingContext.calcRouteId(ro, i))) continue;
                    excludeDuplications.put(id2, (Object)ro);
                    BinaryRoutePlanner.RouteSegment segment = new BinaryRoutePlanner.RouteSegment(ro, i);
                    segment.next = original;
                    original = segment;
                }
            }
        }
        if ((subregions = (List)this.indexedSubregions.get(tileId)) != null) {
            for (RoutingSubregionTile rs : subregions) {
                original = rs.loadRouteSegment(x31, y31, this, (TLongObjectHashMap<RouteDataObject>)excludeDuplications, original);
            }
        }
        return original;
    }

    public void loadSubregionTile(RoutingSubregionTile ts, boolean loadObjectsInMemory, List<RouteDataObject> toLoad, TLongHashSet excludeNotAllowed) {
        boolean wasUnloaded = ts.isUnloaded();
        int ucount = ts.getUnloadCont();
        long now = System.nanoTime();
        try {
            BinaryMapIndexReader reader = this.reverseMap.get(ts.subregion.routeReg);
            ts.setLoadedNonNative();
            List<RouteDataObject> res = reader.loadRouteIndexData(ts.subregion);
            if (toLoad != null) {
                toLoad.addAll(res);
            } else {
                for (RouteDataObject ro : res) {
                    if (ro == null) continue;
                    if (this.config.router.acceptLine(ro)) {
                        if (excludeNotAllowed == null || excludeNotAllowed.contains(ro.getId())) continue;
                        ts.add(ro);
                        continue;
                    }
                    if (excludeNotAllowed == null) continue;
                    excludeNotAllowed.add(ro.getId());
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Loading data exception", e);
        }
        this.timeToLoad += System.nanoTime() - now;
        ++this.loadedTiles;
        if (wasUnloaded) {
            if (ucount == 1) {
                ++this.loadedPrevUnloadedTiles;
            }
        } else {
            if (this.global != null) {
                this.global.allRoutes += ts.tileStatistics.allRoutes;
                this.global.coordinates += ts.tileStatistics.coordinates;
            }
            ++this.distinctLoadedTiles;
        }
        this.global.size += ts.tileStatistics.size;
    }

    private List<RoutingSubregionTile> loadTileHeaders(int x31, int y31) {
        int zoomToLoad = 31 - this.config.ZOOM_TO_LOAD_TILES;
        int tileX = x31 >> zoomToLoad;
        int tileY = y31 >> zoomToLoad;
        return this.loadTileHeaders(zoomToLoad, tileX, tileY);
    }

    public void checkOldRoutingFiles(BinaryMapIndexReader key) {
        if (this.calculationMode == RoutePlannerFrontEnd.RouteCalculationMode.BASE && key.getDateCreated() < 1390172400000L) {
            System.err.println("Old routing file : " + key.getDateCreated() + " " + new Date(key.getDateCreated()));
            String map = "";
            for (BinaryMapRouteReaderAdapter.RouteRegion r : key.getRoutingIndexes()) {
                map = r.getName();
            }
            throw new RuntimeException("Update map '" + map + "' !");
        }
    }

    public void checkOldRoutingFiles(int x31, int y31) {
        block0: for (Map.Entry<BinaryMapIndexReader, List<BinaryMapRouteReaderAdapter.RouteSubregion>> r : this.map.entrySet()) {
            BinaryMapIndexReader reader = r.getKey();
            for (BinaryMapRouteReaderAdapter.RouteRegion reg : reader.getRoutingIndexes()) {
                if (!reg.contains(x31, y31)) continue;
                this.checkOldRoutingFiles(reader);
                continue block0;
            }
        }
    }

    public List<RoutingSubregionTile> loadAllSubregionTiles(BinaryMapIndexReader reader, BinaryMapRouteReaderAdapter.RouteSubregion reg) throws IOException {
        ArrayList<RoutingSubregionTile> list = new ArrayList<RoutingSubregionTile>();
        BinaryMapIndexReader.SearchRequest<RouteDataObject> request = BinaryMapIndexReader.buildSearchRouteRequest(0, Integer.MAX_VALUE, 0, Integer.MAX_VALUE, null);
        List<BinaryMapRouteReaderAdapter.RouteSubregion> subregs = reader.searchRouteIndexTree(request, Collections.singletonList(reg));
        for (BinaryMapRouteReaderAdapter.RouteSubregion s : subregs) {
            list.add(new RoutingSubregionTile(s));
        }
        return list;
    }

    public List<RoutingSubregionTile> loadTileHeaders(int zoomToLoadM31, int tileX, int tileY) {
        BinaryMapIndexReader.SearchRequest<RouteDataObject> request = BinaryMapIndexReader.buildSearchRouteRequest(tileX << zoomToLoadM31, tileX + 1 << zoomToLoadM31, tileY << zoomToLoadM31, tileY + 1 << zoomToLoadM31, null);
        ArrayList<RoutingSubregionTile> collection = null;
        for (Map.Entry<BinaryMapIndexReader, List<BinaryMapRouteReaderAdapter.RouteSubregion>> r : this.map.entrySet()) {
            try {
                if (r.getValue().size() <= 0) continue;
                long now = System.nanoTime();
                List<BinaryMapRouteReaderAdapter.RouteSubregion> subregs = r.getKey().searchRouteIndexTree(request, r.getValue());
                if (subregs.size() > 0) {
                    this.checkOldRoutingFiles(r.getKey());
                }
                for (BinaryMapRouteReaderAdapter.RouteSubregion sr : subregs) {
                    RoutingSubregionTile found;
                    int ind = this.searchSubregionTile(sr);
                    if (ind < 0) {
                        found = new RoutingSubregionTile(sr);
                        this.subregionTiles.add(-(ind + 1), found);
                    } else {
                        found = this.subregionTiles.get(ind);
                    }
                    if (collection == null) {
                        collection = new ArrayList<RoutingSubregionTile>(4);
                    }
                    collection.add(found);
                }
                this.timeToLoadHeaders += System.nanoTime() - now;
            }
            catch (IOException e) {
                throw new RuntimeException("Loading data exception", e);
            }
        }
        return collection;
    }

    public void loadTileData(int x31, int y31, int zoomAround, List<RouteDataObject> toFillIn) {
        int t = this.config.ZOOM_TO_LOAD_TILES - zoomAround;
        int coordinatesShift = 1 << 31 - this.config.ZOOM_TO_LOAD_TILES;
        if (t <= 0) {
            t = 1;
            coordinatesShift = 1 << 31 - zoomAround;
        } else {
            t = 1 << t;
        }
        TLongHashSet ts = new TLongHashSet();
        long now = System.nanoTime();
        for (int i = -t; i <= t; ++i) {
            for (int j = -t; j <= t; ++j) {
                ts.add(this.getRoutingTile(x31 + i * coordinatesShift, y31 + j * coordinatesShift, 0, 2));
            }
        }
        TLongIterator it = ts.iterator();
        TLongObjectHashMap excludeDuplications = new TLongObjectHashMap();
        while (it.hasNext()) {
            this.getAllObjects(it.next(), toFillIn, (TLongObjectHashMap<RouteDataObject>)excludeDuplications);
        }
        this.timeToFindInitialSegments += System.nanoTime() - now;
    }

    private long getRoutingTile(int x31, int y31, int memoryLimit, int loadOptions) {
        long xloc = x31 >> 31 - this.config.ZOOM_TO_LOAD_TILES;
        long yloc = y31 >> 31 - this.config.ZOOM_TO_LOAD_TILES;
        long tileId = (xloc << this.config.ZOOM_TO_LOAD_TILES) + yloc;
        if (loadOptions != 0) {
            List subregions;
            if (memoryLimit == 0) {
                memoryLimit = this.config.memoryLimitation;
            }
            if ((double)this.getCurrentEstimatedSize() > 0.9 * (double)memoryLimit) {
                int sz1 = this.getCurrentEstimatedSize();
                long h1 = 0L;
                int clt = this.getCurrentlyLoadedTiles();
                long us1 = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
                this.unloadUnusedTiles(memoryLimit);
                if (h1 != 0L && this.getCurrentlyLoadedTiles() != clt) {
                    int sz2 = this.getCurrentEstimatedSize();
                    RoutingContext.runGCUsedMemory();
                    long h2 = RoutingContext.runGCUsedMemory();
                    float mb = 1048576.0f;
                    log.warn((Object)("Unload tiles :  estimated " + (float)(sz1 - sz2) / mb + " ?= " + (float)(h1 - h2) / mb + " actual"));
                    log.warn((Object)("Used after " + (float)h2 / mb + " of " + (float)Runtime.getRuntime().totalMemory() / mb + " max " + (float)this.maxMemory() / mb));
                } else {
                    float mb = 1048576.0f;
                    int sz2 = this.getCurrentEstimatedSize();
                    log.warn((Object)("Unload tiles :  occupied before " + (float)sz1 / mb + " Mb - now  " + (float)sz2 / mb + "MB " + (float)memoryLimit / mb + " limit MB " + (float)this.config.memoryLimitation / mb));
                    long us2 = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
                    log.warn((Object)("Used memory before " + (float)us1 / mb + "after " + (float)us1 / mb + " of max " + (float)this.maxMemory() / mb));
                }
            }
            if (!this.indexedSubregions.containsKey(tileId)) {
                List<RoutingSubregionTile> collection = this.loadTileHeaders(x31, y31);
                this.indexedSubregions.put(tileId, collection);
            }
            if ((subregions = (List)this.indexedSubregions.get(tileId)) != null) {
                TLongHashSet duplicates = new TLongHashSet();
                for (RoutingSubregionTile ts : subregions) {
                    if (ts.isLoaded()) continue;
                    this.loadSubregionTile(ts, loadOptions == 2, null, duplicates);
                }
            }
        }
        return tileId;
    }

    private long maxMemory() {
        return 0L;
    }

    public boolean checkIfMemoryLimitCritical(int memoryLimit) {
        return (double)this.getCurrentEstimatedSize() > 0.9 * (double)memoryLimit;
    }

    public void unloadUnusedTiles(int memoryLimit) {
        float desirableSize = (float)memoryLimit * 0.7f;
        ArrayList<RoutingSubregionTile> list = new ArrayList<RoutingSubregionTile>(this.subregionTiles.size() / 2);
        int loaded = 0;
        for (RoutingSubregionTile t : this.subregionTiles) {
            if (!t.isLoaded()) continue;
            list.add(t);
            ++loaded;
        }
        this.maxLoadedTiles = Math.max(this.maxLoadedTiles, this.getCurrentlyLoadedTiles());
        Collections.sort(list, new Comparator<RoutingSubregionTile>(){

            private int pow(int base, int pw) {
                int r = 1;
                for (int i = 0; i < pw; ++i) {
                    r *= base;
                }
                return r;
            }

            @Override
            public int compare(RoutingSubregionTile o1, RoutingSubregionTile o2) {
                int v2;
                int v1 = (o1.access + 1) * this.pow(10, o1.getUnloadCont() - 1);
                return v1 < (v2 = (o2.access + 1) * this.pow(10, o2.getUnloadCont() - 1)) ? -1 : (v1 == v2 ? 0 : 1);
            }
        });
        int i = 0;
        while ((float)this.getCurrentEstimatedSize() >= desirableSize && list.size() - i > loaded / 5 && i < list.size()) {
            RoutingSubregionTile unload = (RoutingSubregionTile)list.get(i);
            ++i;
            unload.unload();
            ++this.unloadedTiles;
            this.global.size -= unload.tileStatistics.size;
        }
        for (RoutingSubregionTile t : this.subregionTiles) {
            t.access /= 3;
        }
    }

    private void getAllObjects(long tileId, List<RouteDataObject> toFillIn, TLongObjectHashMap<RouteDataObject> excludeDuplications) {
        List subregions;
        List routes;
        if (this.tileRoutes.containsKey(tileId) && (routes = (List)this.tileRoutes.get(tileId)) != null) {
            for (RouteDataObject ro : routes) {
                if (excludeDuplications.contains(ro.id)) continue;
                excludeDuplications.put(ro.id, (Object)ro);
                toFillIn.add(ro);
            }
        }
        if ((subregions = (List)this.indexedSubregions.get(tileId)) != null) {
            for (RoutingSubregionTile rs : subregions) {
                rs.loadAllObjects(toFillIn, this, excludeDuplications);
            }
        }
    }

    protected static long runGCUsedMemory() {
        Runtime runtime = Runtime.getRuntime();
        long usedMem1 = runtime.totalMemory() - runtime.freeMemory();
        long usedMem2 = Long.MAX_VALUE;
        int cnt = 4;
        while (cnt-- >= 0) {
            for (int i = 0; usedMem1 < usedMem2 && i < 1000; ++i) {
                runtime.runFinalization();
                runtime.gc();
                Thread.yield();
                usedMem2 = usedMem1;
                usedMem1 = runtime.totalMemory() - runtime.freeMemory();
            }
        }
        return usedMem1;
    }

    private static long calcRouteId(RouteDataObject o, int ind) {
        return (o.getId() << 10) + (long)ind;
    }

    static int getEstimatedSize(RouteDataObject o) {
        int sz = 0;
        sz += 12;
        if (o.names != null) {
            sz += 12;
            TIntObjectIterator it = o.names.iterator();
            while (it.hasNext()) {
                it.advance();
                String vl = (String)it.value();
                sz += 12 + vl.length();
            }
            sz += 12 + o.names.size() * 25;
        }
        sz += 8;
        sz += (12 + 4 * o.getPointsLength()) * 4;
        sz += o.types == null ? 4 : 12 + 4 * o.types.length;
        sz += o.restrictions == null ? 4 : 12 + 8 * o.restrictions.length;
        sz += 4;
        if (o.pointTypes != null) {
            sz += 8 + 4 * o.pointTypes.length;
            for (int i = 0; i < o.pointTypes.length; ++i) {
                sz += 4;
                if (o.pointTypes[i] == null) continue;
                sz += 8 + 8 * o.pointTypes[i].length;
            }
        }
        return (int)((double)sz * 3.5);
    }

    public BinaryMapIndexReader[] getMaps() {
        return this.map.keySet().toArray(new BinaryMapIndexReader[this.map.size()]);
    }

    protected static class TileStatistics {
        public int size = 0;
        public int allRoutes = 0;
        public int coordinates = 0;

        protected TileStatistics() {
        }

        public String toString() {
            return "All routes " + this.allRoutes + " size " + (float)this.size / 1024.0f + " KB coordinates " + this.coordinates + " ratio coord " + (float)this.size / (float)this.coordinates + " ratio routes " + (float)this.size / (float)this.allRoutes;
        }

        public void addObject(RouteDataObject o) {
            ++this.allRoutes;
            this.coordinates += o.getPointsLength() * 2;
            this.size += RoutingContext.getEstimatedSize(o);
        }
    }

    public static class RoutingSubregionTile {
        public final BinaryMapRouteReaderAdapter.RouteSubregion subregion;
        public int access;
        public TileStatistics tileStatistics = new TileStatistics();
        private int isLoaded = 0;
        private TLongObjectMap<BinaryRoutePlanner.RouteSegment> routes = null;

        public RoutingSubregionTile(BinaryMapRouteReaderAdapter.RouteSubregion subregion) {
            this.subregion = subregion;
        }

        public TLongObjectMap<BinaryRoutePlanner.RouteSegment> getRoutes() {
            return this.routes;
        }

        public void loadAllObjects(List<RouteDataObject> toFillIn, RoutingContext ctx, TLongObjectHashMap<RouteDataObject> excludeDuplications) {
            if (this.routes != null) {
                for (BinaryRoutePlanner.RouteSegment rs : this.routes.valueCollection()) {
                    while (rs != null) {
                        RouteDataObject ro = rs.road;
                        if (!excludeDuplications.contains(ro.id)) {
                            excludeDuplications.put(ro.id, (Object)ro);
                            toFillIn.add(ro);
                        }
                        rs = rs.next;
                    }
                }
            }
        }

        private BinaryRoutePlanner.RouteSegment loadRouteSegment(int x31, int y31, RoutingContext ctx, TLongObjectHashMap<RouteDataObject> excludeDuplications, BinaryRoutePlanner.RouteSegment original) {
            if (this.routes == null) {
                return original;
            }
            ++this.access;
            long l = ((long)x31 << 31) + (long)y31;
            BinaryRoutePlanner.RouteSegment segment = (BinaryRoutePlanner.RouteSegment)this.routes.get(l);
            while (segment != null) {
                RouteDataObject ro = segment.road;
                RouteDataObject toCmp = (RouteDataObject)excludeDuplications.get(RoutingContext.calcRouteId(ro, segment.getSegmentStart()));
                if (toCmp == null || toCmp.getPointsLength() < ro.getPointsLength()) {
                    excludeDuplications.put(RoutingContext.calcRouteId(ro, segment.getSegmentStart()), (Object)ro);
                    BinaryRoutePlanner.RouteSegment s = new BinaryRoutePlanner.RouteSegment(ro, segment.getSegmentStart());
                    s.next = original;
                    original = s;
                }
                segment = segment.next;
            }
            return original;
        }

        public boolean isLoaded() {
            return this.isLoaded > 0;
        }

        public int getUnloadCont() {
            return Math.abs(this.isLoaded);
        }

        public boolean isUnloaded() {
            return this.isLoaded < 0;
        }

        public void unload() {
            this.isLoaded = this.isLoaded == 0 ? -1 : -Math.abs(this.isLoaded);
            this.routes = null;
        }

        public void setLoadedNonNative() {
            this.isLoaded = Math.abs(this.isLoaded) + 1;
            this.routes = new TLongObjectHashMap();
            this.tileStatistics = new TileStatistics();
        }

        public void add(RouteDataObject ro) {
            this.tileStatistics.addObject(ro);
            for (int i = 0; i < ro.pointsX.length; ++i) {
                int x31 = ro.getPoint31XTile(i);
                int y31 = ro.getPoint31YTile(i);
                long l = ((long)x31 << 31) + (long)y31;
                BinaryRoutePlanner.RouteSegment segment = new BinaryRoutePlanner.RouteSegment(ro, i);
                if (!this.routes.containsKey(l)) {
                    this.routes.put(l, (Object)segment);
                    continue;
                }
                BinaryRoutePlanner.RouteSegment orig = (BinaryRoutePlanner.RouteSegment)this.routes.get(l);
                while (orig.next != null) {
                    orig = orig.next;
                }
                orig.next = segment;
            }
        }
    }
}

