/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole.rosetta;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.creole.rosetta.ReaderAbstractWiki;
import net.sourceforge.plantuml.creole.rosetta.ReaderWiki;
import net.sourceforge.plantuml.creole.rosetta.WikiLanguage;

public class ReaderCreole
extends ReaderAbstractWiki
implements ReaderWiki {
    @Override
    protected String singleLineFormat(String wiki) {
        wiki = wiki.replace("<b>", WikiLanguage.UNICODE.tag("strong"));
        wiki = wiki.replace("</b>", WikiLanguage.UNICODE.slashTag("strong"));
        wiki = wiki.replace("<i>", WikiLanguage.UNICODE.tag("em"));
        wiki = wiki.replace("</i>", WikiLanguage.UNICODE.slashTag("em"));
        wiki = wiki.replaceAll("\\*\\*(.+?)\\*\\*", WikiLanguage.UNICODE.tag("strong") + "$1" + WikiLanguage.UNICODE.slashTag("strong"));
        wiki = wiki.replaceAll("//(.+?)//", WikiLanguage.UNICODE.tag("em") + "$1" + WikiLanguage.UNICODE.slashTag("em"));
        wiki = wiki.replaceAll("--([^-]+?)--", WikiLanguage.UNICODE.tag("strike") + "$1" + WikiLanguage.UNICODE.slashTag("strike"));
        return wiki;
    }

    @Override
    public List<String> transform(List<String> raw) {
        ArrayList<String> uhtml = new ArrayList<String>();
        for (int i = 0; i < raw.size(); ++i) {
            String current = raw.get(i);
            uhtml.add(this.singleLineFormat(current));
        }
        return Collections.unmodifiableList(uhtml);
    }
}

