/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.png;

import com.sun.imageio.plugins.png.PNGMetadata;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageOutputStream;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.png.PngIO;
import net.sourceforge.plantuml.security.ImageIO;

public class PngIOMetadata {
    private static final String copyleft = "Generated by http://plantuml.com";

    public static void writeWithMetadata(RenderedImage image, OutputStream os, String metadata, int dpi, String debugData) throws IOException {
        PNGMetadata pngMetadata = null;
        try {
            pngMetadata = new PNGMetadata();
        }
        catch (Throwable e) {
            Log.info("Cannot create com.sun.imageio.plugins.png.PNGMetadata");
            PngIO.forceImageIO = true;
            ImageIO.write(image, "png", os);
            return;
        }
        PngIOMetadata.writeInternal(image, os, metadata, dpi, debugData, pngMetadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeInternal(RenderedImage image, OutputStream os, String metadata, int dpi, String debugData, PNGMetadata pngMetadata) throws IOException {
        if (dpi != 96) {
            pngMetadata.pHYs_present = true;
            pngMetadata.pHYs_unitSpecifier = 1;
            pngMetadata.pHYs_pixelsPerUnitYAxis = pngMetadata.pHYs_pixelsPerUnitXAxis = (int)Math.round((double)dpi / 0.0254 + 0.5);
        }
        if (metadata != null) {
            pngMetadata.iTXt_compressionFlag.add(new Boolean(true));
            pngMetadata.iTXt_compressionMethod.add(new Integer(0));
            pngMetadata.iTXt_keyword.add("plantuml");
            pngMetadata.iTXt_languageTag.add("");
            pngMetadata.iTXt_text.add(metadata);
            pngMetadata.iTXt_translatedKeyword.add("");
        }
        if (debugData != null) {
            pngMetadata.tEXt_keyword.add("debug");
            pngMetadata.tEXt_text.add(debugData);
        }
        pngMetadata.tEXt_keyword.add("copyleft");
        pngMetadata.tEXt_text.add(copyleft);
        Log.debug("PngIOMetadata pngMetadata=" + pngMetadata);
        IIOImage iioImage = new IIOImage(image, null, (IIOMetadata)pngMetadata);
        Log.debug("PngIOMetadata iioImage=" + iioImage);
        ImageWriter imagewriter = PngIOMetadata.getImageWriter();
        Log.debug("PngIOMetadata imagewriter=" + imagewriter);
        ImageWriter imageWriter = imagewriter;
        synchronized (imageWriter) {
            ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(os);
            imagewriter.setOutput(imageOutputStream);
            try {
                imagewriter.write(null, iioImage, null);
            }
            finally {
                imageOutputStream.flush();
                imageOutputStream.close();
                imagewriter.reset();
                imagewriter.dispose();
            }
        }
    }

    private static ImageWriter getImageWriter() {
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersBySuffix("png");
        Iterator<ImageWriter> it = ImageIO.getImageWritersBySuffix("png");
        while (it.hasNext()) {
            ImageWriter imagewriter = iterator.next();
            Log.debug("PngIOMetadata countImageWriter = " + it.next());
            if (!imagewriter.getClass().getName().equals("com.sun.imageio.plugins.png.PNGImageWriter")) continue;
            Log.debug("PngIOMetadata Found sun PNGImageWriter");
            return imagewriter;
        }
        Log.debug("Using first one");
        return ImageIO.getImageWritersBySuffix("png").next();
    }
}

