/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.draw;

import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.project.draw.TaskDraw;
import net.sourceforge.plantuml.project.lang.ComplementColors;
import net.sourceforge.plantuml.project.time.Wink;
import net.sourceforge.plantuml.project.timescale.TimeScale;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class TaskDrawSeparator
implements TaskDraw {
    private final TimeScale timeScale;
    private final double y;
    private final Wink min;
    private final Wink max;
    private final String name;
    private static final double MARGIN1 = 10.0;
    private static final double MARGIN2 = 2.0;

    public TaskDrawSeparator(String name, TimeScale timeScale, double y, Wink min, Wink max) {
        this.name = name;
        this.y = y;
        this.timeScale = timeScale;
        this.min = min;
        this.max = max;
    }

    @Override
    public void drawTitle(UGraphic ug) {
        this.getTitle().drawU(ug.apply(UTranslate.dx(10.0)));
    }

    private TextBlock getTitle() {
        if (this.name == null) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        return Display.getWithNewlines(this.name).create(this.getFontConfiguration(), HorizontalAlignment.LEFT, new SpriteContainerEmpty());
    }

    private FontConfiguration getFontConfiguration() {
        UFont font = UFont.serif(11);
        return new FontConfiguration(font, HColorUtils.BLACK, HColorUtils.BLACK, false);
    }

    @Override
    public void drawU(UGraphic ug) {
        double widthTitle = this.getTitle().calculateDimension(ug.getStringBounder()).getWidth();
        double start = this.timeScale.getStartingPosition(this.min) + widthTitle;
        double end = this.timeScale.getEndingPosition(this.max);
        ug = ug.apply(HColorUtils.BLACK);
        ug = ug.apply(UTranslate.dy(this.getHeight() / 2.0));
        if (widthTitle == 0.0) {
            ULine line = ULine.hline(end - start);
            ug.draw(line);
        } else {
            ULine line1 = ULine.hline(8.0);
            ULine line2 = ULine.hline(end - start - 10.0 - 2.0);
            ug.draw(line1);
            ug.apply(UTranslate.dx(widthTitle + 10.0 + 2.0)).draw(line2);
        }
    }

    @Override
    public double getHeight() {
        return 16.0;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public void setColorsAndCompletion(ComplementColors colors, int completion, Url url) {
    }
}

