/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.lang;

import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.project.Failable;
import net.sourceforge.plantuml.project.GanttDiagram;
import net.sourceforge.plantuml.project.lang.Complement;
import net.sourceforge.plantuml.project.lang.ComplementColors;
import net.sourceforge.plantuml.project.lang.ComplementPattern;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class ComplementInColors
implements ComplementPattern {
    @Override
    public IRegex toRegex(String suffix) {
        return new RegexLeaf("COMPLEMENT" + suffix, "in[%s+](#?\\w+)(?:/(#?\\w+))?");
    }

    @Override
    public Failable<Complement> getComplement(GanttDiagram system, RegexResult arg, String suffix) {
        String color1 = arg.get("COMPLEMENT" + suffix, 0);
        String color2 = arg.get("COMPLEMENT" + suffix, 1);
        HColor col1 = system.getIHtmlColorSet().getColorIfValid(color1);
        HColor col2 = system.getIHtmlColorSet().getColorIfValid(color2);
        return Failable.ok(new ComplementColors(col1, col2));
    }
}

