/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.timescale;

import net.sourceforge.plantuml.project.time.Day;
import net.sourceforge.plantuml.project.time.GCalendar;
import net.sourceforge.plantuml.project.time.Wink;
import net.sourceforge.plantuml.project.timescale.TimeScale;
import net.sourceforge.plantuml.project.timescale.TimeScaleWink;

public final class TimeScaleDaily
implements TimeScale {
    private final TimeScaleWink basic = new TimeScaleWink();
    private final double delta;

    public TimeScaleDaily(GCalendar calendar, Day zeroDay) {
        this.delta = zeroDay == null ? 0.0 : this.basic.getStartingPosition(calendar.fromDayAsDate(zeroDay));
    }

    @Override
    public double getStartingPosition(Wink instant) {
        return this.basic.getStartingPosition(instant) - this.delta;
    }

    @Override
    public double getEndingPosition(Wink instant) {
        return this.basic.getEndingPosition(instant) - this.delta;
    }

    @Override
    public double getWidth(Wink instant) {
        return this.basic.getWidth(instant);
    }
}

