/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.log4j;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.SessionChangedListener;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.log4j.ZapOutputWriter;
import org.zaproxy.zap.view.ScanStatus;
import org.zaproxy.zap.view.ZapMenuItem;

public class ExtensionLog4j
extends ExtensionAdaptor {
    private static final String NAME = "ExtensionLog4j";
    private ZapMenuItem menuGarbageCollect = null;
    private ScanStatus scanStatus;

    public ExtensionLog4j() {
        super(NAME);
        this.setOrder(56);
        if (Constant.isDevMode() && View.isInitialised()) {
            this.scanStatus = new ScanStatus(new ImageIcon(ExtensionLog4j.class.getResource("/resource/icon/fugue/bug.png")), Constant.messages.getString("log4j.icon.title"));
            Logger.getRootLogger().addAppender((Appender)new ZapOutputWriter(this.scanStatus));
            View.getSingleton().getMainFrame().getMainFooterPanel().addFooterToolbarRightLabel(this.scanStatus.getCountLabel());
        }
    }

    @Override
    public String getUIName() {
        return Constant.messages.getString("log4j.name");
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        if (this.getView() != null) {
            extensionHook.getHookMenu().addToolsMenuItem(this.getMenuGarbageCollect());
            if (this.scanStatus != null) {
                extensionHook.addSessionListener(new ResetCounterOnSessionChange(this.scanStatus));
            }
        }
    }

    private ZapMenuItem getMenuGarbageCollect() {
        if (this.menuGarbageCollect == null) {
            this.menuGarbageCollect = new ZapMenuItem("log4j.tools.menu.gc");
            this.menuGarbageCollect.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Runtime.getRuntime().gc();
                }
            });
        }
        return this.menuGarbageCollect;
    }

    @Override
    public String getAuthor() {
        return "ZAP Dev Team";
    }

    @Override
    public String getDescription() {
        return Constant.messages.getString("log4j.desc");
    }

    @Override
    public boolean supportsDb(String type) {
        return true;
    }

    private static class ResetCounterOnSessionChange
    implements SessionChangedListener {
        private int previousCount;
        private boolean starting;
        private ScanStatus scanStatus;

        public ResetCounterOnSessionChange(ScanStatus scanStatus) {
            this.scanStatus = scanStatus;
            this.starting = true;
        }

        @Override
        public void sessionAboutToChange(Session session) {
            EventQueue.invokeLater(() -> {
                this.previousCount = this.scanStatus.getScanCount();
            });
        }

        @Override
        public void sessionChanged(Session session) {
            if (this.starting) {
                this.starting = false;
                return;
            }
            EventQueue.invokeLater(() -> {
                this.scanStatus.setScanCount(this.scanStatus.getScanCount() - this.previousCount);
                this.previousCount = 0;
            });
        }

        @Override
        public void sessionScopeChanged(Session session) {
        }

        @Override
        public void sessionModeChanged(Control.Mode mode) {
        }
    }
}

