# -*- coding: utf-8 -*-
info = {
    "name": "ky",
    "date_order": "DMY",
    "january": [
        "январь",
        "янв"
    ],
    "february": [
        "февраль",
        "фев"
    ],
    "march": [
        "март",
        "мар"
    ],
    "april": [
        "апрель",
        "апр"
    ],
    "may": [
        "май"
    ],
    "june": [
        "июнь",
        "июн"
    ],
    "july": [
        "июль",
        "июл"
    ],
    "august": [
        "август",
        "авг"
    ],
    "september": [
        "сентябрь",
        "сен"
    ],
    "october": [
        "октябрь",
        "окт"
    ],
    "november": [
        "ноябрь",
        "ноя"
    ],
    "december": [
        "декабрь",
        "дек"
    ],
    "monday": [
        "дүйшөмбү",
        "дүй"
    ],
    "tuesday": [
        "шейшемби",
        "шейш"
    ],
    "wednesday": [
        "шаршемби",
        "шарш"
    ],
    "thursday": [
        "бейшемби",
        "бейш"
    ],
    "friday": [
        "жума"
    ],
    "saturday": [
        "ишемби",
        "ишм"
    ],
    "sunday": [
        "жекшемби",
        "жек"
    ],
    "am": [
        "таңкы",
        "тң"
    ],
    "pm": [
        "түштөн кийинки",
        "тк"
    ],
    "year": [
        "жыл",
        "ж"
    ],
    "month": [
        "ай"
    ],
    "week": [
        "апта",
        "апт"
    ],
    "day": [
        "күн"
    ],
    "hour": [
        "саат",
        "ст"
    ],
    "minute": [
        "мүнөт",
        "мүн",
        "м"
    ],
    "second": [
        "секунд",
        "сек"
    ],
    "relative-type": {
        "1 year ago": [
            "былтыр"
        ],
        "0 year ago": [
            "быйыл"
        ],
        "in 1 year": [
            "эмдиги жылы"
        ],
        "1 month ago": [
            "өткөн айда"
        ],
        "0 month ago": [
            "бул айда"
        ],
        "in 1 month": [
            "эмдиги айда"
        ],
        "1 week ago": [
            "өткөн аптада",
            "өткөн апт"
        ],
        "0 week ago": [
            "ушул аптада",
            "ушул апт"
        ],
        "in 1 week": [
            "келерки аптада",
            "келерки апт"
        ],
        "1 day ago": [
            "кечээ"
        ],
        "0 day ago": [
            "бүгүн"
        ],
        "in 1 day": [
            "эртеӊ"
        ],
        "0 hour ago": [
            "ушул саатта"
        ],
        "0 minute ago": [
            "ушул мүнөттө"
        ],
        "0 second ago": [
            "азыр"
        ]
    },
    "relative-type-regex": {
        "in \\1 year": [
            "(\\d+) жылдан кийин",
            "(\\d+) жыл кийин"
        ],
        "\\1 year ago": [
            "(\\d+) жыл мурун"
        ],
        "in \\1 month": [
            "(\\d+) айдан кийин",
            "(\\d+) айд кийин",
            "(\\d+) айд кийн"
        ],
        "\\1 month ago": [
            "(\\d+) ай мурун",
            "(\\d+) ай мурн"
        ],
        "in \\1 week": [
            "(\\d+) аптадан кийин",
            "(\\d+) апт кийин"
        ],
        "\\1 week ago": [
            "(\\d+) апта мурун",
            "(\\d+) апт мурун"
        ],
        "in \\1 day": [
            "(\\d+) күндөн кийин",
            "(\\d+) күн кийин"
        ],
        "\\1 day ago": [
            "(\\d+) күн мурун"
        ],
        "in \\1 hour": [
            "(\\d+) сааттан кийин",
            "(\\d+) саат кийин",
            "(\\d+) с кийн"
        ],
        "\\1 hour ago": [
            "(\\d+) саат мурун",
            "(\\d+) с мурн"
        ],
        "in \\1 minute": [
            "(\\d+) мүнөттөн кийин",
            "(\\d+) мүн кийин",
            "(\\d+) мүн кийн"
        ],
        "\\1 minute ago": [
            "(\\d+) мүнөт мурун",
            "(\\d+) мүн мурун",
            "(\\d+) мүн мурн"
        ],
        "in \\1 second": [
            "(\\d+) секунддан кийин",
            "(\\d+) сек кийин",
            "(\\d+) сек кийн"
        ],
        "\\1 second ago": [
            "(\\d+) секунд мурун",
            "(\\d+) сек мурун",
            "(\\d+) сек мурн"
        ]
    },
    "locale_specific": {},
    "skip": [
        " ",
        ".",
        ",",
        ";",
        "-",
        "/",
        "'",
        "|",
        "@",
        "[",
        "]",
        "，"
    ]
}
