/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.jar.Attributes;
import org.eclipse.swt.internal.Platform;

public class Library {
    static int MAJOR_VERSION = 4;
    static int MINOR_VERSION = 629;
    static int REVISION = 0;
    public static final int JAVA_VERSION;
    public static final int SWT_VERSION;
    static final String SEPARATOR;
    static final String DELIMITER;
    static final boolean IS_64;
    static final String SUFFIX_64 = "-64";
    static final String SWT_LIB_DIR;

    static String arch() {
        String string = System.getProperty("os.arch");
        if (string.equals("i386") || string.equals("i686")) {
            return "x86";
        }
        if (string.equals("amd64")) {
            return "x86_64";
        }
        if (string.equals("IA64N")) {
            return "ia64_32";
        }
        if (string.equals("IA64W")) {
            return "ia64";
        }
        return string;
    }

    static String os() {
        String string = System.getProperty("os.name");
        if (string.equals("Linux")) {
            return "linux";
        }
        if (string.equals("AIX")) {
            return "aix";
        }
        if (string.equals("Solaris") || string.equals("SunOS")) {
            return "solaris";
        }
        if (string.equals("HP-UX")) {
            return "hpux";
        }
        if (string.equals("Mac OS X")) {
            return "macosx";
        }
        if (string.startsWith("Win")) {
            return "win32";
        }
        return string;
    }

    static void chmod(String string, String string2) {
        if ("gtk".equals("win32")) {
            return;
        }
        try {
            Runtime.getRuntime().exec(new String[]{"chmod", string, string2}).waitFor();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static long longConst() {
        return 0x1FFFFFFFFL;
    }

    static int parseVersion(String string) {
        int n;
        if (string == null) {
            return 0;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = string.length();
        int n6 = 0;
        for (n = 0; n < n5 && Character.isDigit(string.charAt(n)); ++n) {
        }
        try {
            if (n6 < n5) {
                n2 = Integer.parseInt(string.substring(n6, n));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        n6 = ++n;
        while (n < n5 && Character.isDigit(string.charAt(n))) {
            ++n;
        }
        try {
            if (n6 < n5) {
                n3 = Integer.parseInt(string.substring(n6, n));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        n6 = ++n;
        while (n < n5 && Character.isDigit(string.charAt(n))) {
            ++n;
        }
        try {
            if (n6 < n5) {
                n4 = Integer.parseInt(string.substring(n6, n));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return Library.JAVA_VERSION(n2, n3, n4);
    }

    public static int JAVA_VERSION(int n, int n2, int n3) {
        return (n << 16) + (n2 << 8) + n3;
    }

    public static int SWT_VERSION(int n, int n2) {
        return n * 1000 + n2;
    }

    static boolean extract(String string, String string2, StringBuffer stringBuffer) {
        block11: {
            FileOutputStream fileOutputStream = null;
            InputStream inputStream = null;
            File file = new File(string);
            boolean bl = false;
            try {
                if (!file.exists() && (inputStream = Library.class.getResourceAsStream("/" + string2)) != null) {
                    int n;
                    bl = true;
                    byte[] byArray = new byte[4096];
                    fileOutputStream = new FileOutputStream(string);
                    while ((n = inputStream.read(byArray)) != -1) {
                        fileOutputStream.write(byArray, 0, n);
                    }
                    fileOutputStream.close();
                    inputStream.close();
                    Library.chmod("755", string);
                    if (Library.load(string, stringBuffer)) {
                        return true;
                    }
                }
            }
            catch (Throwable throwable) {
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (!bl || !file.exists()) break block11;
                file.delete();
            }
        }
        return false;
    }

    static boolean isLoadable() {
        Object object;
        Object object2;
        URL uRL = Platform.class.getClassLoader().getResource("org/eclipse/swt/internal/Library.class");
        if (!uRL.getProtocol().equals("jar")) {
            return true;
        }
        Attributes attributes = null;
        try {
            object2 = uRL.openConnection();
            if (!(object2 instanceof JarURLConnection)) {
                return false;
            }
            object = (JarURLConnection)object2;
            attributes = ((JarURLConnection)object).getMainAttributes();
        }
        catch (IOException iOException) {
            return false;
        }
        object2 = Library.os();
        object = Library.arch();
        String string = attributes.getValue("SWT-OS");
        String string2 = attributes.getValue("SWT-Arch");
        if (((String)object).equals(string2) && ((String)object2).equals(string)) {
            return true;
        }
        if (((String)object2).equals("macosx") && ((String)object2).equals(string)) {
            return string2.length() == 0 && (((String)object).equals("ppc") || ((String)object).equals("x86"));
        }
        return false;
    }

    static boolean load(String string, StringBuffer stringBuffer) {
        try {
            if (string.indexOf(SEPARATOR) != -1) {
                System.load(string);
            } else {
                System.loadLibrary(string);
            }
            return true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            if (stringBuffer.length() == 0) {
                stringBuffer.append(DELIMITER);
            }
            stringBuffer.append('\t');
            stringBuffer.append(unsatisfiedLinkError.getMessage());
            stringBuffer.append(DELIMITER);
            return false;
        }
    }

    public static void loadLibrary(String string) {
        Library.loadLibrary(string, true);
    }

    public static void loadLibrary(String string, boolean bl) {
        String string2;
        String string3;
        String string4;
        String string5;
        CharSequence charSequence;
        String string6 = System.getProperty("sun.arch.data.model");
        if (string6 == null) {
            string6 = System.getProperty("com.ibm.vm.bitmode");
        }
        if (string6 != null) {
            if ("32".equals(string6) && IS_64) {
                throw new UnsatisfiedLinkError("Cannot load 64-bit SWT libraries on 32-bit JVM");
            }
            if ("64".equals(string6) && !IS_64) {
                throw new UnsatisfiedLinkError("Cannot load 32-bit SWT libraries on 64-bit JVM");
            }
        }
        if (bl) {
            charSequence = System.getProperty("swt.version");
            if (charSequence == null) {
                charSequence = "" + MAJOR_VERSION;
                if (MINOR_VERSION < 10) {
                    charSequence = (String)charSequence + "00";
                } else if (MINOR_VERSION < 100) {
                    charSequence = (String)charSequence + "0";
                }
                charSequence = (String)charSequence + MINOR_VERSION;
                if (REVISION > 0) {
                    charSequence = (String)charSequence + "r" + REVISION;
                }
            }
            string5 = string + "-" + "gtk" + "-" + (String)charSequence;
            string4 = string + "-" + "gtk";
            string3 = Library.mapLibraryName(string5);
            string2 = Library.mapLibraryName(string4);
        } else {
            string3 = string2 = string;
            string4 = string2;
            string5 = string2;
        }
        charSequence = new StringBuffer();
        String string7 = System.getProperty("swt.library.path");
        if (string7 != null) {
            if (Library.load((string7 = new File(string7).getAbsolutePath()) + SEPARATOR + string3, (StringBuffer)charSequence)) {
                return;
            }
            if (bl && Library.load(string7 + SEPARATOR + string2, (StringBuffer)charSequence)) {
                return;
            }
        }
        if (Library.load(string5, (StringBuffer)charSequence)) {
            return;
        }
        if (bl && Library.load(string4, (StringBuffer)charSequence)) {
            return;
        }
        String string8 = string3;
        String string9 = string2;
        if (string7 == null) {
            string7 = System.getProperty("user.home");
            File file = new File(string7, SWT_LIB_DIR);
            if (file.exists() && file.isDirectory() || file.mkdirs()) {
                string7 = file.getAbsolutePath();
            } else if (IS_64) {
                string8 = Library.mapLibraryName(string5 + SUFFIX_64);
                string9 = Library.mapLibraryName(string4 + SUFFIX_64);
            }
            if (Library.load(string7 + SEPARATOR + string8, (StringBuffer)charSequence)) {
                return;
            }
            if (bl && Library.load(string7 + SEPARATOR + string9, (StringBuffer)charSequence)) {
                return;
            }
        }
        if (string7 != null) {
            if (Library.extract(string7 + SEPARATOR + string8, string3, (StringBuffer)charSequence)) {
                return;
            }
            if (bl && Library.extract(string7 + SEPARATOR + string9, string2, (StringBuffer)charSequence)) {
                return;
            }
        }
        throw new UnsatisfiedLinkError("Could not load SWT library. Reasons: " + ((StringBuffer)charSequence).toString());
    }

    static String mapLibraryName(String string) {
        String string2;
        if ((string = System.mapLibraryName(string)).endsWith(string2 = ".dylib")) {
            string = string.substring(0, string.length() - string2.length()) + ".jnilib";
        }
        return string;
    }

    static {
        IS_64 = Library.longConst() == Library.longConst();
        DELIMITER = System.getProperty("line.separator");
        SEPARATOR = System.getProperty("file.separator");
        SWT_LIB_DIR = ".swt" + SEPARATOR + "lib" + SEPARATOR + Library.os() + SEPARATOR + Library.arch();
        JAVA_VERSION = Library.parseVersion(System.getProperty("java.version"));
        SWT_VERSION = Library.SWT_VERSION(MAJOR_VERSION, MINOR_VERSION);
    }
}

