/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.heapviewer.java;

import com.sun.tools.visualvm.heapviewer.java.Bundle;
import com.sun.tools.visualvm.heapviewer.model.DataType;
import com.sun.tools.visualvm.heapviewer.model.HeapViewerNode;
import org.netbeans.lib.profiler.heap.GCRoot;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.modules.profiler.heapwalk.details.api.DetailsSupport;

public class InstanceNode
extends HeapViewerNode {
    private final Instance instance;
    private String name;
    private String logicalValue;

    public InstanceNode(Instance instance) {
        this.instance = instance;
    }

    public String toString() {
        return this.getName(null);
    }

    public Mode getMode() {
        return Mode.NONE;
    }

    public Instance getInstance() {
        return this.instance;
    }

    public JavaClass getJavaClass() {
        return this.instance.getJavaClass();
    }

    public String getName(Heap heap) {
        if (this.name == null) {
            if (heap == null) {
                return InstanceNode.computeName(this.instance, null);
            }
            this.name = InstanceNode.computeName(this.instance, heap);
        }
        return this.name;
    }

    public String getLogicalValue(Heap heap) {
        if (this.logicalValue == null) {
            this.logicalValue = InstanceNode.computeLogicalValue(this.instance, heap);
        }
        return this.logicalValue;
    }

    public long getOwnSize() {
        return this.instance.getSize();
    }

    public long getRetainedSize(Heap heap) {
        return DataType.RETAINED_SIZE.valuesAvailable(heap) ? this.instance.getRetainedSize() : DataType.RETAINED_SIZE.getNotAvailableValue().longValue();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InstanceNode)) {
            return false;
        }
        return this.instance.equals(((InstanceNode)((Object)o)).instance);
    }

    public int hashCode() {
        return this.instance.hashCode();
    }

    static String computeName(Instance instance, Heap heap) {
        GCRoot gcroot;
        String name = instance.getJavaClass().getName() + "#" + instance.getInstanceNumber();
        GCRoot gCRoot = gcroot = heap == null ? null : heap.getGCRoot(instance);
        if (gcroot != null) {
            name = Bundle.InstanceNode_GCRootFlag(name, gcroot.getKind());
        }
        return name;
    }

    static String computeLogicalValue(Instance instance, Heap heap) {
        String detail = DetailsSupport.getDetailsString((Instance)instance, (Heap)heap);
        return detail == null ? "" : detail;
    }

    protected Object getValue(DataType type, Heap heap) {
        if (type == DataType.NAME) {
            return this.getName(heap);
        }
        if (type == DataType.OWN_SIZE) {
            return this.getOwnSize();
        }
        if (type == DataType.RETAINED_SIZE) {
            return this.getRetainedSize(heap);
        }
        if (type == DataType.INSTANCE) {
            return this.getInstance();
        }
        if (type == DataType.CLASS) {
            return this.getJavaClass();
        }
        if (type == DataType.LOGICAL_VALUE) {
            return this.getLogicalValue(heap);
        }
        if (type == DataType.OBJECT_ID) {
            Instance i = this.getInstance();
            return i == null ? DataType.OBJECT_ID.getNoValue() : Long.valueOf(i.getInstanceId());
        }
        return super.getValue(type, heap);
    }

    @Override
    public InstanceNode createCopy() {
        if (this.instance == null) {
            return null;
        }
        InstanceNode copy = new InstanceNode(this.instance);
        this.setupCopy(copy);
        return copy;
    }

    protected void setupCopy(InstanceNode copy) {
        super.setupCopy(copy);
        copy.name = this.name;
        copy.logicalValue = this.logicalValue;
    }

    public static enum Mode {
        NONE,
        OUTGOING_REFERENCE,
        INCOMING_REFERENCE;

    }
}

