/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.codegen;

import java.text.MessageFormat;
import org.eclipse.jdt.internal.compiler.codegen.VerificationTypeInfo;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class StackMapFrame {
    public static final int USED = 1;
    public static final int SAME_FRAME = 0;
    public static final int CHOP_FRAME = 1;
    public static final int APPEND_FRAME = 2;
    public static final int SAME_FRAME_EXTENDED = 3;
    public static final int FULL_FRAME = 4;
    public static final int SAME_LOCALS_1_STACK_ITEMS = 5;
    public static final int SAME_LOCALS_1_STACK_ITEMS_EXTENDED = 6;
    public int pc;
    public int numberOfStackItems;
    private int numberOfLocals;
    public int localIndex;
    public VerificationTypeInfo[] locals;
    public VerificationTypeInfo[] stackItems;
    private int numberOfDifferentLocals = -1;
    public int tagBits;

    public StackMapFrame(int n) {
        this.locals = new VerificationTypeInfo[n];
        this.numberOfLocals = -1;
        this.numberOfDifferentLocals = -1;
    }

    public int getFrameType(StackMapFrame stackMapFrame) {
        int n = this.getOffsetDelta(stackMapFrame);
        switch (this.numberOfStackItems) {
            case 0: {
                switch (this.numberOfDifferentLocals(stackMapFrame)) {
                    case 0: {
                        return n <= 63 ? 0 : 3;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        return 2;
                    }
                    case -3: 
                    case -2: 
                    case -1: {
                        return 1;
                    }
                }
                break;
            }
            case 1: {
                switch (this.numberOfDifferentLocals(stackMapFrame)) {
                    case 0: {
                        return n <= 63 ? 5 : 6;
                    }
                }
            }
        }
        return 4;
    }

    public void addLocal(int n, VerificationTypeInfo verificationTypeInfo) {
        if (this.locals == null) {
            this.locals = new VerificationTypeInfo[n + 1];
            this.locals[n] = verificationTypeInfo;
        } else {
            int n2 = this.locals.length;
            if (n >= n2) {
                this.locals = new VerificationTypeInfo[n + 1];
                System.arraycopy(this.locals, 0, this.locals, 0, n2);
            }
            this.locals[n] = verificationTypeInfo;
        }
    }

    public void addStackItem(VerificationTypeInfo verificationTypeInfo) {
        if (verificationTypeInfo == null) {
            throw new IllegalArgumentException("info cannot be null");
        }
        if (this.stackItems == null) {
            this.stackItems = new VerificationTypeInfo[1];
            this.stackItems[0] = verificationTypeInfo;
            this.numberOfStackItems = 1;
        } else {
            int n = this.stackItems.length;
            if (this.numberOfStackItems == n) {
                this.stackItems = new VerificationTypeInfo[n + 1];
                System.arraycopy(this.stackItems, 0, this.stackItems, 0, n);
            }
            this.stackItems[this.numberOfStackItems++] = verificationTypeInfo;
        }
    }

    public void addStackItem(TypeBinding typeBinding) {
        if (this.stackItems == null) {
            this.stackItems = new VerificationTypeInfo[1];
            this.stackItems[0] = new VerificationTypeInfo(typeBinding);
            this.numberOfStackItems = 1;
        } else {
            int n = this.stackItems.length;
            if (this.numberOfStackItems == n) {
                this.stackItems = new VerificationTypeInfo[n + 1];
                System.arraycopy(this.stackItems, 0, this.stackItems, 0, n);
            }
            this.stackItems[this.numberOfStackItems++] = new VerificationTypeInfo(typeBinding);
        }
    }

    public StackMapFrame duplicate() {
        int n;
        int n2 = this.locals.length;
        StackMapFrame stackMapFrame = new StackMapFrame(n2);
        stackMapFrame.numberOfLocals = -1;
        stackMapFrame.numberOfDifferentLocals = -1;
        stackMapFrame.pc = this.pc;
        stackMapFrame.numberOfStackItems = this.numberOfStackItems;
        if (n2 != 0) {
            stackMapFrame.locals = new VerificationTypeInfo[n2];
            for (n = 0; n < n2; ++n) {
                VerificationTypeInfo verificationTypeInfo = this.locals[n];
                if (verificationTypeInfo == null) continue;
                stackMapFrame.locals[n] = verificationTypeInfo.duplicate();
            }
        }
        if ((n2 = this.numberOfStackItems) != 0) {
            stackMapFrame.stackItems = new VerificationTypeInfo[n2];
            for (n = 0; n < n2; ++n) {
                stackMapFrame.stackItems[n] = this.stackItems[n].duplicate();
            }
        }
        return stackMapFrame;
    }

    public int numberOfDifferentLocals(StackMapFrame stackMapFrame) {
        if (this.numberOfDifferentLocals != -1) {
            return this.numberOfDifferentLocals;
        }
        if (stackMapFrame == null) {
            this.numberOfDifferentLocals = 0;
            return 0;
        }
        VerificationTypeInfo[] verificationTypeInfoArray = stackMapFrame.locals;
        VerificationTypeInfo[] verificationTypeInfoArray2 = this.locals;
        int n = verificationTypeInfoArray == null ? 0 : verificationTypeInfoArray.length;
        int n2 = verificationTypeInfoArray2 == null ? 0 : verificationTypeInfoArray2.length;
        int n3 = stackMapFrame.getNumberOfLocals();
        int n4 = this.getNumberOfLocals();
        int n5 = 0;
        if (n3 == 0) {
            if (n4 != 0) {
                n5 = n4;
                int n6 = 0;
                for (int i = 0; i < n2 && n6 < n4; ++n6, ++i) {
                    if (verificationTypeInfoArray2[i] != null) {
                        switch (verificationTypeInfoArray2[i].id()) {
                            case 7: 
                            case 8: {
                                ++i;
                            }
                        }
                        continue;
                    }
                    this.numberOfDifferentLocals = n5 = Integer.MAX_VALUE;
                    return n5;
                }
            }
        } else if (n4 == 0) {
            int n7 = 0;
            n5 = -n3;
            for (int i = 0; i < n && n7 < n3; ++n7, ++i) {
                if (verificationTypeInfoArray[i] != null) {
                    switch (verificationTypeInfoArray[i].id()) {
                        case 7: 
                        case 8: {
                            ++i;
                        }
                    }
                    continue;
                }
                this.numberOfDifferentLocals = n5 = Integer.MAX_VALUE;
                return n5;
            }
        } else {
            VerificationTypeInfo verificationTypeInfo;
            int n8;
            int n9 = 0;
            int n10 = 0;
            int n11 = 0;
            for (n8 = 0; n8 < n2 && n10 < n4; ++n8) {
                verificationTypeInfo = verificationTypeInfoArray2[n8];
                if (verificationTypeInfo != null) {
                    ++n10;
                    switch (verificationTypeInfo.id()) {
                        case 7: 
                        case 8: {
                            ++n8;
                        }
                    }
                }
                if (n9 < n && n11 < n3) {
                    VerificationTypeInfo verificationTypeInfo2 = verificationTypeInfoArray[n9];
                    if (verificationTypeInfo2 != null) {
                        ++n11;
                        switch (verificationTypeInfo2.id()) {
                            case 7: 
                            case 8: {
                                ++n9;
                            }
                        }
                    }
                    if (this.equals(verificationTypeInfo2, verificationTypeInfo) && n9 == n8) {
                        if (n5 != 0) {
                            this.numberOfDifferentLocals = n5 = Integer.MAX_VALUE;
                            return n5;
                        }
                    } else {
                        this.numberOfDifferentLocals = n5 = Integer.MAX_VALUE;
                        return n5;
                    }
                    ++n9;
                    continue;
                }
                if (verificationTypeInfo != null) {
                    ++n5;
                } else {
                    this.numberOfDifferentLocals = n5 = Integer.MAX_VALUE;
                    return n5;
                }
                ++n8;
                break;
            }
            if (n10 < n4) {
                while (n8 < n2 && n10 < n4) {
                    verificationTypeInfo = verificationTypeInfoArray2[n8];
                    if (verificationTypeInfo == null) {
                        this.numberOfDifferentLocals = n5 = Integer.MAX_VALUE;
                        return n5;
                    }
                    ++n5;
                    ++n10;
                    switch (verificationTypeInfo.id()) {
                        case 7: 
                        case 8: {
                            ++n8;
                        }
                    }
                    ++n8;
                }
            } else if (n11 < n3) {
                n5 = -n5;
                while (n9 < n && n11 < n3) {
                    verificationTypeInfo = verificationTypeInfoArray[n9];
                    if (verificationTypeInfo == null) {
                        this.numberOfDifferentLocals = n5 = Integer.MAX_VALUE;
                        return n5;
                    }
                    --n5;
                    ++n11;
                    switch (verificationTypeInfo.id()) {
                        case 7: 
                        case 8: {
                            ++n9;
                        }
                    }
                    ++n9;
                }
            }
        }
        this.numberOfDifferentLocals = n5;
        return n5;
    }

    public int getNumberOfLocals() {
        if (this.numberOfLocals != -1) {
            return this.numberOfLocals;
        }
        int n = 0;
        int n2 = this.locals == null ? 0 : this.locals.length;
        for (int i = 0; i < n2; ++i) {
            if (this.locals[i] == null) continue;
            switch (this.locals[i].id()) {
                case 7: 
                case 8: {
                    ++i;
                }
            }
            ++n;
        }
        this.numberOfLocals = n;
        return n;
    }

    public int getOffsetDelta(StackMapFrame stackMapFrame) {
        if (stackMapFrame == null) {
            return this.pc;
        }
        return stackMapFrame.pc == -1 ? this.pc : this.pc - stackMapFrame.pc - 1;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.printFrame(stringBuffer, this);
        return String.valueOf(stringBuffer);
    }

    private void printFrame(StringBuffer stringBuffer, StackMapFrame stackMapFrame) {
        String string = "[pc : {0} locals: {1} stack items: {2}\nlocals: {3}\nstack: {4}\n]";
        int n = stackMapFrame.locals == null ? 0 : stackMapFrame.locals.length;
        stringBuffer.append(MessageFormat.format(string, Integer.toString(stackMapFrame.pc), Integer.toString(stackMapFrame.getNumberOfLocals()), Integer.toString(stackMapFrame.numberOfStackItems), this.print(stackMapFrame.locals, n), this.print(stackMapFrame.stackItems, stackMapFrame.numberOfStackItems)));
    }

    private String print(VerificationTypeInfo[] verificationTypeInfoArray, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        if (verificationTypeInfoArray != null) {
            for (int i = 0; i < n; ++i) {
                VerificationTypeInfo verificationTypeInfo;
                if (i != 0) {
                    stringBuffer.append(',');
                }
                if ((verificationTypeInfo = verificationTypeInfoArray[i]) == null) {
                    stringBuffer.append("top");
                    continue;
                }
                stringBuffer.append(verificationTypeInfo);
            }
        }
        stringBuffer.append(']');
        return String.valueOf(stringBuffer);
    }

    public void putLocal(int n, VerificationTypeInfo verificationTypeInfo) {
        if (this.locals == null) {
            this.locals = new VerificationTypeInfo[n + 1];
            this.locals[n] = verificationTypeInfo;
        } else {
            int n2 = this.locals.length;
            if (n >= n2) {
                this.locals = new VerificationTypeInfo[n + 1];
                System.arraycopy(this.locals, 0, this.locals, 0, n2);
            }
            this.locals[n] = verificationTypeInfo;
        }
    }

    public void replaceWithElementType() {
        VerificationTypeInfo verificationTypeInfo = this.stackItems[this.numberOfStackItems - 1];
        VerificationTypeInfo verificationTypeInfo2 = verificationTypeInfo.duplicate();
        verificationTypeInfo2.replaceWithElementType();
        this.stackItems[this.numberOfStackItems - 1] = verificationTypeInfo2;
    }

    public int getIndexOfDifferentLocals(int n) {
        for (int i = this.locals.length - 1; i >= 0; --i) {
            VerificationTypeInfo verificationTypeInfo = this.locals[i];
            if (verificationTypeInfo == null || --n != 0) continue;
            return i;
        }
        return 0;
    }

    private boolean equals(VerificationTypeInfo verificationTypeInfo, VerificationTypeInfo verificationTypeInfo2) {
        if (verificationTypeInfo == null) {
            return verificationTypeInfo2 == null;
        }
        if (verificationTypeInfo2 == null) {
            return false;
        }
        return verificationTypeInfo.equals(verificationTypeInfo2);
    }
}

