/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import org.netbeans.modules.openide.loaders.SimpleES;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.util.Lookup;

final class MultiDOEditor
implements Callable<CloneableEditorSupport.Pane>,
CookieSet.Factory {
    private CloneableEditorSupport support;
    private static final Method factory;
    private final MultiDataObject outer;
    private final String mimeType;
    private final boolean useMultiview;

    MultiDOEditor(MultiDataObject multiDataObject, String string, boolean bl) {
        this.outer = multiDataObject;
        this.mimeType = string;
        this.useMultiview = bl;
    }

    static boolean isMultiViewAvailable() {
        return factory != null;
    }

    static CloneableEditorSupport.Pane createMultiViewPane(String string, MultiDataObject multiDataObject) {
        try {
            return (CloneableEditorSupport.Pane)factory.invoke(null, string, multiDataObject);
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    @Override
    public CloneableEditorSupport.Pane call() throws Exception {
        if (factory != null) {
            return MultiDOEditor.createMultiViewPane(this.mimeType, this.outer);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Node.Cookie> T createCookie(Class<T> clazz) {
        if (clazz.isAssignableFrom(SimpleES.class)) {
            MultiDOEditor multiDOEditor = this;
            synchronized (multiDOEditor) {
                if (this.support == null) {
                    this.support = DataEditorSupport.create(this.outer, this.outer.getPrimaryEntry(), this.outer.getCookieSet(), this.useMultiview ? this : null);
                }
            }
            return (T)((Node.Cookie)clazz.cast(this.support));
        }
        return null;
    }

    public static void registerEditor(MultiDataObject multiDataObject, String string, boolean bl) {
        MultiDOEditor multiDOEditor = new MultiDOEditor(multiDataObject, string, bl);
        multiDataObject.getCookieSet().add(SimpleES.class, (CookieSet.Factory)multiDOEditor);
    }

    static {
        ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        if (classLoader == null) {
            classLoader = MultiDOEditor.class.getClassLoader();
        }
        Method method = null;
        try {
            Class<?> clazz = Class.forName("org.netbeans.core.api.multiview.MultiViews", true, classLoader);
            method = clazz.getMethod("createCloneableMultiView", String.class, Serializable.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            MultiDataObject.LOG.log(Level.WARNING, "Cannot find a method", noSuchMethodException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            MultiDataObject.LOG.info("Not using multiviews for MultiDataObject.registerEditor()");
            MultiDataObject.LOG.log(Level.FINE, "Cannot find a class", classNotFoundException);
        }
        factory = method;
    }
}

