/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.swing.renderer;

import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import org.netbeans.lib.profiler.ui.swing.renderer.BarRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.MultiRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.NumberPercentRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.ProfilerRenderer;

public class HideableBarRenderer
extends MultiRenderer {
    private static final int BAR_MARGIN = 20;
    private static final int MIN_BAR_WIDTH = 20;
    private static final int MAX_BAR_WIDTH = 100;
    private static final int OPT_BAR_WIDTH = 50;
    private BarDiffMode barDiffMode = BarDiffMode.MODE_BAR_DIFF;
    private int maxRendererWidth;
    private final BarRenderer barRenderer;
    private final ProfilerRenderer mainRenderer;
    private final NumberPercentRenderer numberPercentRenderer;
    private final ProfilerRenderer[] valueRenderers;

    public HideableBarRenderer(ProfilerRenderer profilerRenderer) {
        this(profilerRenderer, profilerRenderer.getComponent().getPreferredSize().width);
    }

    public HideableBarRenderer(ProfilerRenderer profilerRenderer, int n) {
        this.maxRendererWidth = n;
        this.barRenderer = new BarRenderer();
        this.mainRenderer = profilerRenderer;
        this.numberPercentRenderer = profilerRenderer instanceof NumberPercentRenderer ? (NumberPercentRenderer)profilerRenderer : null;
        this.valueRenderers = new ProfilerRenderer[]{this.barRenderer, this.mainRenderer};
        this.setOpaque(true);
        this.setHorizontalAlignment(11);
    }

    public void setBarDiffMode(BarDiffMode barDiffMode) {
        this.barDiffMode = barDiffMode;
    }

    public BarDiffMode getBarDiffMode() {
        return this.barDiffMode;
    }

    @Override
    public void setDiffMode(boolean bl) {
        super.setDiffMode(bl);
        if (!bl || BarDiffMode.MODE_BAR_NORMAL.equals((Object)this.barDiffMode)) {
            this.barRenderer.setVisible(true);
            this.barRenderer.setDiffMode(false);
        } else if (BarDiffMode.MODE_BAR_NONE.equals((Object)this.barDiffMode)) {
            this.barRenderer.setVisible(false);
        } else if (BarDiffMode.MODE_BAR_DIFF.equals((Object)this.barDiffMode)) {
            this.barRenderer.setDiffMode(true);
        }
    }

    public void setMaxValue(long l) {
        int n = Long.toString(this.barRenderer.getMaxValue()).length();
        int n2 = Long.toString(l).length();
        this.barRenderer.setMaxValue(l);
        if (this.numberPercentRenderer != null) {
            this.numberPercentRenderer.setMaxValue(l);
        }
        if (n < n2) {
            this.mainRenderer.setValue((long)Math.pow(10.0, n2) - 1L, -1);
            int n3 = this.mainRenderer.getComponent().getPreferredSize().width;
            this.maxRendererWidth = Math.max(this.maxRendererWidth, n3);
        }
    }

    @Override
    public void setValue(Object object, int n) {
        this.barRenderer.setValue(object, n);
        this.mainRenderer.setValue(object, n);
    }

    @Override
    protected ProfilerRenderer[] valueRenderers() {
        return this.valueRenderers;
    }

    @Override
    protected int renderersGap() {
        return 20;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.mainRenderer.getComponent().getPreferredSize();
    }

    public int getOptimalWidth() {
        return this.maxRendererWidth + this.renderersGap() + 50;
    }

    public int getMaxNoBarWidth() {
        return this.maxRendererWidth + this.renderersGap() + 20 - 1;
    }

    public int getNoBarWidth() {
        return this.maxRendererWidth;
    }

    @Override
    public void paint(Graphics graphics) {
        int n;
        graphics.setColor(this.getBackground());
        graphics.fillRect(this.location.x, this.location.y, this.size.width, this.size.height);
        JComponent jComponent = this.mainRenderer.getComponent();
        int n2 = jComponent.getPreferredSize().width;
        int n3 = this.size.width - n2;
        this.mainRenderer.move(this.location.x + n3, this.location.y);
        jComponent.setSize(n2, this.size.height);
        jComponent.paint(graphics);
        if (this.barRenderer.isVisible() && (n = this.size.width - this.maxRendererWidth - this.renderersGap()) >= 20) {
            this.barRenderer.setSize(Math.min(n, 100), this.size.height);
            this.barRenderer.move(this.location.x, this.location.y);
            this.barRenderer.paint(graphics);
        }
    }

    @Override
    public String toString() {
        return this.mainRenderer.toString();
    }

    public static enum BarDiffMode {
        MODE_BAR_DIFF,
        MODE_BAR_NORMAL,
        MODE_BAR_NONE;

    }
}

