/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.plus.poi;

import java.util.ArrayList;
import java.util.List;
import net.osmand.ResultMatcher;
import net.osmand.data.Amenity;
import net.osmand.plus.poi.PoiUIFilter;
import net.osmand.util.MapUtils;
import net.sourceforge.offroad.OsmWindow;

public class SearchByNameFilter
extends PoiUIFilter {
    public static final String FILTER_ID = "user_by_name";

    public SearchByNameFilter(OsmWindow application) {
        super(application);
        this.name = application.getString(382);
        this.filterId = FILTER_ID;
        this.distanceToSearchValues = new double[]{100.0, 1000.0, 5000.0};
    }

    @Override
    public boolean isAutomaticallyIncreaseSearch() {
        return false;
    }

    @Override
    protected List<Amenity> searchAmenitiesInternal(double lat, double lon, double topLatitude, double bottomLatitude, double leftLongitude, double rightLongitude, final ResultMatcher<Amenity> matcher) {
        this.currentSearchResult = new ArrayList();
        final int limit = this.distanceInd == 0 ? 500 : -1;
        List<Amenity> result = this.app.getResourceManager().searchAmenitiesByName(this.getFilterByName(), topLatitude, leftLongitude, bottomLatitude, rightLongitude, lat, lon, new ResultMatcher<Amenity>(){
            boolean elimit = false;

            @Override
            public boolean publish(Amenity object) {
                if (limit != -1 && SearchByNameFilter.this.currentSearchResult.size() > limit) {
                    this.elimit = true;
                }
                if (matcher.publish(object)) {
                    SearchByNameFilter.this.currentSearchResult.add(object);
                    return true;
                }
                return false;
            }

            @Override
            public boolean isCancelled() {
                return matcher.isCancelled() || this.elimit;
            }
        });
        MapUtils.sortListOfMapObject(result, lat, lon);
        this.currentSearchResult = result;
        return this.currentSearchResult;
    }
}

