/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino;

import cc.arduino.packages.BoardPort;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import processing.app.BaseNoGui;
import processing.app.PreferencesData;
import processing.app.helpers.PreferencesMap;

public class LoadVIDPIDSpecificPreferences {
    public void load(PreferencesMap prefs) {
        BoardPort boardPort = BaseNoGui.getDiscoveryManager().find(PreferencesData.get("serial.port"));
        if (boardPort == null) {
            return;
        }
        String vid = (String)boardPort.getPrefs().get("vid");
        String pid = (String)boardPort.getPrefs().get("pid");
        if (StringUtils.isEmpty((CharSequence)vid) || StringUtils.isEmpty((CharSequence)pid)) {
            return;
        }
        int VIDPIDIndex = this.findVIDPIDIndex(prefs, vid.toUpperCase(), pid.toUpperCase());
        if (VIDPIDIndex < 0) {
            return;
        }
        prefs.putAll(prefs.subTree("vid." + VIDPIDIndex));
    }

    private int findVIDPIDIndex(PreferencesMap preferences, String vid, String pid) {
        Optional<Integer> vidPid = preferences.subTree("vid").entrySet().stream().filter(keyValue -> !((String)keyValue.getKey()).contains(".")).filter(keyValue -> vid.equals(((String)keyValue.getValue()).toUpperCase()) && pid.equals(((String)preferences.get("pid." + (String)keyValue.getKey())).toUpperCase())).map(Map.Entry::getKey).map(Integer::valueOf).findFirst();
        return vidPid.orElse(-1);
    }
}

