/*
 * Decompiled with CFR 0.152.
 */
package processing.app.windows;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ListComPortsParser {
    private final Pattern vidRegExp = Pattern.compile("VID_(\\w\\w\\w\\w)");
    private final Pattern pidRegExp = Pattern.compile("PID_(\\w\\w\\w\\w)");

    public String extractVIDAndPID(String output, String serial) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new StringReader(output));
        while ((line = reader.readLine()) != null) {
            String[] lineParts = line.split(" ");
            if (lineParts.length <= 0 || !lineParts[0].toUpperCase().equals(serial.toUpperCase())) continue;
            String vidPidPart = lineParts[lineParts.length - 1];
            Matcher vidMatcher = this.vidRegExp.matcher(vidPidPart);
            Matcher pidMatcher = this.pidRegExp.matcher(vidPidPart);
            if (!vidMatcher.find() || !pidMatcher.find()) continue;
            return ("0x" + vidMatcher.group(1) + "_0x" + pidMatcher.group(1)).toUpperCase();
        }
        return null;
    }
}

