/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.ClassWriter;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.ScriptRoot;
import org.elasticsearch.painless.node.AStoreable;

public final class EVariable
extends AStoreable {
    private final String name;
    private Locals.Variable variable = null;

    public EVariable(Location location, String name) {
        super(location);
        this.name = Objects.requireNonNull(name);
    }

    @Override
    void extractVariables(Set<String> variables) {
        variables.add(this.name);
    }

    @Override
    void analyze(ScriptRoot scriptRoot, Locals locals) {
        this.variable = locals.getVariable(this.location, this.name);
        if (this.write && this.variable.readonly) {
            throw this.createError(new IllegalArgumentException("Variable [" + this.variable.name + "] is read-only."));
        }
        this.actual = this.variable.clazz;
    }

    @Override
    void write(ClassWriter classWriter, MethodWriter methodWriter, Globals globals) {
        methodWriter.visitVarInsn(MethodWriter.getType(this.actual).getOpcode(21), this.variable.getSlot());
    }

    @Override
    int accessElementCount() {
        return 0;
    }

    @Override
    boolean isDefOptimized() {
        return false;
    }

    @Override
    void updateActual(Class<?> actual) {
        throw new IllegalArgumentException("Illegal tree structure.");
    }

    @Override
    void setup(ClassWriter classWriter, MethodWriter methodWriter, Globals globals) {
    }

    @Override
    void load(ClassWriter classWriter, MethodWriter methodWriter, Globals globals) {
        methodWriter.visitVarInsn(MethodWriter.getType(this.actual).getOpcode(21), this.variable.getSlot());
    }

    @Override
    void store(ClassWriter classWriter, MethodWriter methodWriter, Globals globals) {
        methodWriter.visitVarInsn(MethodWriter.getType(this.actual).getOpcode(54), this.variable.getSlot());
    }

    @Override
    public String toString() {
        return this.singleLineToString(this.name);
    }
}

