/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.util.Comparators;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.metrics.MetricsAggregator;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.sort.SortOrder;

public abstract class NumericMetricsAggregator
extends MetricsAggregator {
    private NumericMetricsAggregator(String name, SearchContext context, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        super(name, context, parent, pipelineAggregators, metaData);
    }

    public static abstract class MultiValue
    extends NumericMetricsAggregator {
        protected MultiValue(String name, SearchContext context, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
            super(name, context, parent, pipelineAggregators, metaData);
        }

        public abstract boolean hasMetric(String var1);

        public abstract double metric(String var1, long var2);

        @Override
        public Aggregator.BucketComparator bucketComparator(String key, SortOrder order) {
            if (key == null) {
                throw new IllegalArgumentException("When ordering on a multi-value metrics aggregation a metric name must be specified.");
            }
            if (!this.hasMetric(key)) {
                throw new IllegalArgumentException("Unknown metric name [" + key + "] on multi-value metrics aggregation [" + this.name() + "]");
            }
            return (lhs, rhs) -> Comparators.compareDiscardNaN(this.metric(key, lhs), this.metric(key, rhs), order == SortOrder.ASC);
        }
    }

    public static abstract class SingleValue
    extends NumericMetricsAggregator {
        protected SingleValue(String name, SearchContext context, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
            super(name, context, parent, pipelineAggregators, metaData);
        }

        public abstract double metric(long var1);

        @Override
        public Aggregator.BucketComparator bucketComparator(String key, SortOrder order) {
            if (key != null && !"value".equals(key)) {
                throw new IllegalArgumentException("Ordering on a single-value metrics aggregation can only be done on its value. Either drop the key (a la \"" + this.name() + "\") or change it to \"value\" (a la \"" + this.name() + ".value\")");
            }
            return (lhs, rhs) -> Comparators.compareDiscardNaN(this.metric(lhs), this.metric(rhs), order == SortOrder.ASC);
        }
    }
}

