/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.crypto.SecretKey;
import org.bouncycastle.jcajce.ZeroizableSecretKey;
import org.bouncycastle.util.Arrays;

public final class AgreedKeyWithMacKey
implements SecretKey {
    private final SecretKey secretKey;
    private final byte[] macKey;
    private final String macAlgorithm;
    private final AtomicBoolean isZeroed = new AtomicBoolean(false);

    public AgreedKeyWithMacKey(SecretKey secretKey) {
        this(secretKey, null, null);
    }

    public AgreedKeyWithMacKey(SecretKey secretKey, String string, byte[] byArray) {
        this.secretKey = secretKey;
        this.macKey = Arrays.clone(byArray);
        this.macAlgorithm = string;
    }

    public String getAlgorithm() {
        return this.secretKey.getAlgorithm();
    }

    public String getFormat() {
        return this.secretKey.getFormat();
    }

    public byte[] getEncoded() {
        return this.secretKey.getEncoded();
    }

    public boolean equals(Object object) {
        return this.secretKey.equals(object);
    }

    public int hashCode() {
        return this.secretKey.hashCode();
    }

    private byte[] getMacKeyBytes() {
        if (this.isZeroed.get()) {
            return null;
        }
        return this.macKey;
    }

    public ZeroizableSecretKey getMacKey() {
        if (this.macKey == null) {
            return null;
        }
        return new ZeroizableSecretKey(){

            public void zeroize() {
                AgreedKeyWithMacKey.this.isZeroed.set(true);
                if (AgreedKeyWithMacKey.this.macKey != null) {
                    Arrays.fill(AgreedKeyWithMacKey.this.macKey, (byte)0);
                }
            }

            public String getAlgorithm() {
                return AgreedKeyWithMacKey.this.macAlgorithm;
            }

            public String getFormat() {
                return "RAW";
            }

            public byte[] getEncoded() {
                return AgreedKeyWithMacKey.this.getMacKeyBytes();
            }
        };
    }
}

