/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.fibs.geotag.Settings;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class DateTimeChooser
extends JDialog {
    private static final I18n i18n = I18nFactory.getI18n(DateTimeChooser.class);
    private static final int MONTHS_IN_YEAR = 12;
    private static final int HOURS_IN_DAY = 24;
    private static final int DAYS_IN_WEEK = 7;
    private static final int MAX_WEEKS_IN_MONTH = 6;
    private JFrame parent;
    private Calendar displayedDate;
    private CalendarLabel[] monthLabels = new CalendarLabel[12];
    private CalendarLabel[][] dayLabels = new CalendarLabel[6][7];
    private CalendarLabel yearLabel;
    private JPanel yearPanel;
    private JPanel monthsPanel;
    private JPanel daysPanel;
    private JPanel calendarPanel;
    private JPanel timePanel;
    private JPanel buttonPanel;
    private TimeZone currentZone;

    public DateTimeChooser(JFrame parent, String title, Calendar date, boolean hasNowButton) {
        super(parent, title, true);
        this.parent = parent;
        this.displayedDate = date;
        this.setLayout(new BorderLayout());
        this.calendarPanel = new JPanel();
        this.calendarPanel.setLayout(new BorderLayout());
        this.calendarPanel.setBorder(new EtchedBorder(0));
        this.setupYearPanel();
        this.calendarPanel.add((Component)this.yearPanel, "North");
        this.setupMonthsPanel();
        this.calendarPanel.add((Component)this.monthsPanel, "Center");
        this.setupDaysPanel();
        this.calendarPanel.add((Component)this.daysPanel, "South");
        this.add((Component)this.calendarPanel, "North");
        final SpinnerDateModel timeModel = new SpinnerDateModel();
        this.setupTimePanel(timeModel);
        this.add((Component)this.timePanel, "Center");
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new GridLayout(1, hasNowButton ? 3 : 2));
        this.buttonPanel.setBorder(new EtchedBorder(0));
        JButton okButton = new JButton(i18n.tr("OK"));
        okButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Calendar displayedTime = Calendar.getInstance();
                displayedTime.setTimeZone(DateTimeChooser.this.getCurrentZone());
                displayedTime.setTime(timeModel.getDate());
                DateTimeChooser.this.getDisplayedDate().set(11, displayedTime.get(11));
                DateTimeChooser.this.getDisplayedDate().set(12, displayedTime.get(12));
                DateTimeChooser.this.getDisplayedDate().set(13, displayedTime.get(13));
                DateTimeChooser.this.dispose();
            }
        });
        this.buttonPanel.add(okButton);
        JButton cancelButton = new JButton(i18n.tr("Cancel"));
        cancelButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DateTimeChooser.this.setDisplayedDate(null);
                DateTimeChooser.this.dispose();
            }
        });
        this.buttonPanel.add(cancelButton);
        JButton nowButton = new JButton(i18n.tr("Now"));
        nowButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DateTimeChooser.this.getDisplayedDate().setTime(new Date());
                timeModel.setValue(DateTimeChooser.this.getDisplayedDate().getTime());
                DateTimeChooser.this.updateDateShown();
            }
        });
        if (hasNowButton) {
            this.buttonPanel.add(nowButton);
        }
        this.add((Component)this.buttonPanel, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DateTimeChooser.this.setDisplayedDate(null);
                super.windowClosing(e);
            }
        });
    }

    private void setupTimePanel(SpinnerDateModel timeModel) {
        this.timePanel = new JPanel();
        this.timePanel.setLayout(new GridLayout(2, 1));
        timeModel.setValue(this.displayedDate.getTime());
        JSpinner timeSpinner = new JSpinner(timeModel);
        final JSpinner.DateEditor timeEditor = new JSpinner.DateEditor(timeSpinner, "HH:mm:ss");
        timeSpinner.setEditor(timeEditor);
        JFormattedTextField textField = timeEditor.getTextField();
        textField.setHorizontalAlignment(0);
        timeSpinner.addChangeListener(new ChangeListenerAdapter(){

            @Override
            public void stateChanged(ChangeEvent event) {
                super.stateChanged(event);
                JSpinner spinner = (JSpinner)event.getSource();
                try {
                    spinner.commitEdit();
                    Calendar newDate = Calendar.getInstance(DateTimeChooser.this.getDisplayedDate().getTimeZone());
                    newDate.setTime((Date)spinner.getValue());
                    newDate.set(DateTimeChooser.this.getDisplayedDate().get(1), DateTimeChooser.this.getDisplayedDate().get(2), DateTimeChooser.this.getDisplayedDate().get(5));
                    DateTimeChooser.this.setDisplayedDate(newDate);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        });
        this.timePanel.add(timeSpinner);
        ArrayList<Object> timeZoneNames = new ArrayList<Object>();
        this.currentZone = this.displayedDate.getTimeZone();
        String lastUsedTimeZone = Settings.get(Settings.SETTING.LAST_USED_TIMEZONE, this.displayedDate.getTimeZone().getID());
        timeZoneNames.add(lastUsedTimeZone);
        String defaultZone = new GregorianCalendar().getTimeZone().getID();
        if (!lastUsedTimeZone.equals(defaultZone)) {
            timeZoneNames.add(defaultZone);
        }
        int offset = -12;
        while (offset <= 12) {
            String name = "GMT";
            if (offset >= 0) {
                name = String.valueOf(name) + '+';
            }
            name = String.valueOf(name) + offset;
            timeZoneNames.add(TimeZone.getTimeZone(name).getID());
            ++offset;
        }
        Object[] availableTimeZones = TimeZone.getAvailableIDs();
        Arrays.sort(availableTimeZones);
        Object[] objectArray = availableTimeZones;
        int n = availableTimeZones.length;
        int n2 = 0;
        while (n2 < n) {
            Object timezoneId = objectArray[n2];
            timeZoneNames.add(timezoneId);
            ++n2;
        }
        JComboBox<Object> timezoneComboBox = new JComboBox<Object>(timeZoneNames.toArray()){

            @Override
            public void actionPerformed(ActionEvent event) {
                DateTimeChooser.this.setCurrentZone(TimeZone.getTimeZone((String)this.getSelectedItem()));
                Settings.put(Settings.SETTING.LAST_USED_TIMEZONE, DateTimeChooser.this.getCurrentZone().getID());
                Calendar newDisplayedDate = Calendar.getInstance(DateTimeChooser.this.getCurrentZone());
                newDisplayedDate.set(5, DateTimeChooser.this.getDisplayedDate().get(5));
                newDisplayedDate.set(2, DateTimeChooser.this.getDisplayedDate().get(2));
                newDisplayedDate.set(1, DateTimeChooser.this.getDisplayedDate().get(1));
                newDisplayedDate.set(11, DateTimeChooser.this.getDisplayedDate().get(11));
                newDisplayedDate.set(12, DateTimeChooser.this.getDisplayedDate().get(12));
                newDisplayedDate.set(13, DateTimeChooser.this.getDisplayedDate().get(13));
                DateTimeChooser.this.setDisplayedDate(newDisplayedDate);
                timeEditor.getFormat().setTimeZone(DateTimeChooser.this.getCurrentZone());
                timeEditor.getTextField().setValue(DateTimeChooser.this.getDisplayedDate().getTime());
            }
        };
        timezoneComboBox.addActionListener(timezoneComboBox);
        timezoneComboBox.setSelectedIndex(0);
        Dimension preferredSize = timezoneComboBox.getPreferredSize();
        preferredSize.width = 42;
        timezoneComboBox.setPreferredSize(preferredSize);
        this.timePanel.add(timezoneComboBox);
    }

    private void setupDaysPanel() {
        this.daysPanel = new JPanel();
        this.daysPanel.setBorder(new EtchedBorder(1));
        this.daysPanel.setLayout(new GridLayout(7, 7));
        String[] weekdayNames = new DateFormatSymbols().getShortWeekdays();
        int day = 1;
        while (day <= 7) {
            CalendarLabel label = new CalendarLabel(weekdayNames[this.getNthDayOfWeek(null, day)], true, false);
            this.daysPanel.add(label);
            ++day;
        }
        int row = 0;
        while (row < 6) {
            int col = 0;
            while (col < 7) {
                this.dayLabels[row][col] = new CalendarLabel("X", false, false);
                this.dayLabels[row][col].addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent event) {
                        CalendarLabel daySelected = (CalendarLabel)event.getSource();
                        int day = daySelected.getNumber();
                        if (day > 0) {
                            DateTimeChooser.this.getDisplayedDate().set(5, day);
                            DateTimeChooser.this.updateDateShown();
                        }
                    }
                });
                this.daysPanel.add(this.dayLabels[row][col]);
                ++col;
            }
            ++row;
        }
    }

    private void setupMonthsPanel() {
        this.monthsPanel = new JPanel();
        this.monthsPanel.setBorder(new EtchedBorder(1));
        this.monthsPanel.setLayout(new GridLayout(2, 6));
        String[] monthSymbols = new DateFormatSymbols().getShortMonths();
        int month = 0;
        while (month < 12) {
            this.monthLabels[month] = new CalendarLabel(monthSymbols[month], false, false);
            this.monthLabels[month].setNumber(month);
            this.monthLabels[month].addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent event) {
                    int selectedMonth = ((CalendarLabel)event.getSource()).getNumber();
                    DateTimeChooser.this.getDisplayedDate().set(2, selectedMonth);
                    DateTimeChooser.this.updateDateShown();
                }
            });
            this.monthsPanel.add(this.monthLabels[month]);
            ++month;
        }
    }

    private void setupYearPanel() {
        this.yearPanel = new JPanel();
        this.yearPanel.setBorder(new EtchedBorder(1));
        this.yearPanel.setLayout(new GridLayout(1, 3));
        CalendarLabel decrement = new CalendarLabel("-", true, true);
        decrement.setHorizontalAlignment(4);
        decrement.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                DateTimeChooser.this.getDisplayedDate().set(1, DateTimeChooser.this.getDisplayedDate().get(1) - 1);
                DateTimeChooser.this.updateDateShown();
            }
        });
        this.yearPanel.add(decrement);
        this.yearLabel = new CalendarLabel("Year", true, false);
        this.yearLabel.setHighlighted(true);
        this.yearPanel.add(this.yearLabel);
        CalendarLabel increment = new CalendarLabel("+", true, true);
        increment.setHorizontalAlignment(2);
        increment.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                DateTimeChooser.this.getDisplayedDate().set(1, DateTimeChooser.this.getDisplayedDate().get(1) + 1);
                DateTimeChooser.this.updateDateShown();
            }
        });
        this.yearPanel.add(increment);
    }

    private int getNthDayOfWeek(Calendar calendar, int n) {
        int[] days = new int[]{1, 2, 3, 4, 5, 6, 7, 1, 2, 3, 4, 5, 6};
        int firstDayOfWeek = calendar == null ? Calendar.getInstance().getFirstDayOfWeek() : calendar.getFirstDayOfWeek();
        return days[n + firstDayOfWeek - 2];
    }

    private int getDayOfWeek(Calendar calendar, int day) {
        int n = 1;
        while (n <= 7) {
            if (this.getNthDayOfWeek(calendar, n) == day) {
                return n;
            }
            ++n;
        }
        return day;
    }

    public void updateDateShown() {
        int column;
        int row;
        if (this.displayedDate == null) {
            this.displayedDate = Calendar.getInstance();
        }
        this.yearLabel.setText(Integer.toString(this.displayedDate.get(1)));
        int month = 0;
        while (month < 12) {
            if (month == this.displayedDate.get(2)) {
                this.monthLabels[month].setHighlighted(true);
            } else {
                this.monthLabels[month].setHighlighted(false);
            }
            ++month;
        }
        Calendar firstDayOfMonth = (Calendar)this.displayedDate.clone();
        firstDayOfMonth.set(5, 1);
        int dayOfWeek = this.getDayOfWeek(firstDayOfMonth, firstDayOfMonth.get(7));
        int col = 0;
        while (col < dayOfWeek - 1) {
            this.dayLabels[0][col].setText("");
            this.dayLabels[0][col].setNumber(0);
            ++col;
        }
        int actualDaysInMonth = this.displayedDate.getActualMaximum(5);
        int day = 1;
        while (day <= actualDaysInMonth) {
            row = (dayOfWeek + day - 2) / 7;
            column = (dayOfWeek + day - 2) % 7;
            this.dayLabels[row][column].setText(Integer.toString(day));
            this.dayLabels[row][column].setNumber(day);
            if (day == this.displayedDate.get(5)) {
                this.dayLabels[row][column].setHighlighted(true);
            } else {
                this.dayLabels[row][column].setHighlighted(false);
            }
            ++day;
        }
        int position = dayOfWeek + actualDaysInMonth - 1;
        while (position < 42) {
            row = position / 7;
            column = position % 7;
            this.dayLabels[row][column].setText("");
            this.dayLabels[row][column].setNumber(0);
            ++position;
        }
    }

    public Calendar openChooser(Calendar date) {
        this.displayedDate = date;
        return this.openChooser();
    }

    public Calendar openChooser() {
        this.updateDateShown();
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(this.parent);
        this.setVisible(true);
        return this.displayedDate;
    }

    Calendar getDisplayedDate() {
        return this.displayedDate;
    }

    TimeZone getCurrentZone() {
        return this.currentZone;
    }

    void setDisplayedDate(Calendar displayedDate) {
        this.displayedDate = displayedDate;
    }

    void setCurrentZone(TimeZone currentZone) {
        this.currentZone = currentZone;
    }

    static class CalendarLabel
    extends JLabel {
        private int number;
        private Color defaultForegroundColour;

        public CalendarLabel(String text, boolean bold, boolean big) {
            super(text, 0);
            this.setFontStyle(bold ? 1 : 0);
            this.defaultForegroundColour = this.getForeground();
            if (big) {
                int size = this.getFont().getSize();
                this.setFont(this.getFont().deriveFont((float)((double)size * 1.5)));
            }
            this.enableEvents(16L);
        }

        private void setFontStyle(int style) {
            this.setFont(this.getFont().deriveFont(style));
        }

        public void setHighlighted(boolean highlighted) {
            this.setForeground(highlighted ? Color.RED : this.defaultForegroundColour);
            this.setFontStyle(highlighted ? 1 : 0);
        }

        public int getNumber() {
            return this.number;
        }

        public void setNumber(int number) {
            this.number = number;
        }
    }

    class ChangeListenerAdapter
    implements ChangeListener {
        ChangeListenerAdapter() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
        }
    }
}

