/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.undo;

import tim.prune.I18nManager;
import tim.prune.data.DataPoint;
import tim.prune.data.TrackInfo;
import tim.prune.undo.UndoDeleteOperation;
import tim.prune.undo.UndoException;

public class UndoDeletePoint
extends UndoDeleteOperation {
    private int _pointIndex = -1;
    private DataPoint _point = null;
    private int _photoIndex = -1;
    private int _audioIndex = -1;
    private boolean _segmentStart = false;

    public UndoDeletePoint(int n, DataPoint dataPoint, int n2, int n3, boolean bl) {
        this._pointIndex = n;
        this._point = dataPoint;
        this._photoIndex = n2;
        this._audioIndex = n3;
        this._segmentStart = bl;
    }

    @Override
    public String getDescription() {
        String string = I18nManager.getText("undo.deletepoint");
        String string2 = this._point.getWaypointName();
        if (string2 != null && !string2.equals("")) {
            string = String.valueOf(string) + " " + string2;
        }
        return string;
    }

    @Override
    public void performUndo(TrackInfo trackInfo) throws UndoException {
        DataPoint dataPoint;
        if (!trackInfo.getTrack().insertPoint(this._point, this._pointIndex)) {
            throw new UndoException(this.getDescription());
        }
        if (this._point.getPhoto() != null && this._photoIndex > -1) {
            if (!trackInfo.getPhotoList().contains(this._point.getPhoto())) {
                trackInfo.getPhotoList().addPhoto(this._point.getPhoto(), this._photoIndex);
            }
            if (this._point.getPhoto().getDataPoint() != this._point) {
                this._point.getPhoto().setDataPoint(this._point);
            }
        }
        if (this._point.getAudio() != null && this._audioIndex > -1) {
            trackInfo.getAudioList().addAudio(this._point.getAudio(), this._audioIndex);
            this._point.getAudio().setDataPoint(this._point);
        }
        if (!this._segmentStart && (dataPoint = trackInfo.getTrack().getNextTrackPoint(this._pointIndex + 1)) != null) {
            dataPoint.setSegmentStart(false);
        }
        this.modifySelection(trackInfo, this._pointIndex, this._pointIndex);
    }
}

