/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.annotation;

import io.micronaut.core.annotation.AnnotationSource;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.EmptyAnnotationMetadata;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.value.OptionalValues;
import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public interface AnnotationMetadata
extends AnnotationSource {
    public static final AnnotationMetadata EMPTY_METADATA = new EmptyAnnotationMetadata();
    public static final String VALUE_MEMBER = "value";
    public static final String CLASS_NAME_SUFFIX = "$$AnnotationMetadata";

    @Nonnull
    default public List<String> getAnnotationNamesByStereotype(@Nullable String stereotype) {
        return Collections.emptyList();
    }

    @Nonnull
    default public Set<String> getAnnotationNames() {
        return Collections.emptySet();
    }

    @Nonnull
    default public Set<String> getDeclaredAnnotationNames() {
        return Collections.emptySet();
    }

    @Nonnull
    default public List<String> getDeclaredAnnotationNamesByStereotype(@Nullable String stereotype) {
        return Collections.emptyList();
    }

    @Nonnull
    default public <T> OptionalValues<T> getValues(@Nonnull String annotation, @Nonnull Class<T> valueType) {
        return OptionalValues.empty();
    }

    default public <T> Optional<T> getDefaultValue(@Nonnull String annotation, @Nonnull String member, @Nonnull Argument<T> requiredType) {
        return Optional.empty();
    }

    @Nonnull
    default public <T extends Annotation> List<AnnotationValue<T>> getAnnotationValuesByType(@Nonnull Class<T> annotationType) {
        return Collections.emptyList();
    }

    @Nonnull
    default public <T extends Annotation> List<AnnotationValue<T>> getDeclaredAnnotationValuesByType(@Nonnull Class<T> annotationType) {
        return Collections.emptyList();
    }

    default public boolean hasDeclaredAnnotation(@Nullable String annotation) {
        return false;
    }

    default public boolean hasAnnotation(@Nullable String annotation) {
        return false;
    }

    default public boolean hasSimpleAnnotation(@Nullable String annotation) {
        if (annotation == null) {
            return false;
        }
        return this.getAnnotationNames().stream().anyMatch(a -> NameUtils.getSimpleName(a).equalsIgnoreCase(annotation));
    }

    default public boolean hasSimpleDeclaredAnnotation(@Nullable String annotation) {
        if (annotation == null) {
            return false;
        }
        return this.getDeclaredAnnotationNames().stream().anyMatch(a -> NameUtils.getSimpleName(a).equalsIgnoreCase(annotation));
    }

    default public boolean hasStereotype(@Nullable String annotation) {
        return false;
    }

    default public boolean hasDeclaredStereotype(@Nullable String annotation) {
        return false;
    }

    @Nonnull
    default public Map<String, Object> getDefaultValues(@Nonnull String annotation) {
        return Collections.emptyMap();
    }

    default public <T> Optional<T> getDefaultValue(@Nonnull String annotation, @Nonnull String member, @Nonnull Class<T> requiredType) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("member", member);
        ArgumentUtils.requireNonNull("requiredType", requiredType);
        return this.getDefaultValue(annotation, member, Argument.of(requiredType));
    }

    default public <T> Optional<T> getDefaultValue(@Nonnull Class<? extends Annotation> annotation, @Nonnull String member, @Nonnull Argument<T> requiredType) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("member", member);
        ArgumentUtils.requireNonNull("requiredType", requiredType);
        return this.getDefaultValue(annotation.getName(), member, requiredType);
    }

    @Override
    default public boolean isAnnotationPresent(@Nonnull Class<? extends Annotation> annotationClass) {
        if (annotationClass == null) {
            return false;
        }
        return this.hasAnnotation(annotationClass);
    }

    @Override
    default public boolean isDeclaredAnnotationPresent(@Nonnull Class<? extends Annotation> annotationClass) {
        if (annotationClass == null) {
            return false;
        }
        return this.hasDeclaredAnnotation(annotationClass);
    }

    default public <T> Optional<T> getDefaultValue(@Nonnull Class<? extends Annotation> annotation, @Nonnull String member, @Nonnull Class<T> requiredType) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        return this.getDefaultValue(annotation.getName(), member, requiredType);
    }

    default public <T> Optional<T> getValue(@Nonnull Class<? extends Annotation> annotation, @Nonnull String member, @Nonnull Class<T> requiredType) {
        ArgumentUtils.requireNonNull("requiredType", requiredType);
        return this.getValue(annotation, member, Argument.of(requiredType));
    }

    default public <T> Optional<T> getValue(@Nonnull Class<? extends Annotation> annotation, @Nonnull String member, @Nonnull Argument<T> requiredType) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("member", member);
        ArgumentUtils.requireNonNull("requiredType", requiredType);
        Repeatable repeatable = annotation.getAnnotation(Repeatable.class);
        if (repeatable != null) {
            List<AnnotationValue<? extends Annotation>> values = this.getAnnotationValuesByType(annotation);
            if (!values.isEmpty()) {
                return values.iterator().next().get(member, requiredType);
            }
            return Optional.empty();
        }
        Optional<AnnotationValue<? extends Annotation>> values = this.findAnnotation(annotation);
        Optional value = values.flatMap(av -> av.get(member, requiredType));
        if (!value.isPresent() && this.hasStereotype(annotation)) {
            return this.getDefaultValue(annotation, member, requiredType);
        }
        return value;
    }

    default public Optional<String> getAnnotationNameByStereotype(@Nullable String stereotype) {
        return this.getAnnotationNamesByStereotype(stereotype).stream().findFirst();
    }

    default public Optional<String> getDeclaredAnnotationNameByStereotype(@Nullable String stereotype) {
        return this.getDeclaredAnnotationNamesByStereotype(stereotype).stream().findFirst();
    }

    default public Optional<Class<? extends Annotation>> getAnnotationTypeByStereotype(@Nonnull Class<? extends Annotation> stereotype) {
        ArgumentUtils.requireNonNull("stereotype", stereotype);
        return this.getAnnotationTypeByStereotype(stereotype.getName());
    }

    default public Optional<Class<? extends Annotation>> getDeclaredAnnotationTypeByStereotype(@Nonnull Class<? extends Annotation> stereotype) {
        ArgumentUtils.requireNonNull("stereotype", stereotype);
        return this.getDeclaredAnnotationTypeByStereotype(stereotype.getName());
    }

    default public Optional<Class<? extends Annotation>> getDeclaredAnnotationTypeByStereotype(@Nullable String stereotype) {
        return this.getDeclaredAnnotationNameByStereotype(stereotype).flatMap(this::getAnnotationType);
    }

    default public Optional<Class<? extends Annotation>> getAnnotationType(@Nonnull String name) {
        ArgumentUtils.requireNonNull("name", name);
        Optional<Class> aClass = ClassUtils.forName(name, this.getClass().getClassLoader());
        return aClass.flatMap(aClass1 -> {
            if (Annotation.class.isAssignableFrom((Class<?>)aClass1)) {
                return Optional.of(aClass1);
            }
            return Optional.empty();
        });
    }

    default public Optional<Class<? extends Annotation>> getAnnotationTypeByStereotype(@Nullable String stereotype) {
        return this.getAnnotationNameByStereotype(stereotype).flatMap(this::getAnnotationType);
    }

    default public Optional<String> getAnnotationNameByStereotype(@Nonnull Class<? extends Annotation> stereotype) {
        ArgumentUtils.requireNonNull("stereotype", stereotype);
        return this.getAnnotationNameByStereotype(stereotype.getName());
    }

    @Nonnull
    default public <T> OptionalValues<T> getValues(@Nonnull Class<? extends Annotation> annotation, @Nonnull Class<T> valueType) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("valueType", valueType);
        return this.getValues(annotation.getName(), valueType);
    }

    @Nonnull
    default public List<String> getAnnotationNamesByStereotype(@Nonnull Class<? extends Annotation> stereotype) {
        ArgumentUtils.requireNonNull("stereotype", stereotype);
        return this.getAnnotationNamesByStereotype(stereotype.getName());
    }

    @Nonnull
    default public List<Class<? extends Annotation>> getAnnotationTypesByStereotype(@Nonnull Class<? extends Annotation> stereotype) {
        ArgumentUtils.requireNonNull("stereotype", stereotype);
        List<String> names = this.getAnnotationNamesByStereotype(stereotype.getName());
        return names.stream().map(this::getAnnotationType).filter(Optional::isPresent).map(opt -> (Class)opt.get()).collect(Collectors.toList());
    }

    @Override
    default public <T extends Annotation> Optional<AnnotationValue<T>> findAnnotation(@Nonnull Class<T> annotationClass) {
        ArgumentUtils.requireNonNull("annotationClass", annotationClass);
        Repeatable repeatable = annotationClass.getAnnotation(Repeatable.class);
        if (repeatable != null) {
            List<AnnotationValue<T>> values = this.getAnnotationValuesByType(annotationClass);
            if (!values.isEmpty()) {
                return Optional.of(values.iterator().next());
            }
            return Optional.empty();
        }
        return this.findAnnotation(annotationClass.getName());
    }

    @Override
    default public <T extends Annotation> Optional<AnnotationValue<T>> findDeclaredAnnotation(@Nonnull Class<T> annotationClass) {
        ArgumentUtils.requireNonNull("annotationClass", annotationClass);
        Repeatable repeatable = annotationClass.getAnnotation(Repeatable.class);
        if (repeatable != null) {
            List<AnnotationValue<T>> values = this.getDeclaredAnnotationValuesByType(annotationClass);
            if (!values.isEmpty()) {
                return Optional.of(values.iterator().next());
            }
            return Optional.empty();
        }
        return this.findDeclaredAnnotation(annotationClass.getName());
    }

    default public <T> Optional<T> getValue(@Nonnull String annotation, @Nonnull String member, @Nonnull Class<T> requiredType) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("member", member);
        ArgumentUtils.requireNonNull("requiredType", requiredType);
        return this.getValue(annotation, member, Argument.of(requiredType));
    }

    default public <T> Optional<T> getValue(@Nonnull String annotation, @Nonnull String member, @Nonnull Argument<T> requiredType) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("member", member);
        ArgumentUtils.requireNonNull("requiredType", requiredType);
        Optional value = this.findAnnotation(annotation).flatMap(av -> av.get(member, requiredType));
        if (!value.isPresent() && this.hasStereotype(annotation)) {
            return this.getDefaultValue(annotation, member, requiredType);
        }
        return value;
    }

    default public OptionalLong longValue(@Nonnull String annotation, @Nonnull String member) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("member", member);
        Optional<Long> result = this.getValue(annotation, member, Long.class);
        return result.map(OptionalLong::of).orElseGet(OptionalLong::empty);
    }

    default public OptionalLong longValue(@Nonnull Class<? extends Annotation> annotation, @Nonnull String member) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        return this.longValue(annotation.getName(), member);
    }

    default public <E extends Enum> Optional<E> enumValue(@Nonnull String annotation, Class<E> enumType) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        return this.enumValue(annotation, VALUE_MEMBER, enumType);
    }

    default public <E extends Enum> Optional<E> enumValue(@Nonnull String annotation, @Nonnull String member, Class<E> enumType) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("member", member);
        return this.getValue(annotation, member, enumType);
    }

    default public <E extends Enum> Optional<E> enumValue(@Nonnull Class<? extends Annotation> annotation, Class<E> enumType) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        return this.enumValue(annotation, VALUE_MEMBER, enumType);
    }

    default public <E extends Enum> Optional<E> enumValue(@Nonnull Class<? extends Annotation> annotation, @Nonnull String member, Class<E> enumType) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("member", member);
        return this.enumValue(annotation.getName(), member, enumType);
    }

    @Nonnull
    default public <T> Class<T>[] classValues(@Nonnull String annotation) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        return this.classValues(annotation, VALUE_MEMBER);
    }

    @Nonnull
    default public <T> Class<T>[] classValues(@Nonnull String annotation, @Nonnull String member) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("member", member);
        return this.getValue(annotation, member, Class[].class).orElse(ReflectionUtils.EMPTY_CLASS_ARRAY);
    }

    @Nonnull
    default public <T> Class<T>[] classValues(@Nonnull Class<? extends Annotation> annotation) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        return this.classValues(annotation, VALUE_MEMBER);
    }

    @Nonnull
    default public <T> Class<T>[] classValues(@Nonnull Class<? extends Annotation> annotation, @Nonnull String member) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("member", member);
        return this.classValues(annotation.getName(), member);
    }

    default public Optional<Class> classValue(@Nonnull String annotation) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        return this.classValue(annotation, VALUE_MEMBER);
    }

    default public Optional<Class> classValue(@Nonnull String annotation, @Nonnull String member) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("member", member);
        Optional<Class> value = this.getValue(annotation, member, Class.class);
        return value;
    }

    default public Optional<Class> classValue(@Nonnull Class<? extends Annotation> annotation) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        return this.classValue(annotation, VALUE_MEMBER);
    }

    default public Optional<Class> classValue(@Nonnull Class<? extends Annotation> annotation, @Nonnull String member) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("member", member);
        return this.classValue(annotation.getName(), member);
    }

    default public OptionalInt intValue(@Nonnull String annotation, @Nonnull String member) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("member", member);
        Optional<Integer> result = this.getValue(annotation, member, Integer.class);
        return result.map(OptionalInt::of).orElseGet(OptionalInt::empty);
    }

    default public OptionalInt intValue(@Nonnull Class<? extends Annotation> annotation, @Nonnull String member) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        return this.intValue(annotation.getName(), member);
    }

    default public OptionalInt intValue(@Nonnull Class<? extends Annotation> annotation) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        return this.intValue(annotation, VALUE_MEMBER);
    }

    default public Optional<String> stringValue(@Nonnull String annotation, @Nonnull String member) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("member", member);
        return this.getValue(annotation, member, String.class);
    }

    default public Optional<String> stringValue(@Nonnull Class<? extends Annotation> annotation, @Nonnull String member) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        return this.stringValue(annotation.getName(), member);
    }

    @Nonnull
    default public Optional<String> stringValue(@Nonnull Class<? extends Annotation> annotation) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        return this.stringValue(annotation, VALUE_MEMBER);
    }

    @Nonnull
    default public Optional<String> stringValue(@Nonnull String annotation) {
        return this.stringValue(annotation, VALUE_MEMBER);
    }

    default public Optional<Boolean> booleanValue(@Nonnull String annotation, @Nonnull String member) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("member", member);
        return this.getValue(annotation, member, Boolean.class);
    }

    default public Optional<Boolean> booleanValue(@Nonnull Class<? extends Annotation> annotation, @Nonnull String member) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        return this.booleanValue(annotation.getName(), member);
    }

    @Nonnull
    default public Optional<Boolean> booleanValue(@Nonnull Class<? extends Annotation> annotation) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        return this.booleanValue(annotation, VALUE_MEMBER);
    }

    @Nonnull
    default public Optional<Boolean> booleanValue(@Nonnull String annotation) {
        return this.booleanValue(annotation, VALUE_MEMBER);
    }

    @Nonnull
    default public String[] stringValues(@Nonnull Class<? extends Annotation> annotation, @Nonnull String member) {
        return StringUtils.EMPTY_STRING_ARRAY;
    }

    @Nonnull
    default public String[] stringValues(@Nonnull Class<? extends Annotation> annotation) {
        return this.stringValues(annotation, VALUE_MEMBER);
    }

    @Nonnull
    default public OptionalDouble doubleValue(@Nonnull String annotation, @Nonnull String member) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("member", member);
        Optional<Double> result = this.getValue(annotation, member, Double.class);
        return result.map(OptionalDouble::of).orElseGet(OptionalDouble::empty);
    }

    @Nonnull
    default public OptionalDouble doubleValue(@Nonnull Class<? extends Annotation> annotation, @Nonnull String member) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        return this.doubleValue(annotation.getName(), member);
    }

    @Nonnull
    default public OptionalDouble doubleValue(@Nonnull Class<? extends Annotation> annotation) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        return this.doubleValue(annotation, VALUE_MEMBER);
    }

    @Nonnull
    default public <T> Optional<T> getValue(@Nonnull String annotation, @Nonnull Class<T> requiredType) {
        return this.getValue(annotation, VALUE_MEMBER, requiredType);
    }

    @Nonnull
    default public Optional<Object> getValue(@Nonnull String annotation, @Nonnull String member) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("member", member);
        return this.getValue(annotation, member, Object.class);
    }

    @Nonnull
    default public Optional<Object> getValue(@Nonnull Class<? extends Annotation> annotation, @Nonnull String member) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("member", member);
        return this.getValue(annotation, member, Object.class);
    }

    default public boolean isTrue(@Nonnull String annotation, @Nonnull String member) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("member", member);
        return this.getValue(annotation, member, Boolean.class).orElse(false);
    }

    default public boolean isTrue(@Nonnull Class<? extends Annotation> annotation, @Nonnull String member) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("member", member);
        return this.getValue(annotation.getName(), member, Boolean.class).orElse(false);
    }

    default public boolean isPresent(@Nonnull String annotation, @Nonnull String member) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("member", member);
        return this.findAnnotation(annotation).map(av -> av.contains(member)).orElse(false);
    }

    default public boolean isPresent(@Nonnull Class<? extends Annotation> annotation, @Nonnull String member) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("member", member);
        return this.isPresent(annotation.getName(), member);
    }

    default public boolean isFalse(@Nonnull Class<? extends Annotation> annotation, @Nonnull String member) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("member", member);
        return !this.isTrue(annotation, member);
    }

    default public boolean isFalse(@Nonnull String annotation, @Nonnull String member) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("member", member);
        return !this.isTrue(annotation, member);
    }

    @Nonnull
    default public Optional<Object> getValue(@Nonnull String annotation) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        return this.getValue(annotation, Object.class);
    }

    @Nonnull
    default public Optional<Object> getValue(@Nonnull Class<? extends Annotation> annotation) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        return this.getValue(annotation, VALUE_MEMBER, Object.class);
    }

    @Nonnull
    default public <T> Optional<T> getValue(@Nonnull Class<? extends Annotation> annotation, @Nonnull Class<T> requiredType) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("requiredType", requiredType);
        return this.getValue(annotation, VALUE_MEMBER, requiredType);
    }

    @Nonnull
    default public <T> Optional<T> getValue(@Nonnull Class<? extends Annotation> annotation, @Nonnull Argument<T> requiredType) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("requiredType", requiredType);
        return this.getValue(annotation, VALUE_MEMBER, requiredType);
    }

    @Nonnull
    default public <T> Optional<T> getValue(@Nonnull String annotation, @Nonnull Argument<T> requiredType) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("requiredType", requiredType);
        return this.getValue(annotation, VALUE_MEMBER, requiredType);
    }

    default public boolean hasAnnotation(@Nullable Class<? extends Annotation> annotation) {
        if (annotation != null) {
            Repeatable repeatable = annotation.getAnnotation(Repeatable.class);
            if (repeatable != null) {
                return this.hasAnnotation(repeatable.value());
            }
            return this.hasAnnotation(annotation.getName());
        }
        return false;
    }

    default public boolean hasStereotype(@Nullable Class<? extends Annotation> annotation) {
        if (annotation != null) {
            Repeatable repeatable = annotation.getAnnotation(Repeatable.class);
            if (repeatable != null) {
                return this.hasStereotype(repeatable.value());
            }
            return this.hasStereotype(annotation.getName());
        }
        return false;
    }

    default public boolean hasStereotype(Class<? extends Annotation> ... annotations) {
        if (ArrayUtils.isEmpty(annotations)) {
            return false;
        }
        for (Class<? extends Annotation> annotation : annotations) {
            if (!this.hasStereotype(annotation)) continue;
            return true;
        }
        return false;
    }

    default public boolean hasStereotype(@Nullable String[] annotations) {
        if (ArrayUtils.isEmpty(annotations)) {
            return false;
        }
        for (String annotation : annotations) {
            if (!this.hasStereotype(annotation)) continue;
            return true;
        }
        return false;
    }

    default public boolean hasDeclaredAnnotation(@Nullable Class<? extends Annotation> annotation) {
        if (annotation != null) {
            Repeatable repeatable = annotation.getAnnotation(Repeatable.class);
            if (repeatable != null) {
                return this.hasDeclaredAnnotation(repeatable.value());
            }
            return this.hasDeclaredAnnotation(annotation.getName());
        }
        return false;
    }

    default public boolean hasDeclaredStereotype(@Nullable Class<? extends Annotation> stereotype) {
        if (stereotype != null) {
            Repeatable repeatable = stereotype.getAnnotation(Repeatable.class);
            if (repeatable != null) {
                return this.hasDeclaredStereotype(repeatable.value());
            }
            return this.hasDeclaredStereotype(stereotype.getName());
        }
        return false;
    }

    default public boolean hasDeclaredStereotype(Class<? extends Annotation> ... annotations) {
        if (ArrayUtils.isEmpty(annotations)) {
            return false;
        }
        for (Class<? extends Annotation> annotation : annotations) {
            if (!this.hasDeclaredStereotype(annotation)) continue;
            return true;
        }
        return false;
    }

    default public boolean isEmpty() {
        return this == EMPTY_METADATA;
    }
}

