/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.awt.Image;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.Lst;
import javajs.util.OC;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.awt.AwtClipboard;
import org.jmol.util.Logger;
import org.jmol.viewer.OutputManager;
import org.jmol.viewer.Viewer;

public final class OutputManagerAwt
extends OutputManager {
    @Override
    protected String getLogPath(String fileName) {
        return this.vwr.isApplet ? fileName : new File(fileName).getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    String clipImageOrPasteText(String text) {
        String msg;
        try {
            if (text == null) {
                Image image = (Image)this.vwr.getScreenImage();
                AwtClipboard.setClipboard((Object)image);
                msg = "OK image to clipboard: " + image.getWidth(null) * image.getHeight(null);
            } else {
                AwtClipboard.setClipboard((Object)text);
                msg = "OK text to clipboard: " + text.length();
            }
        }
        catch (Error er) {
            msg = this.vwr.getErrorMessage();
        }
        finally {
            if (text == null) {
                this.vwr.releaseScreenImage();
            }
        }
        return msg;
    }

    @Override
    String getClipboardText() {
        return AwtClipboard.getClipboardText();
    }

    @Override
    OC openOutputChannel(double privateKey, String fileName, boolean asWriter, boolean asAppend) throws IOException {
        boolean isLocal = OC.isLocal(fileName);
        if (asAppend && isLocal && fileName.indexOf("JmolLog_") < 0) {
            asAppend = false;
        }
        return fileName != null && !this.vwr.haveAccess(Viewer.ACCESS.ALL) || !this.vwr.checkPrivateKey(privateKey) ? null : new OC().setParams(this.vwr.fm, fileName, asWriter, isLocal ? new FileOutputStream(fileName, asAppend) : null);
    }

    @Override
    protected String createSceneSet(String sceneFile, String type, int width, int height) {
        String script0 = this.vwr.getFileAsString3(sceneFile, false, null);
        if (script0 == null) {
            return "no such file: " + sceneFile;
        }
        String fileRoot = sceneFile = PT.rep(sceneFile, ".spt", "");
        String fileExt = type.toLowerCase();
        String[] scenes = PT.split(script0, "pause scene ");
        Hashtable<String, String> htScenes = new Hashtable<String, String>();
        Lst<Integer> list = new Lst<Integer>();
        String script = this.getSceneScript(scenes, htScenes, list);
        if (Logger.debugging) {
            Logger.debug(script);
        }
        script0 = PT.rep(script0, "pause scene", "delay " + this.vwr.am.lastFrameDelay + " # scene");
        String[] str = new String[]{script0, script, null};
        this.vwr.stm.saveState("_scene0");
        int nFiles = 0;
        if (scenes[0] != "") {
            this.vwr.zap(true, true, false);
        }
        int iSceneLast = -1;
        for (int i = 0; i < scenes.length - 1; ++i) {
            try {
                int iScene = (Integer)list.get(i);
                if (iScene > iSceneLast) {
                    this.vwr.showString("Creating Scene " + iScene, false);
                }
                this.vwr.eval.runScript(scenes[i]);
                if (iScene <= iSceneLast) continue;
                iSceneLast = iScene;
                str[2] = "all";
                String fileName = fileRoot + "_scene_" + iScene + ".all." + fileExt;
                Hashtable<String, Object> params = new Hashtable<String, Object>();
                params.put("fileName", fileName);
                params.put("type", "PNGJ");
                params.put("scripts", str);
                params.put("width", width);
                params.put("height", height);
                String msg = this.handleOutputToFile(params, false);
                str[0] = null;
                str[2] = "min";
                fileName = fileRoot + "_scene_" + iScene + ".min." + fileExt;
                params.put("fileName", fileName);
                params.put("width", Math.min(width, 200));
                params.put("height", Math.min(height, 200));
                msg = msg + "\n" + this.handleOutputToFile(params, false);
                this.vwr.showString(msg, false);
                nFiles += 2;
                continue;
            }
            catch (Exception e) {
                return "script error " + e.toString();
            }
        }
        try {
            this.vwr.eval.runScript(this.vwr.stm.getSavedState("_scene0"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "OK " + nFiles + " files created";
    }

    private String getSceneScript(String[] scenes, Map<String, String> htScenes, Lst<Integer> list) {
        int iSceneLast = 0;
        int iScene = 0;
        SB sceneScript = new SB().append("###scene.spt###").append(" Jmol ").append(Viewer.getJmolVersion()).append("\n{\nsceneScripts={");
        for (int i = 1; i < scenes.length; ++i) {
            scenes[i - 1] = PT.trim(scenes[i - 1], "\t\n\r ");
            int[] pt = new int[1];
            iScene = PT.parseIntNext(scenes[i], pt);
            if (iScene == Integer.MIN_VALUE) {
                return "bad scene ID: " + iScene;
            }
            scenes[i] = scenes[i].substring(pt[0]);
            list.addLast(iScene);
            String key = iSceneLast + "-" + iScene;
            htScenes.put(key, scenes[i - 1]);
            if (i > 1) {
                sceneScript.append(",");
            }
            sceneScript.appendC('\n').append(PT.esc(key)).append(": ").append(PT.esc(scenes[i - 1]));
            iSceneLast = iScene;
        }
        sceneScript.append("\n}\n");
        if (list.size() == 0) {
            return "no lines 'pause scene n'";
        }
        sceneScript.append("\nthisSceneRoot = '$SCRIPT_PATH$'.split('_scene_')[1];\n").append("thisSceneID = 0 + ('$SCRIPT_PATH$'.split('_scene_')[2]).split('.')[1];\n").append("var thisSceneState = '$SCRIPT_PATH$'.replace('.min.png','.all.png') + 'state.spt';\n").append("var spath = ''+currentSceneID+'-'+thisSceneID;\n").append("print thisSceneRoot + ' ' + spath;\n").append("var sscript = sceneScripts[spath];\n").append("var isOK = true;\n").append("try{\n").append("if (thisSceneRoot != currentSceneRoot){\n").append(" isOK = false;\n").append("} else if (sscript != '') {\n").append(" isOK = true;\n").append("} else if (thisSceneID <= currentSceneID){\n").append(" isOK = false;\n").append("} else {\n").append(" sscript = '';\n").append(" for (var i = currentSceneID; i < thisSceneID; i++){\n").append("  var key = ''+i+'-'+(i + 1); var script = sceneScripts[key];\n").append("  if (script = '') {isOK = false;break;}\n").append("  sscript += ';'+script;\n").append(" }\n").append("}\n}catch(e){print e;isOK = false}\n").append("if (isOK) {" + this.wrapPathForAllFiles("script inline @sscript", "print e;isOK = false") + "}\n").append("if (!isOK){script @thisSceneState}\n").append("currentSceneRoot = thisSceneRoot; currentSceneID = thisSceneID;\n}\n");
        return sceneScript.toString();
    }
}

