/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.ProjectionBoundsProvider;
import org.openstreetmap.josm.data.projection.ProjectionChangeListener;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public final class ProjectionRegistry {
    private static volatile Projection proj;
    private static ProjectionBoundsProvider boundsProvider;
    private static final List<WeakReference<ProjectionChangeListener>> listeners;

    private ProjectionRegistry() {
    }

    public static Projection getProjection() {
        return proj;
    }

    public static void setProjection(Projection p) {
        CheckParameterUtil.ensureParameterNotNull(p);
        Projection oldValue = proj;
        Bounds b = boundsProvider != null ? boundsProvider.getRealBounds() : null;
        proj = p;
        ProjectionRegistry.fireProjectionChanged(oldValue, proj, b);
    }

    private static void fireProjectionChanged(Projection oldValue, Projection newValue, Bounds oldBounds) {
        if (newValue == null ^ oldValue == null || newValue != null && oldValue != null && !Objects.equals(newValue.toCode(), oldValue.toCode())) {
            listeners.removeIf(x -> x.get() == null);
            listeners.stream().map(Reference::get).filter(Objects::nonNull).forEach(x -> x.projectionChanged(oldValue, newValue));
            if (newValue != null && oldBounds != null && boundsProvider != null) {
                boundsProvider.restoreOldBounds(oldBounds);
            }
        }
    }

    public static void addProjectionChangeListener(ProjectionChangeListener listener) {
        if (listener == null) {
            return;
        }
        for (WeakReference<ProjectionChangeListener> wr : listeners) {
            if (wr.get() != listener) continue;
            return;
        }
        listeners.add(new WeakReference<ProjectionChangeListener>(listener));
    }

    public static void removeProjectionChangeListener(ProjectionChangeListener listener) {
        if (listener == null) {
            return;
        }
        listeners.removeIf(wr -> wr.get() == null || wr.get() == listener);
    }

    public static void clearProjectionChangeListeners() {
        listeners.clear();
    }

    public static ProjectionBoundsProvider getBoundsProvider() {
        return boundsProvider;
    }

    public static void setboundsProvider(ProjectionBoundsProvider provider) {
        boundsProvider = Objects.requireNonNull(provider);
    }

    static {
        listeners = new CopyOnWriteArrayList<WeakReference<ProjectionChangeListener>>();
    }
}

