/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.pair.relation;

import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.data.osm.DefaultNameFormatter;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.gui.conflict.ConflictColors;
import org.openstreetmap.josm.gui.conflict.pair.AbstractListMergeModel;
import org.openstreetmap.josm.tools.ImageProvider;

public class RelationMemberTableCellRenderer
extends JLabel
implements TableCellRenderer {
    private final transient Border rowNumberBorder;

    public RelationMemberTableCellRenderer() {
        this.setIcon(null);
        this.setOpaque(true);
        this.rowNumberBorder = BorderFactory.createEmptyBorder(0, 4, 0, 0);
    }

    protected void reset() {
        this.setBackground(ConflictColors.BGCOLOR.get());
        this.setForeground(ConflictColors.FGCOLOR.get());
        this.setBorder(null);
        this.setIcon(null);
        this.setToolTipText(null);
    }

    protected void renderBackground(AbstractListMergeModel.EntriesTableModel model, RelationMember member, int row, int col, boolean isSelected) {
        Color bgc = ConflictColors.BGCOLOR.get();
        if (col == 0) {
            if (model.getListMergeModel().isFrozen()) {
                bgc = ConflictColors.BGCOLOR_FROZEN.get();
            } else if (model.isParticipatingInCurrentComparePair()) {
                bgc = ConflictColors.BGCOLOR_PARTICIPATING_IN_COMPARISON.get();
            } else if (isSelected) {
                bgc = ConflictColors.BGCOLOR_SELECTED.get();
            }
        } else if (model.getListMergeModel().isFrozen()) {
            bgc = ConflictColors.BGCOLOR_FROZEN.get();
        } else if (member == null) {
            bgc = ConflictColors.BGCOLOR_EMPTY_ROW.get();
        } else if (isSelected) {
            bgc = ConflictColors.BGCOLOR_SELECTED.get();
        } else if (model.isParticipatingInCurrentComparePair()) {
            bgc = model.isSamePositionInOppositeList(row) ? ConflictColors.BGCOLOR_SAME_POSITION_IN_OPPOSITE.get() : (model.isIncludedInOppositeList(row) ? ConflictColors.BGCOLOR_IN_OPPOSITE.get() : ConflictColors.BGCOLOR_NOT_IN_OPPOSITE.get());
        }
        this.setBackground(bgc);
    }

    protected void renderForeground(AbstractListMergeModel.EntriesTableModel model, RelationMember member, int row, int col, boolean isSelected) {
        Color fgc = ConflictColors.FGCOLOR.get();
        if (col == 0 && model.isParticipatingInCurrentComparePair() && !model.getListMergeModel().isFrozen()) {
            fgc = ConflictColors.FGCOLOR_PARTICIPATING_IN_COMPARISON.get();
        }
        this.setForeground(fgc);
    }

    protected void renderRole(RelationMember member) {
        this.setText(member.getRole());
        this.setToolTipText(member.getRole());
    }

    protected void renderPrimitive(RelationMember member) {
        String displayName = member.getMember().getDisplayName(DefaultNameFormatter.getInstance());
        this.setText(displayName);
        this.setToolTipText(DefaultNameFormatter.getInstance().buildDefaultToolTip(member.getMember()));
        this.setIcon(ImageProvider.get(member.getDisplayType()));
    }

    protected void renderRowId(int row) {
        this.setBorder(this.rowNumberBorder);
        this.setText(Integer.toString(row + 1));
    }

    protected void renderEmptyRow() {
        this.setIcon(null);
        this.setBackground(ConflictColors.BGCOLOR_EMPTY_ROW.get());
        this.setText("");
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        RelationMember member = (RelationMember)value;
        this.reset();
        if (member == null) {
            this.renderEmptyRow();
        } else {
            this.renderBackground(this.getModel(table), member, row, column, isSelected);
            this.renderForeground(this.getModel(table), member, row, column, isSelected);
            switch (column) {
                case 0: {
                    this.renderRowId(row);
                    break;
                }
                case 1: {
                    this.renderRole(member);
                    break;
                }
                case 2: {
                    this.renderPrimitive(member);
                    break;
                }
            }
        }
        return this;
    }

    protected AbstractListMergeModel.EntriesTableModel getModel(JTable table) {
        return (AbstractListMergeModel.EntriesTableModel)table.getModel();
    }
}

