/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile;

import java.awt.geom.Dimension2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.activitydiagram3.ftile.MergeStrategy;
import net.sourceforge.plantuml.activitydiagram3.ftile.Worm;
import net.sourceforge.plantuml.activitydiagram3.ftile.WormMutation;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColorAndStyle;
import net.sourceforge.plantuml.graphic.Rainbow;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.comp.PiecewiseAffineTransform;

public class Snake
implements UShape {
    private final Worm worm = new Worm();
    private UPolygon startDecoration;
    private UPolygon endDecoration;
    private final Rainbow color;
    private TextBlock textBlock;
    private String textBlockPosition;
    private MergeStrategy mergeable = MergeStrategy.FULL;
    private Direction emphasizeDirection;
    private final HorizontalAlignment horizontalAlignment;

    public final void setIgnoreForCompression() {
        this.worm.setIgnoreForCompression();
    }

    public Snake transformX(PiecewiseAffineTransform compressionTransform) {
        Snake result = new Snake(this.startDecoration, this.horizontalAlignment, this.color, this.endDecoration);
        result.textBlock = this.textBlock;
        result.mergeable = this.mergeable;
        result.emphasizeDirection = this.emphasizeDirection;
        for (Point2D.Double pt : this.worm) {
            double x = compressionTransform.transform(pt.x);
            double y = pt.y;
            result.addPoint(x, y);
        }
        return result;
    }

    public void removeEndDecoration() {
        this.endDecoration = null;
    }

    public Snake(HorizontalAlignment horizontalAlignment, Rainbow color, UPolygon endDecoration) {
        this(null, horizontalAlignment, color, endDecoration);
    }

    public Snake(UPolygon startDecoration, HorizontalAlignment horizontalAlignment, Rainbow color, UPolygon endDecoration) {
        if (color == null) {
            throw new IllegalArgumentException();
        }
        if (color.size() == 0) {
            throw new IllegalArgumentException();
        }
        this.startDecoration = startDecoration;
        this.endDecoration = endDecoration;
        this.color = color;
        this.horizontalAlignment = horizontalAlignment;
    }

    public Snake(HorizontalAlignment horizontalAlignment, Rainbow color) {
        this(null, horizontalAlignment, color, null);
    }

    public void setLabel(TextBlock label, String position) {
        this.textBlock = label;
        this.textBlockPosition = position;
    }

    public void setLabel(TextBlock label) {
        this.textBlock = label;
    }

    public Snake move(double dx, double dy) {
        Snake result = new Snake(this.startDecoration, this.horizontalAlignment, this.color, this.endDecoration);
        for (Point2D pt : this.worm) {
            result.addPoint(pt.getX() + dx, pt.getY() + dy);
        }
        result.textBlock = this.textBlock;
        result.mergeable = this.mergeable;
        result.emphasizeDirection = this.emphasizeDirection;
        return result;
    }

    public Snake translate(UTranslate translate) {
        return this.move(translate.getDx(), translate.getDy());
    }

    public String toString() {
        return this.worm.toString();
    }

    public void addPoint(double x, double y) {
        this.worm.addPoint(x, y);
    }

    public void addPoint(Point2D p) {
        this.addPoint(p.getX(), p.getY());
    }

    public void drawInternal(UGraphic ug) {
        if (this.color.size() > 1) {
            this.drawRainbow(ug);
        } else {
            this.worm.drawInternalOneColor(this.startDecoration, ug, this.color.getColors().get(0), 1.5, this.emphasizeDirection, this.endDecoration);
            this.drawInternalLabel(ug);
        }
    }

    private void drawRainbow(UGraphic ug) {
        List<HtmlColorAndStyle> colors = this.color.getColors();
        int colorArrowSeparationSpace = this.color.getColorArrowSeparationSpace();
        double move = 2 + colorArrowSeparationSpace;
        WormMutation mutation = WormMutation.create(this.worm, move);
        if (mutation.isDxNegative()) {
            colors = new ArrayList<HtmlColorAndStyle>(colors);
            Collections.reverse(colors);
        }
        double globalMove = -1.0 * (double)(colors.size() - 1) / 2.0;
        Worm current = this.worm.moveFirstPoint(mutation.getFirst().multiplyBy(globalMove));
        if (mutation.size() > 2) {
            current = current.moveLastPoint(mutation.getLast().multiplyBy(globalMove));
        }
        for (int i = 0; i < colors.size(); ++i) {
            double stroke = 1.5;
            if (colorArrowSeparationSpace == 0) {
                stroke = i == colors.size() - 1 ? 2.0 : 3.0;
            }
            current.drawInternalOneColor(this.startDecoration, ug, colors.get(i), stroke, this.emphasizeDirection, this.endDecoration);
            current = mutation.mute(current);
        }
        UTranslate textTranslate = mutation.getTextTranslate(colors.size());
        this.drawInternalLabel(ug.apply(textTranslate));
    }

    private void drawInternalLabel(UGraphic ug) {
        if (this.textBlock != null) {
            Point2D position = this.getTextBlockPosition(ug.getStringBounder());
            this.textBlock.drawU(ug.apply(new UTranslate(position)));
        }
    }

    public double getMaxX(StringBounder stringBounder) {
        double result = -1.7976931348623157E308;
        for (Point2D pt : this.worm) {
            result = Math.max(result, pt.getX());
        }
        if (this.textBlock != null) {
            Point2D position = this.getTextBlockPosition(stringBounder);
            Dimension2D dim = this.textBlock.calculateDimension(stringBounder);
            result = Math.max(result, position.getX() + dim.getWidth());
        }
        return result;
    }

    private Point2D getTextBlockPosition(StringBounder stringBounder) {
        Point2D.Double pt1 = this.worm.get(0);
        Point2D.Double pt2 = this.worm.get(1);
        Dimension2D dim = this.textBlock.calculateDimension(stringBounder);
        double x = Math.max(((Point2D)pt1).getX(), ((Point2D)pt2).getX()) + 4.0;
        boolean zigzag = this.worm.getDirectionsCode().startsWith("DLD") || this.worm.getDirectionsCode().startsWith("DRD");
        double y = (((Point2D)pt1).getY() + ((Point2D)pt2).getY()) / 2.0 - dim.getHeight() / 2.0;
        if ("bottom".equalsIgnoreCase(this.textBlockPosition)) {
            x = this.worm.getLast().getX();
        } else if (this.horizontalAlignment == HorizontalAlignment.CENTER && zigzag) {
            Point2D.Double pt3 = this.worm.get(2);
            x = (((Point2D)pt2).getX() + ((Point2D)pt3).getX()) / 2.0 - dim.getWidth() / 2.0;
        } else if (this.horizontalAlignment == HorizontalAlignment.RIGHT && zigzag) {
            x = Math.max(((Point2D)pt1).getX(), ((Point2D)pt2).getX()) - dim.getWidth() - 4.0;
        } else if (this.worm.getDirectionsCode().equals("RD")) {
            x = Math.max(((Point2D)pt1).getX(), ((Point2D)pt2).getX());
            y = (((Point2D)pt1).getY() + this.worm.get(2).getY()) / 2.0 - dim.getHeight() / 2.0;
        } else if (this.worm.getDirectionsCode().equals("LD")) {
            x = Math.min(((Point2D)pt1).getX(), ((Point2D)pt2).getX());
            y = (((Point2D)pt1).getY() + this.worm.get(2).getY()) / 2.0 - dim.getHeight() / 2.0;
        }
        return new Point2D.Double(x, y);
    }

    public List<Line2D> getHorizontalLines() {
        ArrayList<Line2D> result = new ArrayList<Line2D>();
        for (int i = 0; i < this.worm.size() - 1; ++i) {
            Point2D.Double pt1 = this.worm.get(i);
            Point2D.Double pt2 = this.worm.get(i + 1);
            if (((Point2D)pt1).getY() != ((Point2D)pt2).getY()) continue;
            Line2D.Double line = new Line2D.Double(pt1, pt2);
            result.add(line);
        }
        return result;
    }

    private Point2D getFirst() {
        return this.worm.get(0);
    }

    public Point2D getLast() {
        return this.worm.get(this.worm.size() - 1);
    }

    static boolean same(Point2D pt1, Point2D pt2) {
        return pt1.distance(pt2) < 0.001;
    }

    public Snake merge(Snake other, StringBounder stringBounder) {
        MergeStrategy strategy = this.mergeable.max(other.mergeable);
        if (strategy == MergeStrategy.NONE) {
            return null;
        }
        boolean emptyOther = TextBlockUtils.isEmpty(other.textBlock, stringBounder);
        if (!emptyOther) {
            return null;
        }
        if (Snake.same(this.getLast(), other.getFirst())) {
            UPolygon oneOf;
            UPolygon uPolygon = oneOf = other.endDecoration == null ? this.endDecoration : other.endDecoration;
            if (this.startDecoration != null || other.startDecoration != null) {
                throw new UnsupportedOperationException("Not yet coded: to be done");
            }
            Snake result = new Snake(null, this.horizontalAlignment, this.color, oneOf);
            result.emphasizeDirection = this.emphasizeDirection == null ? other.emphasizeDirection : this.emphasizeDirection;
            result.worm.addAll(this.worm.merge(other.worm, strategy));
            result.mergeable = strategy;
            return result;
        }
        if (Snake.same(this.getFirst(), other.getLast())) {
            return other.merge(this, stringBounder);
        }
        return null;
    }

    public boolean touches(Snake other) {
        if (other.mergeable != MergeStrategy.FULL) {
            return false;
        }
        if (other.worm.isPureHorizontal()) {
            return false;
        }
        return Snake.same(this.getLast(), other.getFirst());
    }

    public void goUnmergeable(MergeStrategy strategy) {
        this.mergeable = strategy;
    }

    public void emphasizeDirection(Direction direction) {
        this.emphasizeDirection = direction;
    }

    public boolean doesHorizontalCross(MinMax minMax) {
        return this.worm.doesHorizontalCross(minMax);
    }
}

