/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.graphic;

import java.util.Arrays;
import net.sourceforge.plantuml.sequencediagram.graphic.Frontier;
import net.sourceforge.plantuml.sequencediagram.graphic.ParticipantRange;

class FrontierComplex
implements Frontier {
    private final double[] freeY;

    public FrontierComplex(double freeY, int rangeEnd) {
        this.freeY = new double[rangeEnd + 1];
        for (int i = 0; i <= rangeEnd; ++i) {
            this.freeY[i] = freeY;
        }
    }

    private FrontierComplex(double[] freeY) {
        this.freeY = freeY;
    }

    private FrontierComplex(double[] freeY, double delta, ParticipantRange range) {
        this((double[])freeY.clone());
        double newV = this.getFreeY(range) + delta;
        for (int i = range.start(); i <= range.end(); ++i) {
            this.freeY[i] = newV;
        }
    }

    @Override
    public double getFreeY(ParticipantRange range) {
        if (range == null) {
            throw new IllegalArgumentException();
        }
        double result = this.freeY[range.start()];
        for (int i = range.start(); i <= range.end(); ++i) {
            if (!(this.freeY[i] > result)) continue;
            result = this.freeY[i];
        }
        return result;
    }

    public String toString() {
        return Arrays.toString(this.freeY);
    }

    @Override
    public FrontierComplex add(double delta, ParticipantRange range) {
        if (range == null) {
            throw new IllegalArgumentException();
        }
        return new FrontierComplex(this.freeY, delta, range);
    }

    FrontierComplex copy() {
        return new FrontierComplex((double[])this.freeY.clone());
    }

    FrontierComplex mergeMax(FrontierComplex other) {
        if (this.freeY.length != other.freeY.length) {
            throw new IllegalArgumentException();
        }
        FrontierComplex result = new FrontierComplex(new double[this.freeY.length]);
        for (int i = 0; i < this.freeY.length; ++i) {
            result.freeY[i] = Math.max(this.freeY[i], other.freeY[i]);
        }
        return result;
    }
}

