"""Zero_Width table, created by bin/update-tables.py."""
# Generated: 2020-06-23T16:03:21.187024
ZERO_WIDTH = {
    '4.1.0': (
        # Source: DerivedGeneralCategory-4.1.0.txt
        # Date:  2005-02-26, 02:35:50 GMT [MD]
        #
        (0x00300, 0x0036f,),  # Combining Grave Accent  ..Combining Latin Small Le
        (0x00483, 0x00486,),  # Combining Cyrillic Titlo..Combining Cyrillic Psili
        (0x00488, 0x00489,),  # Combining Cyrillic Hundr..Combining Cyrillic Milli
        (0x00591, 0x005b9,),  # Hebrew Accent Etnahta   ..Hebrew Point Holam
        (0x005bb, 0x005bd,),  # Hebrew Point Qubuts     ..Hebrew Point Meteg
        (0x005bf, 0x005bf,),  # Hebrew Point Rafe       ..Hebrew Point Rafe
        (0x005c1, 0x005c2,),  # Hebrew Point Shin Dot   ..Hebrew Point Sin Dot
        (0x005c4, 0x005c5,),  # Hebrew Mark Upper Dot   ..Hebrew Mark Lower Dot
        (0x005c7, 0x005c7,),  # Hebrew Point Qamats Qata..Hebrew Point Qamats Qata
        (0x00610, 0x00615,),  # Arabic Sign Sallallahou ..Arabic Small High Tah
        (0x0064b, 0x0065e,),  # Arabic Fathatan         ..Arabic Fatha With Two Do
        (0x00670, 0x00670,),  # Arabic Letter Superscrip..Arabic Letter Superscrip
        (0x006d6, 0x006dc,),  # Arabic Small High Ligatu..Arabic Small High Seen
        (0x006de, 0x006e4,),  # Arabic Start Of Rub El H..Arabic Small High Madda
        (0x006e7, 0x006e8,),  # Arabic Small High Yeh   ..Arabic Small High Noon
        (0x006ea, 0x006ed,),  # Arabic Empty Centre Low ..Arabic Small Low Meem
        (0x00711, 0x00711,),  # Syriac Letter Superscrip..Syriac Letter Superscrip
        (0x00730, 0x0074a,),  # Syriac Pthaha Above     ..Syriac Barrekh
        (0x007a6, 0x007b0,),  # Thaana Abafili          ..Thaana Sukun
        (0x00901, 0x00902,),  # Devanagari Sign Candrabi..Devanagari Sign Anusvara
        (0x0093c, 0x0093c,),  # Devanagari Sign Nukta   ..Devanagari Sign Nukta
        (0x00941, 0x00948,),  # Devanagari Vowel Sign U ..Devanagari Vowel Sign Ai
        (0x0094d, 0x0094d,),  # Devanagari Sign Virama  ..Devanagari Sign Virama
        (0x00951, 0x00954,),  # Devanagari Stress Sign U..Devanagari Acute Accent
        (0x00962, 0x00963,),  # Devanagari Vowel Sign Vo..Devanagari Vowel Sign Vo
        (0x00981, 0x00981,),  # Bengali Sign Candrabindu..Bengali Sign Candrabindu
        (0x009bc, 0x009bc,),  # Bengali Sign Nukta      ..Bengali Sign Nukta
        (0x009c1, 0x009c4,),  # Bengali Vowel Sign U    ..Bengali Vowel Sign Vocal
        (0x009cd, 0x009cd,),  # Bengali Sign Virama     ..Bengali Sign Virama
        (0x009e2, 0x009e3,),  # Bengali Vowel Sign Vocal..Bengali Vowel Sign Vocal
        (0x00a01, 0x00a02,),  # Gurmukhi Sign Adak Bindi..Gurmukhi Sign Bindi
        (0x00a3c, 0x00a3c,),  # Gurmukhi Sign Nukta     ..Gurmukhi Sign Nukta
        (0x00a41, 0x00a42,),  # Gurmukhi Vowel Sign U   ..Gurmukhi Vowel Sign Uu
        (0x00a47, 0x00a48,),  # Gurmukhi Vowel Sign Ee  ..Gurmukhi Vowel Sign Ai
        (0x00a4b, 0x00a4d,),  # Gurmukhi Vowel Sign Oo  ..Gurmukhi Sign Virama
        (0x00a70, 0x00a71,),  # Gurmukhi Tippi          ..Gurmukhi Addak
        (0x00a81, 0x00a82,),  # Gujarati Sign Candrabind..Gujarati Sign Anusvara
        (0x00abc, 0x00abc,),  # Gujarati Sign Nukta     ..Gujarati Sign Nukta
        (0x00ac1, 0x00ac5,),  # Gujarati Vowel Sign U   ..Gujarati Vowel Sign Cand
        (0x00ac7, 0x00ac8,),  # Gujarati Vowel Sign E   ..Gujarati Vowel Sign Ai
        (0x00acd, 0x00acd,),  # Gujarati Sign Virama    ..Gujarati Sign Virama
        (0x00ae2, 0x00ae3,),  # Gujarati Vowel Sign Voca..Gujarati Vowel Sign Voca
        (0x00b01, 0x00b01,),  # Oriya Sign Candrabindu  ..Oriya Sign Candrabindu
        (0x00b3c, 0x00b3c,),  # Oriya Sign Nukta        ..Oriya Sign Nukta
        (0x00b3f, 0x00b3f,),  # Oriya Vowel Sign I      ..Oriya Vowel Sign I
        (0x00b41, 0x00b43,),  # Oriya Vowel Sign U      ..Oriya Vowel Sign Vocalic
        (0x00b4d, 0x00b4d,),  # Oriya Sign Virama       ..Oriya Sign Virama
        (0x00b56, 0x00b56,),  # Oriya Ai Length Mark    ..Oriya Ai Length Mark
        (0x00b82, 0x00b82,),  # Tamil Sign Anusvara     ..Tamil Sign Anusvara
        (0x00bc0, 0x00bc0,),  # Tamil Vowel Sign Ii     ..Tamil Vowel Sign Ii
        (0x00bcd, 0x00bcd,),  # Tamil Sign Virama       ..Tamil Sign Virama
        (0x00c3e, 0x00c40,),  # Telugu Vowel Sign Aa    ..Telugu Vowel Sign Ii
        (0x00c46, 0x00c48,),  # Telugu Vowel Sign E     ..Telugu Vowel Sign Ai
        (0x00c4a, 0x00c4d,),  # Telugu Vowel Sign O     ..Telugu Sign Virama
        (0x00c55, 0x00c56,),  # Telugu Length Mark      ..Telugu Ai Length Mark
        (0x00cbc, 0x00cbc,),  # Kannada Sign Nukta      ..Kannada Sign Nukta
        (0x00cbf, 0x00cbf,),  # Kannada Vowel Sign I    ..Kannada Vowel Sign I
        (0x00cc6, 0x00cc6,),  # Kannada Vowel Sign E    ..Kannada Vowel Sign E
        (0x00ccc, 0x00ccd,),  # Kannada Vowel Sign Au   ..Kannada Sign Virama
        (0x00d41, 0x00d43,),  # Malayalam Vowel Sign U  ..Malayalam Vowel Sign Voc
        (0x00d4d, 0x00d4d,),  # Malayalam Sign Virama   ..Malayalam Sign Virama
        (0x00dca, 0x00dca,),  # Sinhala Sign Al-lakuna  ..Sinhala Sign Al-lakuna
        (0x00dd2, 0x00dd4,),  # Sinhala Vowel Sign Ketti..Sinhala Vowel Sign Ketti
        (0x00dd6, 0x00dd6,),  # Sinhala Vowel Sign Diga ..Sinhala Vowel Sign Diga
        (0x00e31, 0x00e31,),  # Thai Character Mai Han-a..Thai Character Mai Han-a
        (0x00e34, 0x00e3a,),  # Thai Character Sara I   ..Thai Character Phinthu
        (0x00e47, 0x00e4e,),  # Thai Character Maitaikhu..Thai Character Yamakkan
        (0x00eb1, 0x00eb1,),  # Lao Vowel Sign Mai Kan  ..Lao Vowel Sign Mai Kan
        (0x00eb4, 0x00eb9,),  # Lao Vowel Sign I        ..Lao Vowel Sign Uu
        (0x00ebb, 0x00ebc,),  # Lao Vowel Sign Mai Kon  ..Lao Semivowel Sign Lo
        (0x00ec8, 0x00ecd,),  # Lao Tone Mai Ek         ..Lao Niggahita
        (0x00f18, 0x00f19,),  # Tibetan Astrological Sig..Tibetan Astrological Sig
        (0x00f35, 0x00f35,),  # Tibetan Mark Ngas Bzung ..Tibetan Mark Ngas Bzung
        (0x00f37, 0x00f37,),  # Tibetan Mark Ngas Bzung ..Tibetan Mark Ngas Bzung
        (0x00f39, 0x00f39,),  # Tibetan Mark Tsa -phru  ..Tibetan Mark Tsa -phru
        (0x00f71, 0x00f7e,),  # Tibetan Vowel Sign Aa   ..Tibetan Sign Rjes Su Nga
        (0x00f80, 0x00f84,),  # Tibetan Vowel Sign Rever..Tibetan Mark Halanta
        (0x00f86, 0x00f87,),  # Tibetan Sign Lci Rtags  ..Tibetan Sign Yang Rtags
        (0x00f90, 0x00f97,),  # Tibetan Subjoined Letter..Tibetan Subjoined Letter
        (0x00f99, 0x00fbc,),  # Tibetan Subjoined Letter..Tibetan Subjoined Letter
        (0x00fc6, 0x00fc6,),  # Tibetan Symbol Padma Gda..Tibetan Symbol Padma Gda
        (0x0102d, 0x01030,),  # Myanmar Vowel Sign I    ..Myanmar Vowel Sign Uu
        (0x01032, 0x01032,),  # Myanmar Vowel Sign Ai   ..Myanmar Vowel Sign Ai
        (0x01036, 0x01037,),  # Myanmar Sign Anusvara   ..Myanmar Sign Dot Below
        (0x01039, 0x01039,),  # Myanmar Sign Virama     ..Myanmar Sign Virama
        (0x01058, 0x01059,),  # Myanmar Vowel Sign Vocal..Myanmar Vowel Sign Vocal
        (0x0135f, 0x0135f,),  # Ethiopic Combining Gemin..Ethiopic Combining Gemin
        (0x01712, 0x01714,),  # Tagalog Vowel Sign I    ..Tagalog Sign Virama
        (0x01732, 0x01734,),  # Hanunoo Vowel Sign I    ..Hanunoo Sign Pamudpod
        (0x01752, 0x01753,),  # Buhid Vowel Sign I      ..Buhid Vowel Sign U
        (0x01772, 0x01773,),  # Tagbanwa Vowel Sign I   ..Tagbanwa Vowel Sign U
        (0x017b7, 0x017bd,),  # Khmer Vowel Sign I      ..Khmer Vowel Sign Ua
        (0x017c6, 0x017c6,),  # Khmer Sign Nikahit      ..Khmer Sign Nikahit
        (0x017c9, 0x017d3,),  # Khmer Sign Muusikatoan  ..Khmer Sign Bathamasat
        (0x017dd, 0x017dd,),  # Khmer Sign Atthacan     ..Khmer Sign Atthacan
        (0x0180b, 0x0180d,),  # Mongolian Free Variation..Mongolian Free Variation
        (0x018a9, 0x018a9,),  # Mongolian Letter Ali Gal..Mongolian Letter Ali Gal
        (0x01920, 0x01922,),  # Limbu Vowel Sign A      ..Limbu Vowel Sign U
        (0x01927, 0x01928,),  # Limbu Vowel Sign E      ..Limbu Vowel Sign O
        (0x01932, 0x01932,),  # Limbu Small Letter Anusv..Limbu Small Letter Anusv
        (0x01939, 0x0193b,),  # Limbu Sign Mukphreng    ..Limbu Sign Sa-i
        (0x01a17, 0x01a18,),  # Buginese Vowel Sign I   ..Buginese Vowel Sign U
        (0x01dc0, 0x01dc3,),  # Combining Dotted Grave A..Combining Suspension Mar
        (0x020d0, 0x020eb,),  # Combining Left Harpoon A..Combining Long Double So
        (0x0302a, 0x0302f,),  # Ideographic Level Tone M..Hangul Double Dot Tone M
        (0x03099, 0x0309a,),  # Combining Katakana-hirag..Combining Katakana-hirag
        (0x0a806, 0x0a806,),  # Syloti Nagri Sign Hasant..Syloti Nagri Sign Hasant
        (0x0a80b, 0x0a80b,),  # Syloti Nagri Sign Anusva..Syloti Nagri Sign Anusva
        (0x0a825, 0x0a826,),  # Syloti Nagri Vowel Sign ..Syloti Nagri Vowel Sign
        (0x0fb1e, 0x0fb1e,),  # Hebrew Point Judeo-spani..Hebrew Point Judeo-spani
        (0x0fe00, 0x0fe0f,),  # Variation Selector-1    ..Variation Selector-16
        (0x0fe20, 0x0fe23,),  # Combining Ligature Left ..Combining Double Tilde R
        (0x10a01, 0x10a03,),  # Kharoshthi Vowel Sign I ..Kharoshthi Vowel Sign Vo
        (0x10a05, 0x10a06,),  # Kharoshthi Vowel Sign E ..Kharoshthi Vowel Sign O
        (0x10a0c, 0x10a0f,),  # Kharoshthi Vowel Length ..Kharoshthi Sign Visarga
        (0x10a38, 0x10a3a,),  # Kharoshthi Sign Bar Abov..Kharoshthi Sign Dot Belo
        (0x10a3f, 0x10a3f,),  # Kharoshthi Virama       ..Kharoshthi Virama
        (0x1d167, 0x1d169,),  # Musical Symbol Combining..Musical Symbol Combining
        (0x1d17b, 0x1d182,),  # Musical Symbol Combining..Musical Symbol Combining
        (0x1d185, 0x1d18b,),  # Musical Symbol Combining..Musical Symbol Combining
        (0x1d1aa, 0x1d1ad,),  # Musical Symbol Combining..Musical Symbol Combining
        (0x1d242, 0x1d244,),  # Combining Greek Musical ..Combining Greek Musical
        (0xe0100, 0xe01ef,),  # Variation Selector-17   ..Variation Selector-256
    ),
    '5.0.0': (
        # Source: DerivedGeneralCategory-5.0.0.txt
        # Date:  2006-02-27, 23:41:27 GMT [MD]
        #
        (0x00300, 0x0036f,),  # Combining Grave Accent  ..Combining Latin Small Le
        (0x00483, 0x00486,),  # Combining Cyrillic Titlo..Combining Cyrillic Psili
        (0x00488, 0x00489,),  # Combining Cyrillic Hundr..Combining Cyrillic Milli
        (0x00591, 0x005bd,),  # Hebrew Accent Etnahta   ..Hebrew Point Meteg
        (0x005bf, 0x005bf,),  # Hebrew Point Rafe       ..Hebrew Point Rafe
        (0x005c1, 0x005c2,),  # Hebrew Point Shin Dot   ..Hebrew Point Sin Dot
        (0x005c4, 0x005c5,),  # Hebrew Mark Upper Dot   ..Hebrew Mark Lower Dot
        (0x005c7, 0x005c7,),  # Hebrew Point Qamats Qata..Hebrew Point Qamats Qata
        (0x00610, 0x00615,),  # Arabic Sign Sallallahou ..Arabic Small High Tah
        (0x0064b, 0x0065e,),  # Arabic Fathatan         ..Arabic Fatha With Two Do
        (0x00670, 0x00670,),  # Arabic Letter Superscrip..Arabic Letter Superscrip
        (0x006d6, 0x006dc,),  # Arabic Small High Ligatu..Arabic Small High Seen
        (0x006de, 0x006e4,),  # Arabic Start Of Rub El H..Arabic Small High Madda
        (0x006e7, 0x006e8,),  # Arabic Small High Yeh   ..Arabic Small High Noon
        (0x006ea, 0x006ed,),  # Arabic Empty Centre Low ..Arabic Small Low Meem
        (0x00711, 0x00711,),  # Syriac Letter Superscrip..Syriac Letter Superscrip
        (0x00730, 0x0074a,),  # Syriac Pthaha Above     ..Syriac Barrekh
        (0x007a6, 0x007b0,),  # Thaana Abafili          ..Thaana Sukun
        (0x007eb, 0x007f3,),  # Nko Combining Short High..Nko Combining Double Dot
        (0x00901, 0x00902,),  # Devanagari Sign Candrabi..Devanagari Sign Anusvara
        (0x0093c, 0x0093c,),  # Devanagari Sign Nukta   ..Devanagari Sign Nukta
        (0x00941, 0x00948,),  # Devanagari Vowel Sign U ..Devanagari Vowel Sign Ai
        (0x0094d, 0x0094d,),  # Devanagari Sign Virama  ..Devanagari Sign Virama
        (0x00951, 0x00954,),  # Devanagari Stress Sign U..Devanagari Acute Accent
        (0x00962, 0x00963,),  # Devanagari Vowel Sign Vo..Devanagari Vowel Sign Vo
        (0x00981, 0x00981,),  # Bengali Sign Candrabindu..Bengali Sign Candrabindu
        (0x009bc, 0x009bc,),  # Bengali Sign Nukta      ..Bengali Sign Nukta
        (0x009c1, 0x009c4,),  # Bengali Vowel Sign U    ..Bengali Vowel Sign Vocal
        (0x009cd, 0x009cd,),  # Bengali Sign Virama     ..Bengali Sign Virama
        (0x009e2, 0x009e3,),  # Bengali Vowel Sign Vocal..Bengali Vowel Sign Vocal
        (0x00a01, 0x00a02,),  # Gurmukhi Sign Adak Bindi..Gurmukhi Sign Bindi
        (0x00a3c, 0x00a3c,),  # Gurmukhi Sign Nukta     ..Gurmukhi Sign Nukta
        (0x00a41, 0x00a42,),  # Gurmukhi Vowel Sign U   ..Gurmukhi Vowel Sign Uu
        (0x00a47, 0x00a48,),  # Gurmukhi Vowel Sign Ee  ..Gurmukhi Vowel Sign Ai
        (0x00a4b, 0x00a4d,),  # Gurmukhi Vowel Sign Oo  ..Gurmukhi Sign Virama
        (0x00a70, 0x00a71,),  # Gurmukhi Tippi          ..Gurmukhi Addak
        (0x00a81, 0x00a82,),  # Gujarati Sign Candrabind..Gujarati Sign Anusvara
        (0x00abc, 0x00abc,),  # Gujarati Sign Nukta     ..Gujarati Sign Nukta
        (0x00ac1, 0x00ac5,),  # Gujarati Vowel Sign U   ..Gujarati Vowel Sign Cand
        (0x00ac7, 0x00ac8,),  # Gujarati Vowel Sign E   ..Gujarati Vowel Sign Ai
        (0x00acd, 0x00acd,),  # Gujarati Sign Virama    ..Gujarati Sign Virama
        (0x00ae2, 0x00ae3,),  # Gujarati Vowel Sign Voca..Gujarati Vowel Sign Voca
        (0x00b01, 0x00b01,),  # Oriya Sign Candrabindu  ..Oriya Sign Candrabindu
        (0x00b3c, 0x00b3c,),  # Oriya Sign Nukta        ..Oriya Sign Nukta
        (0x00b3f, 0x00b3f,),  # Oriya Vowel Sign I      ..Oriya Vowel Sign I
        (0x00b41, 0x00b43,),  # Oriya Vowel Sign U      ..Oriya Vowel Sign Vocalic
        (0x00b4d, 0x00b4d,),  # Oriya Sign Virama       ..Oriya Sign Virama
        (0x00b56, 0x00b56,),  # Oriya Ai Length Mark    ..Oriya Ai Length Mark
        (0x00b82, 0x00b82,),  # Tamil Sign Anusvara     ..Tamil Sign Anusvara
        (0x00bc0, 0x00bc0,),  # Tamil Vowel Sign Ii     ..Tamil Vowel Sign Ii
        (0x00bcd, 0x00bcd,),  # Tamil Sign Virama       ..Tamil Sign Virama
        (0x00c3e, 0x00c40,),  # Telugu Vowel Sign Aa    ..Telugu Vowel Sign Ii
        (0x00c46, 0x00c48,),  # Telugu Vowel Sign E     ..Telugu Vowel Sign Ai
        (0x00c4a, 0x00c4d,),  # Telugu Vowel Sign O     ..Telugu Sign Virama
        (0x00c55, 0x00c56,),  # Telugu Length Mark      ..Telugu Ai Length Mark
        (0x00cbc, 0x00cbc,),  # Kannada Sign Nukta      ..Kannada Sign Nukta
        (0x00cbf, 0x00cbf,),  # Kannada Vowel Sign I    ..Kannada Vowel Sign I
        (0x00cc6, 0x00cc6,),  # Kannada Vowel Sign E    ..Kannada Vowel Sign E
        (0x00ccc, 0x00ccd,),  # Kannada Vowel Sign Au   ..Kannada Sign Virama
        (0x00ce2, 0x00ce3,),  # Kannada Vowel Sign Vocal..Kannada Vowel Sign Vocal
        (0x00d41, 0x00d43,),  # Malayalam Vowel Sign U  ..Malayalam Vowel Sign Voc
        (0x00d4d, 0x00d4d,),  # Malayalam Sign Virama   ..Malayalam Sign Virama
        (0x00dca, 0x00dca,),  # Sinhala Sign Al-lakuna  ..Sinhala Sign Al-lakuna
        (0x00dd2, 0x00dd4,),  # Sinhala Vowel Sign Ketti..Sinhala Vowel Sign Ketti
        (0x00dd6, 0x00dd6,),  # Sinhala Vowel Sign Diga ..Sinhala Vowel Sign Diga
        (0x00e31, 0x00e31,),  # Thai Character Mai Han-a..Thai Character Mai Han-a
        (0x00e34, 0x00e3a,),  # Thai Character Sara I   ..Thai Character Phinthu
        (0x00e47, 0x00e4e,),  # Thai Character Maitaikhu..Thai Character Yamakkan
        (0x00eb1, 0x00eb1,),  # Lao Vowel Sign Mai Kan  ..Lao Vowel Sign Mai Kan
        (0x00eb4, 0x00eb9,),  # Lao Vowel Sign I        ..Lao Vowel Sign Uu
        (0x00ebb, 0x00ebc,),  # Lao Vowel Sign Mai Kon  ..Lao Semivowel Sign Lo
        (0x00ec8, 0x00ecd,),  # Lao Tone Mai Ek         ..Lao Niggahita
        (0x00f18, 0x00f19,),  # Tibetan Astrological Sig..Tibetan Astrological Sig
        (0x00f35, 0x00f35,),  # Tibetan Mark Ngas Bzung ..Tibetan Mark Ngas Bzung
        (0x00f37, 0x00f37,),  # Tibetan Mark Ngas Bzung ..Tibetan Mark Ngas Bzung
        (0x00f39, 0x00f39,),  # Tibetan Mark Tsa -phru  ..Tibetan Mark Tsa -phru
        (0x00f71, 0x00f7e,),  # Tibetan Vowel Sign Aa   ..Tibetan Sign Rjes Su Nga
        (0x00f80, 0x00f84,),  # Tibetan Vowel Sign Rever..Tibetan Mark Halanta
        (0x00f86, 0x00f87,),  # Tibetan Sign Lci Rtags  ..Tibetan Sign Yang Rtags
        (0x00f90, 0x00f97,),  # Tibetan Subjoined Letter..Tibetan Subjoined Letter
        (0x00f99, 0x00fbc,),  # Tibetan Subjoined Letter..Tibetan Subjoined Letter
        (0x00fc6, 0x00fc6,),  # Tibetan Symbol Padma Gda..Tibetan Symbol Padma Gda
        (0x0102d, 0x01030,),  # Myanmar Vowel Sign I    ..Myanmar Vowel Sign Uu
        (0x01032, 0x01032,),  # Myanmar Vowel Sign Ai   ..Myanmar Vowel Sign Ai
        (0x01036, 0x01037,),  # Myanmar Sign Anusvara   ..Myanmar Sign Dot Below
        (0x01039, 0x01039,),  # Myanmar Sign Virama     ..Myanmar Sign Virama
        (0x01058, 0x01059,),  # Myanmar Vowel Sign Vocal..Myanmar Vowel Sign Vocal
        (0x0135f, 0x0135f,),  # Ethiopic Combining Gemin..Ethiopic Combining Gemin
        (0x01712, 0x01714,),  # Tagalog Vowel Sign I    ..Tagalog Sign Virama
        (0x01732, 0x01734,),  # Hanunoo Vowel Sign I    ..Hanunoo Sign Pamudpod
        (0x01752, 0x01753,),  # Buhid Vowel Sign I      ..Buhid Vowel Sign U
        (0x01772, 0x01773,),  # Tagbanwa Vowel Sign I   ..Tagbanwa Vowel Sign U
        (0x017b7, 0x017bd,),  # Khmer Vowel Sign I      ..Khmer Vowel Sign Ua
        (0x017c6, 0x017c6,),  # Khmer Sign Nikahit      ..Khmer Sign Nikahit
        (0x017c9, 0x017d3,),  # Khmer Sign Muusikatoan  ..Khmer Sign Bathamasat
        (0x017dd, 0x017dd,),  # Khmer Sign Atthacan     ..Khmer Sign Atthacan
        (0x0180b, 0x0180d,),  # Mongolian Free Variation..Mongolian Free Variation
        (0x018a9, 0x018a9,),  # Mongolian Letter Ali Gal..Mongolian Letter Ali Gal
        (0x01920, 0x01922,),  # Limbu Vowel Sign A      ..Limbu Vowel Sign U
        (0x01927, 0x01928,),  # Limbu Vowel Sign E      ..Limbu Vowel Sign O
        (0x01932, 0x01932,),  # Limbu Small Letter Anusv..Limbu Small Letter Anusv
        (0x01939, 0x0193b,),  # Limbu Sign Mukphreng    ..Limbu Sign Sa-i
        (0x01a17, 0x01a18,),  # Buginese Vowel Sign I   ..Buginese Vowel Sign U
        (0x01b00, 0x01b03,),  # Balinese Sign Ulu Ricem ..Balinese Sign Surang
        (0x01b34, 0x01b34,),  # Balinese Sign Rerekan   ..Balinese Sign Rerekan
        (0x01b36, 0x01b3a,),  # Balinese Vowel Sign Ulu ..Balinese Vowel Sign Ra R
        (0x01b3c, 0x01b3c,),  # Balinese Vowel Sign La L..Balinese Vowel Sign La L
        (0x01b42, 0x01b42,),  # Balinese Vowel Sign Pepe..Balinese Vowel Sign Pepe
        (0x01b6b, 0x01b73,),  # Balinese Musical Symbol ..Balinese Musical Symbol
        (0x01dc0, 0x01dca,),  # Combining Dotted Grave A..Combining Latin Small Le
        (0x01dfe, 0x01dff,),  # Combining Left Arrowhead..Combining Right Arrowhea
        (0x020d0, 0x020ef,),  # Combining Left Harpoon A..Combining Right Arrow Be
        (0x0302a, 0x0302f,),  # Ideographic Level Tone M..Hangul Double Dot Tone M
        (0x03099, 0x0309a,),  # Combining Katakana-hirag..Combining Katakana-hirag
        (0x0a806, 0x0a806,),  # Syloti Nagri Sign Hasant..Syloti Nagri Sign Hasant
        (0x0a80b, 0x0a80b,),  # Syloti Nagri Sign Anusva..Syloti Nagri Sign Anusva
        (0x0a825, 0x0a826,),  # Syloti Nagri Vowel Sign ..Syloti Nagri Vowel Sign
        (0x0fb1e, 0x0fb1e,),  # Hebrew Point Judeo-spani..Hebrew Point Judeo-spani
        (0x0fe00, 0x0fe0f,),  # Variation Selector-1    ..Variation Selector-16
        (0x0fe20, 0x0fe23,),  # Combining Ligature Left ..Combining Double Tilde R
        (0x10a01, 0x10a03,),  # Kharoshthi Vowel Sign I ..Kharoshthi Vowel Sign Vo
        (0x10a05, 0x10a06,),  # Kharoshthi Vowel Sign E ..Kharoshthi Vowel Sign O
        (0x10a0c, 0x10a0f,),  # Kharoshthi Vowel Length ..Kharoshthi Sign Visarga
        (0x10a38, 0x10a3a,),  # Kharoshthi Sign Bar Abov..Kharoshthi Sign Dot Belo
        (0x10a3f, 0x10a3f,),  # Kharoshthi Virama       ..Kharoshthi Virama
        (0x1d167, 0x1d169,),  # Musical Symbol Combining..Musical Symbol Combining
        (0x1d17b, 0x1d182,),  # Musical Symbol Combining..Musical Symbol Combining
        (0x1d185, 0x1d18b,),  # Musical Symbol Combining..Musical Symbol Combining
        (0x1d1aa, 0x1d1ad,),  # Musical Symbol Combining..Musical Symbol Combining
        (0x1d242, 0x1d244,),  # Combining Greek Musical ..Combining Greek Musical
        (0xe0100, 0xe01ef,),  # Variation Selector-17   ..Variation Selector-256
    ),
    '5.1.0': (
        # Source: DerivedGeneralCategory-5.1.0.txt
        # Date:  2008-03-20, 17:54:57 GMT [MD]
        #
        (0x00300, 0x0036f,),  # Combining Grave Accent  ..Combining Latin Small Le
        (0x00483, 0x00489,),  # Combining Cyrillic Titlo..Combining Cyrillic Milli
        (0x00591, 0x005bd,),  # Hebrew Accent Etnahta   ..Hebrew Point Meteg
        (0x005bf, 0x005bf,),  # Hebrew Point Rafe       ..Hebrew Point Rafe
        (0x005c1, 0x005c2,),  # Hebrew Point Shin Dot   ..Hebrew Point Sin Dot
        (0x005c4, 0x005c5,),  # Hebrew Mark Upper Dot   ..Hebrew Mark Lower Dot
        (0x005c7, 0x005c7,),  # Hebrew Point Qamats Qata..Hebrew Point Qamats Qata
        (0x00610, 0x0061a,),  # Arabic Sign Sallallahou ..Arabic Small Kasra
        (0x0064b, 0x0065e,),  # Arabic Fathatan         ..Arabic Fatha With Two Do
        (0x00670, 0x00670,),  # Arabic Letter Superscrip..Arabic Letter Superscrip
        (0x006d6, 0x006dc,),  # Arabic Small High Ligatu..Arabic Small High Seen
        (0x006de, 0x006e4,),  # Arabic Start Of Rub El H..Arabic Small High Madda
        (0x006e7, 0x006e8,),  # Arabic Small High Yeh   ..Arabic Small High Noon
        (0x006ea, 0x006ed,),  # Arabic Empty Centre Low ..Arabic Small Low Meem
        (0x00711, 0x00711,),  # Syriac Letter Superscrip..Syriac Letter Superscrip
        (0x00730, 0x0074a,),  # Syriac Pthaha Above     ..Syriac Barrekh
        (0x007a6, 0x007b0,),  # Thaana Abafili          ..Thaana Sukun
        (0x007eb, 0x007f3,),  # Nko Combining Short High..Nko Combining Double Dot
        (0x00901, 0x00902,),  # Devanagari Sign Candrabi..Devanagari Sign Anusvara
        (0x0093c, 0x0093c,),  # Devanagari Sign Nukta   ..Devanagari Sign Nukta
        (0x00941, 0x00948,),  # Devanagari Vowel Sign U ..Devanagari Vowel Sign Ai
        (0x0094d, 0x0094d,),  # Devanagari Sign Virama  ..Devanagari Sign Virama
        (0x00951, 0x00954,),  # Devanagari Stress Sign U..Devanagari Acute Accent
        (0x00962, 0x00963,),  # Devanagari Vowel Sign Vo..Devanagari Vowel Sign Vo
        (0x00981, 0x00981,),  # Bengali Sign Candrabindu..Bengali Sign Candrabindu
        (0x009bc, 0x009bc,),  # Bengali Sign Nukta      ..Bengali Sign Nukta
        (0x009c1, 0x009c4,),  # Bengali Vowel Sign U    ..Bengali Vowel Sign Vocal
        (0x009cd, 0x009cd,),  # Bengali Sign Virama     ..Bengali Sign Virama
        (0x009e2, 0x009e3,),  # Bengali Vowel Sign Vocal..Bengali Vowel Sign Vocal
        (0x00a01, 0x00a02,),  # Gurmukhi Sign Adak Bindi..Gurmukhi Sign Bindi
        (0x00a3c, 0x00a3c,),  # Gurmukhi Sign Nukta     ..Gurmukhi Sign Nukta
        (0x00a41, 0x00a42,),  # Gurmukhi Vowel Sign U   ..Gurmukhi Vowel Sign Uu
        (0x00a47, 0x00a48,),  # Gurmukhi Vowel Sign Ee  ..Gurmukhi Vowel Sign Ai
        (0x00a4b, 0x00a4d,),  # Gurmukhi Vowel Sign Oo  ..Gurmukhi Sign Virama
        (0x00a51, 0x00a51,),  # Gurmukhi Sign Udaat     ..Gurmukhi Sign Udaat
        (0x00a70, 0x00a71,),  # Gurmukhi Tippi          ..Gurmukhi Addak
        (0x00a75, 0x00a75,),  # Gurmukhi Sign Yakash    ..Gurmukhi Sign Yakash
        (0x00a81, 0x00a82,),  # Gujarati Sign Candrabind..Gujarati Sign Anusvara
        (0x00abc, 0x00abc,),  # Gujarati Sign Nukta     ..Gujarati Sign Nukta
        (0x00ac1, 0x00ac5,),  # Gujarati Vowel Sign U   ..Gujarati Vowel Sign Cand
        (0x00ac7, 0x00ac8,),  # Gujarati Vowel Sign E   ..Gujarati Vowel Sign Ai
        (0x00acd, 0x00acd,),  # Gujarati Sign Virama    ..Gujarati Sign Virama
        (0x00ae2, 0x00ae3,),  # Gujarati Vowel Sign Voca..Gujarati Vowel Sign Voca
        (0x00b01, 0x00b01,),  # Oriya Sign Candrabindu  ..Oriya Sign Candrabindu
        (0x00b3c, 0x00b3c,),  # Oriya Sign Nukta        ..Oriya Sign Nukta
        (0x00b3f, 0x00b3f,),  # Oriya Vowel Sign I      ..Oriya Vowel Sign I
        (0x00b41, 0x00b44,),  # Oriya Vowel Sign U      ..Oriya Vowel Sign Vocalic
        (0x00b4d, 0x00b4d,),  # Oriya Sign Virama       ..Oriya Sign Virama
        (0x00b56, 0x00b56,),  # Oriya Ai Length Mark    ..Oriya Ai Length Mark
        (0x00b62, 0x00b63,),  # Oriya Vowel Sign Vocalic..Oriya Vowel Sign Vocalic
        (0x00b82, 0x00b82,),  # Tamil Sign Anusvara     ..Tamil Sign Anusvara
        (0x00bc0, 0x00bc0,),  # Tamil Vowel Sign Ii     ..Tamil Vowel Sign Ii
        (0x00bcd, 0x00bcd,),  # Tamil Sign Virama       ..Tamil Sign Virama
        (0x00c3e, 0x00c40,),  # Telugu Vowel Sign Aa    ..Telugu Vowel Sign Ii
        (0x00c46, 0x00c48,),  # Telugu Vowel Sign E     ..Telugu Vowel Sign Ai
        (0x00c4a, 0x00c4d,),  # Telugu Vowel Sign O     ..Telugu Sign Virama
        (0x00c55, 0x00c56,),  # Telugu Length Mark      ..Telugu Ai Length Mark
        (0x00c62, 0x00c63,),  # Telugu Vowel Sign Vocali..Telugu Vowel Sign Vocali
        (0x00cbc, 0x00cbc,),  # Kannada Sign Nukta      ..Kannada Sign Nukta
        (0x00cbf, 0x00cbf,),  # Kannada Vowel Sign I    ..Kannada Vowel Sign I
        (0x00cc6, 0x00cc6,),  # Kannada Vowel Sign E    ..Kannada Vowel Sign E
        (0x00ccc, 0x00ccd,),  # Kannada Vowel Sign Au   ..Kannada Sign Virama
        (0x00ce2, 0x00ce3,),  # Kannada Vowel Sign Vocal..Kannada Vowel Sign Vocal
        (0x00d41, 0x00d44,),  # Malayalam Vowel Sign U  ..Malayalam Vowel Sign Voc
        (0x00d4d, 0x00d4d,),  # Malayalam Sign Virama   ..Malayalam Sign Virama
        (0x00d62, 0x00d63,),  # Malayalam Vowel Sign Voc..Malayalam Vowel Sign Voc
        (0x00dca, 0x00dca,),  # Sinhala Sign Al-lakuna  ..Sinhala Sign Al-lakuna
        (0x00dd2, 0x00dd4,),  # Sinhala Vowel Sign Ketti..Sinhala Vowel Sign Ketti
        (0x00dd6, 0x00dd6,),  # Sinhala Vowel Sign Diga ..Sinhala Vowel Sign Diga
        (0x00e31, 0x00e31,),  # Thai Character Mai Han-a..Thai Character Mai Han-a
        (0x00e34, 0x00e3a,),  # Thai Character Sara I   ..Thai Character Phinthu
        (0x00e47, 0x00e4e,),  # Thai Character Maitaikhu..Thai Character Yamakkan
        (0x00eb1, 0x00eb1,),  # Lao Vowel Sign Mai Kan  ..Lao Vowel Sign Mai Kan
        (0x00eb4, 0x00eb9,),  # Lao Vowel Sign I        ..Lao Vowel Sign Uu
        (0x00ebb, 0x00ebc,),  # Lao Vowel Sign Mai Kon  ..Lao Semivowel Sign Lo
        (0x00ec8, 0x00ecd,),  # Lao Tone Mai Ek         ..Lao Niggahita
        (0x00f18, 0x00f19,),  # Tibetan Astrological Sig..Tibetan Astrological Sig
        (0x00f35, 0x00f35,),  # Tibetan Mark Ngas Bzung ..Tibetan Mark Ngas Bzung
        (0x00f37, 0x00f37,),  # Tibetan Mark Ngas Bzung ..Tibetan Mark Ngas Bzung
        (0x00f39, 0x00f39,),  # Tibetan Mark Tsa -phru  ..Tibetan Mark Tsa -phru
        (0x00f71, 0x00f7e,),  # Tibetan Vowel Sign Aa   ..Tibetan Sign Rjes Su Nga
        (0x00f80, 0x00f84,),  # Tibetan Vowel Sign Rever..Tibetan Mark Halanta
        (0x00f86, 0x00f87,),  # Tibetan Sign Lci Rtags  ..Tibetan Sign Yang Rtags
        (0x00f90, 0x00f97,),  # Tibetan Subjoined Letter..Tibetan Subjoined Letter
        (0x00f99, 0x00fbc,),  # Tibetan Subjoined Letter..Tibetan Subjoined Letter
        (0x00fc6, 0x00fc6,),  # Tibetan Symbol Padma Gda..Tibetan Symbol Padma Gda
        (0x0102d, 0x01030,),  # Myanmar Vowel Sign I    ..Myanmar Vowel Sign Uu
        (0x01032, 0x01037,),  # Myanmar Vowel Sign Ai   ..Myanmar Sign Dot Below
        (0x01039, 0x0103a,),  # Myanmar Sign Virama     ..Myanmar Sign Asat
        (0x0103d, 0x0103e,),  # Myanmar Consonant Sign M..Myanmar Consonant Sign M
        (0x01058, 0x01059,),  # Myanmar Vowel Sign Vocal..Myanmar Vowel Sign Vocal
        (0x0105e, 0x01060,),  # Myanmar Consonant Sign M..Myanmar Consonant Sign M
        (0x01071, 0x01074,),  # Myanmar Vowel Sign Geba ..Myanmar Vowel Sign Kayah
        (0x01082, 0x01082,),  # Myanmar Consonant Sign S..Myanmar Consonant Sign S
        (0x01085, 0x01086,),  # Myanmar Vowel Sign Shan ..Myanmar Vowel Sign Shan
        (0x0108d, 0x0108d,),  # Myanmar Sign Shan Counci..Myanmar Sign Shan Counci
        (0x0135f, 0x0135f,),  # Ethiopic Combining Gemin..Ethiopic Combining Gemin
        (0x01712, 0x01714,),  # Tagalog Vowel Sign I    ..Tagalog Sign Virama
        (0x01732, 0x01734,),  # Hanunoo Vowel Sign I    ..Hanunoo Sign Pamudpod
        (0x01752, 0x01753,),  # Buhid Vowel Sign I      ..Buhid Vowel Sign U
        (0x01772, 0x01773,),  # Tagbanwa Vowel Sign I   ..Tagbanwa Vowel Sign U
        (0x017b7, 0x017bd,),  # Khmer Vowel Sign I      ..Khmer Vowel Sign Ua
        (0x017c6, 0x017c6,),  # Khmer Sign Nikahit      ..Khmer Sign Nikahit
        (0x017c9, 0x017d3,),  # Khmer Sign Muusikatoan  ..Khmer Sign Bathamasat
        (0x017dd, 0x017dd,),  # Khmer Sign Atthacan     ..Khmer Sign Atthacan
        (0x0180b, 0x0180d,),  # Mongolian Free Variation..Mongolian Free Variation
        (0x018a9, 0x018a9,),  # Mongolian Letter Ali Gal..Mongolian Letter Ali Gal
        (0x01920, 0x01922,),  # Limbu Vowel Sign A      ..Limbu Vowel Sign U
        (0x01927, 0x01928,),  # Limbu Vowel Sign E      ..Limbu Vowel Sign O
        (0x01932, 0x01932,),  # Limbu Small Letter Anusv..Limbu Small Letter Anusv
        (0x01939, 0x0193b,),  # Limbu Sign Mukphreng    ..Limbu Sign Sa-i
        (0x01a17, 0x01a18,),  # Buginese Vowel Sign I   ..Buginese Vowel Sign U
        (0x01b00, 0x01b03,),  # Balinese Sign Ulu Ricem ..Balinese Sign Surang
        (0x01b34, 0x01b34,),  # Balinese Sign Rerekan   ..Balinese Sign Rerekan
        (0x01b36, 0x01b3a,),  # Balinese Vowel Sign Ulu ..Balinese Vowel Sign Ra R
        (0x01b3c, 0x01b3c,),  # Balinese Vowel Sign La L..Balinese Vowel Sign La L
        (0x01b42, 0x01b42,),  # Balinese Vowel Sign Pepe..Balinese Vowel Sign Pepe
        (0x01b6b, 0x01b73,),  # Balinese Musical Symbol ..Balinese Musical Symbol
        (0x01b80, 0x01b81,),  # Sundanese Sign Panyecek ..Sundanese Sign Panglayar
        (0x01ba2, 0x01ba5,),  # Sundanese Consonant Sign..Sundanese Vowel Sign Pan
        (0x01ba8, 0x01ba9,),  # Sundanese Vowel Sign Pam..Sundanese Vowel Sign Pan
        (0x01c2c, 0x01c33,),  # Lepcha Vowel Sign E     ..Lepcha Consonant Sign T
        (0x01c36, 0x01c37,),  # Lepcha Sign Ran         ..Lepcha Sign Nukta
        (0x01dc0, 0x01de6,),  # Combining Dotted Grave A..Combining Latin Small Le
        (0x01dfe, 0x01dff,),  # Combining Left Arrowhead..Combining Right Arrowhea
        (0x020d0, 0x020f0,),  # Combining Left Harpoon A..Combining Asterisk Above
        (0x02de0, 0x02dff,),  # Combining Cyrillic Lette..Combining Cyrillic Lette
        (0x0302a, 0x0302f,),  # Ideographic Level Tone M..Hangul Double Dot Tone M
        (0x03099, 0x0309a,),  # Combining Katakana-hirag..Combining Katakana-hirag
        (0x0a66f, 0x0a672,),  # Combining Cyrillic Vzmet..Combining Cyrillic Thous
        (0x0a67c, 0x0a67d,),  # Combining Cyrillic Kavyk..Combining Cyrillic Payer
        (0x0a802, 0x0a802,),  # Syloti Nagri Sign Dvisva..Syloti Nagri Sign Dvisva
        (0x0a806, 0x0a806,),  # Syloti Nagri Sign Hasant..Syloti Nagri Sign Hasant
        (0x0a80b, 0x0a80b,),  # Syloti Nagri Sign Anusva..Syloti Nagri Sign Anusva
        (0x0a825, 0x0a826,),  # Syloti Nagri Vowel Sign ..Syloti Nagri Vowel Sign
        (0x0a8c4, 0x0a8c4,),  # Saurashtra Sign Virama  ..Saurashtra Sign Virama
        (0x0a926, 0x0a92d,),  # Kayah Li Vowel Ue       ..Kayah Li Tone Calya Plop
        (0x0a947, 0x0a951,),  # Rejang Vowel Sign I     ..Rejang Consonant Sign R
        (0x0aa29, 0x0aa2e,),  # Cham Vowel Sign Aa      ..Cham Vowel Sign Oe
        (0x0aa31, 0x0aa32,),  # Cham Vowel Sign Au      ..Cham Vowel Sign Ue
        (0x0aa35, 0x0aa36,),  # Cham Consonant Sign La  ..Cham Consonant Sign Wa
        (0x0aa43, 0x0aa43,),  # Cham Consonant Sign Fina..Cham Consonant Sign Fina
        (0x0aa4c, 0x0aa4c,),  # Cham Consonant Sign Fina..Cham Consonant Sign Fina
        (0x0fb1e, 0x0fb1e,),  # Hebrew Point Judeo-spani..Hebrew Point Judeo-spani
        (0x0fe00, 0x0fe0f,),  # Variation Selector-1    ..Variation Selector-16
        (0x0fe20, 0x0fe26,),  # Combining Ligature Left ..Combining Conjoining Mac
        (0x101fd, 0x101fd,),  # Phaistos Disc Sign Combi..Phaistos Disc Sign Combi
        (0x10a01, 0x10a03,),  # Kharoshthi Vowel Sign I ..Kharoshthi Vowel Sign Vo
        (0x10a05, 0x10a06,),  # Kharoshthi Vowel Sign E ..Kharoshthi Vowel Sign O
        (0x10a0c, 0x10a0f,),  # Kharoshthi Vowel Length ..Kharoshthi Sign Visarga
        (0x10a38, 0x10a3a,),  # Kharoshthi Sign Bar Abov..Kharoshthi Sign Dot Belo
        (0x10a3f, 0x10a3f,),  # Kharoshthi Virama       ..Kharoshthi Virama
        (0x1d167, 0x1d169,),  # Musical Symbol Combining..Musical Symbol Combining
        (0x1d17b, 0x1d182,),  # Musical Symbol Combining..Musical Symbol Combining
        (0x1d185, 0x1d18b,),  # Musical Symbol Combining..Musical Symbol Combining
        (0x1d1aa, 0x1d1ad,),  # Musical Symbol Combining..Musical Symbol Combining
        (0x1d242, 0x1d244,),  # Combining Greek Musical ..Combining Greek Musical
        (0xe0100, 0xe01ef,),  # Variation Selector-17   ..Variation Selector-256
    ),
    '5.2.0': (
        # Source: DerivedGeneralCategory-5.2.0.txt
        # Date:  2009-08-22, 04:58:21 GMT [MD]
        #
        (0x00300, 0x0036f,),  # Combining Grave Accent  ..Combining Latin Small Le
        (0x00483, 0x00489,),  # Combining Cyrillic Titlo..Combining Cyrillic Milli
        (0x00591, 0x005bd,),  # Hebrew Accent Etnahta   ..Hebrew Point Meteg
        (0x005bf, 0x005bf,),  # Hebrew Point Rafe       ..Hebrew Point Rafe
        (0x005c1, 0x005c2,),  # Hebrew Point Shin Dot   ..Hebrew Point Sin Dot
        (0x005c4, 0x005c5,),  # Hebrew Mark Upper Dot   ..Hebrew Mark Lower Dot
        (0x005c7, 0x005c7,),  # Hebrew Point Qamats Qata..Hebrew Point Qamats Qata
        (0x00610, 0x0061a,),  # Arabic Sign Sallallahou ..Arabic Small Kasra
        (0x0064b, 0x0065e,),  # Arabic Fathatan         ..Arabic Fatha With Two Do
        (0x00670, 0x00670,),  # Arabic Letter Superscrip..Arabic Letter Superscrip
        (0x006d6, 0x006dc,),  # Arabic Small High Ligatu..Arabic Small High Seen
        (0x006de, 0x006e4,),  # Arabic Start Of Rub El H..Arabic Small High Madda
        (0x006e7, 0x006e8,),  # Arabic Small High Yeh   ..Arabic Small High Noon
        (0x006ea, 0x006ed,),  # Arabic Empty Centre Low ..Arabic Small Low Meem
        (0x00711, 0x00711,),  # Syriac Letter Superscrip..Syriac Letter Superscrip
        (0x00730, 0x0074a,),  # Syriac Pthaha Above     ..Syriac Barrekh
        (0x007a6, 0x007b0,),  # Thaana Abafili          ..Thaana Sukun
        (0x007eb, 0x007f3,),  # Nko Combining Short High..Nko Combining Double Dot
        (0x00816, 0x00819,),  # Samaritan Mark In       ..Samaritan Mark Dagesh
        (0x0081b, 0x00823,),  # Samaritan Mark Epentheti..Samaritan Vowel Sign A
        (0x00825, 0x00827,),  # Samaritan Vowel Sign Sho..Samaritan Vowel Sign U
        (0x00829, 0x0082d,),  # Samaritan Vowel Sign Lon..Samaritan Mark Nequdaa
        (0x00900, 0x00902,),  # Devanagari Sign Inverted..Devanagari Sign Anusvara
        (0x0093c, 0x0093c,),  # Devanagari Sign Nukta   ..Devanagari Sign Nukta
        (0x00941, 0x00948,),  # Devanagari Vowel Sign U ..Devanagari Vowel Sign Ai
        (0x0094d, 0x0094d,),  # Devanagari Sign Virama  ..Devanagari Sign Virama
        (0x00951, 0x00955,),  # Devanagari Stress Sign U..Devanagari Vowel Sign Ca
        (0x00962, 0x00963,),  # Devanagari Vowel Sign Vo..Devanagari Vowel Sign Vo
        (0x00981, 0x00981,),  # Bengali Sign Candrabindu..Bengali Sign Candrabindu
        (0x009bc, 0x009bc,),  # Bengali Sign Nukta      ..Bengali Sign Nukta
        (0x009c1, 0x009c4,),  # Bengali Vowel Sign U    ..Bengali Vowel Sign Vocal
        (0x009cd, 0x009cd,),  # Bengali Sign Virama     ..Bengali Sign Virama
        (0x009e2, 0x009e3,),  # Bengali Vowel Sign Vocal..Bengali Vowel Sign Vocal
        (0x00a01, 0x00a02,),  # Gurmukhi Sign Adak Bindi..Gurmukhi Sign Bindi
        (0x00a3c, 0x00a3c,),  # Gurmukhi Sign Nukta     ..Gurmukhi Sign Nukta
        (0x00a41, 0x00a42,),  # Gurmukhi Vowel Sign U   ..Gurmukhi Vowel Sign Uu
        (0x00a47, 0x00a48,),  # Gurmukhi Vowel Sign Ee  ..Gurmukhi Vowel Sign Ai
        (0x00a4b, 0x00a4d,),  # Gurmukhi Vowel Sign Oo  ..Gurmukhi Sign Virama
        (0x00a51, 0x00a51,),  # Gurmukhi Sign Udaat     ..Gurmukhi Sign Udaat
        (0x00a70, 0x00a71,),  # Gurmukhi Tippi          ..Gurmukhi Addak
        (0x00a75, 0x00a75,),  # Gurmukhi Sign Yakash    ..Gurmukhi Sign Yakash
        (0x00a81, 0x00a82,),  # Gujarati Sign Candrabind..Gujarati Sign Anusvara
        (0x00abc, 0x00abc,),  # Gujarati Sign Nukta     ..Gujarati Sign Nukta
        (0x00ac1, 0x00ac5,),  # Gujarati Vowel Sign U   ..Gujarati Vowel Sign Cand
        (0x00ac7, 0x00ac8,),  # Gujarati Vowel Sign E   ..Gujarati Vowel Sign Ai
        (0x00acd, 0x00acd,),  # Gujarati Sign Virama    ..Gujarati Sign Virama
        (0x00ae2, 0x00ae3,),  # Gujarati Vowel Sign Voca..Gujarati Vowel Sign Voca
        (0x00b01, 0x00b01,),  # Oriya Sign Candrabindu  ..Oriya Sign Candrabindu
        (0x00b3c, 0x00b3c,),  # Oriya Sign Nukta        ..Oriya Sign Nukta
        (0x00b3f, 0x00b3f,),  # Oriya Vowel Sign I      ..Oriya Vowel Sign I
        (0x00b41, 0x00b44,),  # Oriya Vowel Sign U      ..Oriya Vowel Sign Vocalic
        (0x00b4d, 0x00b4d,),  # Oriya Sign Virama       ..Oriya Sign Virama
        (0x00b56, 0x00b56,),  # Oriya Ai Length Mark    ..Oriya Ai Length Mark
        (0x00b62, 0x00b63,),  # Oriya Vowel Sign Vocalic..Oriya Vowel Sign Vocalic
        (0x00b82, 0x00b82,),  # Tamil Sign Anusvara     ..Tamil Sign Anusvara
        (0x00bc0, 0x00bc0,),  # Tamil Vowel Sign Ii     ..Tamil Vowel Sign Ii
        (0x00bcd, 0x00bcd,),  # Tamil Sign Virama       ..Tamil Sign Virama
        (0x00c3e, 0x00c40,),  # Telugu Vowel Sign Aa    ..Telugu Vowel Sign Ii
        (0x00c46, 0x00c48,),  # Telugu Vowel Sign E     ..Telugu Vowel Sign Ai
        (0x00c4a, 0x00c4d,),  # Telugu Vowel Sign O     ..Telugu Sign Virama
        (0x00c55, 0x00c56,),  # Telugu Length Mark      ..Telugu Ai Length Mark
        (0x00c62, 0x00c63,),  # Telugu Vowel Sign Vocali..Telugu Vowel Sign Vocali
        (0x00cbc, 0x00cbc,),  # Kannada Sign Nukta      ..Kannada Sign Nukta
        (0x00cbf, 0x00cbf,),  # Kannada Vowel Sign I    ..Kannada Vowel Sign I
        (0x00cc6, 0x00cc6,),  # Kannada Vowel Sign E    ..Kannada Vowel Sign E
        (0x00ccc, 0x00ccd,),  # Kannada Vowel Sign Au   ..Kannada Sign Virama
        (0x00ce2, 0x00ce3,),  # Kannada Vowel Sign Vocal..Kannada Vowel Sign Vocal
        (0x00d41, 0x00d44,),  # Malayalam Vowel Sign U  ..Malayalam Vowel Sign Voc
        (0x00d4d, 0x00d4d,),  # Malayalam Sign Virama   ..Malayalam Sign Virama
        (0x00d62, 0x00d63,),  # Malayalam Vowel Sign Voc..Malayalam Vowel Sign Voc
        (0x00dca, 0x00dca,),  # Sinhala Sign Al-lakuna  ..Sinhala Sign Al-lakuna
        (0x00dd2, 0x00dd4,),  # Sinhala Vowel Sign Ketti..Sinhala Vowel Sign Ketti
        (0x00dd6, 0x00dd6,),  # Sinhala Vowel Sign Diga ..Sinhala Vowel Sign Diga
        (0x00e31, 0x00e31,),  # Thai Character Mai Han-a..Thai Character Mai Han-a
        (0x00e34, 0x00e3a,),  # Thai Character Sara I   ..Thai Character Phinthu
        (0x00e47, 0x00e4e,),  # Thai Character Maitaikhu..Thai Character Yamakkan
        (0x00eb1, 0x00eb1,),  # Lao Vowel Sign Mai Kan  ..Lao Vowel Sign Mai Kan
        (0x00eb4, 0x00eb9,),  # Lao Vowel Sign I        ..Lao Vowel Sign Uu
        (0x00ebb, 0x00ebc,),  # Lao Vowel Sign Mai Kon  ..Lao Semivowel Sign Lo
        (0x00ec8, 0x00ecd,),  # Lao Tone Mai Ek         ..Lao Niggahita
        (0x00f18, 0x00f19,),  # Tibetan Astrological Sig..Tibetan Astrological Sig
        (0x00f35, 0x00f35,),  # Tibetan Mark Ngas Bzung ..Tibetan Mark Ngas Bzung
        (0x00f37, 0x00f37,),  # Tibetan Mark Ngas Bzung ..Tibetan Mark Ngas Bzung
        (0x00f39, 0x00f39,),  # Tibetan Mark Tsa -phru  ..Tibetan Mark Tsa -phru
        (0x00f71, 0x00f7e,),  # Tibetan Vowel Sign Aa   ..Tibetan Sign Rjes Su Nga
        (0x00f80, 0x00f84,),  # Tibetan Vowel Sign Rever..Tibetan Mark Halanta
        (0x00f86, 0x00f87,),  # Tibetan Sign Lci Rtags  ..Tibetan Sign Yang Rtags
        (0x00f90, 0x00f97,),  # Tibetan Subjoined Letter..Tibetan Subjoined Letter
        (0x00f99, 0x00fbc,),  # Tibetan Subjoined Letter..Tibetan Subjoined Letter
        (0x00fc6, 0x00fc6,),  # Tibetan Symbol Padma Gda..Tibetan Symbol Padma Gda
        (0x0102d, 0x01030,),  # Myanmar Vowel Sign I    ..Myanmar Vowel Sign Uu
        (0x01032, 0x01037,),  # Myanmar Vowel Sign Ai   ..Myanmar Sign Dot Below
        (0x01039, 0x0103a,),  # Myanmar Sign Virama     ..Myanmar Sign Asat
        (0x0103d, 0x0103e,),  # Myanmar Consonant Sign M..Myanmar Consonant Sign M
        (0x01058, 0x01059,),  # Myanmar Vowel Sign Vocal..Myanmar Vowel Sign Vocal
        (0x0105e, 0x01060,),  # Myanmar Consonant Sign M..Myanmar Consonant Sign M
        (0x01071, 0x01074,),  # Myanmar Vowel Sign Geba ..Myanmar Vowel Sign Kayah
        (0x01082, 0x01082,),  # Myanmar Consonant Sign S..Myanmar Consonant Sign S
        (0x01085, 0x01086,),  # Myanmar Vowel Sign Shan ..Myanmar Vowel Sign Shan
        (0x0108d, 0x0108d,),  # Myanmar Sign Shan Counci..Myanmar Sign Shan Counci
        (0x0109d, 0x0109d,),  # Myanmar Vowel Sign Aiton..Myanmar Vowel Sign Aiton
        (0x0135f, 0x0135f,),  # Ethiopic Combining Gemin..Ethiopic Combining Gemin
        (0x01712, 0x01714,),  # Tagalog Vowel Sign I    ..Tagalog Sign Virama
        (0x01732, 0x01734,),  # Hanunoo Vowel Sign I    ..Hanunoo Sign Pamudpod
        (0x01752, 0x01753,),  # Buhid Vowel Sign I      ..Buhid Vowel Sign U
        (0x01772, 0x01773,),  # Tagbanwa Vowel Sign I   ..Tagbanwa Vowel Sign U
        (0x017b7, 0x017bd,),  # Khmer Vowel Sign I      ..Khmer Vowel Sign Ua
        (0x017c6, 0x017c6,),  # Khmer Sign Nikahit      ..Khmer Sign Nikahit
        (0x017c9, 0x017d3,),  # Khmer Sign Muusikatoan  ..Khmer Sign Bathamasat
        (0x017dd, 0x017dd,),  # Khmer Sign Atthacan     ..Khmer Sign Atthacan
        (0x0180b, 0x0180d,),  # Mongolian Free Variation..Mongolian Free Variation
        (0x018a9, 0x018a9,),  # Mongolian Letter Ali Gal..Mongolian Letter Ali Gal
        (0x01920, 0x01922,),  # Limbu Vowel Sign A      ..Limbu Vowel Sign U
        (0x01927, 0x01928,),  # Limbu Vowel Sign E      ..Limbu Vowel Sign O
        (0x01932, 0x01932,),  # Limbu Small Letter Anusv..Limbu Small Letter Anusv
        (0x01939, 0x0193b,),  # Limbu Sign Mukphreng    ..Limbu Sign Sa-i
        (0x01a17, 0x01a18,),  # Buginese Vowel Sign I   ..Buginese Vowel Sign U
        (0x01a56, 0x01a56,),  # Tai Tham Consonant Sign ..Tai Tham Consonant Sign
        (0x01a58, 0x01a5e,),  # Tai Tham Sign Mai Kang L..Tai Tham Consonant Sign
        (0x01a60, 0x01a60,),  # Tai Tham Sign Sakot     ..Tai Tham Sign Sakot
        (0x01a62, 0x01a62,),  # Tai Tham Vowel Sign Mai ..Tai Tham Vowel Sign Mai
        (0x01a65, 0x01a6c,),  # Tai Tham Vowel Sign I   ..Tai Tham Vowel Sign Oa B
        (0x01a73, 0x01a7c,),  # Tai Tham Vowel Sign Oa A..Tai Tham Sign Khuen-lue
        (0x01a7f, 0x01a7f,),  # Tai Tham Combining Crypt..Tai Tham Combining Crypt
        (0x01b00, 0x01b03,),  # Balinese Sign Ulu Ricem ..Balinese Sign Surang
        (0x01b34, 0x01b34,),  # Balinese Sign Rerekan   ..Balinese Sign Rerekan
        (0x01b36, 0x01b3a,),  # Balinese Vowel Sign Ulu ..Balinese Vowel Sign Ra R
        (0x01b3c, 0x01b3c,),  # Balinese Vowel Sign La L..Balinese Vowel Sign La L
        (0x01b42, 0x01b42,),  # Balinese Vowel Sign Pepe..Balinese Vowel Sign Pepe
        (0x01b6b, 0x01b73,),  # Balinese Musical Symbol ..Balinese Musical Symbol
        (0x01b80, 0x01b81,),  # Sundanese Sign Panyecek ..Sundanese Sign Panglayar
        (0x01ba2, 0x01ba5,),  # Sundanese Consonant Sign..Sundanese Vowel Sign Pan
        (0x01ba8, 0x01ba9,),  # Sundanese Vowel Sign Pam..Sundanese Vowel Sign Pan
        (0x01c2c, 0x01c33,),  # Lepcha Vowel Sign E     ..Lepcha Consonant Sign T
        (0x01c36, 0x01c37,),  # Lepcha Sign Ran         ..Lepcha Sign Nukta
        (0x01cd0, 0x01cd2,),  # Vedic Tone Karshana     ..Vedic Tone Prenkha
        (0x01cd4, 0x01ce0,),  # Vedic Sign Yajurvedic Mi..Vedic Tone Rigvedic Kash
        (0x01ce2, 0x01ce8,),  # Vedic Sign Visarga Svari..Vedic Sign Visarga Anuda
        (0x01ced, 0x01ced,),  # Vedic Sign Tiryak       ..Vedic Sign Tiryak
        (0x01dc0, 0x01de6,),  # Combining Dotted Grave A..Combining Latin Small Le
        (0x01dfd, 0x01dff,),  # Combining Almost Equal T..Combining Right Arrowhea
        (0x020d0, 0x020f0,),  # Combining Left Harpoon A..Combining Asterisk Above
        (0x02cef, 0x02cf1,),  # Coptic Combining Ni Abov..Coptic Combining Spiritu
        (0x02de0, 0x02dff,),  # Combining Cyrillic Lette..Combining Cyrillic Lette
        (0x0302a, 0x0302f,),  # Ideographic Level Tone M..Hangul Double Dot Tone M
        (0x03099, 0x0309a,),  # Combining Katakana-hirag..Combining Katakana-hirag
        (0x0a66f, 0x0a672,),  # Combining Cyrillic Vzmet..Combining Cyrillic Thous
        (0x0a67c, 0x0a67d,),  # Combining Cyrillic Kavyk..Combining Cyrillic Payer
        (0x0a6f0, 0x0a6f1,),  # Bamum Combining Mark Koq..Bamum Combining Mark Tuk
        (0x0a802, 0x0a802,),  # Syloti Nagri Sign Dvisva..Syloti Nagri Sign Dvisva
        (0x0a806, 0x0a806,),  # Syloti Nagri Sign Hasant..Syloti Nagri Sign Hasant
        (0x0a80b, 0x0a80b,),  # Syloti Nagri Sign Anusva..Syloti Nagri Sign Anusva
        (0x0a825, 0x0a826,),  # Syloti Nagri Vowel Sign ..Syloti Nagri Vowel Sign
        (0x0a8c4, 0x0a8c4,),  # Saurashtra Sign Virama  ..Saurashtra Sign Virama
        (0x0a8e0, 0x0a8f1,),  # Combining Devanagari Dig..Combining Devanagari Sig
        (0x0a926, 0x0a92d,),  # Kayah Li Vowel Ue       ..Kayah Li Tone Calya Plop
        (0x0a947, 0x0a951,),  # Rejang Vowel Sign I     ..Rejang Consonant Sign R
        (0x0a980, 0x0a982,),  # Javanese Sign Panyangga ..Javanese Sign Layar
        (0x0a9b3, 0x0a9b3,),  # Javanese Sign Cecak Telu..Javanese Sign Cecak Telu
        (0x0a9b6, 0x0a9b9,),  # Javanese Vowel Sign Wulu..Javanese Vowel Sign Suku
        (0x0a9bc, 0x0a9bc,),  # Javanese Vowel Sign Pepe..Javanese Vowel Sign Pepe
        (0x0aa29, 0x0aa2e,),  # Cham Vowel Sign Aa      ..Cham Vowel Sign Oe
        (0x0aa31, 0x0aa32,),  # Cham Vowel Sign Au      ..Cham Vowel Sign Ue
        (0x0aa35, 0x0aa36,),  # Cham Consonant Sign La  ..Cham Consonant Sign Wa
        (0x0aa43, 0x0aa43,),  # Cham Consonant Sign Fina..Cham Consonant Sign Fina
        (0x0aa4c, 0x0aa4c,),  # Cham Consonant Sign Fina..Cham Consonant Sign Fina
        (0x0aab0, 0x0aab0,),  # Tai Viet Mai Kang       ..Tai Viet Mai Kang
        (0x0aab2, 0x0aab4,),  # Tai Viet Vowel I        ..Tai Viet Vowel U
        (0x0aab7, 0x0aab8,),  # Tai Viet Mai Khit       ..Tai Viet Vowel Ia
        (0x0aabe, 0x0aabf,),  # Tai Viet Vowel Am       ..Tai Viet Tone Mai Ek
        (0x0aac1, 0x0aac1,),  # Tai Viet Tone Mai Tho   ..Tai Viet Tone Mai Tho
        (0x0abe5, 0x0abe5,),  # Meetei Mayek Vowel Sign ..Meetei Mayek Vowel Sign
        (0x0abe8, 0x0abe8,),  # Meetei Mayek Vowel Sign ..Meetei Mayek Vowel Sign
        (0x0abed, 0x0abed,),  # Meetei Mayek Apun Iyek  ..Meetei Mayek Apun Iyek
        (0x0fb1e, 0x0fb1e,),  # Hebrew Point Judeo-spani..Hebrew Point Judeo-spani
        (0x0fe00, 0x0fe0f,),  # Variation Selector-1    ..Variation Selector-16
        (0x0fe20, 0x0fe26,),  # Combining Ligature Left ..Combining Conjoining Mac
        (0x101fd, 0x101fd,),  # Phaistos Disc Sign Combi..Phaistos Disc Sign Combi
        (0x10a01, 0x10a03,),  # Kharoshthi Vowel Sign I ..Kharoshthi Vowel Sign Vo
        (0x10a05, 0x10a06,),  # Kharoshthi Vowel Sign E ..Kharoshthi Vowel Sign O
        (0x10a0c, 0x10a0f,),  # Kharoshthi Vowel Length ..Kharoshthi Sign Visarga
        (0x10a38, 0x10a3a,),  # Kharoshthi Sign Bar Abov..Kharoshthi Sign Dot Belo
        (0x10a3f, 0x10a3f,),  # Kharoshthi Virama       ..Kharoshthi Virama
        (0x11080, 0x11081,),  # Kaithi Sign Candrabindu ..Kaithi Sign Anusvara
        (0x110b3, 0x110b6,),  # Kaithi Vowel Sign U     ..Kaithi Vowel Sign Ai
        (0x110b9, 0x110ba,),  # Kaithi Sign Virama      ..Kaithi Sign Nukta
        (0x1d167, 0x1d169,),  # Musical Symbol Combining..Musical Symbol Combining
        (0x1d17b, 0x1d182,),  # Musical Symbol Combining..Musical Symbol Combining
        (0x1d185, 0x1d18b,),  # Musical Symbol Combining..Musical Symbol Combining
        (0x1d1aa, 0x1d1ad,),  # Musical Symbol Combining..Musical Symbol Combining
        (0x1d242, 0x1d244,),  # Combining Greek Musical ..Combining Greek Musical
        (0xe0100, 0xe01ef,),  # Variation Selector-17   ..Variation Selector-256
    ),
    '6.0.0': (
        # Source: DerivedGeneralCategory-6.0.0.txt
        # Date:  2010-08-19, 00:48:09 GMT [MD]
        #
        (0x00300, 0x0036f,),  # Combining Grave Accent  ..Combining Latin Small Le
        (0x00483, 0x00489,),  # Combining Cyrillic Titlo..Combining Cyrillic Milli
        (0x00591, 0x005bd,),  # Hebrew Accent Etnahta   ..Hebrew Point Meteg
        (0x005bf, 0x005bf,),  # Hebrew Point Rafe       ..Hebrew Point Rafe
        (0x005c1, 0x005c2,),  # Hebrew Point Shin Dot   ..Hebrew Point Sin Dot
        (0x005c4, 0x005c5,),  # Hebrew Mark Upper Dot   ..Hebrew Mark Lower Dot
        (0x005c7, 0x005c7,),  # Hebrew Point Qamats Qata..Hebrew Point Qamats Qata
        (0x00610, 0x0061a,),  # Arabic Sign Sallallahou ..Arabic Small Kasra
        (0x0064b, 0x0065f,),  # Arabic Fathatan         ..Arabic Wavy Hamza Below
        (0x00670, 0x00670,),  # Arabic Letter Superscrip..Arabic Letter Superscrip
        (0x006d6, 0x006dc,),  # Arabic Small High Ligatu..Arabic Small High Seen
        (0x006df, 0x006e4,),  # Arabic Small High Rounde..Arabic Small High Madda
        (0x006e7, 0x006e8,),  # Arabic Small High Yeh   ..Arabic Small High Noon
        (0x006ea, 0x006ed,),  # Arabic Empty Centre Low ..Arabic Small Low Meem
        (0x00711, 0x00711,),  # Syriac Letter Superscrip..Syriac Letter Superscrip
        (0x00730, 0x0074a,),  # Syriac Pthaha Above     ..Syriac Barrekh
        (0x007a6, 0x007b0,),  # Thaana Abafili          ..Thaana Sukun
        (0x007eb, 0x007f3,),  # Nko Combining Short High..Nko Combining Double Dot
        (0x00816, 0x00819,),  # Samaritan Mark In       ..Samaritan Mark Dagesh
        (0x0081b, 0x00823,),  # Samaritan Mark Epentheti..Samaritan Vowel Sign A
        (0x00825, 0x00827,),  # Samaritan Vowel Sign Sho..Samaritan Vowel Sign U
        (0x00829, 0x0082d,),  # Samaritan Vowel Sign Lon..Samaritan Mark Nequdaa
        (0x00859, 0x0085b,),  # Mandaic Affrication Mark..Mandaic Gemination Mark
        (0x00900, 0x00902,),  # Devanagari Sign Inverted..Devanagari Sign Anusvara
        (0x0093a, 0x0093a,),  # Devanagari Vowel Sign Oe..Devanagari Vowel Sign Oe
        (0x0093c, 0x0093c,),  # Devanagari Sign Nukta   ..Devanagari Sign Nukta
        (0x00941, 0x00948,),  # Devanagari Vowel Sign U ..Devanagari Vowel Sign Ai
        (0x0094d, 0x0094d,),  # Devanagari Sign Virama  ..Devanagari Sign Virama
        (0x00951, 0x00957,),  # Devanagari Stress Sign U..Devanagari Vowel Sign Uu
        (0x00962, 0x00963,),  # Devanagari Vowel Sign Vo..Devanagari Vowel Sign Vo
        (0x00981, 0x00981,),  # Bengali Sign Candrabindu..Bengali Sign Candrabindu
        (0x009bc, 0x009bc,),  # Bengali Sign Nukta      ..Bengali Sign Nukta
        (0x009c1, 0x009c4,),  # Bengali Vowel Sign U    ..Bengali Vowel Sign Vocal
        (0x009cd, 0x009cd,),  # Bengali Sign Virama     ..Bengali Sign Virama
        (0x009e2, 0x009e3,),  # Bengali Vowel Sign Vocal..Bengali Vowel Sign Vocal
        (0x00a01, 0x00a02,),  # Gurmukhi Sign Adak Bindi..Gurmukhi Sign Bindi
        (0x00a3c, 0x00a3c,),  # Gurmukhi Sign Nukta     ..Gurmukhi Sign Nukta
        (0x00a41, 0x00a42,),  # Gurmukhi Vowel Sign U   ..Gurmukhi Vowel Sign Uu
        (0x00a47, 0x00a48,),  # Gurmukhi Vowel Sign Ee  ..Gurmukhi Vowel Sign Ai
        (0x00a4b, 0x00a4d,),  # Gurmukhi Vowel Sign Oo  ..Gurmukhi Sign Virama
        (0x00a51, 0x00a51,),  # Gurmukhi Sign Udaat     ..Gurmukhi Sign Udaat
        (0x00a70, 0x00a71,),  # Gurmukhi Tippi          ..Gurmukhi Addak
        (0x00a75, 0x00a75,),  # Gurmukhi Sign Yakash    ..Gurmukhi Sign Yakash
        (0x00a81, 0x00a82,),  # Gujarati Sign Candrabind..Gujarati Sign Anusvara
        (0x00abc, 0x00abc,),  # Gujarati Sign Nukta     ..Gujarati Sign Nukta
        (0x00ac1, 0x00ac5,),  # Gujarati Vowel Sign U   ..Gujarati Vowel Sign Cand
        (0x00ac7, 0x00ac8,),  # Gujarati Vowel Sign E   ..Gujarati Vowel Sign Ai
        (0x00acd, 0x00acd,),  # Gujarati Sign Virama    ..Gujarati Sign Virama
        (0x00ae2, 0x00ae3,),  # Gujarati Vowel Sign Voca..Gujarati Vowel Sign Voca
        (0x00b01, 0x00b01,),  # Oriya Sign Candrabindu  ..Oriya Sign Candrabindu
        (0x00b3c, 0x00b3c,),  # Oriya Sign Nukta        ..Oriya Sign Nukta
        (0x00b3f, 0x00b3f,),  # Oriya Vowel Sign I      ..Oriya Vowel Sign I
        (0x00b41, 0x00b44,),  # Oriya Vowel Sign U      ..Oriya Vowel Sign Vocalic
        (0x00b4d, 0x00b4d,),  # Oriya Sign Virama       ..Oriya Sign Virama
        (0x00b56, 0x00b56,),  # Oriya Ai Length Mark    ..Oriya Ai Length Mark
        (0x00b62, 0x00b63,),  # Oriya Vowel Sign Vocalic..Oriya Vowel Sign Vocalic
        (0x00b82, 0x00b82,),  # Tamil Sign Anusvara     ..Tamil Sign Anusvara
        (0x00bc0, 0x00bc0,),  # Tamil Vowel Sign Ii     ..Tamil Vowel Sign Ii
        (0x00bcd, 0x00bcd,),  # Tamil Sign Virama       ..Tamil Sign Virama
        (0x00c3e, 0x00c40,),  # Telugu Vowel Sign Aa    ..Telugu Vowel Sign Ii
        (0x00c46, 0x00c48,),  # Telugu Vowel Sign E     ..Telugu Vowel Sign Ai
        (0x00c4a, 0x00c4d,),  # Telugu Vowel Sign O     ..Telugu Sign Virama
        (0x00c55, 0x00c56,),  # Telugu Length Mark      ..Telugu Ai Length Mark
        (0x00c62, 0x00c63,),  # Telugu Vowel Sign Vocali..Telugu Vowel Sign Vocali
        (0x00cbc, 0x00cbc,),  # Kannada Sign Nukta      ..Kannada Sign Nukta
        (0x00cbf, 0x00cbf,),  # Kannada Vowel Sign I    ..Kannada Vowel Sign I
        (0x00cc6, 0x00cc6,),  # Kannada Vowel Sign E    ..Kannada Vowel Sign E
        (0x00ccc, 0x00ccd,),  # Kannada Vowel Sign Au   ..Kannada Sign Virama
        (0x00ce2, 0x00ce3,),  # Kannada Vowel Sign Vocal..Kannada Vowel Sign Vocal
        (0x00d41, 0x00d44,),  # Malayalam Vowel Sign U  ..Malayalam Vowel Sign Voc
        (0x00d4d, 0x00d4d,),  # Malayalam Sign Virama   ..Malayalam Sign Virama
        (0x00d62, 0x00d63,),  # Malayalam Vowel Sign Voc..Malayalam Vowel Sign Voc
        (0x00dca, 0x00dca,),  # Sinhala Sign Al-lakuna  ..Sinhala Sign Al-lakuna
        (0x00dd2, 0x00dd4,),  # Sinhala Vowel Sign Ketti..Sinhala Vowel Sign Ketti
        (0x00dd6, 0x00dd6,),  # Sinhala Vowel Sign Diga ..Sinhala Vowel Sign Diga
        (0x00e31, 0x00e31,),  # Thai Character Mai Han-a..Thai Character Mai Han-a
        (0x00e34, 0x00e3a,),  # Thai Character Sara I   ..Thai Character Phinthu
        (0x00e47, 0x00e4e,),  # Thai Character Maitaikhu..Thai Character Yamakkan
        (0x00eb1, 0x00eb1,),  # Lao Vowel Sign Mai Kan  ..Lao Vowel Sign Mai Kan
        (0x00eb4, 0x00eb9,),  # Lao Vowel Sign I        ..Lao Vowel Sign Uu
        (0x00ebb, 0x00ebc,),  # Lao Vowel Sign Mai Kon  ..Lao Semivowel Sign Lo
        (0x00ec8, 0x00ecd,),  # Lao Tone Mai Ek         ..Lao Niggahita
        (0x00f18, 0x00f19,),  # Tibetan Astrological Sig..Tibetan Astrological Sig
        (0x00f35, 0x00f35,),  # Tibetan Mark Ngas Bzung ..Tibetan Mark Ngas Bzung
        (0x00f37, 0x00f37,),  # Tibetan Mark Ngas Bzung ..Tibetan Mark Ngas Bzung
        (0x00f39, 0x00f39,),  # Tibetan Mark Tsa -phru  ..Tibetan Mark Tsa -phru
        (0x00f71, 0x00f7e,),  # Tibetan Vowel Sign Aa   ..Tibetan Sign Rjes Su Nga
        (0x00f80, 0x00f84,),  # Tibetan Vowel Sign Rever..Tibetan Mark Halanta
        (0x00f86, 0x00f87,),  # Tibetan Sign Lci Rtags  ..Tibetan Sign Yang Rtags
        (0x00f8d, 0x00f97,),  # Tibetan Subjoined Sign L..Tibetan Subjoined Letter
        (0x00f99, 0x00fbc,),  # Tibetan Subjoined Letter..Tibetan Subjoined Letter
        (0x00fc6, 0x00fc6,),  # Tibetan Symbol Padma Gda..Tibetan Symbol Padma Gda
        (0x0102d, 0x01030,),  # Myanmar Vowel Sign I    ..Myanmar Vowel Sign Uu
        (0x01032, 0x01037,),  # Myanmar Vowel Sign Ai   ..Myanmar Sign Dot Below
        (0x01039, 0x0103a,),  # Myanmar Sign Virama     ..Myanmar Sign Asat
        (0x0103d, 0x0103e,),  # Myanmar Consonant Sign M..Myanmar Consonant Sign M
        (0x01058, 0x01059,),  # Myanmar Vowel Sign Vocal..Myanmar Vowel Sign Vocal
        (0x0105e, 0x01060,),  # Myanmar Consonant Sign M..Myanmar Consonant Sign M
        (0x01071, 0x01074,),  # Myanmar Vowel Sign Geba ..Myanmar Vowel Sign Kayah
        (0x01082, 0x01082,),  # Myanmar Consonant Sign S..Myanmar Consonant Sign S
        (0x01085, 0x01086,),  # Myanmar Vowel Sign Shan ..Myanmar Vowel Sign Shan
        (0x0108d, 0x0108d,),  # Myanmar Sign Shan Counci..Myanmar Sign Shan Counci
        (0x0109d, 0x0109d,),  # Myanmar Vowel Sign Aiton..Myanmar Vowel Sign Aiton
        (0x0135d, 0x0135f,),  # Ethiopic Combining Gemin..Ethiopic Combining Gemin
        (0x01712, 0x01714,),  # Tagalog Vowel Sign I    ..Tagalog Sign Virama
        (0x01732, 0x01734,),  # Hanunoo Vowel Sign I    ..Hanunoo Sign Pamudpod
        (0x01752, 0x01753,),  # Buhid Vowel Sign I      ..Buhid Vowel Sign U
        (0x01772, 0x01773,),  # Tagbanwa Vowel Sign I   ..Tagbanwa Vowel Sign U
        (0x017b7, 0x017bd,),  # Khmer Vowel Sign I      ..Khmer Vowel Sign Ua
        (0x017c6, 0x017c6,),  # Khmer Sign Nikahit      ..Khmer Sign Nikahit
        (0x017c9, 0x017d3,),  # Khmer Sign Muusikatoan  ..Khmer Sign Bathamasat
        (0x017dd, 0x017dd,),  # Khmer Sign Atthacan     ..Khmer Sign Atthacan
        (0x0180b, 0x0180d,),  # Mongolian Free Variation..Mongolian Free Variation
        (0x018a9, 0x018a9,),  # Mongolian Letter Ali Gal..Mongolian Letter Ali Gal
        (0x01920, 0x01922,),  # Limbu Vowel Sign A      ..Limbu Vowel Sign U
        (0x01927, 0x01928,),  # Limbu Vowel Sign E      ..Limbu Vowel Sign O
        (0x01932, 0x01932,),  # Limbu Small Letter Anusv..Limbu Small Letter Anusv
        (0x01939, 0x0193b,),  # Limbu Sign Mukphreng    ..Limbu Sign Sa-i
        (0x01a17, 0x01a18,),  # Buginese Vowel Sign I   ..Buginese Vowel Sign U
        (0x01a56, 0x01a56,),  # Tai Tham Consonant Sign ..Tai Tham Consonant Sign
        (0x01a58, 0x01a5e,),  # Tai Tham Sign Mai Kang L..Tai Tham Consonant Sign
        (0x01a60, 0x01a60,),  # Tai Tham Sign Sakot     ..Tai Tham Sign Sakot
        (0x01a62, 0x01a62,),  # Tai Tham Vowel Sign Mai ..Tai Tham Vowel Sign Mai
        (0x01a65, 0x01a6c,),  # Tai Tham Vowel Sign I   ..Tai Tham Vowel Sign Oa B
        (0x01a73, 0x01a7c,),  # Tai Tham Vowel Sign Oa A..Tai Tham Sign Khuen-lue
        (0x01a7f, 0x01a7f,),  # Tai Tham Combining Crypt..Tai Tham Combining Crypt
        (0x01b00, 0x01b03,),  # Balinese Sign Ulu Ricem ..Balinese Sign Surang
        (0x01b34, 0x01b34,),  # Balinese Sign Rerekan   ..Balinese Sign Rerekan
        (0x01b36, 0x01b3a,),  # Balinese Vowel Sign Ulu ..Balinese Vowel Sign Ra R
        (0x01b3c, 0x01b3c,),  # Balinese Vowel Sign La L..Balinese Vowel Sign La L
        (0x01b42, 0x01b42,),  # Balinese Vowel Sign Pepe..Balinese Vowel Sign Pepe
        (0x01b6b, 0x01b73,),  # Balinese Musical Symbol ..Balinese Musical Symbol
        (0x01b80, 0x01b81,),  # Sundanese Sign Panyecek ..Sundanese Sign Panglayar
        (0x01ba2, 0x01ba5,),  # Sundanese Consonant Sign..Sundanese Vowel Sign Pan
        (0x01ba8, 0x01ba9,),  # Sundanese Vowel Sign Pam..Sundanese Vowel Sign Pan
        (0x01be6, 0x01be6,),  # Batak Sign Tompi        ..Batak Sign Tompi
        (0x01be8, 0x01be9,),  # Batak Vowel Sign Pakpak ..Batak Vowel Sign Ee
        (0x01bed, 0x01bed,),  # Batak Vowel Sign Karo O ..Batak Vowel Sign Karo O
        (0x01bef, 0x01bf1,),  # Batak Vowel Sign U For S..Batak Consonant Sign H
        (0x01c2c, 0x01c33,),  # Lepcha Vowel Sign E     ..Lepcha Consonant Sign T
        (0x01c36, 0x01c37,),  # Lepcha Sign Ran         ..Lepcha Sign Nukta
        (0x01cd0, 0x01cd2,),  # Vedic Tone Karshana     ..Vedic Tone Prenkha
        (0x01cd4, 0x01ce0,),  # Vedic Sign Yajurvedic Mi..Vedic Tone Rigvedic Kash
        (0x01ce2, 0x01ce8,),  # Vedic Sign Visarga Svari..Vedic Sign Visarga Anuda
        (0x01ced, 0x01ced,),  # Vedic Sign Tiryak       ..Vedic Sign Tiryak
        (0x01dc0, 0x01de6,),  # Combining Dotted Grave A..Combining Latin Small Le
        (0x01dfc, 0x01dff,),  # Combining Double Inverte..Combining Right Arrowhea
        (0x020d0, 0x020f0,),  # Combining Left Harpoon A..Combining Asterisk Above
        (0x02cef, 0x02cf1,),  # Coptic Combining Ni Abov..Coptic Combining Spiritu
        (0x02d7f, 0x02d7f,),  # Tifinagh Consonant Joine..Tifinagh Consonant Joine
        (0x02de0, 0x02dff,),  # Combining Cyrillic Lette..Combining Cyrillic Lette
        (0x0302a, 0x0302f,),  # Ideographic Level Tone M..Hangul Double Dot Tone M
        (0x03099, 0x0309a,),  # Combining Katakana-hirag..Combining Katakana-hirag
        (0x0a66f, 0x0a672,),  # Combining Cyrillic Vzmet..Combining Cyrillic Thous
        (0x0a67c, 0x0a67d,),  # Combining Cyrillic Kavyk..Combining Cyrillic Payer
        (0x0a6f0, 0x0a6f1,),  # Bamum Combining Mark Koq..Bamum Combining Mark Tuk
        (0x0a802, 0x0a802,),  # Syloti Nagri Sign Dvisva..Syloti Nagri Sign Dvisva
        (0x0a806, 0x0a806,),  # Syloti Nagri Sign Hasant..Syloti Nagri Sign Hasant
        (0x0a80b, 0x0a80b,),  # Syloti Nagri Sign Anusva..Syloti Nagri Sign Anusva
        (0x0a825, 0x0a826,),  # Syloti Nagri Vowel Sign ..Syloti Nagri Vowel Sign
        (0x0a8c4, 0x0a8c4,),  # Saurashtra Sign Virama  ..Saurashtra Sign Virama
        (0x0a8e0, 0x0a8f1,),  # Combining Devanagari Dig..Combining Devanagari Sig
        (0x0a926, 0x0a92d,),  # Kayah Li Vowel Ue       ..Kayah Li Tone Calya Plop
        (0x0a947, 0x0a951,),  # Rejang Vowel Sign I     ..Rejang Consonant Sign R
        (0x0a980, 0x0a982,),  # Javanese Sign Panyangga ..Javanese Sign Layar
        (0x0a9b3, 0x0a9b3,),  # Javanese Sign Cecak Telu..Javanese Sign Cecak Telu
        (0x0a9b6, 0x0a9b9,),  # Javanese Vowel Sign Wulu..Javanese Vowel Sign Suku
        (0x0a9bc, 0x0a9bc,),  # Javanese Vowel Sign Pepe..Javanese Vowel Sign Pepe
        (0x0aa29, 0x0aa2e,),  # Cham Vowel Sign Aa      ..Cham Vowel Sign Oe
        (0x0aa31, 0x0aa32,),  # Cham Vowel Sign Au      ..Cham Vowel Sign Ue
        (0x0aa35, 0x0aa36,),  # Cham Consonant Sign La  ..Cham Consonant Sign Wa
        (0x0aa43, 0x0aa43,),  # Cham Consonant Sign Fina..Cham Consonant Sign Fina
        (0x0aa4c, 0x0aa4c,),  # Cham Consonant Sign Fina..Cham Consonant Sign Fina
        (0x0aab0, 0x0aab0,),  # Tai Viet Mai Kang       ..Tai Viet Mai Kang
        (0x0aab2, 0x0aab4,),  # Tai Viet Vowel I        ..Tai Viet Vowel U
        (0x0aab7, 0x0aab8,),  # Tai Viet Mai Khit       ..Tai Viet Vowel Ia
        (0x0aabe, 0x0aabf,),  # Tai Viet Vowel Am       ..Tai Viet Tone Mai Ek
        (0x0aac1, 0x0aac1,),  # Tai Viet Tone Mai Tho   ..Tai Viet Tone Mai Tho
        (0x0abe5, 0x0abe5,),  # Meetei Mayek Vowel Sign ..Meetei Mayek Vowel Sign
        (0x0abe8, 0x0abe8,),  # Meetei Mayek Vowel Sign ..Meetei Mayek Vowel Sign
        (0x0abed, 0x0abed,),  # Meetei Mayek Apun Iyek  ..Meetei Mayek Apun Iyek
        (0x0fb1e, 0x0fb1e,),  # Hebrew Point Judeo-spani..Hebrew Point Judeo-spani
        (0x0fe00, 0x0fe0f,),  # Variation Selector-1    ..Variation Selector-16
        (0x0fe20, 0x0fe26,),  # Combining Ligature Left ..Combining Conjoining Mac
        (0x101fd, 0x101fd,),  # Phaistos Disc Sign Combi..Phaistos Disc Sign Combi
        (0x10a01, 0x10a03,),  # Kharoshthi Vowel Sign I ..Kharoshthi Vowel Sign Vo
        (0x10a05, 0x10a06,),  # Kharoshthi Vowel Sign E ..Kharoshthi Vowel Sign O
        (0x10a0c, 0x10a0f,),  # Kharoshthi Vowel Length ..Kharoshthi Sign Visarga
        (0x10a38, 0x10a3a,),  # Kharoshthi Sign Bar Abov..Kharoshthi Sign Dot Belo
        (0x10a3f, 0x10a3f,),  # Kharoshthi Virama       ..Kharoshthi Virama
        (0x11001, 0x11001,),  # Brahmi Sign Anusvara    ..Brahmi Sign Anusvara
        (0x11038, 0x11046,),  # Brahmi Vowel Sign Aa    ..Brahmi Virama
        (0x11080, 0x11081,),  # Kaithi Sign Candrabindu ..Kaithi Sign Anusvara
        (0x110b3, 0x110b6,),  # Kaithi Vowel Sign U     ..Kaithi Vowel Sign Ai
        (0x110b9, 0x110ba,),  # Kaithi Sign Virama      ..Kaithi Sign Nukta
        (0x1d167, 0x1d169,),  # Musical Symbol Combining..Musical Symbol Combining
        (0x1d17b, 0x1d182,),  # Musical Symbol Combining..Musical Symbol Combining
        (0x1d185, 0x1d18b,),  # Musical Symbol Combining..Musical Symbol Combining
        (0x1d1aa, 0x1d1ad,),  # Musical Symbol Combining..Musical Symbol Combining
        (0x1d242, 0x1d244,),  # Combining Greek Musical ..Combining Greek Musical
        (0xe0100, 0xe01ef,),  # Variation Selector-17   ..Variation Selector-256
    ),
    '6.1.0': (
        # Source: DerivedGeneralCategory-6.1.0.txt
        # Date:  2011-11-27, 05:10:22 GMT [MD]
        #
        (0x00300, 0x0036f,),  # Combining Grave Accent  ..Combining Latin Small Le
        (0x00483, 0x00489,),  # Combining Cyrillic Titlo..Combining Cyrillic Milli
        (0x00591, 0x005bd,),  # Hebrew Accent Etnahta   ..Hebrew Point Meteg
        (0x005bf, 0x005bf,),  # Hebrew Point Rafe       ..Hebrew Point Rafe
        (0x005c1, 0x005c2,),  # Hebrew Point Shin Dot   ..Hebrew Point Sin Dot
        (0x005c4, 0x005c5,),  # Hebrew Mark Upper Dot   ..Hebrew Mark Lower Dot
        (0x005c7, 0x005c7,),  # Hebrew Point Qamats Qata..Hebrew Point Qamats Qata
        (0x00610, 0x0061a,),  # Arabic Sign Sallallahou ..Arabic Small Kasra
        (0x0064b, 0x0065f,),  # Arabic Fathatan         ..Arabic Wavy Hamza Below
        (0x00670, 0x00670,),  # Arabic Letter Superscrip..Arabic Letter Superscrip
        (0x006d6, 0x006dc,),  # Arabic Small High Ligatu..Arabic Small High Seen
        (0x006df, 0x006e4,),  # Arabic Small High Rounde..Arabic Small High Madda
        (0x006e7, 0x006e8,),  # Arabic Small High Yeh   ..Arabic Small High Noon
        (0x006ea, 0x006ed,),  # Arabic Empty Centre Low ..Arabic Small Low Meem
        (0x00711, 0x00711,),  # Syriac Letter Superscrip..Syriac Letter Superscrip
        (0x00730, 0x0074a,),  # Syriac Pthaha Above     ..Syriac Barrekh
        (0x007a6, 0x007b0,),  # Thaana Abafili          ..Thaana Sukun
        (0x007eb, 0x007f3,),  # Nko Combining Short High..Nko Combining Double Dot
        (0x00816, 0x00819,),  # Samaritan Mark In       ..Samaritan Mark Dagesh
        (0x0081b, 0x00823,),  # Samaritan Mark Epentheti..Samaritan Vowel Sign A
        (0x00825, 0x00827,),  # Samaritan Vowel Sign Sho..Samaritan Vowel Sign U
        (0x00829, 0x0082d,),  # Samaritan Vowel Sign Lon..Samaritan Mark Nequdaa
        (0x00859, 0x0085b,),  # Mandaic Affrication Mark..Mandaic Gemination Mark
        (0x008e4, 0x008fe,),  # Arabic Curly Fatha      ..Arabic Damma With Dot
        (0x00900, 0x00902,),  # Devanagari Sign Inverted..Devanagari Sign Anusvara
        (0x0093a, 0x0093a,),  # Devanagari Vowel Sign Oe..Devanagari Vowel Sign Oe
        (0x0093c, 0x0093c,),  # Devanagari Sign Nukta   ..Devanagari Sign Nukta
        (0x00941, 0x00948,),  # Devanagari Vowel Sign U ..Devanagari Vowel Sign Ai
        (0x0094d, 0x0094d,),  # Devanagari Sign Virama  ..Devanagari Sign Virama
        (0x00951, 0x00957,),  # Devanagari Stress Sign U..Devanagari Vowel Sign Uu
        (0x00962, 0x00963,),  # Devanagari Vowel Sign Vo..Devanagari Vowel Sign Vo
        (0x00981, 0x00981,),  # Bengali Sign Candrabindu..Bengali Sign Candrabindu
        (0x009bc, 0x009bc,),  # Bengali Sign Nukta      ..Bengali Sign Nukta
        (0x009c1, 0x009c4,),  # Bengali Vowel Sign U    ..Bengali Vowel Sign Vocal
        (0x009cd, 0x009cd,),  # Bengali Sign Virama     ..Bengali Sign Virama
        (0x009e2, 0x009e3,),  # Bengali Vowel Sign Vocal..Bengali Vowel Sign Vocal
        (0x00a01, 0x00a02,),  # Gurmukhi Sign Adak Bindi..Gurmukhi Sign Bindi
        (0x00a3c, 0x00a3c,),  # Gurmukhi Sign Nukta     ..Gurmukhi Sign Nukta
        (0x00a41, 0x00a42,),  # Gurmukhi Vowel Sign U   ..Gurmukhi Vowel Sign Uu
        (0x00a47, 0x00a48,),  # Gurmukhi Vowel Sign Ee  ..Gurmukhi Vowel Sign Ai
        (0x00a4b, 0x00a4d,),  # Gurmukhi Vowel Sign Oo  ..Gurmukhi Sign Virama
        (0x00a51, 0x00a51,),  # Gurmukhi Sign Udaat     ..Gurmukhi Sign Udaat
        (0x00a70, 0x00a71,),  # Gurmukhi Tippi          ..Gurmukhi Addak
        (0x00a75, 0x00a75,),  # Gurmukhi Sign Yakash    ..Gurmukhi Sign Yakash
        (0x00a81, 0x00a82,),  # Gujarati Sign Candrabind..Gujarati Sign Anusvara
        (0x00abc, 0x00abc,),  # Gujarati Sign Nukta     ..Gujarati Sign Nukta
        (0x00ac1, 0x00ac5,),  # Gujarati Vowel Sign U   ..Gujarati Vowel Sign Cand
        (0x00ac7, 0x00ac8,),  # Gujarati Vowel Sign E   ..Gujarati Vowel Sign Ai
        (0x00acd, 0x00acd,),  # Gujarati Sign Virama    ..Gujarati Sign Virama
        (0x00ae2, 0x00ae3,),  # Gujarati Vowel Sign Voca..Gujarati Vowel Sign Voca
        (0x00b01, 0x00b01,),  # Oriya Sign Candrabindu  ..Oriya Sign Candrabindu
        (0x00b3c, 0x00b3c,),  # Oriya Sign Nukta        ..Oriya Sign Nukta
        (0x00b3f, 0x00b3f,),  # Oriya Vowel Sign I      ..Oriya Vowel Sign I
        (0x00b41, 0x00b44,),  # Oriya Vowel Sign U      ..Oriya Vowel Sign Vocalic
        (0x00b4d, 0x00b4d,),  # Oriya Sign Virama       ..Oriya Sign Virama
        (0x00b56, 0x00b56,),  # Oriya Ai Length Mark    ..Oriya Ai Length Mark
        (0x00b62, 0x00b63,),  # Oriya Vowel Sign Vocalic..Oriya Vowel Sign Vocalic
        (0x00b82, 0x00b82,),  # Tamil Sign Anusvara     ..Tamil Sign Anusvara
        (0x00bc0, 0x00bc0,),  # Tamil Vowel Sign Ii     ..Tamil Vowel Sign Ii
        (0x00bcd, 0x00bcd,),  # Tamil Sign Virama       ..Tamil Sign Virama
        (0x00c3e, 0x00c40,),  # Telugu Vowel Sign Aa    ..Telugu Vowel Sign Ii
        (0x00c46, 0x00c48,),  # Telugu Vowel Sign E     ..Telugu Vowel Sign Ai
        (0x00c4a, 0x00c4d,),  # Telugu Vowel Sign O     ..Telugu Sign Virama
        (0x00c55, 0x00c56,),  # Telugu Length Mark      ..Telugu Ai Length Mark
        (0x00c62, 0x00c63,),  # Telugu Vowel Sign Vocali..Telugu Vowel Sign Vocali
        (0x00cbc, 0x00cbc,),  # Kannada Sign Nukta      ..Kannada Sign Nukta
        (0x00cbf, 0x00cbf,),  # Kannada Vowel Sign I    ..Kannada Vowel Sign I
        (0x00cc6, 0x00cc6,),  # Kannada Vowel Sign E    ..Kannada Vowel Sign E
        (0x00ccc, 0x00ccd,),  # Kannada Vowel Sign Au   ..Kannada Sign Virama
        (0x00ce2, 0x00ce3,),  # Kannada Vowel Sign Vocal..Kannada Vowel Sign Vocal
        (0x00d41, 0x00d44,),  # Malayalam Vowel Sign U  ..Malayalam Vowel Sign Voc
        (0x00d4d, 0x00d4d,),  # Malayalam Sign Virama   ..Malayalam Sign Virama
        (0x00d62, 0x00d63,),  # Malayalam Vowel Sign Voc..Malayalam Vowel Sign Voc
        (0x00dca, 0x00dca,),  # Sinhala Sign Al-lakuna  ..Sinhala Sign Al-lakuna
        (0x00dd2, 0x00dd4,),  # Sinhala Vowel Sign Ketti..Sinhala Vowel Sign Ketti
        (0x00dd6, 0x00dd6,),  # Sinhala Vowel Sign Diga ..Sinhala Vowel Sign Diga
        (0x00e31, 0x00e31,),  # Thai Character Mai Han-a..Thai Character Mai Han-a
        (0x00e34, 0x00e3a,),  # Thai Character Sara I   ..Thai Character Phinthu
        (0x00e47, 0x00e4e,),  # Thai Character Maitaikhu..Thai Character Yamakkan
        (0x00eb1, 0x00eb1,),  # Lao Vowel Sign Mai Kan  ..Lao Vowel Sign Mai Kan
        (0x00eb4, 0x00eb9,),  # Lao Vowel Sign I        ..Lao Vowel Sign Uu
        (0x00ebb, 0x00ebc,),  # Lao Vowel Sign Mai Kon  ..Lao Semivowel Sign Lo
        (0x00ec8, 0x00ecd,),  # Lao Tone Mai Ek         ..Lao Niggahita
        (0x00f18, 0x00f19,),  # Tibetan Astrological Sig..Tibetan Astrological Sig
        (0x00f35, 0x00f35,),  # Tibetan Mark Ngas Bzung ..Tibetan Mark Ngas Bzung
        (0x00f37, 0x00f37,),  # Tibetan Mark Ngas Bzung ..Tibetan Mark Ngas Bzung
        (0x00f39, 0x00f39,),  # Tibetan Mark Tsa -phru  ..Tibetan Mark Tsa -phru
        (0x00f71, 0x00f7e,),  # Tibetan Vowel Sign Aa   ..Tibetan Sign Rjes Su Nga
        (0x00f80, 0x00f84,),  # Tibetan Vowel Sign Rever..Tibetan Mark Halanta
        (0x00f86, 0x00f87,),  # Tibetan Sign Lci Rtags  ..Tibetan Sign Yang Rtags
        (0x00f8d, 0x00f97,),  # Tibetan Subjoined Sign L..Tibetan Subjoined Letter
        (0x00f99, 0x00fbc,),  # Tibetan Subjoined Letter..Tibetan Subjoined Letter
        (0x00fc6, 0x00fc6,),  # Tibetan Symbol Padma Gda..Tibetan Symbol Padma Gda
        (0x0102d, 0x01030,),  # Myanmar Vowel Sign I    ..Myanmar Vowel Sign Uu
        (0x01032, 0x01037,),  # Myanmar Vowel Sign Ai   ..Myanmar Sign Dot Below
        (0x01039, 0x0103a,),  # Myanmar Sign Virama     ..Myanmar Sign Asat
        (0x0103d, 0x0103e,),  # Myanmar Consonant Sign M..Myanmar Consonant Sign M
        (0x01058, 0x01059,),  # Myanmar Vowel Sign Vocal..Myanmar Vowel Sign Vocal
        (0x0105e, 0x01060,),  # Myanmar Consonant Sign M..Myanmar Consonant Sign M
        (0x01071, 0x01074,),  # Myanmar Vowel Sign Geba ..Myanmar Vowel Sign Kayah
        (0x01082, 0x01082,),  # Myanmar Consonant Sign S..Myanmar Consonant Sign S
        (0x01085, 0x01086,),  # Myanmar Vowel Sign Shan ..Myanmar Vowel Sign Shan
        (0x0108d, 0x0108d,),  # Myanmar Sign Shan Counci..Myanmar Sign Shan Counci
        (0x0109d, 0x0109d,),  # Myanmar Vowel Sign Aiton..Myanmar Vowel Sign Aiton
        (0x0135d, 0x0135f,),  # Ethiopic Combining Gemin..Ethiopic Combining Gemin
        (0x01712, 0x01714,),  # Tagalog Vowel Sign I    ..Tagalog Sign Virama
        (0x01732, 0x01734,),  # Hanunoo Vowel Sign I    ..Hanunoo Sign Pamudpod
        (0x01752, 0x01753,),  # Buhid Vowel Sign I      ..Buhid Vowel Sign U
        (0x01772, 0x01773,),  # Tagbanwa Vowel Sign I   ..Tagbanwa Vowel Sign U
        (0x017b4, 0x017b5,),  # Khmer Vowel Inherent Aq ..Khmer Vowel Inherent Aa
        (0x017b7, 0x017bd,),  # Khmer Vowel Sign I      ..Khmer Vowel Sign Ua
        (0x017c6, 0x017c6,),  # Khmer Sign Nikahit      ..Khmer Sign Nikahit
        (0x017c9, 0x017d3,),  # Khmer Sign Muusikatoan  ..Khmer Sign Bathamasat
        (0x017dd, 0x017dd,),  # Khmer Sign Atthacan     ..Khmer Sign Atthacan
        (0x0180b, 0x0180d,),  # Mongolian Free Variation..Mongolian Free Variation
        (0x018a9, 0x018a9,),  # Mongolian Letter Ali Gal..Mongolian Letter Ali Gal
        (0x01920, 0x01922,),  # Limbu Vowel Sign A      ..Limbu Vowel Sign U
        (0x01927, 0x01928,),  # Limbu Vowel Sign E      ..Limbu Vowel Sign O
        (0x01932, 0x01932,),  # Limbu Small Letter Anusv..Limbu Small Letter Anusv
        (0x01939, 0x0193b,),  # Limbu Sign Mukphreng    ..Limbu Sign Sa-i
        (0x01a17, 0x01a18,),  # Buginese Vowel Sign I   ..Buginese Vowel Sign U
        (0x01a56, 0x01a56,),  # Tai Tham Consonant Sign ..Tai Tham Consonant Sign
        (0x01a58, 0x01a5e,),  # Tai Tham Sign Mai Kang L..Tai Tham Consonant Sign
        (0x01a60, 0x01a60,),  # Tai Tham Sign Sakot     ..Tai Tham Sign Sakot
        (0x01a62, 0x01a62,),  # Tai Tham Vowel Sign Mai ..Tai Tham Vowel Sign Mai
        (0x01a65, 0x01a6c,),  # Tai Tham Vowel Sign I   ..Tai Tham Vowel Sign Oa B
        (0x01a73, 0x01a7c,),  # Tai Tham Vowel Sign Oa A..Tai Tham Sign Khuen-lue
        (0x01a7f, 0x01a7f,),  # Tai Tham Combining Crypt..Tai Tham Combining Crypt
        (0x01b00, 0x01b03,),  # Balinese Sign Ulu Ricem ..Balinese Sign Surang
        (0x01b34, 0x01b34,),  # Balinese Sign Rerekan   ..Balinese Sign Rerekan
        (0x01b36, 0x01b3a,),  # Balinese Vowel Sign Ulu ..Balinese Vowel Sign Ra R
        (0x01b3c, 0x01b3c,),  # Balinese Vowel Sign La L..Balinese Vowel Sign La L
        (0x01b42, 0x01b42,),  # Balinese Vowel Sign Pepe..Balinese Vowel Sign Pepe
        (0x01b6b, 0x01b73,),  # Balinese Musical Symbol ..Balinese Musical Symbol
        (0x01b80, 0x01b81,),  # Sundanese Sign Panyecek ..Sundanese Sign Panglayar
        (0x01ba2, 0x01ba5,),  # Sundanese Consonant Sign..Sundanese Vowel Sign Pan
        (0x01ba8, 0x01ba9,),  # Sundanese Vowel Sign Pam..Sundanese Vowel Sign Pan
        (0x01bab, 0x01bab,),  # Sundanese Sign Virama   ..Sundanese Sign Virama
        (0x01be6, 0x01be6,),  # Batak Sign Tompi        ..Batak Sign Tompi
        (0x01be8, 0x01be9,),  # Batak Vowel Sign Pakpak ..Batak Vowel Sign Ee
        (0x01bed, 0x01bed,),  # Batak Vowel Sign Karo O ..Batak Vowel Sign Karo O
        (0x01bef, 0x01bf1,),  # Batak Vowel Sign U For S..Batak Consonant Sign H
        (0x01c2c, 0x01c33,),  # Lepcha Vowel Sign E     ..Lepcha Consonant Sign T
        (0x01c36, 0x01c37,),  # Lepcha Sign Ran         ..Lepcha Sign Nukta
        (0x01cd0, 0x01cd2,),  # Vedic Tone Karshana     ..Vedic Tone Prenkha
        (0x01cd4, 0x01ce0,),  # Vedic Sign Yajurvedic Mi..Vedic Tone Rigvedic Kash
        (0x01ce2, 0x01ce8,),  # Vedic Sign Visarga Svari..Vedic Sign Visarga Anuda
        (0x01ced, 0x01ced,),  # Vedic Sign Tiryak       ..Vedic Sign Tiryak
        (0x01cf4, 0x01cf4,),  # Vedic Tone Candra Above ..Vedic Tone Candra Above
        (0x01dc0, 0x01de6,),  # Combining Dotted Grave A..Combining Latin Small Le
        (0x01dfc, 0x01dff,),  # Combining Double Inverte..Combining Right Arrowhea
        (0x020d0, 0x020f0,),  # Combining Left Harpoon A..Combining Asterisk Above
        (0x02cef, 0x02cf1,),  # Coptic Combining Ni Abov..Coptic Combining Spiritu
        (0x02d7f, 0x02d7f,),  # Tifinagh Consonant Joine..Tifinagh Consonant Joine
        (0x02de0, 0x02dff,),  # Combining Cyrillic Lette..Combining Cyrillic Lette
        (0x0302a, 0x0302d,),  # Ideographic Level Tone M..Ideographic Entering Ton
        (0x03099, 0x0309a,),  # Combining Katakana-hirag..Combining Katakana-hirag
        (0x0a66f, 0x0a672,),  # Combining Cyrillic Vzmet..Combining Cyrillic Thous
        (0x0a674, 0x0a67d,),  # Combining Cyrillic Lette..Combining Cyrillic Payer
        (0x0a69f, 0x0a69f,),  # Combining Cyrillic Lette..Combining Cyrillic Lette
        (0x0a6f0, 0x0a6f1,),  # Bamum Combining Mark Koq..Bamum Combining Mark Tuk
        (0x0a802, 0x0a802,),  # Syloti Nagri Sign Dvisva..Syloti Nagri Sign Dvisva
        (0x0a806, 0x0a806,),  # Syloti Nagri Sign Hasant..Syloti Nagri Sign Hasant
        (0x0a80b, 0x0a80b,),  # Syloti Nagri Sign Anusva..Syloti Nagri Sign Anusva
        (0x0a825, 0x0a826,),  # Syloti Nagri Vowel Sign ..Syloti Nagri Vowel Sign
        (0x0a8c4, 0x0a8c4,),  # Saurashtra Sign Virama  ..Saurashtra Sign Virama
        (0x0a8e0, 0x0a8f1,),  # Combining Devanagari Dig..Combining Devanagari Sig
        (0x0a926, 0x0a92d,),  # Kayah Li Vowel Ue       ..Kayah Li Tone Calya Plop
        (0x0a947, 0x0a951,),  # Rejang Vowel Sign I     ..Rejang Consonant Sign R
        (0x0a980, 0x0a982,),  # Javanese Sign Panyangga ..Javanese Sign Layar
        (0x0a9b3, 0x0a9b3,),  # Javanese Sign Cecak Telu..Javanese Sign Cecak Telu
        (0x0a9b6, 0x0a9b9,),  # Javanese Vowel Sign Wulu..Javanese Vowel Sign Suku
        (0x0a9bc, 0x0a9bc,),  # Javanese Vowel Sign Pepe..Javanese Vowel Sign Pepe
        (0x0aa29, 0x0aa2e,),  # Cham Vowel Sign Aa      ..Cham Vowel Sign Oe
        (0x0aa31, 0x0aa32,),  # Cham Vowel Sign Au      ..Cham Vowel Sign Ue
        (0x0aa35, 0x0aa36,),  # Cham Consonant Sign La  ..Cham Consonant Sign Wa
        (0x0aa43, 0x0aa43,),  # Cham Consonant Sign Fina..Cham Consonant Sign Fina
        (0x0aa4c, 0x0aa4c,),  # Cham Consonant Sign Fina..Cham Consonant Sign Fina
        (0x0aab0, 0x0aab0,),  # Tai Viet Mai Kang       ..Tai Viet Mai Kang
        (0x0aab2, 0x0aab4,),  # Tai Viet Vowel I        ..Tai Viet Vowel U
        (0x0aab7, 0x0aab8,),  # Tai Viet Mai Khit       ..Tai Viet Vowel Ia
        (0x0aabe, 0x0aabf,),  # Tai Viet Vowel Am       ..Tai Viet Tone Mai Ek
        (0x0aac1, 0x0aac1,),  # Tai Viet Tone Mai Tho   ..Tai Viet Tone Mai Tho
        (0x0aaec, 0x0aaed,),  # Meetei Mayek Vowel Sign ..Meetei Mayek Vowel Sign
        (0x0aaf6, 0x0aaf6,),  # Meetei Mayek Virama     ..Meetei Mayek Virama
        (0x0abe5, 0x0abe5,),  # Meetei Mayek Vowel Sign ..Meetei Mayek Vowel Sign
        (0x0abe8, 0x0abe8,),  # Meetei Mayek Vowel Sign ..Meetei Mayek Vowel Sign
        (0x0abed, 0x0abed,),  # Meetei Mayek Apun Iyek  ..Meetei Mayek Apun Iyek
        (0x0fb1e, 0x0fb1e,),  # Hebrew Point Judeo-spani..Hebrew Point Judeo-spani
        (0x0fe00, 0x0fe0f,),  # Variation Selector-1    ..Variation Selector-16
        (0x0fe20, 0x0fe26,),  # Combining Ligature Left ..Combining Conjoining Mac
        (0x101fd, 0x101fd,),  # Phaistos Disc Sign Combi..Phaistos Disc Sign Combi
        (0x10a01, 0x10a03,),  # Kharoshthi Vowel Sign I ..Kharoshthi Vowel Sign Vo
        (0x10a05, 0x10a06,),  # Kharoshthi Vowel Sign E ..Kharoshthi Vowel Sign O
        (0x10a0c, 0x10a0f,),  # Kharoshthi Vowel Length ..Kharoshthi Sign Visarga
        (0x10a38, 0x10a3a,),  # Kharoshthi Sign Bar Abov..Kharoshthi Sign Dot Belo
        (0x10a3f, 0x10a3f,),  # Kharoshthi Virama       ..Kharoshthi Virama
        (0x11001, 0x11001,),  # Brahmi Sign Anusvara    ..Brahmi Sign Anusvara
        (0x11038, 0x11046,),  # Brahmi Vowel Sign Aa    ..Brahmi Virama
        (0x11080, 0x11081,),  # Kaithi Sign Candrabindu ..Kaithi Sign Anusvara
        (0x110b3, 0x110b6,),  # Kaithi Vowel Sign U     ..Kaithi Vowel Sign Ai
        (0x110b9, 0x110ba,),  # Kaithi Sign Virama      ..Kaithi Sign Nukta
        (0x11100, 0x11102,),  # Chakma Sign Candrabindu ..Chakma Sign Visarga
        (0x11127, 0x1112b,),  # Chakma Vowel Sign A     ..Chakma Vowel Sign Uu
        (0x1112d, 0x11134,),  # Chakma Vowel Sign Ai    ..Chakma Maayyaa
        (0x11180, 0x11181,),  # Sharada Sign Candrabindu..Sharada Sign Anusvara
        (0x111b6, 0x111be,),  # Sharada Vowel Sign U    ..Sharada Vowel Sign O
        (0x116ab, 0x116ab,),  # Takri Sign Anusvara     ..Takri Sign Anusvara
        (0x116ad, 0x116ad,),  # Takri Vowel Sign Aa     ..Takri Vowel Sign Aa
        (0x116b0, 0x116b5,),  # Takri Vowel Sign U      ..Takri Vowel Sign Au
        (0x116b7, 0x116b7,),  # Takri Sign Nukta        ..Takri Sign Nukta
        (0x16f8f, 0x16f92,),  # Miao Tone Right         ..Miao Tone Below
        (0x1d167, 0x1d169,),  # Musical Symbol Combining..Musical Symbol Combining
        (0x1d17b, 0x1d182,),  # Musical Symbol Combining..Musical Symbol Combining
        (0x1d185, 0x1d18b,),  # Musical Symbol Combining..Musical Symbol Combining
        (0x1d1aa, 0x1d1ad,),  # Musical Symbol Combining..Musical Symbol Combining
        (0x1d242, 0x1d244,),  # Combining Greek Musical ..Combining Greek Musical
        (0xe0100, 0xe01ef,),  # Variation Selector-17   ..Variation Selector-256
    ),
    '6.2.0': (
        # Source: DerivedGeneralCategory-6.2.0.txt
        # Date:  2012-05-20, 00:42:34 GMT [MD]
        #
        (0x00300, 0x0036f,),  # Combining Grave Accent  ..Combining Latin Small Le
        (0x00483, 0x00489,),  # Combining Cyrillic Titlo..Combining Cyrillic Milli
        (0x00591, 0x005bd,),  # Hebrew Accent Etnahta   ..Hebrew Point Meteg
        (0x005bf, 0x005bf,),  # Hebrew Point Rafe       ..Hebrew Point Rafe
        (0x005c1, 0x005c2,),  # Hebrew Point Shin Dot   ..Hebrew Point Sin Dot
        (0x005c4, 0x005c5,),  # Hebrew Mark Upper Dot   ..Hebrew Mark Lower Dot
        (0x005c7, 0x005c7,),  # Hebrew Point Qamats Qata..Hebrew Point Qamats Qata
        (0x00610, 0x0061a,),  # Arabic Sign Sallallahou ..Arabic Small Kasra
        (0x0064b, 0x0065f,),  # Arabic Fathatan         ..Arabic Wavy Hamza Below
        (0x00670, 0x00670,),  # Arabic Letter Superscrip..Arabic Letter Superscrip
        (0x006d6, 0x006dc,),  # Arabic Small High Ligatu..Arabic Small High Seen
        (0x006df, 0x006e4,),  # Arabic Small High Rounde..Arabic Small High Madda
        (0x006e7, 0x006e8,),  # Arabic Small High Yeh   ..Arabic Small High Noon
        (0x006ea, 0x006ed,),  # Arabic Empty Centre Low ..Arabic Small Low Meem
        (0x00711, 0x00711,),  # Syriac Letter Superscrip..Syriac Letter Superscrip
        (0x00730, 0x0074a,),  # Syriac Pthaha Above     ..Syriac Barrekh
        (0x007a6, 0x007b0,),  # Thaana Abafili          ..Thaana Sukun
        (0x007eb, 0x007f3,),  # Nko Combining Short High..Nko Combining Double Dot
        (0x00816, 0x00819,),  # Samaritan Mark In       ..Samaritan Mark Dagesh
        (0x0081b, 0x00823,),  # Samaritan Mark Epentheti..Samaritan Vowel Sign A
        (0x00825, 0x00827,),  # Samaritan Vowel Sign Sho..Samaritan Vowel Sign U
        (0x00829, 0x0082d,),  # Samaritan Vowel Sign Lon..Samaritan Mark Nequdaa
        (0x00859, 0x0085b,),  # Mandaic Affrication Mark..Mandaic Gemination Mark
        (0x008e4, 0x008fe,),  # Arabic Curly Fatha      ..Arabic Damma With Dot
        (0x00900, 0x00902,),  # Devanagari Sign Inverted..Devanagari Sign Anusvara
        (0x0093a, 0x0093a,),  # Devanagari Vowel Sign Oe..Devanagari Vowel Sign Oe
        (0x0093c, 0x0093c,),  # Devanagari Sign Nukta   ..Devanagari Sign Nukta
        (0x00941, 0x00948,),  # Devanagari Vowel Sign U ..Devanagari Vowel Sign Ai
        (0x0094d, 0x0094d,),  # Devanagari Sign Virama  ..Devanagari Sign Virama
        (0x00951, 0x00957,),  # Devanagari Stress Sign U..Devanagari Vowel Sign Uu
        (0x00962, 0x00963,),  # Devanagari Vowel Sign Vo..Devanagari Vowel Sign Vo
        (0x00981, 0x00981,),  # Bengali Sign Candrabindu..Bengali Sign Candrabindu
        (0x009bc, 0x009bc,),  # Bengali Sign Nukta      ..Bengali Sign Nukta
        (0x009c1, 0x009c4,),  # Bengali Vowel Sign U    ..Bengali Vowel Sign Vocal
        (0x009cd, 0x009cd,),  # Bengali Sign Virama     ..Bengali Sign Virama
        (0x009e2, 0x009e3,),  # Bengali Vowel Sign Vocal..Bengali Vowel Sign Vocal
        (0x00a01, 0x00a02,),  # Gurmukhi Sign Adak Bindi..Gurmukhi Sign Bindi
        (0x00a3c, 0x00a3c,),  # Gurmukhi Sign Nukta     ..Gurmukhi Sign Nukta
        (0x00a41, 0x00a42,),  # Gurmukhi Vowel Sign U   ..Gurmukhi Vowel Sign Uu
        (0x00a47, 0x00a48,),  # Gurmukhi Vowel Sign Ee  ..Gurmukhi Vowel Sign Ai
        (0x00a4b, 0x00a4d,),  # Gurmukhi Vowel Sign Oo  ..Gurmukhi Sign Virama
        (0x00a51, 0x00a51,),  # Gurmukhi Sign Udaat     ..Gurmukhi Sign Udaat
        (0x00a70, 0x00a71,),  # Gurmukhi Tippi          ..Gurmukhi Addak
        (0x00a75, 0x00a75,),  # Gurmukhi Sign Yakash    ..Gurmukhi Sign Yakash
        (0x00a81, 0x00a82,),  # Gujarati Sign Candrabind..Gujarati Sign Anusvara
        (0x00abc, 0x00abc,),  # Gujarati Sign Nukta     ..Gujarati Sign Nukta
        (0x00ac1, 0x00ac5,),  # Gujarati Vowel Sign U   ..Gujarati Vowel Sign Cand
        (0x00ac7, 0x00ac8,),  # Gujarati Vowel Sign E   ..Gujarati Vowel Sign Ai
        (0x00acd, 0x00acd,),  # Gujarati Sign Virama    ..Gujarati Sign Virama
        (0x00ae2, 0x00ae3,),  # Gujarati Vowel Sign Voca..Gujarati Vowel Sign Voca
        (0x00b01, 0x00b01,),  # Oriya Sign Candrabindu  ..Oriya Sign Candrabindu
        (0x00b3c, 0x00b3c,),  # Oriya Sign Nukta        ..Oriya Sign Nukta
        (0x00b3f, 0x00b3f,),  # Oriya Vowel Sign I      ..Oriya Vowel Sign I
        (0x00b41, 0x00b44,),  # Oriya Vowel Sign U      ..Oriya Vowel Sign Vocalic
        (0x00b4d, 0x00b4d,),  # Oriya Sign Virama       ..Oriya Sign Virama
        (0x00b56, 0x00b56,),  # Oriya Ai Length Mark    ..Oriya Ai Length Mark
        (0x00b62, 0x00b63,),  # Oriya Vowel Sign Vocalic..Oriya Vowel Sign Vocalic
        (0x00b82, 0x00b82,),  # Tamil Sign Anusvara     ..Tamil Sign Anusvara
        (0x00bc0, 0x00bc0,),  # Tamil Vowel Sign Ii     ..Tamil Vowel Sign Ii
        (0x00bcd, 0x00bcd,),  # Tamil Sign Virama       ..Tamil Sign Virama
        (0x00c3e, 0x00c40,),  # Telugu Vowel Sign Aa    ..Telugu Vowel Sign Ii
        (0x00c46, 0x00c48,),  # Telugu Vowel Sign E     ..Telugu Vowel Sign Ai
        (0x00c4a, 0x00c4d,),  # Telugu Vowel Sign O     ..Telugu Sign Virama
        (0x00c55, 0x00c56,),  # Telugu Length Mark      ..Telugu Ai Length Mark
        (0x00c62, 0x00c63,),  # Telugu Vowel Sign Vocali..Telugu Vowel Sign Vocali
        (0x00cbc, 0x00cbc,),  # Kannada Sign Nukta      ..Kannada Sign Nukta
        (0x00cbf, 0x00cbf,),  # Kannada Vowel Sign I    ..Kannada Vowel Sign I
        (0x00cc6, 0x00cc6,),  # Kannada Vowel Sign E    ..Kannada Vowel Sign E
        (0x00ccc, 0x00ccd,),  # Kannada Vowel Sign Au   ..Kannada Sign Virama
        (0x00ce2, 0x00ce3,),  # Kannada Vowel Sign Vocal..Kannada Vowel Sign Vocal
        (0x00d41, 0x00d44,),  # Malayalam Vowel Sign U  ..Malayalam Vowel Sign Voc
        (0x00d4d, 0x00d4d,),  # Malayalam Sign Virama   ..Malayalam Sign Virama
        (0x00d62, 0x00d63,),  # Malayalam Vowel Sign Voc..Malayalam Vowel Sign Voc
        (0x00dca, 0x00dca,),  # Sinhala Sign Al-lakuna  ..Sinhala Sign Al-lakuna
        (0x00dd2, 0x00dd4,),  # Sinhala Vowel Sign Ketti..Sinhala Vowel Sign Ketti
        (0x00dd6, 0x00dd6,),  # Sinhala Vowel Sign Diga ..Sinhala Vowel Sign Diga
        (0x00e31, 0x00e31,),  # Thai Character Mai Han-a..Thai Character Mai Han-a
        (0x00e34, 0x00e3a,),  # Thai Character Sara I   ..Thai Character Phinthu
        (0x00e47, 0x00e4e,),  # Thai Character Maitaikhu..Thai Character Yamakkan
        (0x00eb1, 0x00eb1,),  # Lao Vowel Sign Mai Kan  ..Lao Vowel Sign Mai Kan
        (0x00eb4, 0x00eb9,),  # Lao Vowel Sign I        ..Lao Vowel Sign Uu
        (0x00ebb, 0x00ebc,),  # Lao Vowel Sign Mai Kon  ..Lao Semivowel Sign Lo
        (0x00ec8, 0x00ecd,),  # Lao Tone Mai Ek         ..Lao Niggahita
        (0x00f18, 0x00f19,),  # Tibetan Astrological Sig..Tibetan Astrological Sig
        (0x00f35, 0x00f35,),  # Tibetan Mark Ngas Bzung ..Tibetan Mark Ngas Bzung
        (0x00f37, 0x00f37,),  # Tibetan Mark Ngas Bzung ..Tibetan Mark Ngas Bzung
        (0x00f39, 0x00f39,),  # Tibetan Mark Tsa -phru  ..Tibetan Mark Tsa -phru
        (0x00f71, 0x00f7e,),  # Tibetan Vowel Sign Aa   ..Tibetan Sign Rjes Su Nga
        (0x00f80, 0x00f84,),  # Tibetan Vowel Sign Rever..Tibetan Mark Halanta
        (0x00f86, 0x00f87,),  # Tibetan Sign Lci Rtags  ..Tibetan Sign Yang Rtags
        (0x00f8d, 0x00f97,),  # Tibetan Subjoined Sign L..Tibetan Subjoined Letter
        (0x00f99, 0x00fbc,),  # Tibetan Subjoined Letter..Tibetan Subjoined Letter
        (0x00fc6, 0x00fc6,),  # Tibetan Symbol Padma Gda..Tibetan Symbol Padma Gda
        (0x0102d, 0x01030,),  # Myanmar Vowel Sign I    ..Myanmar Vowel Sign Uu
        (0x01032, 0x01037,),  # Myanmar Vowel Sign Ai   ..Myanmar Sign Dot Below
        (0x01039, 0x0103a,),  # Myanmar Sign Virama     ..Myanmar Sign Asat
        (0x0103d, 0x0103e,),  # Myanmar Consonant Sign M..Myanmar Consonant Sign M
        (0x01058, 0x01059,),  # Myanmar Vowel Sign Vocal..Myanmar Vowel Sign Vocal
        (0x0105e, 0x01060,),  # Myanmar Consonant Sign M..Myanmar Consonant Sign M
        (0x01071, 0x01074,),  # Myanmar Vowel Sign Geba ..Myanmar Vowel Sign Kayah
        (0x01082, 0x01082,),  # Myanmar Consonant Sign S..Myanmar Consonant Sign S
        (0x01085, 0x01086,),  # Myanmar Vowel Sign Shan ..Myanmar Vowel Sign Shan
        (0x0108d, 0x0108d,),  # Myanmar Sign Shan Counci..Myanmar Sign Shan Counci
        (0x0109d, 0x0109d,),  # Myanmar Vowel Sign Aiton..Myanmar Vowel Sign Aiton
        (0x0135d, 0x0135f,),  # Ethiopic Combining Gemin..Ethiopic Combining Gemin
        (0x01712, 0x01714,),  # Tagalog Vowel Sign I    ..Tagalog Sign Virama
        (0x01732, 0x01734,),  # Hanunoo Vowel Sign I    ..Hanunoo Sign Pamudpod
        (0x01752, 0x01753,),  # Buhid Vowel Sign I      ..Buhid Vowel Sign U
        (0x01772, 0x01773,),  # Tagbanwa Vowel Sign I   ..Tagbanwa Vowel Sign U
        (0x017b4, 0x017b5,),  # Khmer Vowel Inherent Aq ..Khmer Vowel Inherent Aa
        (0x017b7, 0x017bd,),  # Khmer Vowel Sign I      ..Khmer Vowel Sign Ua
        (0x017c6, 0x017c6,),  # Khmer Sign Nikahit      ..Khmer Sign Nikahit
        (0x017c9, 0x017d3,),  # Khmer Sign Muusikatoan  ..Khmer Sign Bathamasat
        (0x017dd, 0x017dd,),  # Khmer Sign Atthacan     ..Khmer Sign Atthacan
        (0x0180b, 0x0180d,),  # Mongolian Free Variation..Mongolian Free Variation
        (0x018a9, 0x018a9,),  # Mongolian Letter Ali Gal..Mongolian Letter Ali Gal
        (0x01920, 0x01922,),  # Limbu Vowel Sign A      ..Limbu Vowel Sign U
        (0x01927, 0x01928,),  # Limbu Vowel Sign E      ..Limbu Vowel Sign O
        (0x01932, 0x01932,),  # Limbu Small Letter Anusv..Limbu Small Letter Anusv
        (0x01939, 0x0193b,),  # Limbu Sign Mukphreng    ..Limbu Sign Sa-i
        (0x01a17, 0x01a18,),  # Buginese Vowel Sign I   ..Buginese Vowel Sign U
        (0x01a56, 0x01a56,),  # Tai Tham Consonant Sign ..Tai Tham Consonant Sign
        (0x01a58, 0x01a5e,),  # Tai Tham Sign Mai Kang L..Tai Tham Consonant Sign
        (0x01a60, 0x01a60,),  # Tai Tham Sign Sakot     ..Tai Tham Sign Sakot
        (0x01a62, 0x01a62,),  # Tai Tham Vowel Sign Mai ..Tai Tham Vowel Sign Mai
        (0x01a65, 0x01a6c,),  # Tai Tham Vowel Sign I   ..Tai Tham Vowel Sign Oa B
        (0x01a73, 0x01a7c,),  # Tai Tham Vowel Sign Oa A..Tai Tham Sign Khuen-lue
        (0x01a7f, 0x01a7f,),  # Tai Tham Combining Crypt..Tai Tham Combining Crypt
        (0x01b00, 0x01b03,),  # Balinese Sign Ulu Ricem ..Balinese Sign Surang
        (0x01b34, 0x01b34,),  # Balinese Sign Rerekan   ..Balinese Sign Rerekan
        (0x01b36, 0x01b3a,),  # Balinese Vowel Sign Ulu ..Balinese Vowel Sign Ra R
        (0x01b3c, 0x01b3c,),  # Balinese Vowel Sign La L..Balinese Vowel Sign La L
        (0x01b42, 0x01b42,),  # Balinese Vowel Sign Pepe..Balinese Vowel Sign Pepe
        (0x01b6b, 0x01b73,),  # Balinese Musical Symbol ..Balinese Musical Symbol
        (0x01b80, 0x01b81,),  # Sundanese Sign Panyecek ..Sundanese Sign Panglayar
        (0x01ba2, 0x01ba5,),  # Sundanese Consonant Sign..Sundanese Vowel Sign Pan
        (0x01ba8, 0x01ba9,),  # Sundanese Vowel Sign Pam..Sundanese Vowel Sign Pan
        (0x01bab, 0x01bab,),  # Sundanese Sign Virama   ..Sundanese Sign Virama
        (0x01be6, 0x01be6,),  # Batak Sign Tompi        ..Batak Sign Tompi
        (0x01be8, 0x01be9,),  # Batak Vowel Sign Pakpak ..Batak Vowel Sign Ee
        (0x01bed, 0x01bed,),  # Batak Vowel Sign Karo O ..Batak Vowel Sign Karo O
        (0x01bef, 0x01bf1,),  # Batak Vowel Sign U For S..Batak Consonant Sign H
        (0x01c2c, 0x01c33,),  # Lepcha Vowel Sign E     ..Lepcha Consonant Sign T
        (0x01c36, 0x01c37,),  # Lepcha Sign Ran         ..Lepcha Sign Nukta
        (0x01cd0, 0x01cd2,),  # Vedic Tone Karshana     ..Vedic Tone Prenkha
        (0x01cd4, 0x01ce0,),  # Vedic Sign Yajurvedic Mi..Vedic Tone Rigvedic Kash
        (0x01ce2, 0x01ce8,),  # Vedic Sign Visarga Svari..Vedic Sign Visarga Anuda
        (0x01ced, 0x01ced,),  # Vedic Sign Tiryak       ..Vedic Sign Tiryak
        (0x01cf4, 0x01cf4,),  # Vedic Tone Candra Above ..Vedic Tone Candra Above
        (0x01dc0, 0x01de6,),  # Combining Dotted Grave A..Combining Latin Small Le
        (0x01dfc, 0x01dff,),  # Combining Double Inverte..Combining Right Arrowhea
        (0x020d0, 0x020f0,),  # Combining Left Harpoon A..Combining Asterisk Above
        (0x02cef, 0x02cf1,),  # Coptic Combining Ni Abov..Coptic Combining Spiritu
        (0x02d7f, 0x02d7f,),  # Tifinagh Consonant Joine..Tifinagh Consonant Joine
        (0x02de0, 0x02dff,),  # Combining Cyrillic Lette..Combining Cyrillic Lette
        (0x0302a, 0x0302d,),  # Ideographic Level Tone M..Ideographic Entering Ton
        (0x03099, 0x0309a,),  # Combining Katakana-hirag..Combining Katakana-hirag
        (0x0a66f, 0x0a672,),  # Combining Cyrillic Vzmet..Combining Cyrillic Thous
        (0x0a674, 0x0a67d,),  # Combining Cyrillic Lette..Combining Cyrillic Payer
        (0x0a69f, 0x0a69f,),  # Combining Cyrillic Lette..Combining Cyrillic Lette
        (0x0a6f0, 0x0a6f1,),  # Bamum Combining Mark Koq..Bamum Combining Mark Tuk
        (0x0a802, 0x0a802,),  # Syloti Nagri Sign Dvisva..Syloti Nagri Sign Dvisva
        (0x0a806, 0x0a806,),  # Syloti Nagri Sign Hasant..Syloti Nagri Sign Hasant
        (0x0a80b, 0x0a80b,),  # Syloti Nagri Sign Anusva..Syloti Nagri Sign Anusva
        (0x0a825, 0x0a826,),  # Syloti Nagri Vowel Sign ..Syloti Nagri Vowel Sign
        (0x0a8c4, 0x0a8c4,),  # Saurashtra Sign Virama  ..Saurashtra Sign Virama
        (0x0a8e0, 0x0a8f1,),  # Combining Devanagari Dig..Combining Devanagari Sig
        (0x0a926, 0x0a92d,),  # Kayah Li Vowel Ue       ..Kayah Li Tone Calya Plop
        (0x0a947, 0x0a951,),  # Rejang Vowel Sign I     ..Rejang Consonant Sign R
        (0x0a980, 0x0a982,),  # Javanese Sign Panyangga ..Javanese Sign Layar
        (0x0a9b3, 0x0a9b3,),  # Javanese Sign Cecak Telu..Javanese Sign Cecak Telu
        (0x0a9b6, 0x0a9b9,),  # Javanese Vowel Sign Wulu..Javanese Vowel Sign Suku
        (0x0a9bc, 0x0a9bc,),  # Javanese Vowel Sign Pepe..Javanese Vowel Sign Pepe
        (0x0aa29, 0x0aa2e,),  # Cham Vowel Sign Aa      ..Cham Vowel Sign Oe
        (0x0aa31, 0x0aa32,),  # Cham Vowel Sign Au      ..Cham Vowel Sign Ue
        (0x0aa35, 0x0aa36,),  # Cham Consonant Sign La  ..Cham Consonant Sign Wa
        (0x0aa43, 0x0aa43,),  # Cham Consonant Sign Fina..Cham Consonant Sign Fina
        (0x0aa4c, 0x0aa4c,),  # Cham Consonant Sign Fina..Cham Consonant Sign Fina
        (0x0aab0, 0x0aab0,),  # Tai Viet Mai Kang       ..Tai Viet Mai Kang
        (0x0aab2, 0x0aab4,),  # Tai Viet Vowel I        ..Tai Viet Vowel U
        (0x0aab7, 0x0aab8,),  # Tai Viet Mai Khit       ..Tai Viet Vowel Ia
        (0x0aabe, 0x0aabf,),  # Tai Viet Vowel Am       ..Tai Viet Tone Mai Ek
        (0x0aac1, 0x0aac1,),  # Tai Viet Tone Mai Tho   ..Tai Viet Tone Mai Tho
        (0x0aaec, 0x0aaed,),  # Meetei Mayek Vowel Sign ..Meetei Mayek Vowel Sign
        (0x0aaf6, 0x0aaf6,),  # Meetei Mayek Virama     ..Meetei Mayek Virama
        (0x0abe5, 0x0abe5,),  # Meetei Mayek Vowel Sign ..Meetei Mayek Vowel Sign
        (0x0abe8, 0x0abe8,),  # Meetei Mayek Vowel Sign ..Meetei Mayek Vowel Sign
        (0x0abed, 0x0abed,),  # Meetei Mayek Apun Iyek  ..Meetei Mayek Apun Iyek
        (0x0fb1e, 0x0fb1e,),  # Hebrew Point Judeo-spani..Hebrew Point Judeo-spani
        (0x0fe00, 0x0fe0f,),  # Variation Selector-1    ..Variation Selector-16
        (0x0fe20, 0x0fe26,),  # Combining Ligature Left ..Combining Conjoining Mac
        (0x101fd, 0x101fd,),  # Phaistos Disc Sign Combi..Phaistos Disc Sign Combi
        (0x10a01, 0x10a03,),  # Kharoshthi Vowel Sign I ..Kharoshthi Vowel Sign Vo
        (0x10a05, 0x10a06,),  # Kharoshthi Vowel Sign E ..Kharoshthi Vowel Sign O
        (0x10a0c, 0x10a0f,),  # Kharoshthi Vowel Length ..Kharoshthi Sign Visarga
        (0x10a38, 0x10a3a,),  # Kharoshthi Sign Bar Abov..Kharoshthi Sign Dot Belo
        (0x10a3f, 0x10a3f,),  # Kharoshthi Virama       ..Kharoshthi Virama
        (0x11001, 0x11001,),  # Brahmi Sign Anusvara    ..Brahmi Sign Anusvara
        (0x11038, 0x11046,),  # Brahmi Vowel Sign Aa    ..Brahmi Virama
        (0x11080, 0x11081,),  # Kaithi Sign Candrabindu ..Kaithi Sign Anusvara
        (0x110b3, 0x110b6,),  # Kaithi Vowel Sign U     ..Kaithi Vowel Sign Ai
        (0x110b9, 0x110ba,),  # Kaithi Sign Virama      ..Kaithi Sign Nukta
        (0x11100, 0x11102,),  # Chakma Sign Candrabindu ..Chakma Sign Visarga
        (0x11127, 0x1112b,),  # Chakma Vowel Sign A     ..Chakma Vowel Sign Uu
        (0x1112d, 0x11134,),  # Chakma Vowel Sign Ai    ..Chakma Maayyaa
        (0x11180, 0x11181,),  # Sharada Sign Candrabindu..Sharada Sign Anusvara
        (0x111b6, 0x111be,),  # Sharada Vowel Sign U    ..Sharada Vowel Sign O
        (0x116ab, 0x116ab,),  # Takri Sign Anusvara     ..Takri Sign Anusvara
        (0x116ad, 0x116ad,),  # Takri Vowel Sign Aa     ..Takri Vowel Sign Aa
        (0x116b0, 0x116b5,),  # Takri Vowel Sign U      ..Takri Vowel Sign Au
        (0x116b7, 0x116b7,),  # Takri Sign Nukta        ..Takri Sign Nukta
        (0x16f8f, 0x16f92,),  # Miao Tone Right         ..Miao Tone Below
        (0x1d167, 0x1d169,),  # Musical Symbol Combining..Musical Symbol Combining
        (0x1d17b, 0x1d182,),  # Musical Symbol Combining..Musical Symbol Combining
        (0x1d185, 0x1d18b,),  # Musical Symbol Combining..Musical Symbol Combining
        (0x1d1aa, 0x1d1ad,),  # Musical Symbol Combining..Musical Symbol Combining
        (0x1d242, 0x1d244,),  # Combining Greek Musical ..Combining Greek Musical
        (0xe0100, 0xe01ef,),  # Variation Selector-17   ..Variation Selector-256
    ),
    '6.3.0': (
        # Source: DerivedGeneralCategory-6.3.0.txt
        # Date:  2013-07-05, 14:08:45 GMT [MD]
        #
        (0x00300, 0x0036f,),  # Combining Grave Accent  ..Combining Latin Small Le
        (0x00483, 0x00489,),  # Combining Cyrillic Titlo..Combining Cyrillic Milli
        (0x00591, 0x005bd,),  # Hebrew Accent Etnahta   ..Hebrew Point Meteg
        (0x005bf, 0x005bf,),  # Hebrew Point Rafe       ..Hebrew Point Rafe
        (0x005c1, 0x005c2,),  # Hebrew Point Shin Dot   ..Hebrew Point Sin Dot
        (0x005c4, 0x005c5,),  # Hebrew Mark Upper Dot   ..Hebrew Mark Lower Dot
        (0x005c7, 0x005c7,),  # Hebrew Point Qamats Qata..Hebrew Point Qamats Qata
        (0x00610, 0x0061a,),  # Arabic Sign Sallallahou ..Arabic Small Kasra
        (0x0064b, 0x0065f,),  # Arabic Fathatan         ..Arabic Wavy Hamza Below
        (0x00670, 0x00670,),  # Arabic Letter Superscrip..Arabic Letter Superscrip
        (0x006d6, 0x006dc,),  # Arabic Small High Ligatu..Arabic Small High Seen
        (0x006df, 0x006e4,),  # Arabic Small High Rounde..Arabic Small High Madda
        (0x006e7, 0x006e8,),  # Arabic Small High Yeh   ..Arabic Small High Noon
        (0x006ea, 0x006ed,),  # Arabic Empty Centre Low ..Arabic Small Low Meem
        (0x00711, 0x00711,),  # Syriac Letter Superscrip..Syriac Letter Superscrip
        (0x00730, 0x0074a,),  # Syriac Pthaha Above     ..Syriac Barrekh
        (0x007a6, 0x007b0,),  # Thaana Abafili          ..Thaana Sukun
        (0x007eb, 0x007f3,),  # Nko Combining Short High..Nko Combining Double Dot
        (0x00816, 0x00819,),  # Samaritan Mark In       ..Samaritan Mark Dagesh
        (0x0081b, 0x00823,),  # Samaritan Mark Epentheti..Samaritan Vowel Sign A
        (0x00825, 0x00827,),  # Samaritan Vowel Sign Sho..Samaritan Vowel Sign U
        (0x00829, 0x0082d,),  # Samaritan Vowel Sign Lon..Samaritan Mark Nequdaa
        (0x00859, 0x0085b,),  # Mandaic Affrication Mark..Mandaic Gemination Mark
        (0x008e4, 0x008fe,),  # Arabic Curly Fatha      ..Arabic Damma With Dot
        (0x00900, 0x00902,),  # Devanagari Sign Inverted..Devanagari Sign Anusvara
        (0x0093a, 0x0093a,),  # Devanagari Vowel Sign Oe..Devanagari Vowel Sign Oe
        (0x0093c, 0x0093c,),  # Devanagari Sign Nukta   ..Devanagari Sign Nukta
        (0x00941, 0x00948,),  # Devanagari Vowel Sign U ..Devanagari Vowel Sign Ai
        (0x0094d, 0x0094d,),  # Devanagari Sign Virama  ..Devanagari Sign Virama
        (0x00951, 0x00957,),  # Devanagari Stress Sign U..Devanagari Vowel Sign Uu
        (0x00962, 0x00963,),  # Devanagari Vowel Sign Vo..Devanagari Vowel Sign Vo
        (0x00981, 0x00981,),  # Bengali Sign Candrabindu..Bengali Sign Candrabindu
        (0x009bc, 0x009bc,),  # Bengali Sign Nukta      ..Bengali Sign Nukta
        (0x009c1, 0x009c4,),  # Bengali Vowel Sign U    ..Bengali Vowel Sign Vocal
        (0x009cd, 0x009cd,),  # Bengali Sign Virama     ..Bengali Sign Virama
        (0x009e2, 0x009e3,),  # Bengali Vowel Sign Vocal..Bengali Vowel Sign Vocal
        (0x00a01, 0x00a02,),  # Gurmukhi Sign Adak Bindi..Gurmukhi Sign Bindi
        (0x00a3c, 0x00a3c,),  # Gurmukhi Sign Nukta     ..Gurmukhi Sign Nukta
        (0x00a41, 0x00a42,),  # Gurmukhi Vowel Sign U   ..Gurmukhi Vowel Sign Uu
        (0x00a47, 0x00a48,),  # Gurmukhi Vowel Sign Ee  ..Gurmukhi Vowel Sign Ai
        (0x00a4b, 0x00a4d,),  # Gurmukhi Vowel Sign Oo  ..Gurmukhi Sign Virama
        (0x00a51, 0x00a51,),  # Gurmukhi Sign Udaat     ..Gurmukhi Sign Udaat
        (0x00a70, 0x00a71,),  # Gurmukhi Tippi          ..Gurmukhi Addak
        (0x00a75, 0x00a75,),  # Gurmukhi Sign Yakash    ..Gurmukhi Sign Yakash
        (0x00a81, 0x00a82,),  # Gujarati Sign Candrabind..Gujarati Sign Anusvara
        (0x00abc, 0x00abc,),  # Gujarati Sign Nukta     ..Gujarati Sign Nukta
        (0x00ac1, 0x00ac5,),  # Gujarati Vowel Sign U   ..Gujarati Vowel Sign Cand
        (0x00ac7, 0x00ac8,),  # Gujarati Vowel Sign E   ..Gujarati Vowel Sign Ai
        (0x00acd, 0x00acd,),  # Gujarati Sign Virama    ..Gujarati Sign Virama
        (0x00ae2, 0x00ae3,),  # Gujarati Vowel Sign Voca..Gujarati Vowel Sign Voca
        (0x00b01, 0x00b01,),  # Oriya Sign Candrabindu  ..Oriya Sign Candrabindu
        (0x00b3c, 0x00b3c,),  # Oriya Sign Nukta        ..Oriya Sign Nukta
        (0x00b3f, 0x00b3f,),  # Oriya Vowel Sign I      ..Oriya Vowel Sign I
        (0x00b41, 0x00b44,),  # Oriya Vowel Sign U      ..Oriya Vowel Sign Vocalic
        (0x00b4d, 0x00b4d,),  # Oriya Sign Virama       ..Oriya Sign Virama
        (0x00b56, 0x00b56,),  # Oriya Ai Length Mark    ..Oriya Ai Length Mark
        (0x00b62, 0x00b63,),  # Oriya Vowel Sign Vocalic..Oriya Vowel Sign Vocalic
        (0x00b82, 0x00b82,),  # Tamil Sign Anusvara     ..Tamil Sign Anusvara
        (0x00bc0, 0x00bc0,),  # Tamil Vowel Sign Ii     ..Tamil Vowel Sign Ii
        (0x00bcd, 0x00bcd,),  # Tamil Sign Virama       ..Tamil Sign Virama
        (0x00c3e, 0x00c40,),  # Telugu Vowel Sign Aa    ..Telugu Vowel Sign Ii
        (0x00c46, 0x00c48,),  # Telugu Vowel Sign E     ..Telugu Vowel Sign Ai
        (0x00c4a, 0x00c4d,),  # Telugu Vowel Sign O     ..Telugu Sign Virama
        (0x00c55, 0x00c56,),  # Telugu Length Mark      ..Telugu Ai Length Mark
        (0x00c62, 0x00c63,),  # Telugu Vowel Sign Vocali..Telugu Vowel Sign Vocali
        (0x00cbc, 0x00cbc,),  # Kannada Sign Nukta      ..Kannada Sign Nukta
        (0x00cbf, 0x00cbf,),  # Kannada Vowel Sign I    ..Kannada Vowel Sign I
        (0x00cc6, 0x00cc6,),  # Kannada Vowel Sign E    ..Kannada Vowel Sign E
        (0x00ccc, 0x00ccd,),  # Kannada Vowel Sign Au   ..Kannada Sign Virama
        (0x00ce2, 0x00ce3,),  # Kannada Vowel Sign Vocal..Kannada Vowel Sign Vocal
        (0x00d41, 0x00d44,),  # Malayalam Vowel Sign U  ..Malayalam Vowel Sign Voc
        (0x00d4d, 0x00d4d,),  # Malayalam Sign Virama   ..Malayalam Sign Virama
        (0x00d62, 0x00d63,),  # Malayalam Vowel Sign Voc..Malayalam Vowel Sign Voc
        (0x00dca, 0x00dca,),  # Sinhala Sign Al-lakuna  ..Sinhala Sign Al-lakuna
        (0x00dd2, 0x00dd4,),  # Sinhala Vowel Sign Ketti..Sinhala Vowel Sign Ketti
        (0x00dd6, 0x00dd6,),  # Sinhala Vowel Sign Diga ..Sinhala Vowel Sign Diga
        (0x00e31, 0x00e31,),  # Thai Character Mai Han-a..Thai Character Mai Han-a
        (0x00e34, 0x00e3a,),  # Thai Character Sara I   ..Thai Character Phinthu
        (0x00e47, 0x00e4e,),  # Thai Character Maitaikhu..Thai Character Yamakkan
        (0x00eb1, 0x00eb1,),  # Lao Vowel Sign Mai Kan  ..Lao Vowel Sign Mai Kan
        (0x00eb4, 0x00eb9,),  # Lao Vowel Sign I        ..Lao Vowel Sign Uu
        (0x00ebb, 0x00ebc,),  # Lao Vowel Sign Mai Kon  ..Lao Semivowel Sign Lo
        (0x00ec8, 0x00ecd,),  # Lao Tone Mai Ek         ..Lao Niggahita
        (0x00f18, 0x00f19,),  # Tibetan Astrological Sig..Tibetan Astrological Sig
        (0x00f35, 0x00f35,),  # Tibetan Mark Ngas Bzung ..Tibetan Mark Ngas Bzung
        (0x00f37, 0x00f37,),  # Tibetan Mark Ngas Bzung ..Tibetan Mark Ngas Bzung
        (0x00f39, 0x00f39,),  # Tibetan Mark Tsa -phru  ..Tibetan Mark Tsa -phru
        (0x00f71, 0x00f7e,),  # Tibetan Vowel Sign Aa   ..Tibetan Sign Rjes Su Nga
        (0x00f80, 0x00f84,),  # Tibetan Vowel Sign Rever..Tibetan Mark Halanta
        (0x00f86, 0x00f87,),  # Tibetan Sign Lci Rtags  ..Tibetan Sign Yang Rtags
        (0x00f8d, 0x00f97,),  # Tibetan Subjoined Sign L..Tibetan Subjoined Letter
        (0x00f99, 0x00fbc,),  # Tibetan Subjoined Letter..Tibetan Subjoined Letter
        (0x00fc6, 0x00fc6,),  # Tibetan Symbol Padma Gda..Tibetan Symbol Padma Gda
        (0x0102d, 0x01030,),  # Myanmar Vowel Sign I    ..Myanmar Vowel Sign Uu
        (0x01032, 0x01037,),  # Myanmar Vowel Sign Ai   ..Myanmar Sign Dot Below
        (0x01039, 0x0103a,),  # Myanmar Sign Virama     ..Myanmar Sign Asat
        (0x0103d, 0x0103e,),  # Myanmar Consonant Sign M..Myanmar Consonant Sign M
        (0x01058, 0x01059,),  # Myanmar Vowel Sign Vocal..Myanmar Vowel Sign Vocal
        (0x0105e, 0x01060,),  # Myanmar Consonant Sign M..Myanmar Consonant Sign M
        (0x01071, 0x01074,),  # Myanmar Vowel Sign Geba ..Myanmar Vowel Sign Kayah
        (0x01082, 0x01082,),  # Myanmar Consonant Sign S..Myanmar Consonant Sign S
        (0x01085, 0x01086,),  # Myanmar Vowel Sign Shan ..Myanmar Vowel Sign Shan
        (0x0108d, 0x0108d,),  # Myanmar Sign Shan Counci..Myanmar Sign Shan Counci
        (0x0109d, 0x0109d,),  # Myanmar Vowel Sign Aiton..Myanmar Vowel Sign Aiton
        (0x0135d, 0x0135f,),  # Ethiopic Combining Gemin..Ethiopic Combining Gemin
        (0x01712, 0x01714,),  # Tagalog Vowel Sign I    ..Tagalog Sign Virama
        (0x01732, 0x01734,),  # Hanunoo Vowel Sign I    ..Hanunoo Sign Pamudpod
        (0x01752, 0x01753,),  # Buhid Vowel Sign I      ..Buhid Vowel Sign U
        (0x01772, 0x01773,),  # Tagbanwa Vowel Sign I   ..Tagbanwa Vowel Sign U
        (0x017b4, 0x017b5,),  # Khmer Vowel Inherent Aq ..Khmer Vowel Inherent Aa
        (0x017b7, 0x017bd,),  # Khmer Vowel Sign I      ..Khmer Vowel Sign Ua
        (0x017c6, 0x017c6,),  # Khmer Sign Nikahit      ..Khmer Sign Nikahit
        (0x017c9, 0x017d3,),  # Khmer Sign Muusikatoan  ..Khmer Sign Bathamasat
        (0x017dd, 0x017dd,),  # Khmer Sign Atthacan     ..Khmer Sign Atthacan
        (0x0180b, 0x0180d,),  # Mongolian Free Variation..Mongolian Free Variation
        (0x018a9, 0x018a9,),  # Mongolian Letter Ali Gal..Mongolian Letter Ali Gal
        (0x01920, 0x01922,),  # Limbu Vowel Sign A      ..Limbu Vowel Sign U
        (0x01927, 0x01928,),  # Limbu Vowel Sign E      ..Limbu Vowel Sign O
        (0x01932, 0x01932,),  # Limbu Small Letter Anusv..Limbu Small Letter Anusv
        (0x01939, 0x0193b,),  # Limbu Sign Mukphreng    ..Limbu Sign Sa-i
        (0x01a17, 0x01a18,),  # Buginese Vowel Sign I   ..Buginese Vowel Sign U
        (0x01a1b, 0x01a1b,),  # Buginese Vowel Sign Ae  ..Buginese Vowel Sign Ae
        (0x01a56, 0x01a56,),  # Tai Tham Consonant Sign ..Tai Tham Consonant Sign
        (0x01a58, 0x01a5e,),  # Tai Tham Sign Mai Kang L..Tai Tham Consonant Sign
        (0x01a60, 0x01a60,),  # Tai Tham Sign Sakot     ..Tai Tham Sign Sakot
        (0x01a62, 0x01a62,),  # Tai Tham Vowel Sign Mai ..Tai Tham Vowel Sign Mai
        (0x01a65, 0x01a6c,),  # Tai Tham Vowel Sign I   ..Tai Tham Vowel Sign Oa B
        (0x01a73, 0x01a7c,),  # Tai Tham Vowel Sign Oa A..Tai Tham Sign Khuen-lue
        (0x01a7f, 0x01a7f,),  # Tai Tham Combining Crypt..Tai Tham Combining Crypt
        (0x01b00, 0x01b03,),  # Balinese Sign Ulu Ricem ..Balinese Sign Surang
        (0x01b34, 0x01b34,),  # Balinese Sign Rerekan   ..Balinese Sign Rerekan
        (0x01b36, 0x01b3a,),  # Balinese Vowel Sign Ulu ..Balinese Vowel Sign Ra R
        (0x01b3c, 0x01b3c,),  # Balinese Vowel Sign La L..Balinese Vowel Sign La L
        (0x01b42, 0x01b42,),  # Balinese Vowel Sign Pepe..Balinese Vowel Sign Pepe
        (0x01b6b, 0x01b73,),  # Balinese Musical Symbol ..Balinese Musical Symbol
        (0x01b80, 0x01b81,),  # Sundanese Sign Panyecek ..Sundanese Sign Panglayar
        (0x01ba2, 0x01ba5,),  # Sundanese Consonant Sign..Sundanese Vowel Sign Pan
        (0x01ba8, 0x01ba9,),  # Sundanese Vowel Sign Pam..Sundanese Vowel Sign Pan
        (0x01bab, 0x01bab,),  # Sundanese Sign Virama   ..Sundanese Sign Virama
        (0x01be6, 0x01be6,),  # Batak Sign Tompi        ..Batak Sign Tompi
        (0x01be8, 0x01be9,),  # Batak Vowel Sign Pakpak ..Batak Vowel Sign Ee
        (0x01bed, 0x01bed,),  # Batak Vowel Sign Karo O ..Batak Vowel Sign Karo O
        (0x01bef, 0x01bf1,),  # Batak Vowel Sign U For S..Batak Consonant Sign H
        (0x01c2c, 0x01c33,),  # Lepcha Vowel Sign E     ..Lepcha Consonant Sign T
        (0x01c36, 0x01c37,),  # Lepcha Sign Ran         ..Lepcha Sign Nukta
        (0x01cd0, 0x01cd2,),  # Vedic Tone Karshana     ..Vedic Tone Prenkha
        (0x01cd4, 0x01ce0,),  # Vedic Sign Yajurvedic Mi..Vedic Tone Rigvedic Kash
        (0x01ce2, 0x01ce8,),  # Vedic Sign Visarga Svari..Vedic Sign Visarga Anuda
        (0x01ced, 0x01ced,),  # Vedic Sign Tiryak       ..Vedic Sign Tiryak
        (0x01cf4, 0x01cf4,),  # Vedic Tone Candra Above ..Vedic Tone Candra Above
        (0x01dc0, 0x01de6,),  # Combining Dotted Grave A..Combining Latin Small Le
        (0x01dfc, 0x01dff,),  # Combining Double Inverte..Combining Right Arrowhea
        (0x020d0, 0x020f0,),  # Combining Left Harpoon A..Combining Asterisk Above
        (0x02cef, 0x02cf1,),  # Coptic Combining Ni Abov..Coptic Combining Spiritu
        (0x02d7f, 0x02d7f,),  # Tifinagh Consonant Joine..Tifinagh Consonant Joine
        (0x02de0, 0x02dff,),  # Combining Cyrillic Lette..Combining Cyrillic Lette
        (0x0302a, 0x0302d,),  # Ideographic Level Tone M..Ideographic Entering Ton
        (0x03099, 0x0309a,),  # Combining Katakana-hirag..Combining Katakana-hirag
        (0x0a66f, 0x0a672,),  # Combining Cyrillic Vzmet..Combining Cyrillic Thous
        (0x0a674, 0x0a67d,),  # Combining Cyrillic Lette..Combining Cyrillic Payer
        (0x0a69f, 0x0a69f,),  # Combining Cyrillic Lette..Combining Cyrillic Lette
        (0x0a6f0, 0x0a6f1,),  # Bamum Combining Mark Koq..Bamum Combining Mark Tuk
        (0x0a802, 0x0a802,),  # Syloti Nagri Sign Dvisva..Syloti Nagri Sign Dvisva
        (0x0a806, 0x0a806,),  # Syloti Nagri Sign Hasant..Syloti Nagri Sign Hasant
        (0x0a80b, 0x0a80b,),  # Syloti Nagri Sign Anusva..Syloti Nagri Sign Anusva
        (0x0a825, 0x0a826,),  # Syloti Nagri Vowel Sign ..Syloti Nagri Vowel Sign
        (0x0a8c4, 0x0a8c4,),  # Saurashtra Sign Virama  ..Saurashtra Sign Virama
        (0x0a8e0, 0x0a8f1,),  # Combining Devanagari Dig..Combining Devanagari Sig
        (0x0a926, 0x0a92d,),  # Kayah Li Vowel Ue       ..Kayah Li Tone Calya Plop
        (0x0a947, 0x0a951,),  # Rejang Vowel Sign I     ..Rejang Consonant Sign R
        (0x0a980, 0x0a982,),  # Javanese Sign Panyangga ..Javanese Sign Layar
        (0x0a9b3, 0x0a9b3,),  # Javanese Sign Cecak Telu..Javanese Sign Cecak Telu
        (0x0a9b6, 0x0a9b9,),  # Javanese Vowel Sign Wulu..Javanese Vowel Sign Suku
        (0x0a9bc, 0x0a9bc,),  # Javanese Vowel Sign Pepe..Javanese Vowel Sign Pepe
        (0x0aa29, 0x0aa2e,),  # Cham Vowel Sign Aa      ..Cham Vowel Sign Oe
        (0x0aa31, 0x0aa32,),  # Cham Vowel Sign Au      ..Cham Vowel Sign Ue
        (0x0aa35, 0x0aa36,),  # Cham Consonant Sign La  ..Cham Consonant Sign Wa
        (0x0aa43, 0x0aa43,),  # Cham Consonant Sign Fina..Cham Consonant Sign Fina
        (0x0aa4c, 0x0aa4c,),  # Cham Consonant Sign Fina..Cham Consonant Sign Fina
        (0x0aab0, 0x0aab0,),  # Tai Viet Mai Kang       ..Tai Viet Mai Kang
        (0x0aab2, 0x0aab4,),  # Tai Viet Vowel I        ..Tai Viet Vowel U
        (0x0aab7, 0x0aab8,),  # Tai Viet Mai Khit       ..Tai Viet Vowel Ia
        (0x0aabe, 0x0aabf,),  # Tai Viet Vowel Am       ..Tai Viet Tone Mai Ek
        (0x0aac1, 0x0aac1,),  # Tai Viet Tone Mai Tho   ..Tai Viet Tone Mai Tho
        (0x0aaec, 0x0aaed,),  # Meetei Mayek Vowel Sign ..Meetei Mayek Vowel Sign
        (0x0aaf6, 0x0aaf6,),  # Meetei Mayek Virama     ..Meetei Mayek Virama
        (0x0abe5, 0x0abe5,),  # Meetei Mayek Vowel Sign ..Meetei Mayek Vowel Sign
        (0x0abe8, 0x0abe8,),  # Meetei Mayek Vowel Sign ..Meetei Mayek Vowel Sign
        (0x0abed, 0x0abed,),  # Meetei Mayek Apun Iyek  ..Meetei Mayek Apun Iyek
        (0x0fb1e, 0x0fb1e,),  # Hebrew Point Judeo-spani..Hebrew Point Judeo-spani
        (0x0fe00, 0x0fe0f,),  # Variation Selector-1    ..Variation Selector-16
        (0x0fe20, 0x0fe26,),  # Combining Ligature Left ..Combining Conjoining Mac
        (0x101fd, 0x101fd,),  # Phaistos Disc Sign Combi..Phaistos Disc Sign Combi
        (0x10a01, 0x10a03,),  # Kharoshthi Vowel Sign I ..Kharoshthi Vowel Sign Vo
        (0x10a05, 0x10a06,),  # Kharoshthi Vowel Sign E ..Kharoshthi Vowel Sign O
        (0x10a0c, 0x10a0f,),  # Kharoshthi Vowel Length ..Kharoshthi Sign Visarga
        (0x10a38, 0x10a3a,),  # Kharoshthi Sign Bar Abov..Kharoshthi Sign Dot Belo
        (0x10a3f, 0x10a3f,),  # Kharoshthi Virama       ..Kharoshthi Virama
        (0x11001, 0x11001,),  # Brahmi Sign Anusvara    ..Brahmi Sign Anusvara
        (0x11038, 0x11046,),  # Brahmi Vowel Sign Aa    ..Brahmi Virama
        (0x11080, 0x11081,),  # Kaithi Sign Candrabindu ..Kaithi Sign Anusvara
        (0x110b3, 0x110b6,),  # Kaithi Vowel Sign U     ..Kaithi Vowel Sign Ai
        (0x110b9, 0x110ba,),  # Kaithi Sign Virama      ..Kaithi Sign Nukta
        (0x11100, 0x11102,),  # Chakma Sign Candrabindu ..Chakma Sign Visarga
        (0x11127, 0x1112b,),  # Chakma Vowel Sign A     ..Chakma Vowel Sign Uu
        (0x1112d, 0x11134,),  # Chakma Vowel Sign Ai    ..Chakma Maayyaa
        (0x11180, 0x11181,),  # Sharada Sign Candrabindu..Sharada Sign Anusvara
        (0x111b6, 0x111be,),  # Sharada Vowel Sign U    ..Sharada Vowel Sign O
        (0x116ab, 0x116ab,),  # Takri Sign Anusvara     ..Takri Sign Anusvara
        (0x116ad, 0x116ad,),  # Takri Vowel Sign Aa     ..Takri Vowel Sign Aa
        (0x116b0, 0x116b5,),  # Takri Vowel Sign U      ..Takri Vowel Sign Au
        (0x116b7, 0x116b7,),  # Takri Sign Nukta        ..Takri Sign Nukta
        (0x16f8f, 0x16f92,),  # Miao Tone Right         ..Miao Tone Below
        (0x1d167, 0x1d169,),  # Musical Symbol Combining..Musical Symbol Combining
        (0x1d17b, 0x1d182,),  # Musical Symbol Combining..Musical Symbol Combining
        (0x1d185, 0x1d18b,),  # Musical Symbol Combining..Musical Symbol Combining
        (0x1d1aa, 0x1d1ad,),  # Musical Symbol Combining..Musical Symbol Combining
        (0x1d242, 0x1d244,),  # Combining Greek Musical ..Combining Greek Musical
        (0xe0100, 0xe01ef,),  # Variation Selector-17   ..Variation Selector-256
    ),
    '7.0.0': (
        # Source: DerivedGeneralCategory-7.0.0.txt
        # Date:  2014-02-07, 18:42:12 GMT [MD]
        #
        (0x00300, 0x0036f,),  # Combining Grave Accent  ..Combining Latin Small Le
        (0x00483, 0x00489,),  # Combining Cyrillic Titlo..Combining Cyrillic Milli
        (0x00591, 0x005bd,),  # Hebrew Accent Etnahta   ..Hebrew Point Meteg
        (0x005bf, 0x005bf,),  # Hebrew Point Rafe       ..Hebrew Point Rafe
        (0x005c1, 0x005c2,),  # Hebrew Point Shin Dot   ..Hebrew Point Sin Dot
        (0x005c4, 0x005c5,),  # Hebrew Mark Upper Dot   ..Hebrew Mark Lower Dot
        (0x005c7, 0x005c7,),  # Hebrew Point Qamats Qata..Hebrew Point Qamats Qata
        (0x00610, 0x0061a,),  # Arabic Sign Sallallahou ..Arabic Small Kasra
        (0x0064b, 0x0065f,),  # Arabic Fathatan         ..Arabic Wavy Hamza Below
        (0x00670, 0x00670,),  # Arabic Letter Superscrip..Arabic Letter Superscrip
        (0x006d6, 0x006dc,),  # Arabic Small High Ligatu..Arabic Small High Seen
        (0x006df, 0x006e4,),  # Arabic Small High Rounde..Arabic Small High Madda
        (0x006e7, 0x006e8,),  # Arabic Small High Yeh   ..Arabic Small High Noon
        (0x006ea, 0x006ed,),  # Arabic Empty Centre Low ..Arabic Small Low Meem
        (0x00711, 0x00711,),  # Syriac Letter Superscrip..Syriac Letter Superscrip
        (0x00730, 0x0074a,),  # Syriac Pthaha Above     ..Syriac Barrekh
        (0x007a6, 0x007b0,),  # Thaana Abafili          ..Thaana Sukun
        (0x007eb, 0x007f3,),  # Nko Combining Short High..Nko Combining Double Dot
        (0x00816, 0x00819,),  # Samaritan Mark In       ..Samaritan Mark Dagesh
        (0x0081b, 0x00823,),  # Samaritan Mark Epentheti..Samaritan Vowel Sign A
        (0x00825, 0x00827,),  # Samaritan Vowel Sign Sho..Samaritan Vowel Sign U
        (0x00829, 0x0082d,),  # Samaritan Vowel Sign Lon..Samaritan Mark Nequdaa
        (0x00859, 0x0085b,),  # Mandaic Affrication Mark..Mandaic Gemination Mark
        (0x008e4, 0x00902,),  # Arabic Curly Fatha      ..Devanagari Sign Anusvara
        (0x0093a, 0x0093a,),  # Devanagari Vowel Sign Oe..Devanagari Vowel Sign Oe
        (0x0093c, 0x0093c,),  # Devanagari Sign Nukta   ..Devanagari Sign Nukta
        (0x00941, 0x00948,),  # Devanagari Vowel Sign U ..Devanagari Vowel Sign Ai
        (0x0094d, 0x0094d,),  # Devanagari Sign Virama  ..Devanagari Sign Virama
        (0x00951, 0x00957,),  # Devanagari Stress Sign U..Devanagari Vowel Sign Uu
        (0x00962, 0x00963,),  # Devanagari Vowel Sign Vo..Devanagari Vowel Sign Vo
        (0x00981, 0x00981,),  # Bengali Sign Candrabindu..Bengali Sign Candrabindu
        (0x009bc, 0x009bc,),  # Bengali Sign Nukta      ..Bengali Sign Nukta
        (0x009c1, 0x009c4,),  # Bengali Vowel Sign U    ..Bengali Vowel Sign Vocal
        (0x009cd, 0x009cd,),  # Bengali Sign Virama     ..Bengali Sign Virama
        (0x009e2, 0x009e3,),  # Bengali Vowel Sign Vocal..Bengali Vowel Sign Vocal
        (0x00a01, 0x00a02,),  # Gurmukhi Sign Adak Bindi..Gurmukhi Sign Bindi
        (0x00a3c, 0x00a3c,),  # Gurmukhi Sign Nukta     ..Gurmukhi Sign Nukta
        (0x00a41, 0x00a42,),  # Gurmukhi Vowel Sign U   ..Gurmukhi Vowel Sign Uu
        (0x00a47, 0x00a48,),  # Gurmukhi Vowel Sign Ee  ..Gurmukhi Vowel Sign Ai
        (0x00a4b, 0x00a4d,),  # Gurmukhi Vowel Sign Oo  ..Gurmukhi Sign Virama
        (0x00a51, 0x00a51,),  # Gurmukhi Sign Udaat     ..Gurmukhi Sign Udaat
        (0x00a70, 0x00a71,),  # Gurmukhi Tippi          ..Gurmukhi Addak
        (0x00a75, 0x00a75,),  # Gurmukhi Sign Yakash    ..Gurmukhi Sign Yakash
        (0x00a81, 0x00a82,),  # Gujarati Sign Candrabind..Gujarati Sign Anusvara
        (0x00abc, 0x00abc,),  # Gujarati Sign Nukta     ..Gujarati Sign Nukta
        (0x00ac1, 0x00ac5,),  # Gujarati Vowel Sign U   ..Gujarati Vowel Sign Cand
        (0x00ac7, 0x00ac8,),  # Gujarati Vowel Sign E   ..Gujarati Vowel Sign Ai
        (0x00acd, 0x00acd,),  # Gujarati Sign Virama    ..Gujarati Sign Virama
        (0x00ae2, 0x00ae3,),  # Gujarati Vowel Sign Voca..Gujarati Vowel Sign Voca
        (0x00b01, 0x00b01,),  # Oriya Sign Candrabindu  ..Oriya Sign Candrabindu
        (0x00b3c, 0x00b3c,),  # Oriya Sign Nukta        ..Oriya Sign Nukta
        (0x00b3f, 0x00b3f,),  # Oriya Vowel Sign I      ..Oriya Vowel Sign I
        (0x00b41, 0x00b44,),  # Oriya Vowel Sign U      ..Oriya Vowel Sign Vocalic
        (0x00b4d, 0x00b4d,),  # Oriya Sign Virama       ..Oriya Sign Virama
        (0x00b56, 0x00b56,),  # Oriya Ai Length Mark    ..Oriya Ai Length Mark
        (0x00b62, 0x00b63,),  # Oriya Vowel Sign Vocalic..Oriya Vowel Sign Vocalic
        (0x00b82, 0x00b82,),  # Tamil Sign Anusvara     ..Tamil Sign Anusvara
        (0x00bc0, 0x00bc0,),  # Tamil Vowel Sign Ii     ..Tamil Vowel Sign Ii
        (0x00bcd, 0x00bcd,),  # Tamil Sign Virama       ..Tamil Sign Virama
        (0x00c00, 0x00c00,),  # Telugu Sign Combining Ca..Telugu Sign Combining Ca
        (0x00c3e, 0x00c40,),  # Telugu Vowel Sign Aa    ..Telugu Vowel Sign Ii
        (0x00c46, 0x00c48,),  # Telugu Vowel Sign E     ..Telugu Vowel Sign Ai
        (0x00c4a, 0x00c4d,),  # Telugu Vowel Sign O     ..Telugu Sign Virama
        (0x00c55, 0x00c56,),  # Telugu Length Mark      ..Telugu Ai Length Mark
        (0x00c62, 0x00c63,),  # Telugu Vowel Sign Vocali..Telugu Vowel Sign Vocali
        (0x00c81, 0x00c81,),  # Kannada Sign Candrabindu..Kannada Sign Candrabindu
        (0x00cbc, 0x00cbc,),  # Kannada Sign Nukta      ..Kannada Sign Nukta
        (0x00cbf, 0x00cbf,),  # Kannada Vowel Sign I    ..Kannada Vowel Sign I
        (0x00cc6, 0x00cc6,),  # Kannada Vowel Sign E    ..Kannada Vowel Sign E
        (0x00ccc, 0x00ccd,),  # Kannada Vowel Sign Au   ..Kannada Sign Virama
        (0x00ce2, 0x00ce3,),  # Kannada Vowel Sign Vocal..Kannada Vowel Sign Vocal
        (0x00d01, 0x00d01,),  # Malayalam Sign Candrabin..Malayalam Sign Candrabin
        (0x00d41, 0x00d44,),  # Malayalam Vowel Sign U  ..Malayalam Vowel Sign Voc
        (0x00d4d, 0x00d4d,),  # Malayalam Sign Virama   ..Malayalam Sign Virama
        (0x00d62, 0x00d63,),  # Malayalam Vowel Sign Voc..Malayalam Vowel Sign Voc
        (0x00dca, 0x00dca,),  # Sinhala Sign Al-lakuna  ..Sinhala Sign Al-lakuna
        (0x00dd2, 0x00dd4,),  # Sinhala Vowel Sign Ketti..Sinhala Vowel Sign Ketti
        (0x00dd6, 0x00dd6,),  # Sinhala Vowel Sign Diga ..Sinhala Vowel Sign Diga
        (0x00e31, 0x00e31,),  # Thai Character Mai Han-a..Thai Character Mai Han-a
        (0x00e34, 0x00e3a,),  # Thai Character Sara I   ..Thai Character Phinthu
        (0x00e47, 0x00e4e,),  # Thai Character Maitaikhu..Thai Character Yamakkan
        (0x00eb1, 0x00eb1,),  # Lao Vowel Sign Mai Kan  ..Lao Vowel Sign Mai Kan
        (0x00eb4, 0x00eb9,),  # Lao Vowel Sign I        ..Lao Vowel Sign Uu
        (0x00ebb, 0x00ebc,),  # Lao Vowel Sign Mai Kon  ..Lao Semivowel Sign Lo
        (0x00ec8, 0x00ecd,),  # Lao Tone Mai Ek         ..Lao Niggahita
        (0x00f18, 0x00f19,),  # Tibetan Astrological Sig..Tibetan Astrological Sig
        (0x00f35, 0x00f35,),  # Tibetan Mark Ngas Bzung ..Tibetan Mark Ngas Bzung
        (0x00f37, 0x00f37,),  # Tibetan Mark Ngas Bzung ..Tibetan Mark Ngas Bzung
        (0x00f39, 0x00f39,),  # Tibetan Mark Tsa -phru  ..Tibetan Mark Tsa -phru
        (0x00f71, 0x00f7e,),  # Tibetan Vowel Sign Aa   ..Tibetan Sign Rjes Su Nga
        (0x00f80, 0x00f84,),  # Tibetan Vowel Sign Rever..Tibetan Mark Halanta
        (0x00f86, 0x00f87,),  # Tibetan Sign Lci Rtags  ..Tibetan Sign Yang Rtags
        (0x00f8d, 0x00f97,),  # Tibetan Subjoined Sign L..Tibetan Subjoined Letter
        (0x00f99, 0x00fbc,),  # Tibetan Subjoined Letter..Tibetan Subjoined Letter
        (0x00fc6, 0x00fc6,),  # Tibetan Symbol Padma Gda..Tibetan Symbol Padma Gda
        (0x0102d, 0x01030,),  # Myanmar Vowel Sign I    ..Myanmar Vowel Sign Uu
        (0x01032, 0x01037,),  # Myanmar Vowel Sign Ai   ..Myanmar Sign Dot Below
        (0x01039, 0x0103a,),  # Myanmar Sign Virama     ..Myanmar Sign Asat
        (0x0103d, 0x0103e,),  # Myanmar Consonant Sign M..Myanmar Consonant Sign M
        (0x01058, 0x01059,),  # Myanmar Vowel Sign Vocal..Myanmar Vowel Sign Vocal
        (0x0105e, 0x01060,),  # Myanmar Consonant Sign M..Myanmar Consonant Sign M
        (0x01071, 0x01074,),  # Myanmar Vowel Sign Geba ..Myanmar Vowel Sign Kayah
        (0x01082, 0x01082,),  # Myanmar Consonant Sign S..Myanmar Consonant Sign S
        (0x01085, 0x01086,),  # Myanmar Vowel Sign Shan ..Myanmar Vowel Sign Shan
        (0x0108d, 0x0108d,),  # Myanmar Sign Shan Counci..Myanmar Sign Shan Counci
        (0x0109d, 0x0109d,),  # Myanmar Vowel Sign Aiton..Myanmar Vowel Sign Aiton
        (0x0135d, 0x0135f,),  # Ethiopic Combining Gemin..Ethiopic Combining Gemin
        (0x01712, 0x01714,),  # Tagalog Vowel Sign I    ..Tagalog Sign Virama
        (0x01732, 0x01734,),  # Hanunoo Vowel Sign I    ..Hanunoo Sign Pamudpod
        (0x01752, 0x01753,),  # Buhid Vowel Sign I      ..Buhid Vowel Sign U
        (0x01772, 0x01773,),  # Tagbanwa Vowel Sign I   ..Tagbanwa Vowel Sign U
        (0x017b4, 0x017b5,),  # Khmer Vowel Inherent Aq ..Khmer Vowel Inherent Aa
        (0x017b7, 0x017bd,),  # Khmer Vowel Sign I      ..Khmer Vowel Sign Ua
        (0x017c6, 0x017c6,),  # Khmer Sign Nikahit      ..Khmer Sign Nikahit
        (0x017c9, 0x017d3,),  # Khmer Sign Muusikatoan  ..Khmer Sign Bathamasat
        (0x017dd, 0x017dd,),  # Khmer Sign Atthacan     ..Khmer Sign Atthacan
        (0x0180b, 0x0180d,),  # Mongolian Free Variation..Mongolian Free Variation
        (0x018a9, 0x018a9,),  # Mongolian Letter Ali Gal..Mongolian Letter Ali Gal
        (0x01920, 0x01922,),  # Limbu Vowel Sign A      ..Limbu Vowel Sign U
        (0x01927, 0x01928,),  # Limbu Vowel Sign E      ..Limbu Vowel Sign O
        (0x01932, 0x01932,),  # Limbu Small Letter Anusv..Limbu Small Letter Anusv
        (0x01939, 0x0193b,),  # Limbu Sign Mukphreng    ..Limbu Sign Sa-i
        (0x01a17, 0x01a18,),  # Buginese Vowel Sign I   ..Buginese Vowel Sign U
        (0x01a1b, 0x01a1b,),  # Buginese Vowel Sign Ae  ..Buginese Vowel Sign Ae
        (0x01a56, 0x01a56,),  # Tai Tham Consonant Sign ..Tai Tham Consonant Sign
        (0x01a58, 0x01a5e,),  # Tai Tham Sign Mai Kang L..Tai Tham Consonant Sign
        (0x01a60, 0x01a60,),  # Tai Tham Sign Sakot     ..Tai Tham Sign Sakot
        (0x01a62, 0x01a62,),  # Tai Tham Vowel Sign Mai ..Tai Tham Vowel Sign Mai
        (0x01a65, 0x01a6c,),  # Tai Tham Vowel Sign I   ..Tai Tham Vowel Sign Oa B
        (0x01a73, 0x01a7c,),  # Tai Tham Vowel Sign Oa A..Tai Tham Sign Khuen-lue
        (0x01a7f, 0x01a7f,),  # Tai Tham Combining Crypt..Tai Tham Combining Crypt
        (0x01ab0, 0x01abe,),  # Combining Doubled Circum..Combining Parentheses Ov
        (0x01b00, 0x01b03,),  # Balinese Sign Ulu Ricem ..Balinese Sign Surang
        (0x01b34, 0x01b34,),  # Balinese Sign Rerekan   ..Balinese Sign Rerekan
        (0x01b36, 0x01b3a,),  # Balinese Vowel Sign Ulu ..Balinese Vowel Sign Ra R
        (0x01b3c, 0x01b3c,),  # Balinese Vowel Sign La L..Balinese Vowel Sign La L
        (0x01b42, 0x01b42,),  # Balinese Vowel Sign Pepe..Balinese Vowel Sign Pepe
        (0x01b6b, 0x01b73,),  # Balinese Musical Symbol ..Balinese Musical Symbol
        (0x01b80, 0x01b81,),  # Sundanese Sign Panyecek ..Sundanese Sign Panglayar
        (0x01ba2, 0x01ba5,),  # Sundanese Consonant Sign..Sundanese Vowel Sign Pan
        (0x01ba8, 0x01ba9,),  # Sundanese Vowel Sign Pam..Sundanese Vowel Sign Pan
        (0x01bab, 0x01bad,),  # Sundanese Sign Virama   ..Sundanese Consonant Sign
        (0x01be6, 0x01be6,),  # Batak Sign Tompi        ..Batak Sign Tompi
        (0x01be8, 0x01be9,),  # Batak Vowel Sign Pakpak ..Batak Vowel Sign Ee
        (0x01bed, 0x01bed,),  # Batak Vowel Sign Karo O ..Batak Vowel Sign Karo O
        (0x01bef, 0x01bf1,),  # Batak Vowel Sign U For S..Batak Consonant Sign H
        (0x01c2c, 0x01c33,),  # Lepcha Vowel Sign E     ..Lepcha Consonant Sign T
        (0x01c36, 0x01c37,),  # Lepcha Sign Ran         ..Lepcha Sign Nukta
        (0x01cd0, 0x01cd2,),  # Vedic Tone Karshana     ..Vedic Tone Prenkha
        (0x01cd4, 0x01ce0,),  # Vedic Sign Yajurvedic Mi..Vedic Tone Rigvedic Kash
        (0x01ce2, 0x01ce8,),  # Vedic Sign Visarga Svari..Vedic Sign Visarga Anuda
        (0x01ced, 0x01ced,),  # Vedic Sign Tiryak       ..Vedic Sign Tiryak
        (0x01cf4, 0x01cf4,),  # Vedic Tone Candra Above ..Vedic Tone Candra Above
        (0x01cf8, 0x01cf9,),  # Vedic Tone Ring Above   ..Vedic Tone Double Ring A
        (0x01dc0, 0x01df5,),  # Combining Dotted Grave A..Combining Up Tack Above
        (0x01dfc, 0x01dff,),  # Combining Double Inverte..Combining Right Arrowhea
        (0x020d0, 0x020f0,),  # Combining Left Harpoon A..Combining Asterisk Above
        (0x02cef, 0x02cf1,),  # Coptic Combining Ni Abov..Coptic Combining Spiritu
        (0x02d7f, 0x02d7f,),  # Tifinagh Consonant Joine..Tifinagh Consonant Joine
        (0x02de0, 0x02dff,),  # Combining Cyrillic Lette..Combining Cyrillic Lette
        (0x0302a, 0x0302d,),  # Ideographic Level Tone M..Ideographic Entering Ton
        (0x03099, 0x0309a,),  # Combining Katakana-hirag..Combining Katakana-hirag
        (0x0a66f, 0x0a672,),  # Combining Cyrillic Vzmet..Combining Cyrillic Thous
        (0x0a674, 0x0a67d,),  # Combining Cyrillic Lette..Combining Cyrillic Payer
        (0x0a69f, 0x0a69f,),  # Combining Cyrillic Lette..Combining Cyrillic Lette
        (0x0a6f0, 0x0a6f1,),  # Bamum Combining Mark Koq..Bamum Combining Mark Tuk
        (0x0a802, 0x0a802,),  # Syloti Nagri Sign Dvisva..Syloti Nagri Sign Dvisva
        (0x0a806, 0x0a806,),  # Syloti Nagri Sign Hasant..Syloti Nagri Sign Hasant
        (0x0a80b, 0x0a80b,),  # Syloti Nagri Sign Anusva..Syloti Nagri Sign Anusva
        (0x0a825, 0x0a826,),  # Syloti Nagri Vowel Sign ..Syloti Nagri Vowel Sign
        (0x0a8c4, 0x0a8c4,),  # Saurashtra Sign Virama  ..Saurashtra Sign Virama
        (0x0a8e0, 0x0a8f1,),  # Combining Devanagari Dig..Combining Devanagari Sig
        (0x0a926, 0x0a92d,),  # Kayah Li Vowel Ue       ..Kayah Li Tone Calya Plop
        (0x0a947, 0x0a951,),  # Rejang Vowel Sign I     ..Rejang Consonant Sign R
        (0x0a980, 0x0a982,),  # Javanese Sign Panyangga ..Javanese Sign Layar
        (0x0a9b3, 0x0a9b3,),  # Javanese Sign Cecak Telu..Javanese Sign Cecak Telu
        (0x0a9b6, 0x0a9b9,),  # Javanese Vowel Sign Wulu..Javanese Vowel Sign Suku
        (0x0a9bc, 0x0a9bc,),  # Javanese Vowel Sign Pepe..Javanese Vowel Sign Pepe
        (0x0a9e5, 0x0a9e5,),  # Myanmar Sign Shan Saw   ..Myanmar Sign Shan Saw
        (0x0aa29, 0x0aa2e,),  # Cham Vowel Sign Aa      ..Cham Vowel Sign Oe
        (0x0aa31, 0x0aa32,),  # Cham Vowel Sign Au      ..Cham Vowel Sign Ue
        (0x0aa35, 0x0aa36,),  # Cham Consonant Sign La  ..Cham Consonant Sign Wa
        (0x0aa43, 0x0aa43,),  # Cham Consonant Sign Fina..Cham Consonant Sign Fina
        (0x0aa4c, 0x0aa4c,),  # Cham Consonant Sign Fina..Cham Consonant Sign Fina
        (0x0aa7c, 0x0aa7c,),  # Myanmar Sign Tai Laing T..Myanmar Sign Tai Laing T
        (0x0aab0, 0x0aab0,),  # Tai Viet Mai Kang       ..Tai Viet Mai Kang
        (0x0aab2, 0x0aab4,),  # Tai Viet Vowel I        ..Tai Viet Vowel U
        (0x0aab7, 0x0aab8,),  # Tai Viet Mai Khit       ..Tai Viet Vowel Ia
        (0x0aabe, 0x0aabf,),  # Tai Viet Vowel Am       ..Tai Viet Tone Mai Ek
        (0x0aac1, 0x0aac1,),  # Tai Viet Tone Mai Tho   ..Tai Viet Tone Mai Tho
        (0x0aaec, 0x0aaed,),  # Meetei Mayek Vowel Sign ..Meetei Mayek Vowel Sign
        (0x0aaf6, 0x0aaf6,),  # Meetei Mayek Virama     ..Meetei Mayek Virama
        (0x0abe5, 0x0abe5,),  # Meetei Mayek Vowel Sign ..Meetei Mayek Vowel Sign
        (0x0abe8, 0x0abe8,),  # Meetei Mayek Vowel Sign ..Meetei Mayek Vowel Sign
        (0x0abed, 0x0abed,),  # Meetei Mayek Apun Iyek  ..Meetei Mayek Apun Iyek
        (0x0fb1e, 0x0fb1e,),  # Hebrew Point Judeo-spani..Hebrew Point Judeo-spani
        (0x0fe00, 0x0fe0f,),  # Variation Selector-1    ..Variation Selector-16
        (0x0fe20, 0x0fe2d,),  # Combining Ligature Left ..Combining Conjoining Mac
        (0x101fd, 0x101fd,),  # Phaistos Disc Sign Combi..Phaistos Disc Sign Combi
        (0x102e0, 0x102e0,),  # Coptic Epact Thousands M..Coptic Epact Thousands M
        (0x10376, 0x1037a,),  # Combining Old Permic Let..Combining Old Permic Let
        (0x10a01, 0x10a03,),  # Kharoshthi Vowel Sign I ..Kharoshthi Vowel Sign Vo
        (0x10a05, 0x10a06,),  # Kharoshthi Vowel Sign E ..Kharoshthi Vowel Sign O
        (0x10a0c, 0x10a0f,),  # Kharoshthi Vowel Length ..Kharoshthi Sign Visarga
        (0x10a38, 0x10a3a,),  # Kharoshthi Sign Bar Abov..Kharoshthi Sign Dot Belo
        (0x10a3f, 0x10a3f,),  # Kharoshthi Virama       ..Kharoshthi Virama
        (0x10ae5, 0x10ae6,),  # Manichaean Abbreviation ..Manichaean Abbreviation
        (0x11001, 0x11001,),  # Brahmi Sign Anusvara    ..Brahmi Sign Anusvara
        (0x11038, 0x11046,),  # Brahmi Vowel Sign Aa    ..Brahmi Virama
        (0x1107f, 0x11081,),  # Brahmi Number Joiner    ..Kaithi Sign Anusvara
        (0x110b3, 0x110b6,),  # Kaithi Vowel Sign U     ..Kaithi Vowel Sign Ai
        (0x110b9, 0x110ba,),  # Kaithi Sign Virama      ..Kaithi Sign Nukta
        (0x11100, 0x11102,),  # Chakma Sign Candrabindu ..Chakma Sign Visarga
        (0x11127, 0x1112b,),  # Chakma Vowel Sign A     ..Chakma Vowel Sign Uu
        (0x1112d, 0x11134,),  # Chakma Vowel Sign Ai    ..Chakma Maayyaa
        (0x11173, 0x11173,),  # Mahajani Sign Nukta     ..Mahajani Sign Nukta
        (0x11180, 0x11181,),  # Sharada Sign Candrabindu..Sharada Sign Anusvara
        (0x111b6, 0x111be,),  # Sharada Vowel Sign U    ..Sharada Vowel Sign O
        (0x1122f, 0x11231,),  # Khojki Vowel Sign U     ..Khojki Vowel Sign Ai
        (0x11234, 0x11234,),  # Khojki Sign Anusvara    ..Khojki Sign Anusvara
        (0x11236, 0x11237,),  # Khojki Sign Nukta       ..Khojki Sign Shadda
        (0x112df, 0x112df,),  # Khudawadi Sign Anusvara ..Khudawadi Sign Anusvara
        (0x112e3, 0x112ea,),  # Khudawadi Vowel Sign U  ..Khudawadi Sign Virama
        (0x11301, 0x11301,),  # Grantha Sign Candrabindu..Grantha Sign Candrabindu
        (0x1133c, 0x1133c,),  # Grantha Sign Nukta      ..Grantha Sign Nukta
        (0x11340, 0x11340,),  # Grantha Vowel Sign Ii   ..Grantha Vowel Sign Ii
        (0x11366, 0x1136c,),  # Combining Grantha Digit ..Combining Grantha Digit
        (0x11370, 0x11374,),  # Combining Grantha Letter..Combining Grantha Letter
        (0x114b3, 0x114b8,),  # Tirhuta Vowel Sign U    ..Tirhuta Vowel Sign Vocal
        (0x114ba, 0x114ba,),  # Tirhuta Vowel Sign Short..Tirhuta Vowel Sign Short
        (0x114bf, 0x114c0,),  # Tirhuta Sign Candrabindu..Tirhuta Sign Anusvara
        (0x114c2, 0x114c3,),  # Tirhuta Sign Virama     ..Tirhuta Sign Nukta
        (0x115b2, 0x115b5,),  # Siddham Vowel Sign U    ..Siddham Vowel Sign Vocal
        (0x115bc, 0x115bd,),  # Siddham Sign Candrabindu..Siddham Sign Anusvara
        (0x115bf, 0x115c0,),  # Siddham Sign Virama     ..Siddham Sign Nukta
        (0x11633, 0x1163a,),  # Modi Vowel Sign U       ..Modi Vowel Sign Ai
        (0x1163d, 0x1163d,),  # Modi Sign Anusvara      ..Modi Sign Anusvara
        (0x1163f, 0x11640,),  # Modi Sign Virama        ..Modi Sign Ardhacandra
        (0x116ab, 0x116ab,),  # Takri Sign Anusvara     ..Takri Sign Anusvara
        (0x116ad, 0x116ad,),  # Takri Vowel Sign Aa     ..Takri Vowel Sign Aa
        (0x116b0, 0x116b5,),  # Takri Vowel Sign U      ..Takri Vowel Sign Au
        (0x116b7, 0x116b7,),  # Takri Sign Nukta        ..Takri Sign Nukta
        (0x16af0, 0x16af4,),  # Bassa Vah Combining High..Bassa Vah Combining High
        (0x16b30, 0x16b36,),  # Pahawh Hmong Mark Cim Tu..Pahawh Hmong Mark Cim Ta
        (0x16f8f, 0x16f92,),  # Miao Tone Right         ..Miao Tone Below
        (0x1bc9d, 0x1bc9e,),  # Duployan Thick Letter Se..Duployan Double Mark
        (0x1d167, 0x1d169,),  # Musical Symbol Combining..Musical Symbol Combining
        (0x1d17b, 0x1d182,),  # Musical Symbol Combining..Musical Symbol Combining
        (0x1d185, 0x1d18b,),  # Musical Symbol Combining..Musical Symbol Combining
        (0x1d1aa, 0x1d1ad,),  # Musical Symbol Combining..Musical Symbol Combining
        (0x1d242, 0x1d244,),  # Combining Greek Musical ..Combining Greek Musical
        (0x1e8d0, 0x1e8d6,),  # Mende Kikakui Combining ..Mende Kikakui Combining
        (0xe0100, 0xe01ef,),  # Variation Selector-17   ..Variation Selector-256
    ),
    '8.0.0': (
        # Source: DerivedGeneralCategory-8.0.0.txt
        # Date:  2015-02-13, 13:47:11 GMT [MD]
        #
        (0x00300, 0x0036f,),  # Combining Grave Accent  ..Combining Latin Small Le
        (0x00483, 0x00489,),  # Combining Cyrillic Titlo..Combining Cyrillic Milli
        (0x00591, 0x005bd,),  # Hebrew Accent Etnahta   ..Hebrew Point Meteg
        (0x005bf, 0x005bf,),  # Hebrew Point Rafe       ..Hebrew Point Rafe
        (0x005c1, 0x005c2,),  # Hebrew Point Shin Dot   ..Hebrew Point Sin Dot
        (0x005c4, 0x005c5,),  # Hebrew Mark Upper Dot   ..Hebrew Mark Lower Dot
        (0x005c7, 0x005c7,),  # Hebrew Point Qamats Qata..Hebrew Point Qamats Qata
        (0x00610, 0x0061a,),  # Arabic Sign Sallallahou ..Arabic Small Kasra
        (0x0064b, 0x0065f,),  # Arabic Fathatan         ..Arabic Wavy Hamza Below
        (0x00670, 0x00670,),  # Arabic Letter Superscrip..Arabic Letter Superscrip
        (0x006d6, 0x006dc,),  # Arabic Small High Ligatu..Arabic Small High Seen
        (0x006df, 0x006e4,),  # Arabic Small High Rounde..Arabic Small High Madda
        (0x006e7, 0x006e8,),  # Arabic Small High Yeh   ..Arabic Small High Noon
        (0x006ea, 0x006ed,),  # Arabic Empty Centre Low ..Arabic Small Low Meem
        (0x00711, 0x00711,),  # Syriac Letter Superscrip..Syriac Letter Superscrip
        (0x00730, 0x0074a,),  # Syriac Pthaha Above     ..Syriac Barrekh
        (0x007a6, 0x007b0,),  # Thaana Abafili          ..Thaana Sukun
        (0x007eb, 0x007f3,),  # Nko Combining Short High..Nko Combining Double Dot
        (0x00816, 0x00819,),  # Samaritan Mark In       ..Samaritan Mark Dagesh
        (0x0081b, 0x00823,),  # Samaritan Mark Epentheti..Samaritan Vowel Sign A
        (0x00825, 0x00827,),  # Samaritan Vowel Sign Sho..Samaritan Vowel Sign U
        (0x00829, 0x0082d,),  # Samaritan Vowel Sign Lon..Samaritan Mark Nequdaa
        (0x00859, 0x0085b,),  # Mandaic Affrication Mark..Mandaic Gemination Mark
        (0x008e3, 0x00902,),  # Arabic Turned Damma Belo..Devanagari Sign Anusvara
        (0x0093a, 0x0093a,),  # Devanagari Vowel Sign Oe..Devanagari Vowel Sign Oe
        (0x0093c, 0x0093c,),  # Devanagari Sign Nukta   ..Devanagari Sign Nukta
        (0x00941, 0x00948,),  # Devanagari Vowel Sign U ..Devanagari Vowel Sign Ai
        (0x0094d, 0x0094d,),  # Devanagari Sign Virama  ..Devanagari Sign Virama
        (0x00951, 0x00957,),  # Devanagari Stress Sign U..Devanagari Vowel Sign Uu
        (0x00962, 0x00963,),  # Devanagari Vowel Sign Vo..Devanagari Vowel Sign Vo
        (0x00981, 0x00981,),  # Bengali Sign Candrabindu..Bengali Sign Candrabindu
        (0x009bc, 0x009bc,),  # Bengali Sign Nukta      ..Bengali Sign Nukta
        (0x009c1, 0x009c4,),  # Bengali Vowel Sign U    ..Bengali Vowel Sign Vocal
        (0x009cd, 0x009cd,),  # Bengali Sign Virama     ..Bengali Sign Virama
        (0x009e2, 0x009e3,),  # Bengali Vowel Sign Vocal..Bengali Vowel Sign Vocal
        (0x00a01, 0x00a02,),  # Gurmukhi Sign Adak Bindi..Gurmukhi Sign Bindi
        (0x00a3c, 0x00a3c,),  # Gurmukhi Sign Nukta     ..Gurmukhi Sign Nukta
        (0x00a41, 0x00a42,),  # Gurmukhi Vowel Sign U   ..Gurmukhi Vowel Sign Uu
        (0x00a47, 0x00a48,),  # Gurmukhi Vowel Sign Ee  ..Gurmukhi Vowel Sign Ai
        (0x00a4b, 0x00a4d,),  # Gurmukhi Vowel Sign Oo  ..Gurmukhi Sign Virama
        (0x00a51, 0x00a51,),  # Gurmukhi Sign Udaat     ..Gurmukhi Sign Udaat
        (0x00a70, 0x00a71,),  # Gurmukhi Tippi          ..Gurmukhi Addak
        (0x00a75, 0x00a75,),  # Gurmukhi Sign Yakash    ..Gurmukhi Sign Yakash
        (0x00a81, 0x00a82,),  # Gujarati Sign Candrabind..Gujarati Sign Anusvara
        (0x00abc, 0x00abc,),  # Gujarati Sign Nukta     ..Gujarati Sign Nukta
        (0x00ac1, 0x00ac5,),  # Gujarati Vowel Sign U   ..Gujarati Vowel Sign Cand
        (0x00ac7, 0x00ac8,),  # Gujarati Vowel Sign E   ..Gujarati Vowel Sign Ai
        (0x00acd, 0x00acd,),  # Gujarati Sign Virama    ..Gujarati Sign Virama
        (0x00ae2, 0x00ae3,),  # Gujarati Vowel Sign Voca..Gujarati Vowel Sign Voca
        (0x00b01, 0x00b01,),  # Oriya Sign Candrabindu  ..Oriya Sign Candrabindu
        (0x00b3c, 0x00b3c,),  # Oriya Sign Nukta        ..Oriya Sign Nukta
        (0x00b3f, 0x00b3f,),  # Oriya Vowel Sign I      ..Oriya Vowel Sign I
        (0x00b41, 0x00b44,),  # Oriya Vowel Sign U      ..Oriya Vowel Sign Vocalic
        (0x00b4d, 0x00b4d,),  # Oriya Sign Virama       ..Oriya Sign Virama
        (0x00b56, 0x00b56,),  # Oriya Ai Length Mark    ..Oriya Ai Length Mark
        (0x00b62, 0x00b63,),  # Oriya Vowel Sign Vocalic..Oriya Vowel Sign Vocalic
        (0x00b82, 0x00b82,),  # Tamil Sign Anusvara     ..Tamil Sign Anusvara
        (0x00bc0, 0x00bc0,),  # Tamil Vowel Sign Ii     ..Tamil Vowel Sign Ii
        (0x00bcd, 0x00bcd,),  # Tamil Sign Virama       ..Tamil Sign Virama
        (0x00c00, 0x00c00,),  # Telugu Sign Combining Ca..Telugu Sign Combining Ca
        (0x00c3e, 0x00c40,),  # Telugu Vowel Sign Aa    ..Telugu Vowel Sign Ii
        (0x00c46, 0x00c48,),  # Telugu Vowel Sign E     ..Telugu Vowel Sign Ai
        (0x00c4a, 0x00c4d,),  # Telugu Vowel Sign O     ..Telugu Sign Virama
        (0x00c55, 0x00c56,),  # Telugu Length Mark      ..Telugu Ai Length Mark
        (0x00c62, 0x00c63,),  # Telugu Vowel Sign Vocali..Telugu Vowel Sign Vocali
        (0x00c81, 0x00c81,),  # Kannada Sign Candrabindu..Kannada Sign Candrabindu
        (0x00cbc, 0x00cbc,),  # Kannada Sign Nukta      ..Kannada Sign Nukta
        (0x00cbf, 0x00cbf,),  # Kannada Vowel Sign I    ..Kannada Vowel Sign I
        (0x00cc6, 0x00cc6,),  # Kannada Vowel Sign E    ..Kannada Vowel Sign E
        (0x00ccc, 0x00ccd,),  # Kannada Vowel Sign Au   ..Kannada Sign Virama
        (0x00ce2, 0x00ce3,),  # Kannada Vowel Sign Vocal..Kannada Vowel Sign Vocal
        (0x00d01, 0x00d01,),  # Malayalam Sign Candrabin..Malayalam Sign Candrabin
        (0x00d41, 0x00d44,),  # Malayalam Vowel Sign U  ..Malayalam Vowel Sign Voc
        (0x00d4d, 0x00d4d,),  # Malayalam Sign Virama   ..Malayalam Sign Virama
        (0x00d62, 0x00d63,),  # Malayalam Vowel Sign Voc..Malayalam Vowel Sign Voc
        (0x00dca, 0x00dca,),  # Sinhala Sign Al-lakuna  ..Sinhala Sign Al-lakuna
        (0x00dd2, 0x00dd4,),  # Sinhala Vowel Sign Ketti..Sinhala Vowel Sign Ketti
        (0x00dd6, 0x00dd6,),  # Sinhala Vowel Sign Diga ..Sinhala Vowel Sign Diga
        (0x00e31, 0x00e31,),  # Thai Character Mai Han-a..Thai Character Mai Han-a
        (0x00e34, 0x00e3a,),  # Thai Character Sara I   ..Thai Character Phinthu
        (0x00e47, 0x00e4e,),  # Thai Character Maitaikhu..Thai Character Yamakkan
        (0x00eb1, 0x00eb1,),  # Lao Vowel Sign Mai Kan  ..Lao Vowel Sign Mai Kan
        (0x00eb4, 0x00eb9,),  # Lao Vowel Sign I        ..Lao Vowel Sign Uu
        (0x00ebb, 0x00ebc,),  # Lao Vowel Sign Mai Kon  ..Lao Semivowel Sign Lo
        (0x00ec8, 0x00ecd,),  # Lao Tone Mai Ek         ..Lao Niggahita
        (0x00f18, 0x00f19,),  # Tibetan Astrological Sig..Tibetan Astrological Sig
        (0x00f35, 0x00f35,),  # Tibetan Mark Ngas Bzung ..Tibetan Mark Ngas Bzung
        (0x00f37, 0x00f37,),  # Tibetan Mark Ngas Bzung ..Tibetan Mark Ngas Bzung
        (0x00f39, 0x00f39,),  # Tibetan Mark Tsa -phru  ..Tibetan Mark Tsa -phru
        (0x00f71, 0x00f7e,),  # Tibetan Vowel Sign Aa   ..Tibetan Sign Rjes Su Nga
        (0x00f80, 0x00f84,),  # Tibetan Vowel Sign Rever..Tibetan Mark Halanta
        (0x00f86, 0x00f87,),  # Tibetan Sign Lci Rtags  ..Tibetan Sign Yang Rtags
        (0x00f8d, 0x00f97,),  # Tibetan Subjoined Sign L..Tibetan Subjoined Letter
        (0x00f99, 0x00fbc,),  # Tibetan Subjoined Letter..Tibetan Subjoined Letter
        (0x00fc6, 0x00fc6,),  # Tibetan Symbol Padma Gda..Tibetan Symbol Padma Gda
        (0x0102d, 0x01030,),  # Myanmar Vowel Sign I    ..Myanmar Vowel Sign Uu
        (0x01032, 0x01037,),  # Myanmar Vowel Sign Ai   ..Myanmar Sign Dot Below
        (0x01039, 0x0103a,),  # Myanmar Sign Virama     ..Myanmar Sign Asat
        (0x0103d, 0x0103e,),  # Myanmar Consonant Sign M..Myanmar Consonant Sign M
        (0x01058, 0x01059,),  # Myanmar Vowel Sign Vocal..Myanmar Vowel Sign Vocal
        (0x0105e, 0x01060,),  # Myanmar Consonant Sign M..Myanmar Consonant Sign M
        (0x01071, 0x01074,),  # Myanmar Vowel Sign Geba ..Myanmar Vowel Sign Kayah
        (0x01082, 0x01082,),  # Myanmar Consonant Sign S..Myanmar Consonant Sign S
        (0x01085, 0x01086,),  # Myanmar Vowel Sign Shan ..Myanmar Vowel Sign Shan
        (0x0108d, 0x0108d,),  # Myanmar Sign Shan Counci..Myanmar Sign Shan Counci
        (0x0109d, 0x0109d,),  # Myanmar Vowel Sign Aiton..Myanmar Vowel Sign Aiton
        (0x0135d, 0x0135f,),  # Ethiopic Combining Gemin..Ethiopic Combining Gemin
        (0x01712, 0x01714,),  # Tagalog Vowel Sign I    ..Tagalog Sign Virama
        (0x01732, 0x01734,),  # Hanunoo Vowel Sign I    ..Hanunoo Sign Pamudpod
        (0x01752, 0x01753,),  # Buhid Vowel Sign I      ..Buhid Vowel Sign U
        (0x01772, 0x01773,),  # Tagbanwa Vowel Sign I   ..Tagbanwa Vowel Sign U
        (0x017b4, 0x017b5,),  # Khmer Vowel Inherent Aq ..Khmer Vowel Inherent Aa
        (0x017b7, 0x017bd,),  # Khmer Vowel Sign I      ..Khmer Vowel Sign Ua
        (0x017c6, 0x017c6,),  # Khmer Sign Nikahit      ..Khmer Sign Nikahit
        (0x017c9, 0x017d3,),  # Khmer Sign Muusikatoan  ..Khmer Sign Bathamasat
        (0x017dd, 0x017dd,),  # Khmer Sign Atthacan     ..Khmer Sign Atthacan
        (0x0180b, 0x0180d,),  # Mongolian Free Variation..Mongolian Free Variation
        (0x018a9, 0x018a9,),  # Mongolian Letter Ali Gal..Mongolian Letter Ali Gal
        (0x01920, 0x01922,),  # Limbu Vowel Sign A      ..Limbu Vowel Sign U
        (0x01927, 0x01928,),  # Limbu Vowel Sign E      ..Limbu Vowel Sign O
        (0x01932, 0x01932,),  # Limbu Small Letter Anusv..Limbu Small Letter Anusv
        (0x01939, 0x0193b,),  # Limbu Sign Mukphreng    ..Limbu Sign Sa-i
        (0x01a17, 0x01a18,),  # Buginese Vowel Sign I   ..Buginese Vowel Sign U
        (0x01a1b, 0x01a1b,),  # Buginese Vowel Sign Ae  ..Buginese Vowel Sign Ae
        (0x01a56, 0x01a56,),  # Tai Tham Consonant Sign ..Tai Tham Consonant Sign
        (0x01a58, 0x01a5e,),  # Tai Tham Sign Mai Kang L..Tai Tham Consonant Sign
        (0x01a60, 0x01a60,),  # Tai Tham Sign Sakot     ..Tai Tham Sign Sakot
        (0x01a62, 0x01a62,),  # Tai Tham Vowel Sign Mai ..Tai Tham Vowel Sign Mai
        (0x01a65, 0x01a6c,),  # Tai Tham Vowel Sign I   ..Tai Tham Vowel Sign Oa B
        (0x01a73, 0x01a7c,),  # Tai Tham Vowel Sign Oa A..Tai Tham Sign Khuen-lue
        (0x01a7f, 0x01a7f,),  # Tai Tham Combining Crypt..Tai Tham Combining Crypt
        (0x01ab0, 0x01abe,),  # Combining Doubled Circum..Combining Parentheses Ov
        (0x01b00, 0x01b03,),  # Balinese Sign Ulu Ricem ..Balinese Sign Surang
        (0x01b34, 0x01b34,),  # Balinese Sign Rerekan   ..Balinese Sign Rerekan
        (0x01b36, 0x01b3a,),  # Balinese Vowel Sign Ulu ..Balinese Vowel Sign Ra R
        (0x01b3c, 0x01b3c,),  # Balinese Vowel Sign La L..Balinese Vowel Sign La L
        (0x01b42, 0x01b42,),  # Balinese Vowel Sign Pepe..Balinese Vowel Sign Pepe
        (0x01b6b, 0x01b73,),  # Balinese Musical Symbol ..Balinese Musical Symbol
        (0x01b80, 0x01b81,),  # Sundanese Sign Panyecek ..Sundanese Sign Panglayar
        (0x01ba2, 0x01ba5,),  # Sundanese Consonant Sign..Sundanese Vowel Sign Pan
        (0x01ba8, 0x01ba9,),  # Sundanese Vowel Sign Pam..Sundanese Vowel Sign Pan
        (0x01bab, 0x01bad,),  # Sundanese Sign Virama   ..Sundanese Consonant Sign
        (0x01be6, 0x01be6,),  # Batak Sign Tompi        ..Batak Sign Tompi
        (0x01be8, 0x01be9,),  # Batak Vowel Sign Pakpak ..Batak Vowel Sign Ee
        (0x01bed, 0x01bed,),  # Batak Vowel Sign Karo O ..Batak Vowel Sign Karo O
        (0x01bef, 0x01bf1,),  # Batak Vowel Sign U For S..Batak Consonant Sign H
        (0x01c2c, 0x01c33,),  # Lepcha Vowel Sign E     ..Lepcha Consonant Sign T
        (0x01c36, 0x01c37,),  # Lepcha Sign Ran         ..Lepcha Sign Nukta
        (0x01cd0, 0x01cd2,),  # Vedic Tone Karshana     ..Vedic Tone Prenkha
        (0x01cd4, 0x01ce0,),  # Vedic Sign Yajurvedic Mi..Vedic Tone Rigvedic Kash
        (0x01ce2, 0x01ce8,),  # Vedic Sign Visarga Svari..Vedic Sign Visarga Anuda
        (0x01ced, 0x01ced,),  # Vedic Sign Tiryak       ..Vedic Sign Tiryak
        (0x01cf4, 0x01cf4,),  # Vedic Tone Candra Above ..Vedic Tone Candra Above
        (0x01cf8, 0x01cf9,),  # Vedic Tone Ring Above   ..Vedic Tone Double Ring A
        (0x01dc0, 0x01df5,),  # Combining Dotted Grave A..Combining Up Tack Above
        (0x01dfc, 0x01dff,),  # Combining Double Inverte..Combining Right Arrowhea
        (0x020d0, 0x020f0,),  # Combining Left Harpoon A..Combining Asterisk Above
        (0x02cef, 0x02cf1,),  # Coptic Combining Ni Abov..Coptic Combining Spiritu
        (0x02d7f, 0x02d7f,),  # Tifinagh Consonant Joine..Tifinagh Consonant Joine
        (0x02de0, 0x02dff,),  # Combining Cyrillic Lette..Combining Cyrillic Lette
        (0x0302a, 0x0302d,),  # Ideographic Level Tone M..Ideographic Entering Ton
        (0x03099, 0x0309a,),  # Combining Katakana-hirag..Combining Katakana-hirag
        (0x0a66f, 0x0a672,),  # Combining Cyrillic Vzmet..Combining Cyrillic Thous
        (0x0a674, 0x0a67d,),  # Combining Cyrillic Lette..Combining Cyrillic Payer
        (0x0a69e, 0x0a69f,),  # Combining Cyrillic Lette..Combining Cyrillic Lette
        (0x0a6f0, 0x0a6f1,),  # Bamum Combining Mark Koq..Bamum Combining Mark Tuk
        (0x0a802, 0x0a802,),  # Syloti Nagri Sign Dvisva..Syloti Nagri Sign Dvisva
        (0x0a806, 0x0a806,),  # Syloti Nagri Sign Hasant..Syloti Nagri Sign Hasant
        (0x0a80b, 0x0a80b,),  # Syloti Nagri Sign Anusva..Syloti Nagri Sign Anusva
        (0x0a825, 0x0a826,),  # Syloti Nagri Vowel Sign ..Syloti Nagri Vowel Sign
        (0x0a8c4, 0x0a8c4,),  # Saurashtra Sign Virama  ..Saurashtra Sign Virama
        (0x0a8e0, 0x0a8f1,),  # Combining Devanagari Dig..Combining Devanagari Sig
        (0x0a926, 0x0a92d,),  # Kayah Li Vowel Ue       ..Kayah Li Tone Calya Plop
        (0x0a947, 0x0a951,),  # Rejang Vowel Sign I     ..Rejang Consonant Sign R
        (0x0a980, 0x0a982,),  # Javanese Sign Panyangga ..Javanese Sign Layar
        (0x0a9b3, 0x0a9b3,),  # Javanese Sign Cecak Telu..Javanese Sign Cecak Telu
        (0x0a9b6, 0x0a9b9,),  # Javanese Vowel Sign Wulu..Javanese Vowel Sign Suku
        (0x0a9bc, 0x0a9bc,),  # Javanese Vowel Sign Pepe..Javanese Vowel Sign Pepe
        (0x0a9e5, 0x0a9e5,),  # Myanmar Sign Shan Saw   ..Myanmar Sign Shan Saw
        (0x0aa29, 0x0aa2e,),  # Cham Vowel Sign Aa      ..Cham Vowel Sign Oe
        (0x0aa31, 0x0aa32,),  # Cham Vowel Sign Au      ..Cham Vowel Sign Ue
        (0x0aa35, 0x0aa36,),  # Cham Consonant Sign La  ..Cham Consonant Sign Wa
        (0x0aa43, 0x0aa43,),  # Cham Consonant Sign Fina..Cham Consonant Sign Fina
        (0x0aa4c, 0x0aa4c,),  # Cham Consonant Sign Fina..Cham Consonant Sign Fina
        (0x0aa7c, 0x0aa7c,),  # Myanmar Sign Tai Laing T..Myanmar Sign Tai Laing T
        (0x0aab0, 0x0aab0,),  # Tai Viet Mai Kang       ..Tai Viet Mai Kang
        (0x0aab2, 0x0aab4,),  # Tai Viet Vowel I        ..Tai Viet Vowel U
        (0x0aab7, 0x0aab8,),  # Tai Viet Mai Khit       ..Tai Viet Vowel Ia
        (0x0aabe, 0x0aabf,),  # Tai Viet Vowel Am       ..Tai Viet Tone Mai Ek
        (0x0aac1, 0x0aac1,),  # Tai Viet Tone Mai Tho   ..Tai Viet Tone Mai Tho
        (0x0aaec, 0x0aaed,),  # Meetei Mayek Vowel Sign ..Meetei Mayek Vowel Sign
        (0x0aaf6, 0x0aaf6,),  # Meetei Mayek Virama     ..Meetei Mayek Virama
        (0x0abe5, 0x0abe5,),  # Meetei Mayek Vowel Sign ..Meetei Mayek Vowel Sign
        (0x0abe8, 0x0abe8,),  # Meetei Mayek Vowel Sign ..Meetei Mayek Vowel Sign
        (0x0abed, 0x0abed,),  # Meetei Mayek Apun Iyek  ..Meetei Mayek Apun Iyek
        (0x0fb1e, 0x0fb1e,),  # Hebrew Point Judeo-spani..Hebrew Point Judeo-spani
        (0x0fe00, 0x0fe0f,),  # Variation Selector-1    ..Variation Selector-16
        (0x0fe20, 0x0fe2f,),  # Combining Ligature Left ..Combining Cyrillic Titlo
        (0x101fd, 0x101fd,),  # Phaistos Disc Sign Combi..Phaistos Disc Sign Combi
        (0x102e0, 0x102e0,),  # Coptic Epact Thousands M..Coptic Epact Thousands M
        (0x10376, 0x1037a,),  # Combining Old Permic Let..Combining Old Permic Let
        (0x10a01, 0x10a03,),  # Kharoshthi Vowel Sign I ..Kharoshthi Vowel Sign Vo
        (0x10a05, 0x10a06,),  # Kharoshthi Vowel Sign E ..Kharoshthi Vowel Sign O
        (0x10a0c, 0x10a0f,),  # Kharoshthi Vowel Length ..Kharoshthi Sign Visarga
        (0x10a38, 0x10a3a,),  # Kharoshthi Sign Bar Abov..Kharoshthi Sign Dot Belo
        (0x10a3f, 0x10a3f,),  # Kharoshthi Virama       ..Kharoshthi Virama
        (0x10ae5, 0x10ae6,),  # Manichaean Abbreviation ..Manichaean Abbreviation
        (0x11001, 0x11001,),  # Brahmi Sign Anusvara    ..Brahmi Sign Anusvara
        (0x11038, 0x11046,),  # Brahmi Vowel Sign Aa    ..Brahmi Virama
        (0x1107f, 0x11081,),  # Brahmi Number Joiner    ..Kaithi Sign Anusvara
        (0x110b3, 0x110b6,),  # Kaithi Vowel Sign U     ..Kaithi Vowel Sign Ai
        (0x110b9, 0x110ba,),  # Kaithi Sign Virama      ..Kaithi Sign Nukta
        (0x11100, 0x11102,),  # Chakma Sign Candrabindu ..Chakma Sign Visarga
        (0x11127, 0x1112b,),  # Chakma Vowel Sign A     ..Chakma Vowel Sign Uu
        (0x1112d, 0x11134,),  # Chakma Vowel Sign Ai    ..Chakma Maayyaa
        (0x11173, 0x11173,),  # Mahajani Sign Nukta     ..Mahajani Sign Nukta
        (0x11180, 0x11181,),  # Sharada Sign Candrabindu..Sharada Sign Anusvara
        (0x111b6, 0x111be,),  # Sharada Vowel Sign U    ..Sharada Vowel Sign O
        (0x111ca, 0x111cc,),  # Sharada Sign Nukta      ..Sharada Extra Short Vowe
        (0x1122f, 0x11231,),  # Khojki Vowel Sign U     ..Khojki Vowel Sign Ai
        (0x11234, 0x11234,),  # Khojki Sign Anusvara    ..Khojki Sign Anusvara
        (0x11236, 0x11237,),  # Khojki Sign Nukta       ..Khojki Sign Shadda
        (0x112df, 0x112df,),  # Khudawadi Sign Anusvara ..Khudawadi Sign Anusvara
        (0x112e3, 0x112ea,),  # Khudawadi Vowel Sign U  ..Khudawadi Sign Virama
        (0x11300, 0x11301,),  # Grantha Sign Combining A..Grantha Sign Candrabindu
        (0x1133c, 0x1133c,),  # Grantha Sign Nukta      ..Grantha Sign Nukta
        (0x11340, 0x11340,),  # Grantha Vowel Sign Ii   ..Grantha Vowel Sign Ii
        (0x11366, 0x1136c,),  # Combining Grantha Digit ..Combining Grantha Digit
        (0x11370, 0x11374,),  # Combining Grantha Letter..Combining Grantha Letter
        (0x114b3, 0x114b8,),  # Tirhuta Vowel Sign U    ..Tirhuta Vowel Sign Vocal
        (0x114ba, 0x114ba,),  # Tirhuta Vowel Sign Short..Tirhuta Vowel Sign Short
        (0x114bf, 0x114c0,),  # Tirhuta Sign Candrabindu..Tirhuta Sign Anusvara
        (0x114c2, 0x114c3,),  # Tirhuta Sign Virama     ..Tirhuta Sign Nukta
        (0x115b2, 0x115b5,),  # Siddham Vowel Sign U    ..Siddham Vowel Sign Vocal
        (0x115bc, 0x115bd,),  # Siddham Sign Candrabindu..Siddham Sign Anusvara
        (0x115bf, 0x115c0,),  # Siddham Sign Virama     ..Siddham Sign Nukta
        (0x115dc, 0x115dd,),  # Siddham Vowel Sign Alter..Siddham Vowel Sign Alter
        (0x11633, 0x1163a,),  # Modi Vowel Sign U       ..Modi Vowel Sign Ai
        (0x1163d, 0x1163d,),  # Modi Sign Anusvara      ..Modi Sign Anusvara
        (0x1163f, 0x11640,),  # Modi Sign Virama        ..Modi Sign Ardhacandra
        (0x116ab, 0x116ab,),  # Takri Sign Anusvara     ..Takri Sign Anusvara
        (0x116ad, 0x116ad,),  # Takri Vowel Sign Aa     ..Takri Vowel Sign Aa
        (0x116b0, 0x116b5,),  # Takri Vowel Sign U      ..Takri Vowel Sign Au
        (0x116b7, 0x116b7,),  # Takri Sign Nukta        ..Takri Sign Nukta
        (0x1171d, 0x1171f,),  # Ahom Consonant Sign Medi..Ahom Consonant Sign Medi
        (0x11722, 0x11725,),  # Ahom Vowel Sign I       ..Ahom Vowel Sign Uu
        (0x11727, 0x1172b,),  # Ahom Vowel Sign Aw      ..Ahom Sign Killer
        (0x16af0, 0x16af4,),  # Bassa Vah Combining High..Bassa Vah Combining High
        (0x16b30, 0x16b36,),  # Pahawh Hmong Mark Cim Tu..Pahawh Hmong Mark Cim Ta
        (0x16f8f, 0x16f92,),  # Miao Tone Right         ..Miao Tone Below
        (0x1bc9d, 0x1bc9e,),  # Duployan Thick Letter Se..Duployan Double Mark
        (0x1d167, 0x1d169,),  # Musical Symbol Combining..Musical Symbol Combining
        (0x1d17b, 0x1d182,),  # Musical Symbol Combining..Musical Symbol Combining
        (0x1d185, 0x1d18b,),  # Musical Symbol Combining..Musical Symbol Combining
        (0x1d1aa, 0x1d1ad,),  # Musical Symbol Combining..Musical Symbol Combining
        (0x1d242, 0x1d244,),  # Combining Greek Musical ..Combining Greek Musical
        (0x1da00, 0x1da36,),  # Signwriting Head Rim    ..Signwriting Air Sucking
        (0x1da3b, 0x1da6c,),  # Signwriting Mouth Closed..Signwriting Excitement
        (0x1da75, 0x1da75,),  # Signwriting Upper Body T..Signwriting Upper Body T
        (0x1da84, 0x1da84,),  # Signwriting Location Hea..Signwriting Location Hea
        (0x1da9b, 0x1da9f,),  # Signwriting Fill Modifie..Signwriting Fill Modifie
        (0x1daa1, 0x1daaf,),  # Signwriting Rotation Mod..Signwriting Rotation Mod
        (0x1e8d0, 0x1e8d6,),  # Mende Kikakui Combining ..Mende Kikakui Combining
        (0xe0100, 0xe01ef,),  # Variation Selector-17   ..Variation Selector-256
    ),
    '9.0.0': (
        # Source: DerivedGeneralCategory-9.0.0.txt
        # Date:  2016-06-01, 10:34:26 GMT
        #
        (0x00300, 0x0036f,),  # Combining Grave Accent  ..Combining Latin Small Le
        (0x00483, 0x00489,),  # Combining Cyrillic Titlo..Combining Cyrillic Milli
        (0x00591, 0x005bd,),  # Hebrew Accent Etnahta   ..Hebrew Point Meteg
        (0x005bf, 0x005bf,),  # Hebrew Point Rafe       ..Hebrew Point Rafe
        (0x005c1, 0x005c2,),  # Hebrew Point Shin Dot   ..Hebrew Point Sin Dot
        (0x005c4, 0x005c5,),  # Hebrew Mark Upper Dot   ..Hebrew Mark Lower Dot
        (0x005c7, 0x005c7,),  # Hebrew Point Qamats Qata..Hebrew Point Qamats Qata
        (0x00610, 0x0061a,),  # Arabic Sign Sallallahou ..Arabic Small Kasra
        (0x0064b, 0x0065f,),  # Arabic Fathatan         ..Arabic Wavy Hamza Below
        (0x00670, 0x00670,),  # Arabic Letter Superscrip..Arabic Letter Superscrip
        (0x006d6, 0x006dc,),  # Arabic Small High Ligatu..Arabic Small High Seen
        (0x006df, 0x006e4,),  # Arabic Small High Rounde..Arabic Small High Madda
        (0x006e7, 0x006e8,),  # Arabic Small High Yeh   ..Arabic Small High Noon
        (0x006ea, 0x006ed,),  # Arabic Empty Centre Low ..Arabic Small Low Meem
        (0x00711, 0x00711,),  # Syriac Letter Superscrip..Syriac Letter Superscrip
        (0x00730, 0x0074a,),  # Syriac Pthaha Above     ..Syriac Barrekh
        (0x007a6, 0x007b0,),  # Thaana Abafili          ..Thaana Sukun
        (0x007eb, 0x007f3,),  # Nko Combining Short High..Nko Combining Double Dot
        (0x00816, 0x00819,),  # Samaritan Mark In       ..Samaritan Mark Dagesh
        (0x0081b, 0x00823,),  # Samaritan Mark Epentheti..Samaritan Vowel Sign A
        (0x00825, 0x00827,),  # Samaritan Vowel Sign Sho..Samaritan Vowel Sign U
        (0x00829, 0x0082d,),  # Samaritan Vowel Sign Lon..Samaritan Mark Nequdaa
        (0x00859, 0x0085b,),  # Mandaic Affrication Mark..Mandaic Gemination Mark
        (0x008d4, 0x008e1,),  # Arabic Small High Word A..Arabic Small High Sign S
        (0x008e3, 0x00902,),  # Arabic Turned Damma Belo..Devanagari Sign Anusvara
        (0x0093a, 0x0093a,),  # Devanagari Vowel Sign Oe..Devanagari Vowel Sign Oe
        (0x0093c, 0x0093c,),  # Devanagari Sign Nukta   ..Devanagari Sign Nukta
        (0x00941, 0x00948,),  # Devanagari Vowel Sign U ..Devanagari Vowel Sign Ai
        (0x0094d, 0x0094d,),  # Devanagari Sign Virama  ..Devanagari Sign Virama
        (0x00951, 0x00957,),  # Devanagari Stress Sign U..Devanagari Vowel Sign Uu
        (0x00962, 0x00963,),  # Devanagari Vowel Sign Vo..Devanagari Vowel Sign Vo
        (0x00981, 0x00981,),  # Bengali Sign Candrabindu..Bengali Sign Candrabindu
        (0x009bc, 0x009bc,),  # Bengali Sign Nukta      ..Bengali Sign Nukta
        (0x009c1, 0x009c4,),  # Bengali Vowel Sign U    ..Bengali Vowel Sign Vocal
        (0x009cd, 0x009cd,),  # Bengali Sign Virama     ..Bengali Sign Virama
        (0x009e2, 0x009e3,),  # Bengali Vowel Sign Vocal..Bengali Vowel Sign Vocal
        (0x00a01, 0x00a02,),  # Gurmukhi Sign Adak Bindi..Gurmukhi Sign Bindi
        (0x00a3c, 0x00a3c,),  # Gurmukhi Sign Nukta     ..Gurmukhi Sign Nukta
        (0x00a41, 0x00a42,),  # Gurmukhi Vowel Sign U   ..Gurmukhi Vowel Sign Uu
        (0x00a47, 0x00a48,),  # Gurmukhi Vowel Sign Ee  ..Gurmukhi Vowel Sign Ai
        (0x00a4b, 0x00a4d,),  # Gurmukhi Vowel Sign Oo  ..Gurmukhi Sign Virama
        (0x00a51, 0x00a51,),  # Gurmukhi Sign Udaat     ..Gurmukhi Sign Udaat
        (0x00a70, 0x00a71,),  # Gurmukhi Tippi          ..Gurmukhi Addak
        (0x00a75, 0x00a75,),  # Gurmukhi Sign Yakash    ..Gurmukhi Sign Yakash
        (0x00a81, 0x00a82,),  # Gujarati Sign Candrabind..Gujarati Sign Anusvara
        (0x00abc, 0x00abc,),  # Gujarati Sign Nukta     ..Gujarati Sign Nukta
        (0x00ac1, 0x00ac5,),  # Gujarati Vowel Sign U   ..Gujarati Vowel Sign Cand
        (0x00ac7, 0x00ac8,),  # Gujarati Vowel Sign E   ..Gujarati Vowel Sign Ai
        (0x00acd, 0x00acd,),  # Gujarati Sign Virama    ..Gujarati Sign Virama
        (0x00ae2, 0x00ae3,),  # Gujarati Vowel Sign Voca..Gujarati Vowel Sign Voca
        (0x00b01, 0x00b01,),  # Oriya Sign Candrabindu  ..Oriya Sign Candrabindu
        (0x00b3c, 0x00b3c,),  # Oriya Sign Nukta        ..Oriya Sign Nukta
        (0x00b3f, 0x00b3f,),  # Oriya Vowel Sign I      ..Oriya Vowel Sign I
        (0x00b41, 0x00b44,),  # Oriya Vowel Sign U      ..Oriya Vowel Sign Vocalic
        (0x00b4d, 0x00b4d,),  # Oriya Sign Virama       ..Oriya Sign Virama
        (0x00b56, 0x00b56,),  # Oriya Ai Length Mark    ..Oriya Ai Length Mark
        (0x00b62, 0x00b63,),  # Oriya Vowel Sign Vocalic..Oriya Vowel Sign Vocalic
        (0x00b82, 0x00b82,),  # Tamil Sign Anusvara     ..Tamil Sign Anusvara
        (0x00bc0, 0x00bc0,),  # Tamil Vowel Sign Ii     ..Tamil Vowel Sign Ii
        (0x00bcd, 0x00bcd,),  # Tamil Sign Virama       ..Tamil Sign Virama
        (0x00c00, 0x00c00,),  # Telugu Sign Combining Ca..Telugu Sign Combining Ca
        (0x00c3e, 0x00c40,),  # Telugu Vowel Sign Aa    ..Telugu Vowel Sign Ii
        (0x00c46, 0x00c48,),  # Telugu Vowel Sign E     ..Telugu Vowel Sign Ai
        (0x00c4a, 0x00c4d,),  # Telugu Vowel Sign O     ..Telugu Sign Virama
        (0x00c55, 0x00c56,),  # Telugu Length Mark      ..Telugu Ai Length Mark
        (0x00c62, 0x00c63,),  # Telugu Vowel Sign Vocali..Telugu Vowel Sign Vocali
        (0x00c81, 0x00c81,),  # Kannada Sign Candrabindu..Kannada Sign Candrabindu
        (0x00cbc, 0x00cbc,),  # Kannada Sign Nukta      ..Kannada Sign Nukta
        (0x00cbf, 0x00cbf,),  # Kannada Vowel Sign I    ..Kannada Vowel Sign I
        (0x00cc6, 0x00cc6,),  # Kannada Vowel Sign E    ..Kannada Vowel Sign E
        (0x00ccc, 0x00ccd,),  # Kannada Vowel Sign Au   ..Kannada Sign Virama
        (0x00ce2, 0x00ce3,),  # Kannada Vowel Sign Vocal..Kannada Vowel Sign Vocal
        (0x00d01, 0x00d01,),  # Malayalam Sign Candrabin..Malayalam Sign Candrabin
        (0x00d41, 0x00d44,),  # Malayalam Vowel Sign U  ..Malayalam Vowel Sign Voc
        (0x00d4d, 0x00d4d,),  # Malayalam Sign Virama   ..Malayalam Sign Virama
        (0x00d62, 0x00d63,),  # Malayalam Vowel Sign Voc..Malayalam Vowel Sign Voc
        (0x00dca, 0x00dca,),  # Sinhala Sign Al-lakuna  ..Sinhala Sign Al-lakuna
        (0x00dd2, 0x00dd4,),  # Sinhala Vowel Sign Ketti..Sinhala Vowel Sign Ketti
        (0x00dd6, 0x00dd6,),  # Sinhala Vowel Sign Diga ..Sinhala Vowel Sign Diga
        (0x00e31, 0x00e31,),  # Thai Character Mai Han-a..Thai Character Mai Han-a
        (0x00e34, 0x00e3a,),  # Thai Character Sara I   ..Thai Character Phinthu
        (0x00e47, 0x00e4e,),  # Thai Character Maitaikhu..Thai Character Yamakkan
        (0x00eb1, 0x00eb1,),  # Lao Vowel Sign Mai Kan  ..Lao Vowel Sign Mai Kan
        (0x00eb4, 0x00eb9,),  # Lao Vowel Sign I        ..Lao Vowel Sign Uu
        (0x00ebb, 0x00ebc,),  # Lao Vowel Sign Mai Kon  ..Lao Semivowel Sign Lo
        (0x00ec8, 0x00ecd,),  # Lao Tone Mai Ek         ..Lao Niggahita
        (0x00f18, 0x00f19,),  # Tibetan Astrological Sig..Tibetan Astrological Sig
        (0x00f35, 0x00f35,),  # Tibetan Mark Ngas Bzung ..Tibetan Mark Ngas Bzung
        (0x00f37, 0x00f37,),  # Tibetan Mark Ngas Bzung ..Tibetan Mark Ngas Bzung
        (0x00f39, 0x00f39,),  # Tibetan Mark Tsa -phru  ..Tibetan Mark Tsa -phru
        (0x00f71, 0x00f7e,),  # Tibetan Vowel Sign Aa   ..Tibetan Sign Rjes Su Nga
        (0x00f80, 0x00f84,),  # Tibetan Vowel Sign Rever..Tibetan Mark Halanta
        (0x00f86, 0x00f87,),  # Tibetan Sign Lci Rtags  ..Tibetan Sign Yang Rtags
        (0x00f8d, 0x00f97,),  # Tibetan Subjoined Sign L..Tibetan Subjoined Letter
        (0x00f99, 0x00fbc,),  # Tibetan Subjoined Letter..Tibetan Subjoined Letter
        (0x00fc6, 0x00fc6,),  # Tibetan Symbol Padma Gda..Tibetan Symbol Padma Gda
        (0x0102d, 0x01030,),  # Myanmar Vowel Sign I    ..Myanmar Vowel Sign Uu
        (0x01032, 0x01037,),  # Myanmar Vowel Sign Ai   ..Myanmar Sign Dot Below
        (0x01039, 0x0103a,),  # Myanmar Sign Virama     ..Myanmar Sign Asat
        (0x0103d, 0x0103e,),  # Myanmar Consonant Sign M..Myanmar Consonant Sign M
        (0x01058, 0x01059,),  # Myanmar Vowel Sign Vocal..Myanmar Vowel Sign Vocal
        (0x0105e, 0x01060,),  # Myanmar Consonant Sign M..Myanmar Consonant Sign M
        (0x01071, 0x01074,),  # Myanmar Vowel Sign Geba ..Myanmar Vowel Sign Kayah
        (0x01082, 0x01082,),  # Myanmar Consonant Sign S..Myanmar Consonant Sign S
        (0x01085, 0x01086,),  # Myanmar Vowel Sign Shan ..Myanmar Vowel Sign Shan
        (0x0108d, 0x0108d,),  # Myanmar Sign Shan Counci..Myanmar Sign Shan Counci
        (0x0109d, 0x0109d,),  # Myanmar Vowel Sign Aiton..Myanmar Vowel Sign Aiton
        (0x0135d, 0x0135f,),  # Ethiopic Combining Gemin..Ethiopic Combining Gemin
        (0x01712, 0x01714,),  # Tagalog Vowel Sign I    ..Tagalog Sign Virama
        (0x01732, 0x01734,),  # Hanunoo Vowel Sign I    ..Hanunoo Sign Pamudpod
        (0x01752, 0x01753,),  # Buhid Vowel Sign I      ..Buhid Vowel Sign U
        (0x01772, 0x01773,),  # Tagbanwa Vowel Sign I   ..Tagbanwa Vowel Sign U
        (0x017b4, 0x017b5,),  # Khmer Vowel Inherent Aq ..Khmer Vowel Inherent Aa
        (0x017b7, 0x017bd,),  # Khmer Vowel Sign I      ..Khmer Vowel Sign Ua
        (0x017c6, 0x017c6,),  # Khmer Sign Nikahit      ..Khmer Sign Nikahit
        (0x017c9, 0x017d3,),  # Khmer Sign Muusikatoan  ..Khmer Sign Bathamasat
        (0x017dd, 0x017dd,),  # Khmer Sign Atthacan     ..Khmer Sign Atthacan
        (0x0180b, 0x0180d,),  # Mongolian Free Variation..Mongolian Free Variation
        (0x01885, 0x01886,),  # Mongolian Letter Ali Gal..Mongolian Letter Ali Gal
        (0x018a9, 0x018a9,),  # Mongolian Letter Ali Gal..Mongolian Letter Ali Gal
        (0x01920, 0x01922,),  # Limbu Vowel Sign A      ..Limbu Vowel Sign U
        (0x01927, 0x01928,),  # Limbu Vowel Sign E      ..Limbu Vowel Sign O
        (0x01932, 0x01932,),  # Limbu Small Letter Anusv..Limbu Small Letter Anusv
        (0x01939, 0x0193b,),  # Limbu Sign Mukphreng    ..Limbu Sign Sa-i
        (0x01a17, 0x01a18,),  # Buginese Vowel Sign I   ..Buginese Vowel Sign U
        (0x01a1b, 0x01a1b,),  # Buginese Vowel Sign Ae  ..Buginese Vowel Sign Ae
        (0x01a56, 0x01a56,),  # Tai Tham Consonant Sign ..Tai Tham Consonant Sign
        (0x01a58, 0x01a5e,),  # Tai Tham Sign Mai Kang L..Tai Tham Consonant Sign
        (0x01a60, 0x01a60,),  # Tai Tham Sign Sakot     ..Tai Tham Sign Sakot
        (0x01a62, 0x01a62,),  # Tai Tham Vowel Sign Mai ..Tai Tham Vowel Sign Mai
        (0x01a65, 0x01a6c,),  # Tai Tham Vowel Sign I   ..Tai Tham Vowel Sign Oa B
        (0x01a73, 0x01a7c,),  # Tai Tham Vowel Sign Oa A..Tai Tham Sign Khuen-lue
        (0x01a7f, 0x01a7f,),  # Tai Tham Combining Crypt..Tai Tham Combining Crypt
        (0x01ab0, 0x01abe,),  # Combining Doubled Circum..Combining Parentheses Ov
        (0x01b00, 0x01b03,),  # Balinese Sign Ulu Ricem ..Balinese Sign Surang
        (0x01b34, 0x01b34,),  # Balinese Sign Rerekan   ..Balinese Sign Rerekan
        (0x01b36, 0x01b3a,),  # Balinese Vowel Sign Ulu ..Balinese Vowel Sign Ra R
        (0x01b3c, 0x01b3c,),  # Balinese Vowel Sign La L..Balinese Vowel Sign La L
        (0x01b42, 0x01b42,),  # Balinese Vowel Sign Pepe..Balinese Vowel Sign Pepe
        (0x01b6b, 0x01b73,),  # Balinese Musical Symbol ..Balinese Musical Symbol
        (0x01b80, 0x01b81,),  # Sundanese Sign Panyecek ..Sundanese Sign Panglayar
        (0x01ba2, 0x01ba5,),  # Sundanese Consonant Sign..Sundanese Vowel Sign Pan
        (0x01ba8, 0x01ba9,),  # Sundanese Vowel Sign Pam..Sundanese Vowel Sign Pan
        (0x01bab, 0x01bad,),  # Sundanese Sign Virama   ..Sundanese Consonant Sign
        (0x01be6, 0x01be6,),  # Batak Sign Tompi        ..Batak Sign Tompi
        (0x01be8, 0x01be9,),  # Batak Vowel Sign Pakpak ..Batak Vowel Sign Ee
        (0x01bed, 0x01bed,),  # Batak Vowel Sign Karo O ..Batak Vowel Sign Karo O
        (0x01bef, 0x01bf1,),  # Batak Vowel Sign U For S..Batak Consonant Sign H
        (0x01c2c, 0x01c33,),  # Lepcha Vowel Sign E     ..Lepcha Consonant Sign T
        (0x01c36, 0x01c37,),  # Lepcha Sign Ran         ..Lepcha Sign Nukta
        (0x01cd0, 0x01cd2,),  # Vedic Tone Karshana     ..Vedic Tone Prenkha
        (0x01cd4, 0x01ce0,),  # Vedic Sign Yajurvedic Mi..Vedic Tone Rigvedic Kash
        (0x01ce2, 0x01ce8,),  # Vedic Sign Visarga Svari..Vedic Sign Visarga Anuda
        (0x01ced, 0x01ced,),  # Vedic Sign Tiryak       ..Vedic Sign Tiryak
        (0x01cf4, 0x01cf4,),  # Vedic Tone Candra Above ..Vedic Tone Candra Above
        (0x01cf8, 0x01cf9,),  # Vedic Tone Ring Above   ..Vedic Tone Double Ring A
        (0x01dc0, 0x01df5,),  # Combining Dotted Grave A..Combining Up Tack Above
        (0x01dfb, 0x01dff,),  # Combining Deletion Mark ..Combining Right Arrowhea
        (0x020d0, 0x020f0,),  # Combining Left Harpoon A..Combining Asterisk Above
        (0x02cef, 0x02cf1,),  # Coptic Combining Ni Abov..Coptic Combining Spiritu
        (0x02d7f, 0x02d7f,),  # Tifinagh Consonant Joine..Tifinagh Consonant Joine
        (0x02de0, 0x02dff,),  # Combining Cyrillic Lette..Combining Cyrillic Lette
        (0x0302a, 0x0302d,),  # Ideographic Level Tone M..Ideographic Entering Ton
        (0x03099, 0x0309a,),  # Combining Katakana-hirag..Combining Katakana-hirag
        (0x0a66f, 0x0a672,),  # Combining Cyrillic Vzmet..Combining Cyrillic Thous
        (0x0a674, 0x0a67d,),  # Combining Cyrillic Lette..Combining Cyrillic Payer
        (0x0a69e, 0x0a69f,),  # Combining Cyrillic Lette..Combining Cyrillic Lette
        (0x0a6f0, 0x0a6f1,),  # Bamum Combining Mark Koq..Bamum Combining Mark Tuk
        (0x0a802, 0x0a802,),  # Syloti Nagri Sign Dvisva..Syloti Nagri Sign Dvisva
        (0x0a806, 0x0a806,),  # Syloti Nagri Sign Hasant..Syloti Nagri Sign Hasant
        (0x0a80b, 0x0a80b,),  # Syloti Nagri Sign Anusva..Syloti Nagri Sign Anusva
        (0x0a825, 0x0a826,),  # Syloti Nagri Vowel Sign ..Syloti Nagri Vowel Sign
        (0x0a8c4, 0x0a8c5,),  # Saurashtra Sign Virama  ..Saurashtra Sign Candrabi
        (0x0a8e0, 0x0a8f1,),  # Combining Devanagari Dig..Combining Devanagari Sig
        (0x0a926, 0x0a92d,),  # Kayah Li Vowel Ue       ..Kayah Li Tone Calya Plop
        (0x0a947, 0x0a951,),  # Rejang Vowel Sign I     ..Rejang Consonant Sign R
        (0x0a980, 0x0a982,),  # Javanese Sign Panyangga ..Javanese Sign Layar
        (0x0a9b3, 0x0a9b3,),  # Javanese Sign Cecak Telu..Javanese Sign Cecak Telu
        (0x0a9b6, 0x0a9b9,),  # Javanese Vowel Sign Wulu..Javanese Vowel Sign Suku
        (0x0a9bc, 0x0a9bc,),  # Javanese Vowel Sign Pepe..Javanese Vowel Sign Pepe
        (0x0a9e5, 0x0a9e5,),  # Myanmar Sign Shan Saw   ..Myanmar Sign Shan Saw
        (0x0aa29, 0x0aa2e,),  # Cham Vowel Sign Aa      ..Cham Vowel Sign Oe
        (0x0aa31, 0x0aa32,),  # Cham Vowel Sign Au      ..Cham Vowel Sign Ue
        (0x0aa35, 0x0aa36,),  # Cham Consonant Sign La  ..Cham Consonant Sign Wa
        (0x0aa43, 0x0aa43,),  # Cham Consonant Sign Fina..Cham Consonant Sign Fina
        (0x0aa4c, 0x0aa4c,),  # Cham Consonant Sign Fina..Cham Consonant Sign Fina
        (0x0aa7c, 0x0aa7c,),  # Myanmar Sign Tai Laing T..Myanmar Sign Tai Laing T
        (0x0aab0, 0x0aab0,),  # Tai Viet Mai Kang       ..Tai Viet Mai Kang
        (0x0aab2, 0x0aab4,),  # Tai Viet Vowel I        ..Tai Viet Vowel U
        (0x0aab7, 0x0aab8,),  # Tai Viet Mai Khit       ..Tai Viet Vowel Ia
        (0x0aabe, 0x0aabf,),  # Tai Viet Vowel Am       ..Tai Viet Tone Mai Ek
        (0x0aac1, 0x0aac1,),  # Tai Viet Tone Mai Tho   ..Tai Viet Tone Mai Tho
        (0x0aaec, 0x0aaed,),  # Meetei Mayek Vowel Sign ..Meetei Mayek Vowel Sign
        (0x0aaf6, 0x0aaf6,),  # Meetei Mayek Virama     ..Meetei Mayek Virama
        (0x0abe5, 0x0abe5,),  # Meetei Mayek Vowel Sign ..Meetei Mayek Vowel Sign
        (0x0abe8, 0x0abe8,),  # Meetei Mayek Vowel Sign ..Meetei Mayek Vowel Sign
        (0x0abed, 0x0abed,),  # Meetei Mayek Apun Iyek  ..Meetei Mayek Apun Iyek
        (0x0fb1e, 0x0fb1e,),  # Hebrew Point Judeo-spani..Hebrew Point Judeo-spani
        (0x0fe00, 0x0fe0f,),  # Variation Selector-1    ..Variation Selector-16
        (0x0fe20, 0x0fe2f,),  # Combining Ligature Left ..Combining Cyrillic Titlo
        (0x101fd, 0x101fd,),  # Phaistos Disc Sign Combi..Phaistos Disc Sign Combi
        (0x102e0, 0x102e0,),  # Coptic Epact Thousands M..Coptic Epact Thousands M
        (0x10376, 0x1037a,),  # Combining Old Permic Let..Combining Old Permic Let
        (0x10a01, 0x10a03,),  # Kharoshthi Vowel Sign I ..Kharoshthi Vowel Sign Vo
        (0x10a05, 0x10a06,),  # Kharoshthi Vowel Sign E ..Kharoshthi Vowel Sign O
        (0x10a0c, 0x10a0f,),  # Kharoshthi Vowel Length ..Kharoshthi Sign Visarga
        (0x10a38, 0x10a3a,),  # Kharoshthi Sign Bar Abov..Kharoshthi Sign Dot Belo
        (0x10a3f, 0x10a3f,),  # Kharoshthi Virama       ..Kharoshthi Virama
        (0x10ae5, 0x10ae6,),  # Manichaean Abbreviation ..Manichaean Abbreviation
        (0x11001, 0x11001,),  # Brahmi Sign Anusvara    ..Brahmi Sign Anusvara
        (0x11038, 0x11046,),  # Brahmi Vowel Sign Aa    ..Brahmi Virama
        (0x1107f, 0x11081,),  # Brahmi Number Joiner    ..Kaithi Sign Anusvara
        (0x110b3, 0x110b6,),  # Kaithi Vowel Sign U     ..Kaithi Vowel Sign Ai
        (0x110b9, 0x110ba,),  # Kaithi Sign Virama      ..Kaithi Sign Nukta
        (0x11100, 0x11102,),  # Chakma Sign Candrabindu ..Chakma Sign Visarga
        (0x11127, 0x1112b,),  # Chakma Vowel Sign A     ..Chakma Vowel Sign Uu
        (0x1112d, 0x11134,),  # Chakma Vowel Sign Ai    ..Chakma Maayyaa
        (0x11173, 0x11173,),  # Mahajani Sign Nukta     ..Mahajani Sign Nukta
        (0x11180, 0x11181,),  # Sharada Sign Candrabindu..Sharada Sign Anusvara
        (0x111b6, 0x111be,),  # Sharada Vowel Sign U    ..Sharada Vowel Sign O
        (0x111ca, 0x111cc,),  # Sharada Sign Nukta      ..Sharada Extra Short Vowe
        (0x1122f, 0x11231,),  # Khojki Vowel Sign U     ..Khojki Vowel Sign Ai
        (0x11234, 0x11234,),  # Khojki Sign Anusvara    ..Khojki Sign Anusvara
        (0x11236, 0x11237,),  # Khojki Sign Nukta       ..Khojki Sign Shadda
        (0x1123e, 0x1123e,),  # Khojki Sign Sukun       ..Khojki Sign Sukun
        (0x112df, 0x112df,),  # Khudawadi Sign Anusvara ..Khudawadi Sign Anusvara
        (0x112e3, 0x112ea,),  # Khudawadi Vowel Sign U  ..Khudawadi Sign Virama
        (0x11300, 0x11301,),  # Grantha Sign Combining A..Grantha Sign Candrabindu
        (0x1133c, 0x1133c,),  # Grantha Sign Nukta      ..Grantha Sign Nukta
        (0x11340, 0x11340,),  # Grantha Vowel Sign Ii   ..Grantha Vowel Sign Ii
        (0x11366, 0x1136c,),  # Combining Grantha Digit ..Combining Grantha Digit
        (0x11370, 0x11374,),  # Combining Grantha Letter..Combining Grantha Letter
        (0x11438, 0x1143f,),  # Newa Vowel Sign U       ..Newa Vowel Sign Ai
        (0x11442, 0x11444,),  # Newa Sign Virama        ..Newa Sign Anusvara
        (0x11446, 0x11446,),  # Newa Sign Nukta         ..Newa Sign Nukta
        (0x114b3, 0x114b8,),  # Tirhuta Vowel Sign U    ..Tirhuta Vowel Sign Vocal
        (0x114ba, 0x114ba,),  # Tirhuta Vowel Sign Short..Tirhuta Vowel Sign Short
        (0x114bf, 0x114c0,),  # Tirhuta Sign Candrabindu..Tirhuta Sign Anusvara
        (0x114c2, 0x114c3,),  # Tirhuta Sign Virama     ..Tirhuta Sign Nukta
        (0x115b2, 0x115b5,),  # Siddham Vowel Sign U    ..Siddham Vowel Sign Vocal
        (0x115bc, 0x115bd,),  # Siddham Sign Candrabindu..Siddham Sign Anusvara
        (0x115bf, 0x115c0,),  # Siddham Sign Virama     ..Siddham Sign Nukta
        (0x115dc, 0x115dd,),  # Siddham Vowel Sign Alter..Siddham Vowel Sign Alter
        (0x11633, 0x1163a,),  # Modi Vowel Sign U       ..Modi Vowel Sign Ai
        (0x1163d, 0x1163d,),  # Modi Sign Anusvara      ..Modi Sign Anusvara
        (0x1163f, 0x11640,),  # Modi Sign Virama        ..Modi Sign Ardhacandra
        (0x116ab, 0x116ab,),  # Takri Sign Anusvara     ..Takri Sign Anusvara
        (0x116ad, 0x116ad,),  # Takri Vowel Sign Aa     ..Takri Vowel Sign Aa
        (0x116b0, 0x116b5,),  # Takri Vowel Sign U      ..Takri Vowel Sign Au
        (0x116b7, 0x116b7,),  # Takri Sign Nukta        ..Takri Sign Nukta
        (0x1171d, 0x1171f,),  # Ahom Consonant Sign Medi..Ahom Consonant Sign Medi
        (0x11722, 0x11725,),  # Ahom Vowel Sign I       ..Ahom Vowel Sign Uu
        (0x11727, 0x1172b,),  # Ahom Vowel Sign Aw      ..Ahom Sign Killer
        (0x11c30, 0x11c36,),  # Bhaiksuki Vowel Sign I  ..Bhaiksuki Vowel Sign Voc
        (0x11c38, 0x11c3d,),  # Bhaiksuki Vowel Sign E  ..Bhaiksuki Sign Anusvara
        (0x11c3f, 0x11c3f,),  # Bhaiksuki Sign Virama   ..Bhaiksuki Sign Virama
        (0x11c92, 0x11ca7,),  # Marchen Subjoined Letter..Marchen Subjoined Letter
        (0x11caa, 0x11cb0,),  # Marchen Subjoined Letter..Marchen Vowel Sign Aa
        (0x11cb2, 0x11cb3,),  # Marchen Vowel Sign U    ..Marchen Vowel Sign E
        (0x11cb5, 0x11cb6,),  # Marchen Sign Anusvara   ..Marchen Sign Candrabindu
        (0x16af0, 0x16af4,),  # Bassa Vah Combining High..Bassa Vah Combining High
        (0x16b30, 0x16b36,),  # Pahawh Hmong Mark Cim Tu..Pahawh Hmong Mark Cim Ta
        (0x16f8f, 0x16f92,),  # Miao Tone Right         ..Miao Tone Below
        (0x1bc9d, 0x1bc9e,),  # Duployan Thick Letter Se..Duployan Double Mark
        (0x1d167, 0x1d169,),  # Musical Symbol Combining..Musical Symbol Combining
        (0x1d17b, 0x1d182,),  # Musical Symbol Combining..Musical Symbol Combining
        (0x1d185, 0x1d18b,),  # Musical Symbol Combining..Musical Symbol Combining
        (0x1d1aa, 0x1d1ad,),  # Musical Symbol Combining..Musical Symbol Combining
        (0x1d242, 0x1d244,),  # Combining Greek Musical ..Combining Greek Musical
        (0x1da00, 0x1da36,),  # Signwriting Head Rim    ..Signwriting Air Sucking
        (0x1da3b, 0x1da6c,),  # Signwriting Mouth Closed..Signwriting Excitement
        (0x1da75, 0x1da75,),  # Signwriting Upper Body T..Signwriting Upper Body T
        (0x1da84, 0x1da84,),  # Signwriting Location Hea..Signwriting Location Hea
        (0x1da9b, 0x1da9f,),  # Signwriting Fill Modifie..Signwriting Fill Modifie
        (0x1daa1, 0x1daaf,),  # Signwriting Rotation Mod..Signwriting Rotation Mod
        (0x1e000, 0x1e006,),  # Combining Glagolitic Let..Combining Glagolitic Let
        (0x1e008, 0x1e018,),  # Combining Glagolitic Let..Combining Glagolitic Let
        (0x1e01b, 0x1e021,),  # Combining Glagolitic Let..Combining Glagolitic Let
        (0x1e023, 0x1e024,),  # Combining Glagolitic Let..Combining Glagolitic Let
        (0x1e026, 0x1e02a,),  # Combining Glagolitic Let..Combining Glagolitic Let
        (0x1e8d0, 0x1e8d6,),  # Mende Kikakui Combining ..Mende Kikakui Combining
        (0x1e944, 0x1e94a,),  # Adlam Alif Lengthener   ..Adlam Nukta
        (0xe0100, 0xe01ef,),  # Variation Selector-17   ..Variation Selector-256
    ),
    '10.0.0': (
        # Source: DerivedGeneralCategory-10.0.0.txt
        # Date:  2017-03-08, 08:41:49 GMT
        #
        (0x00300, 0x0036f,),  # Combining Grave Accent  ..Combining Latin Small Le
        (0x00483, 0x00489,),  # Combining Cyrillic Titlo..Combining Cyrillic Milli
        (0x00591, 0x005bd,),  # Hebrew Accent Etnahta   ..Hebrew Point Meteg
        (0x005bf, 0x005bf,),  # Hebrew Point Rafe       ..Hebrew Point Rafe
        (0x005c1, 0x005c2,),  # Hebrew Point Shin Dot   ..Hebrew Point Sin Dot
        (0x005c4, 0x005c5,),  # Hebrew Mark Upper Dot   ..Hebrew Mark Lower Dot
        (0x005c7, 0x005c7,),  # Hebrew Point Qamats Qata..Hebrew Point Qamats Qata
        (0x00610, 0x0061a,),  # Arabic Sign Sallallahou ..Arabic Small Kasra
        (0x0064b, 0x0065f,),  # Arabic Fathatan         ..Arabic Wavy Hamza Below
        (0x00670, 0x00670,),  # Arabic Letter Superscrip..Arabic Letter Superscrip
        (0x006d6, 0x006dc,),  # Arabic Small High Ligatu..Arabic Small High Seen
        (0x006df, 0x006e4,),  # Arabic Small High Rounde..Arabic Small High Madda
        (0x006e7, 0x006e8,),  # Arabic Small High Yeh   ..Arabic Small High Noon
        (0x006ea, 0x006ed,),  # Arabic Empty Centre Low ..Arabic Small Low Meem
        (0x00711, 0x00711,),  # Syriac Letter Superscrip..Syriac Letter Superscrip
        (0x00730, 0x0074a,),  # Syriac Pthaha Above     ..Syriac Barrekh
        (0x007a6, 0x007b0,),  # Thaana Abafili          ..Thaana Sukun
        (0x007eb, 0x007f3,),  # Nko Combining Short High..Nko Combining Double Dot
        (0x00816, 0x00819,),  # Samaritan Mark In       ..Samaritan Mark Dagesh
        (0x0081b, 0x00823,),  # Samaritan Mark Epentheti..Samaritan Vowel Sign A
        (0x00825, 0x00827,),  # Samaritan Vowel Sign Sho..Samaritan Vowel Sign U
        (0x00829, 0x0082d,),  # Samaritan Vowel Sign Lon..Samaritan Mark Nequdaa
        (0x00859, 0x0085b,),  # Mandaic Affrication Mark..Mandaic Gemination Mark
        (0x008d4, 0x008e1,),  # Arabic Small High Word A..Arabic Small High Sign S
        (0x008e3, 0x00902,),  # Arabic Turned Damma Belo..Devanagari Sign Anusvara
        (0x0093a, 0x0093a,),  # Devanagari Vowel Sign Oe..Devanagari Vowel Sign Oe
        (0x0093c, 0x0093c,),  # Devanagari Sign Nukta   ..Devanagari Sign Nukta
        (0x00941, 0x00948,),  # Devanagari Vowel Sign U ..Devanagari Vowel Sign Ai
        (0x0094d, 0x0094d,),  # Devanagari Sign Virama  ..Devanagari Sign Virama
        (0x00951, 0x00957,),  # Devanagari Stress Sign U..Devanagari Vowel Sign Uu
        (0x00962, 0x00963,),  # Devanagari Vowel Sign Vo..Devanagari Vowel Sign Vo
        (0x00981, 0x00981,),  # Bengali Sign Candrabindu..Bengali Sign Candrabindu
        (0x009bc, 0x009bc,),  # Bengali Sign Nukta      ..Bengali Sign Nukta
        (0x009c1, 0x009c4,),  # Bengali Vowel Sign U    ..Bengali Vowel Sign Vocal
        (0x009cd, 0x009cd,),  # Bengali Sign Virama     ..Bengali Sign Virama
        (0x009e2, 0x009e3,),  # Bengali Vowel Sign Vocal..Bengali Vowel Sign Vocal
        (0x00a01, 0x00a02,),  # Gurmukhi Sign Adak Bindi..Gurmukhi Sign Bindi
        (0x00a3c, 0x00a3c,),  # Gurmukhi Sign Nukta     ..Gurmukhi Sign Nukta
        (0x00a41, 0x00a42,),  # Gurmukhi Vowel Sign U   ..Gurmukhi Vowel Sign Uu
        (0x00a47, 0x00a48,),  # Gurmukhi Vowel Sign Ee  ..Gurmukhi Vowel Sign Ai
        (0x00a4b, 0x00a4d,),  # Gurmukhi Vowel Sign Oo  ..Gurmukhi Sign Virama
        (0x00a51, 0x00a51,),  # Gurmukhi Sign Udaat     ..Gurmukhi Sign Udaat
        (0x00a70, 0x00a71,),  # Gurmukhi Tippi          ..Gurmukhi Addak
        (0x00a75, 0x00a75,),  # Gurmukhi Sign Yakash    ..Gurmukhi Sign Yakash
        (0x00a81, 0x00a82,),  # Gujarati Sign Candrabind..Gujarati Sign Anusvara
        (0x00abc, 0x00abc,),  # Gujarati Sign Nukta     ..Gujarati Sign Nukta
        (0x00ac1, 0x00ac5,),  # Gujarati Vowel Sign U   ..Gujarati Vowel Sign Cand
        (0x00ac7, 0x00ac8,),  # Gujarati Vowel Sign E   ..Gujarati Vowel Sign Ai
        (0x00acd, 0x00acd,),  # Gujarati Sign Virama    ..Gujarati Sign Virama
        (0x00ae2, 0x00ae3,),  # Gujarati Vowel Sign Voca..Gujarati Vowel Sign Voca
        (0x00afa, 0x00aff,),  # Gujarati Sign Sukun     ..Gujarati Sign Two-circle
        (0x00b01, 0x00b01,),  # Oriya Sign Candrabindu  ..Oriya Sign Candrabindu
        (0x00b3c, 0x00b3c,),  # Oriya Sign Nukta        ..Oriya Sign Nukta
        (0x00b3f, 0x00b3f,),  # Oriya Vowel Sign I      ..Oriya Vowel Sign I
        (0x00b41, 0x00b44,),  # Oriya Vowel Sign U      ..Oriya Vowel Sign Vocalic
        (0x00b4d, 0x00b4d,),  # Oriya Sign Virama       ..Oriya Sign Virama
        (0x00b56, 0x00b56,),  # Oriya Ai Length Mark    ..Oriya Ai Length Mark
        (0x00b62, 0x00b63,),  # Oriya Vowel Sign Vocalic..Oriya Vowel Sign Vocalic
        (0x00b82, 0x00b82,),  # Tamil Sign Anusvara     ..Tamil Sign Anusvara
        (0x00bc0, 0x00bc0,),  # Tamil Vowel Sign Ii     ..Tamil Vowel Sign Ii
        (0x00bcd, 0x00bcd,),  # Tamil Sign Virama       ..Tamil Sign Virama
        (0x00c00, 0x00c00,),  # Telugu Sign Combining Ca..Telugu Sign Combining Ca
        (0x00c3e, 0x00c40,),  # Telugu Vowel Sign Aa    ..Telugu Vowel Sign Ii
        (0x00c46, 0x00c48,),  # Telugu Vowel Sign E     ..Telugu Vowel Sign Ai
        (0x00c4a, 0x00c4d,),  # Telugu Vowel Sign O     ..Telugu Sign Virama
        (0x00c55, 0x00c56,),  # Telugu Length Mark      ..Telugu Ai Length Mark
        (0x00c62, 0x00c63,),  # Telugu Vowel Sign Vocali..Telugu Vowel Sign Vocali
        (0x00c81, 0x00c81,),  # Kannada Sign Candrabindu..Kannada Sign Candrabindu
        (0x00cbc, 0x00cbc,),  # Kannada Sign Nukta      ..Kannada Sign Nukta
        (0x00cbf, 0x00cbf,),  # Kannada Vowel Sign I    ..Kannada Vowel Sign I
        (0x00cc6, 0x00cc6,),  # Kannada Vowel Sign E    ..Kannada Vowel Sign E
        (0x00ccc, 0x00ccd,),  # Kannada Vowel Sign Au   ..Kannada Sign Virama
        (0x00ce2, 0x00ce3,),  # Kannada Vowel Sign Vocal..Kannada Vowel Sign Vocal
        (0x00d00, 0x00d01,),  # Malayalam Sign Combining..Malayalam Sign Candrabin
        (0x00d3b, 0x00d3c,),  # Malayalam Sign Vertical ..Malayalam Sign Circular
        (0x00d41, 0x00d44,),  # Malayalam Vowel Sign U  ..Malayalam Vowel Sign Voc
        (0x00d4d, 0x00d4d,),  # Malayalam Sign Virama   ..Malayalam Sign Virama
        (0x00d62, 0x00d63,),  # Malayalam Vowel Sign Voc..Malayalam Vowel Sign Voc
        (0x00dca, 0x00dca,),  # Sinhala Sign Al-lakuna  ..Sinhala Sign Al-lakuna
        (0x00dd2, 0x00dd4,),  # Sinhala Vowel Sign Ketti..Sinhala Vowel Sign Ketti
        (0x00dd6, 0x00dd6,),  # Sinhala Vowel Sign Diga ..Sinhala Vowel Sign Diga
        (0x00e31, 0x00e31,),  # Thai Character Mai Han-a..Thai Character Mai Han-a
        (0x00e34, 0x00e3a,),  # Thai Character Sara I   ..Thai Character Phinthu
        (0x00e47, 0x00e4e,),  # Thai Character Maitaikhu..Thai Character Yamakkan
        (0x00eb1, 0x00eb1,),  # Lao Vowel Sign Mai Kan  ..Lao Vowel Sign Mai Kan
        (0x00eb4, 0x00eb9,),  # Lao Vowel Sign I        ..Lao Vowel Sign Uu
        (0x00ebb, 0x00ebc,),  # Lao Vowel Sign Mai Kon  ..Lao Semivowel Sign Lo
        (0x00ec8, 0x00ecd,),  # Lao Tone Mai Ek         ..Lao Niggahita
        (0x00f18, 0x00f19,),  # Tibetan Astrological Sig..Tibetan Astrological Sig
        (0x00f35, 0x00f35,),  # Tibetan Mark Ngas Bzung ..Tibetan Mark Ngas Bzung
        (0x00f37, 0x00f37,),  # Tibetan Mark Ngas Bzung ..Tibetan Mark Ngas Bzung
        (0x00f39, 0x00f39,),  # Tibetan Mark Tsa -phru  ..Tibetan Mark Tsa -phru
        (0x00f71, 0x00f7e,),  # Tibetan Vowel Sign Aa   ..Tibetan Sign Rjes Su Nga
        (0x00f80, 0x00f84,),  # Tibetan Vowel Sign Rever..Tibetan Mark Halanta
        (0x00f86, 0x00f87,),  # Tibetan Sign Lci Rtags  ..Tibetan Sign Yang Rtags
        (0x00f8d, 0x00f97,),  # Tibetan Subjoined Sign L..Tibetan Subjoined Letter
        (0x00f99, 0x00fbc,),  # Tibetan Subjoined Letter..Tibetan Subjoined Letter
        (0x00fc6, 0x00fc6,),  # Tibetan Symbol Padma Gda..Tibetan Symbol Padma Gda
        (0x0102d, 0x01030,),  # Myanmar Vowel Sign I    ..Myanmar Vowel Sign Uu
        (0x01032, 0x01037,),  # Myanmar Vowel Sign Ai   ..Myanmar Sign Dot Below
        (0x01039, 0x0103a,),  # Myanmar Sign Virama     ..Myanmar Sign Asat
        (0x0103d, 0x0103e,),  # Myanmar Consonant Sign M..Myanmar Consonant Sign M
        (0x01058, 0x01059,),  # Myanmar Vowel Sign Vocal..Myanmar Vowel Sign Vocal
        (0x0105e, 0x01060,),  # Myanmar Consonant Sign M..Myanmar Consonant Sign M
        (0x01071, 0x01074,),  # Myanmar Vowel Sign Geba ..Myanmar Vowel Sign Kayah
        (0x01082, 0x01082,),  # Myanmar Consonant Sign S..Myanmar Consonant Sign S
        (0x01085, 0x01086,),  # Myanmar Vowel Sign Shan ..Myanmar Vowel Sign Shan
        (0x0108d, 0x0108d,),  # Myanmar Sign Shan Counci..Myanmar Sign Shan Counci
        (0x0109d, 0x0109d,),  # Myanmar Vowel Sign Aiton..Myanmar Vowel Sign Aiton
        (0x0135d, 0x0135f,),  # Ethiopic Combining Gemin..Ethiopic Combining Gemin
        (0x01712, 0x01714,),  # Tagalog Vowel Sign I    ..Tagalog Sign Virama
        (0x01732, 0x01734,),  # Hanunoo Vowel Sign I    ..Hanunoo Sign Pamudpod
        (0x01752, 0x01753,),  # Buhid Vowel Sign I      ..Buhid Vowel Sign U
        (0x01772, 0x01773,),  # Tagbanwa Vowel Sign I   ..Tagbanwa Vowel Sign U
        (0x017b4, 0x017b5,),  # Khmer Vowel Inherent Aq ..Khmer Vowel Inherent Aa
        (0x017b7, 0x017bd,),  # Khmer Vowel Sign I      ..Khmer Vowel Sign Ua
        (0x017c6, 0x017c6,),  # Khmer Sign Nikahit      ..Khmer Sign Nikahit
        (0x017c9, 0x017d3,),  # Khmer Sign Muusikatoan  ..Khmer Sign Bathamasat
        (0x017dd, 0x017dd,),  # Khmer Sign Atthacan     ..Khmer Sign Atthacan
        (0x0180b, 0x0180d,),  # Mongolian Free Variation..Mongolian Free Variation
        (0x01885, 0x01886,),  # Mongolian Letter Ali Gal..Mongolian Letter Ali Gal
        (0x018a9, 0x018a9,),  # Mongolian Letter Ali Gal..Mongolian Letter Ali Gal
        (0x01920, 0x01922,),  # Limbu Vowel Sign A      ..Limbu Vowel Sign U
        (0x01927, 0x01928,),  # Limbu Vowel Sign E      ..Limbu Vowel Sign O
        (0x01932, 0x01932,),  # Limbu Small Letter Anusv..Limbu Small Letter Anusv
        (0x01939, 0x0193b,),  # Limbu Sign Mukphreng    ..Limbu Sign Sa-i
        (0x01a17, 0x01a18,),  # Buginese Vowel Sign I   ..Buginese Vowel Sign U
        (0x01a1b, 0x01a1b,),  # Buginese Vowel Sign Ae  ..Buginese Vowel Sign Ae
        (0x01a56, 0x01a56,),  # Tai Tham Consonant Sign ..Tai Tham Consonant Sign
        (0x01a58, 0x01a5e,),  # Tai Tham Sign Mai Kang L..Tai Tham Consonant Sign
        (0x01a60, 0x01a60,),  # Tai Tham Sign Sakot     ..Tai Tham Sign Sakot
        (0x01a62, 0x01a62,),  # Tai Tham Vowel Sign Mai ..Tai Tham Vowel Sign Mai
        (0x01a65, 0x01a6c,),  # Tai Tham Vowel Sign I   ..Tai Tham Vowel Sign Oa B
        (0x01a73, 0x01a7c,),  # Tai Tham Vowel Sign Oa A..Tai Tham Sign Khuen-lue
        (0x01a7f, 0x01a7f,),  # Tai Tham Combining Crypt..Tai Tham Combining Crypt
        (0x01ab0, 0x01abe,),  # Combining Doubled Circum..Combining Parentheses Ov
        (0x01b00, 0x01b03,),  # Balinese Sign Ulu Ricem ..Balinese Sign Surang
        (0x01b34, 0x01b34,),  # Balinese Sign Rerekan   ..Balinese Sign Rerekan
        (0x01b36, 0x01b3a,),  # Balinese Vowel Sign Ulu ..Balinese Vowel Sign Ra R
        (0x01b3c, 0x01b3c,),  # Balinese Vowel Sign La L..Balinese Vowel Sign La L
        (0x01b42, 0x01b42,),  # Balinese Vowel Sign Pepe..Balinese Vowel Sign Pepe
        (0x01b6b, 0x01b73,),  # Balinese Musical Symbol ..Balinese Musical Symbol
        (0x01b80, 0x01b81,),  # Sundanese Sign Panyecek ..Sundanese Sign Panglayar
        (0x01ba2, 0x01ba5,),  # Sundanese Consonant Sign..Sundanese Vowel Sign Pan
        (0x01ba8, 0x01ba9,),  # Sundanese Vowel Sign Pam..Sundanese Vowel Sign Pan
        (0x01bab, 0x01bad,),  # Sundanese Sign Virama   ..Sundanese Consonant Sign
        (0x01be6, 0x01be6,),  # Batak Sign Tompi        ..Batak Sign Tompi
        (0x01be8, 0x01be9,),  # Batak Vowel Sign Pakpak ..Batak Vowel Sign Ee
        (0x01bed, 0x01bed,),  # Batak Vowel Sign Karo O ..Batak Vowel Sign Karo O
        (0x01bef, 0x01bf1,),  # Batak Vowel Sign U For S..Batak Consonant Sign H
        (0x01c2c, 0x01c33,),  # Lepcha Vowel Sign E     ..Lepcha Consonant Sign T
        (0x01c36, 0x01c37,),  # Lepcha Sign Ran         ..Lepcha Sign Nukta
        (0x01cd0, 0x01cd2,),  # Vedic Tone Karshana     ..Vedic Tone Prenkha
        (0x01cd4, 0x01ce0,),  # Vedic Sign Yajurvedic Mi..Vedic Tone Rigvedic Kash
        (0x01ce2, 0x01ce8,),  # Vedic Sign Visarga Svari..Vedic Sign Visarga Anuda
        (0x01ced, 0x01ced,),  # Vedic Sign Tiryak       ..Vedic Sign Tiryak
        (0x01cf4, 0x01cf4,),  # Vedic Tone Candra Above ..Vedic Tone Candra Above
        (0x01cf8, 0x01cf9,),  # Vedic Tone Ring Above   ..Vedic Tone Double Ring A
        (0x01dc0, 0x01df9,),  # Combining Dotted Grave A..Combining Wide Inverted
        (0x01dfb, 0x01dff,),  # Combining Deletion Mark ..Combining Right Arrowhea
        (0x020d0, 0x020f0,),  # Combining Left Harpoon A..Combining Asterisk Above
        (0x02cef, 0x02cf1,),  # Coptic Combining Ni Abov..Coptic Combining Spiritu
        (0x02d7f, 0x02d7f,),  # Tifinagh Consonant Joine..Tifinagh Consonant Joine
        (0x02de0, 0x02dff,),  # Combining Cyrillic Lette..Combining Cyrillic Lette
        (0x0302a, 0x0302d,),  # Ideographic Level Tone M..Ideographic Entering Ton
        (0x03099, 0x0309a,),  # Combining Katakana-hirag..Combining Katakana-hirag
        (0x0a66f, 0x0a672,),  # Combining Cyrillic Vzmet..Combining Cyrillic Thous
        (0x0a674, 0x0a67d,),  # Combining Cyrillic Lette..Combining Cyrillic Payer
        (0x0a69e, 0x0a69f,),  # Combining Cyrillic Lette..Combining Cyrillic Lette
        (0x0a6f0, 0x0a6f1,),  # Bamum Combining Mark Koq..Bamum Combining Mark Tuk
        (0x0a802, 0x0a802,),  # Syloti Nagri Sign Dvisva..Syloti Nagri Sign Dvisva
        (0x0a806, 0x0a806,),  # Syloti Nagri Sign Hasant..Syloti Nagri Sign Hasant
        (0x0a80b, 0x0a80b,),  # Syloti Nagri Sign Anusva..Syloti Nagri Sign Anusva
        (0x0a825, 0x0a826,),  # Syloti Nagri Vowel Sign ..Syloti Nagri Vowel Sign
        (0x0a8c4, 0x0a8c5,),  # Saurashtra Sign Virama  ..Saurashtra Sign Candrabi
        (0x0a8e0, 0x0a8f1,),  # Combining Devanagari Dig..Combining Devanagari Sig
        (0x0a926, 0x0a92d,),  # Kayah Li Vowel Ue       ..Kayah Li Tone Calya Plop
        (0x0a947, 0x0a951,),  # Rejang Vowel Sign I     ..Rejang Consonant Sign R
        (0x0a980, 0x0a982,),  # Javanese Sign Panyangga ..Javanese Sign Layar
        (0x0a9b3, 0x0a9b3,),  # Javanese Sign Cecak Telu..Javanese Sign Cecak Telu
        (0x0a9b6, 0x0a9b9,),  # Javanese Vowel Sign Wulu..Javanese Vowel Sign Suku
        (0x0a9bc, 0x0a9bc,),  # Javanese Vowel Sign Pepe..Javanese Vowel Sign Pepe
        (0x0a9e5, 0x0a9e5,),  # Myanmar Sign Shan Saw   ..Myanmar Sign Shan Saw
        (0x0aa29, 0x0aa2e,),  # Cham Vowel Sign Aa      ..Cham Vowel Sign Oe
        (0x0aa31, 0x0aa32,),  # Cham Vowel Sign Au      ..Cham Vowel Sign Ue
        (0x0aa35, 0x0aa36,),  # Cham Consonant Sign La  ..Cham Consonant Sign Wa
        (0x0aa43, 0x0aa43,),  # Cham Consonant Sign Fina..Cham Consonant Sign Fina
        (0x0aa4c, 0x0aa4c,),  # Cham Consonant Sign Fina..Cham Consonant Sign Fina
        (0x0aa7c, 0x0aa7c,),  # Myanmar Sign Tai Laing T..Myanmar Sign Tai Laing T
        (0x0aab0, 0x0aab0,),  # Tai Viet Mai Kang       ..Tai Viet Mai Kang
        (0x0aab2, 0x0aab4,),  # Tai Viet Vowel I        ..Tai Viet Vowel U
        (0x0aab7, 0x0aab8,),  # Tai Viet Mai Khit       ..Tai Viet Vowel Ia
        (0x0aabe, 0x0aabf,),  # Tai Viet Vowel Am       ..Tai Viet Tone Mai Ek
        (0x0aac1, 0x0aac1,),  # Tai Viet Tone Mai Tho   ..Tai Viet Tone Mai Tho
        (0x0aaec, 0x0aaed,),  # Meetei Mayek Vowel Sign ..Meetei Mayek Vowel Sign
        (0x0aaf6, 0x0aaf6,),  # Meetei Mayek Virama     ..Meetei Mayek Virama
        (0x0abe5, 0x0abe5,),  # Meetei Mayek Vowel Sign ..Meetei Mayek Vowel Sign
        (0x0abe8, 0x0abe8,),  # Meetei Mayek Vowel Sign ..Meetei Mayek Vowel Sign
        (0x0abed, 0x0abed,),  # Meetei Mayek Apun Iyek  ..Meetei Mayek Apun Iyek
        (0x0fb1e, 0x0fb1e,),  # Hebrew Point Judeo-spani..Hebrew Point Judeo-spani
        (0x0fe00, 0x0fe0f,),  # Variation Selector-1    ..Variation Selector-16
        (0x0fe20, 0x0fe2f,),  # Combining Ligature Left ..Combining Cyrillic Titlo
        (0x101fd, 0x101fd,),  # Phaistos Disc Sign Combi..Phaistos Disc Sign Combi
        (0x102e0, 0x102e0,),  # Coptic Epact Thousands M..Coptic Epact Thousands M
        (0x10376, 0x1037a,),  # Combining Old Permic Let..Combining Old Permic Let
        (0x10a01, 0x10a03,),  # Kharoshthi Vowel Sign I ..Kharoshthi Vowel Sign Vo
        (0x10a05, 0x10a06,),  # Kharoshthi Vowel Sign E ..Kharoshthi Vowel Sign O
        (0x10a0c, 0x10a0f,),  # Kharoshthi Vowel Length ..Kharoshthi Sign Visarga
        (0x10a38, 0x10a3a,),  # Kharoshthi Sign Bar Abov..Kharoshthi Sign Dot Belo
        (0x10a3f, 0x10a3f,),  # Kharoshthi Virama       ..Kharoshthi Virama
        (0x10ae5, 0x10ae6,),  # Manichaean Abbreviation ..Manichaean Abbreviation
        (0x11001, 0x11001,),  # Brahmi Sign Anusvara    ..Brahmi Sign Anusvara
        (0x11038, 0x11046,),  # Brahmi Vowel Sign Aa    ..Brahmi Virama
        (0x1107f, 0x11081,),  # Brahmi Number Joiner    ..Kaithi Sign Anusvara
        (0x110b3, 0x110b6,),  # Kaithi Vowel Sign U     ..Kaithi Vowel Sign Ai
        (0x110b9, 0x110ba,),  # Kaithi Sign Virama      ..Kaithi Sign Nukta
        (0x11100, 0x11102,),  # Chakma Sign Candrabindu ..Chakma Sign Visarga
        (0x11127, 0x1112b,),  # Chakma Vowel Sign A     ..Chakma Vowel Sign Uu
        (0x1112d, 0x11134,),  # Chakma Vowel Sign Ai    ..Chakma Maayyaa
        (0x11173, 0x11173,),  # Mahajani Sign Nukta     ..Mahajani Sign Nukta
        (0x11180, 0x11181,),  # Sharada Sign Candrabindu..Sharada Sign Anusvara
        (0x111b6, 0x111be,),  # Sharada Vowel Sign U    ..Sharada Vowel Sign O
        (0x111ca, 0x111cc,),  # Sharada Sign Nukta      ..Sharada Extra Short Vowe
        (0x1122f, 0x11231,),  # Khojki Vowel Sign U     ..Khojki Vowel Sign Ai
        (0x11234, 0x11234,),  # Khojki Sign Anusvara    ..Khojki Sign Anusvara
        (0x11236, 0x11237,),  # Khojki Sign Nukta       ..Khojki Sign Shadda
        (0x1123e, 0x1123e,),  # Khojki Sign Sukun       ..Khojki Sign Sukun
        (0x112df, 0x112df,),  # Khudawadi Sign Anusvara ..Khudawadi Sign Anusvara
        (0x112e3, 0x112ea,),  # Khudawadi Vowel Sign U  ..Khudawadi Sign Virama
        (0x11300, 0x11301,),  # Grantha Sign Combining A..Grantha Sign Candrabindu
        (0x1133c, 0x1133c,),  # Grantha Sign Nukta      ..Grantha Sign Nukta
        (0x11340, 0x11340,),  # Grantha Vowel Sign Ii   ..Grantha Vowel Sign Ii
        (0x11366, 0x1136c,),  # Combining Grantha Digit ..Combining Grantha Digit
        (0x11370, 0x11374,),  # Combining Grantha Letter..Combining Grantha Letter
        (0x11438, 0x1143f,),  # Newa Vowel Sign U       ..Newa Vowel Sign Ai
        (0x11442, 0x11444,),  # Newa Sign Virama        ..Newa Sign Anusvara
        (0x11446, 0x11446,),  # Newa Sign Nukta         ..Newa Sign Nukta
        (0x114b3, 0x114b8,),  # Tirhuta Vowel Sign U    ..Tirhuta Vowel Sign Vocal
        (0x114ba, 0x114ba,),  # Tirhuta Vowel Sign Short..Tirhuta Vowel Sign Short
        (0x114bf, 0x114c0,),  # Tirhuta Sign Candrabindu..Tirhuta Sign Anusvara
        (0x114c2, 0x114c3,),  # Tirhuta Sign Virama     ..Tirhuta Sign Nukta
        (0x115b2, 0x115b5,),  # Siddham Vowel Sign U    ..Siddham Vowel Sign Vocal
        (0x115bc, 0x115bd,),  # Siddham Sign Candrabindu..Siddham Sign Anusvara
        (0x115bf, 0x115c0,),  # Siddham Sign Virama     ..Siddham Sign Nukta
        (0x115dc, 0x115dd,),  # Siddham Vowel Sign Alter..Siddham Vowel Sign Alter
        (0x11633, 0x1163a,),  # Modi Vowel Sign U       ..Modi Vowel Sign Ai
        (0x1163d, 0x1163d,),  # Modi Sign Anusvara      ..Modi Sign Anusvara
        (0x1163f, 0x11640,),  # Modi Sign Virama        ..Modi Sign Ardhacandra
        (0x116ab, 0x116ab,),  # Takri Sign Anusvara     ..Takri Sign Anusvara
        (0x116ad, 0x116ad,),  # Takri Vowel Sign Aa     ..Takri Vowel Sign Aa
        (0x116b0, 0x116b5,),  # Takri Vowel Sign U      ..Takri Vowel Sign Au
        (0x116b7, 0x116b7,),  # Takri Sign Nukta        ..Takri Sign Nukta
        (0x1171d, 0x1171f,),  # Ahom Consonant Sign Medi..Ahom Consonant Sign Medi
        (0x11722, 0x11725,),  # Ahom Vowel Sign I       ..Ahom Vowel Sign Uu
        (0x11727, 0x1172b,),  # Ahom Vowel Sign Aw      ..Ahom Sign Killer
        (0x11a01, 0x11a06,),  # Zanabazar Square Vowel S..Zanabazar Square Vowel S
        (0x11a09, 0x11a0a,),  # Zanabazar Square Vowel S..Zanabazar Square Vowel L
        (0x11a33, 0x11a38,),  # Zanabazar Square Final C..Zanabazar Square Sign An
        (0x11a3b, 0x11a3e,),  # Zanabazar Square Cluster..Zanabazar Square Cluster
        (0x11a47, 0x11a47,),  # Zanabazar Square Subjoin..Zanabazar Square Subjoin
        (0x11a51, 0x11a56,),  # Soyombo Vowel Sign I    ..Soyombo Vowel Sign Oe
        (0x11a59, 0x11a5b,),  # Soyombo Vowel Sign Vocal..Soyombo Vowel Length Mar
        (0x11a8a, 0x11a96,),  # Soyombo Final Consonant ..Soyombo Sign Anusvara
        (0x11a98, 0x11a99,),  # Soyombo Gemination Mark ..Soyombo Subjoiner
        (0x11c30, 0x11c36,),  # Bhaiksuki Vowel Sign I  ..Bhaiksuki Vowel Sign Voc
        (0x11c38, 0x11c3d,),  # Bhaiksuki Vowel Sign E  ..Bhaiksuki Sign Anusvara
        (0x11c3f, 0x11c3f,),  # Bhaiksuki Sign Virama   ..Bhaiksuki Sign Virama
        (0x11c92, 0x11ca7,),  # Marchen Subjoined Letter..Marchen Subjoined Letter
        (0x11caa, 0x11cb0,),  # Marchen Subjoined Letter..Marchen Vowel Sign Aa
        (0x11cb2, 0x11cb3,),  # Marchen Vowel Sign U    ..Marchen Vowel Sign E
        (0x11cb5, 0x11cb6,),  # Marchen Sign Anusvara   ..Marchen Sign Candrabindu
        (0x11d31, 0x11d36,),  # Masaram Gondi Vowel Sign..Masaram Gondi Vowel Sign
        (0x11d3a, 0x11d3a,),  # Masaram Gondi Vowel Sign..Masaram Gondi Vowel Sign
        (0x11d3c, 0x11d3d,),  # Masaram Gondi Vowel Sign..Masaram Gondi Vowel Sign
        (0x11d3f, 0x11d45,),  # Masaram Gondi Vowel Sign..Masaram Gondi Virama
        (0x11d47, 0x11d47,),  # Masaram Gondi Ra-kara   ..Masaram Gondi Ra-kara
        (0x16af0, 0x16af4,),  # Bassa Vah Combining High..Bassa Vah Combining High
        (0x16b30, 0x16b36,),  # Pahawh Hmong Mark Cim Tu..Pahawh Hmong Mark Cim Ta
        (0x16f8f, 0x16f92,),  # Miao Tone Right         ..Miao Tone Below
        (0x1bc9d, 0x1bc9e,),  # Duployan Thick Letter Se..Duployan Double Mark
        (0x1d167, 0x1d169,),  # Musical Symbol Combining..Musical Symbol Combining
        (0x1d17b, 0x1d182,),  # Musical Symbol Combining..Musical Symbol Combining
        (0x1d185, 0x1d18b,),  # Musical Symbol Combining..Musical Symbol Combining
        (0x1d1aa, 0x1d1ad,),  # Musical Symbol Combining..Musical Symbol Combining
        (0x1d242, 0x1d244,),  # Combining Greek Musical ..Combining Greek Musical
        (0x1da00, 0x1da36,),  # Signwriting Head Rim    ..Signwriting Air Sucking
        (0x1da3b, 0x1da6c,),  # Signwriting Mouth Closed..Signwriting Excitement
        (0x1da75, 0x1da75,),  # Signwriting Upper Body T..Signwriting Upper Body T
        (0x1da84, 0x1da84,),  # Signwriting Location Hea..Signwriting Location Hea
        (0x1da9b, 0x1da9f,),  # Signwriting Fill Modifie..Signwriting Fill Modifie
        (0x1daa1, 0x1daaf,),  # Signwriting Rotation Mod..Signwriting Rotation Mod
        (0x1e000, 0x1e006,),  # Combining Glagolitic Let..Combining Glagolitic Let
        (0x1e008, 0x1e018,),  # Combining Glagolitic Let..Combining Glagolitic Let
        (0x1e01b, 0x1e021,),  # Combining Glagolitic Let..Combining Glagolitic Let
        (0x1e023, 0x1e024,),  # Combining Glagolitic Let..Combining Glagolitic Let
        (0x1e026, 0x1e02a,),  # Combining Glagolitic Let..Combining Glagolitic Let
        (0x1e8d0, 0x1e8d6,),  # Mende Kikakui Combining ..Mende Kikakui Combining
        (0x1e944, 0x1e94a,),  # Adlam Alif Lengthener   ..Adlam Nukta
        (0xe0100, 0xe01ef,),  # Variation Selector-17   ..Variation Selector-256
    ),
    '11.0.0': (
        # Source: DerivedGeneralCategory-11.0.0.txt
        # Date:  2018-02-21, 05:34:04 GMT
        #
        (0x00300, 0x0036f,),  # Combining Grave Accent  ..Combining Latin Small Le
        (0x00483, 0x00489,),  # Combining Cyrillic Titlo..Combining Cyrillic Milli
        (0x00591, 0x005bd,),  # Hebrew Accent Etnahta   ..Hebrew Point Meteg
        (0x005bf, 0x005bf,),  # Hebrew Point Rafe       ..Hebrew Point Rafe
        (0x005c1, 0x005c2,),  # Hebrew Point Shin Dot   ..Hebrew Point Sin Dot
        (0x005c4, 0x005c5,),  # Hebrew Mark Upper Dot   ..Hebrew Mark Lower Dot
        (0x005c7, 0x005c7,),  # Hebrew Point Qamats Qata..Hebrew Point Qamats Qata
        (0x00610, 0x0061a,),  # Arabic Sign Sallallahou ..Arabic Small Kasra
        (0x0064b, 0x0065f,),  # Arabic Fathatan         ..Arabic Wavy Hamza Below
        (0x00670, 0x00670,),  # Arabic Letter Superscrip..Arabic Letter Superscrip
        (0x006d6, 0x006dc,),  # Arabic Small High Ligatu..Arabic Small High Seen
        (0x006df, 0x006e4,),  # Arabic Small High Rounde..Arabic Small High Madda
        (0x006e7, 0x006e8,),  # Arabic Small High Yeh   ..Arabic Small High Noon
        (0x006ea, 0x006ed,),  # Arabic Empty Centre Low ..Arabic Small Low Meem
        (0x00711, 0x00711,),  # Syriac Letter Superscrip..Syriac Letter Superscrip
        (0x00730, 0x0074a,),  # Syriac Pthaha Above     ..Syriac Barrekh
        (0x007a6, 0x007b0,),  # Thaana Abafili          ..Thaana Sukun
        (0x007eb, 0x007f3,),  # Nko Combining Short High..Nko Combining Double Dot
        (0x007fd, 0x007fd,),  # Nko Dantayalan          ..Nko Dantayalan
        (0x00816, 0x00819,),  # Samaritan Mark In       ..Samaritan Mark Dagesh
        (0x0081b, 0x00823,),  # Samaritan Mark Epentheti..Samaritan Vowel Sign A
        (0x00825, 0x00827,),  # Samaritan Vowel Sign Sho..Samaritan Vowel Sign U
        (0x00829, 0x0082d,),  # Samaritan Vowel Sign Lon..Samaritan Mark Nequdaa
        (0x00859, 0x0085b,),  # Mandaic Affrication Mark..Mandaic Gemination Mark
        (0x008d3, 0x008e1,),  # Arabic Small Low Waw    ..Arabic Small High Sign S
        (0x008e3, 0x00902,),  # Arabic Turned Damma Belo..Devanagari Sign Anusvara
        (0x0093a, 0x0093a,),  # Devanagari Vowel Sign Oe..Devanagari Vowel Sign Oe
        (0x0093c, 0x0093c,),  # Devanagari Sign Nukta   ..Devanagari Sign Nukta
        (0x00941, 0x00948,),  # Devanagari Vowel Sign U ..Devanagari Vowel Sign Ai
        (0x0094d, 0x0094d,),  # Devanagari Sign Virama  ..Devanagari Sign Virama
        (0x00951, 0x00957,),  # Devanagari Stress Sign U..Devanagari Vowel Sign Uu
        (0x00962, 0x00963,),  # Devanagari Vowel Sign Vo..Devanagari Vowel Sign Vo
        (0x00981, 0x00981,),  # Bengali Sign Candrabindu..Bengali Sign Candrabindu
        (0x009bc, 0x009bc,),  # Bengali Sign Nukta      ..Bengali Sign Nukta
        (0x009c1, 0x009c4,),  # Bengali Vowel Sign U    ..Bengali Vowel Sign Vocal
        (0x009cd, 0x009cd,),  # Bengali Sign Virama     ..Bengali Sign Virama
        (0x009e2, 0x009e3,),  # Bengali Vowel Sign Vocal..Bengali Vowel Sign Vocal
        (0x009fe, 0x009fe,),  # Bengali Sandhi Mark     ..Bengali Sandhi Mark
        (0x00a01, 0x00a02,),  # Gurmukhi Sign Adak Bindi..Gurmukhi Sign Bindi
        (0x00a3c, 0x00a3c,),  # Gurmukhi Sign Nukta     ..Gurmukhi Sign Nukta
        (0x00a41, 0x00a42,),  # Gurmukhi Vowel Sign U   ..Gurmukhi Vowel Sign Uu
        (0x00a47, 0x00a48,),  # Gurmukhi Vowel Sign Ee  ..Gurmukhi Vowel Sign Ai
        (0x00a4b, 0x00a4d,),  # Gurmukhi Vowel Sign Oo  ..Gurmukhi Sign Virama
        (0x00a51, 0x00a51,),  # Gurmukhi Sign Udaat     ..Gurmukhi Sign Udaat
        (0x00a70, 0x00a71,),  # Gurmukhi Tippi          ..Gurmukhi Addak
        (0x00a75, 0x00a75,),  # Gurmukhi Sign Yakash    ..Gurmukhi Sign Yakash
        (0x00a81, 0x00a82,),  # Gujarati Sign Candrabind..Gujarati Sign Anusvara
        (0x00abc, 0x00abc,),  # Gujarati Sign Nukta     ..Gujarati Sign Nukta
        (0x00ac1, 0x00ac5,),  # Gujarati Vowel Sign U   ..Gujarati Vowel Sign Cand
        (0x00ac7, 0x00ac8,),  # Gujarati Vowel Sign E   ..Gujarati Vowel Sign Ai
        (0x00acd, 0x00acd,),  # Gujarati Sign Virama    ..Gujarati Sign Virama
        (0x00ae2, 0x00ae3,),  # Gujarati Vowel Sign Voca..Gujarati Vowel Sign Voca
        (0x00afa, 0x00aff,),  # Gujarati Sign Sukun     ..Gujarati Sign Two-circle
        (0x00b01, 0x00b01,),  # Oriya Sign Candrabindu  ..Oriya Sign Candrabindu
        (0x00b3c, 0x00b3c,),  # Oriya Sign Nukta        ..Oriya Sign Nukta
        (0x00b3f, 0x00b3f,),  # Oriya Vowel Sign I      ..Oriya Vowel Sign I
        (0x00b41, 0x00b44,),  # Oriya Vowel Sign U      ..Oriya Vowel Sign Vocalic
        (0x00b4d, 0x00b4d,),  # Oriya Sign Virama       ..Oriya Sign Virama
        (0x00b56, 0x00b56,),  # Oriya Ai Length Mark    ..Oriya Ai Length Mark
        (0x00b62, 0x00b63,),  # Oriya Vowel Sign Vocalic..Oriya Vowel Sign Vocalic
        (0x00b82, 0x00b82,),  # Tamil Sign Anusvara     ..Tamil Sign Anusvara
        (0x00bc0, 0x00bc0,),  # Tamil Vowel Sign Ii     ..Tamil Vowel Sign Ii
        (0x00bcd, 0x00bcd,),  # Tamil Sign Virama       ..Tamil Sign Virama
        (0x00c00, 0x00c00,),  # Telugu Sign Combining Ca..Telugu Sign Combining Ca
        (0x00c04, 0x00c04,),  # Telugu Sign Combining An..Telugu Sign Combining An
        (0x00c3e, 0x00c40,),  # Telugu Vowel Sign Aa    ..Telugu Vowel Sign Ii
        (0x00c46, 0x00c48,),  # Telugu Vowel Sign E     ..Telugu Vowel Sign Ai
        (0x00c4a, 0x00c4d,),  # Telugu Vowel Sign O     ..Telugu Sign Virama
        (0x00c55, 0x00c56,),  # Telugu Length Mark      ..Telugu Ai Length Mark
        (0x00c62, 0x00c63,),  # Telugu Vowel Sign Vocali..Telugu Vowel Sign Vocali
        (0x00c81, 0x00c81,),  # Kannada Sign Candrabindu..Kannada Sign Candrabindu
        (0x00cbc, 0x00cbc,),  # Kannada Sign Nukta      ..Kannada Sign Nukta
        (0x00cbf, 0x00cbf,),  # Kannada Vowel Sign I    ..Kannada Vowel Sign I
        (0x00cc6, 0x00cc6,),  # Kannada Vowel Sign E    ..Kannada Vowel Sign E
        (0x00ccc, 0x00ccd,),  # Kannada Vowel Sign Au   ..Kannada Sign Virama
        (0x00ce2, 0x00ce3,),  # Kannada Vowel Sign Vocal..Kannada Vowel Sign Vocal
        (0x00d00, 0x00d01,),  # Malayalam Sign Combining..Malayalam Sign Candrabin
        (0x00d3b, 0x00d3c,),  # Malayalam Sign Vertical ..Malayalam Sign Circular
        (0x00d41, 0x00d44,),  # Malayalam Vowel Sign U  ..Malayalam Vowel Sign Voc
        (0x00d4d, 0x00d4d,),  # Malayalam Sign Virama   ..Malayalam Sign Virama
        (0x00d62, 0x00d63,),  # Malayalam Vowel Sign Voc..Malayalam Vowel Sign Voc
        (0x00dca, 0x00dca,),  # Sinhala Sign Al-lakuna  ..Sinhala Sign Al-lakuna
        (0x00dd2, 0x00dd4,),  # Sinhala Vowel Sign Ketti..Sinhala Vowel Sign Ketti
        (0x00dd6, 0x00dd6,),  # Sinhala Vowel Sign Diga ..Sinhala Vowel Sign Diga
        (0x00e31, 0x00e31,),  # Thai Character Mai Han-a..Thai Character Mai Han-a
        (0x00e34, 0x00e3a,),  # Thai Character Sara I   ..Thai Character Phinthu
        (0x00e47, 0x00e4e,),  # Thai Character Maitaikhu..Thai Character Yamakkan
        (0x00eb1, 0x00eb1,),  # Lao Vowel Sign Mai Kan  ..Lao Vowel Sign Mai Kan
        (0x00eb4, 0x00eb9,),  # Lao Vowel Sign I        ..Lao Vowel Sign Uu
        (0x00ebb, 0x00ebc,),  # Lao Vowel Sign Mai Kon  ..Lao Semivowel Sign Lo
        (0x00ec8, 0x00ecd,),  # Lao Tone Mai Ek         ..Lao Niggahita
        (0x00f18, 0x00f19,),  # Tibetan Astrological Sig..Tibetan Astrological Sig
        (0x00f35, 0x00f35,),  # Tibetan Mark Ngas Bzung ..Tibetan Mark Ngas Bzung
        (0x00f37, 0x00f37,),  # Tibetan Mark Ngas Bzung ..Tibetan Mark Ngas Bzung
        (0x00f39, 0x00f39,),  # Tibetan Mark Tsa -phru  ..Tibetan Mark Tsa -phru
        (0x00f71, 0x00f7e,),  # Tibetan Vowel Sign Aa   ..Tibetan Sign Rjes Su Nga
        (0x00f80, 0x00f84,),  # Tibetan Vowel Sign Rever..Tibetan Mark Halanta
        (0x00f86, 0x00f87,),  # Tibetan Sign Lci Rtags  ..Tibetan Sign Yang Rtags
        (0x00f8d, 0x00f97,),  # Tibetan Subjoined Sign L..Tibetan Subjoined Letter
        (0x00f99, 0x00fbc,),  # Tibetan Subjoined Letter..Tibetan Subjoined Letter
        (0x00fc6, 0x00fc6,),  # Tibetan Symbol Padma Gda..Tibetan Symbol Padma Gda
        (0x0102d, 0x01030,),  # Myanmar Vowel Sign I    ..Myanmar Vowel Sign Uu
        (0x01032, 0x01037,),  # Myanmar Vowel Sign Ai   ..Myanmar Sign Dot Below
        (0x01039, 0x0103a,),  # Myanmar Sign Virama     ..Myanmar Sign Asat
        (0x0103d, 0x0103e,),  # Myanmar Consonant Sign M..Myanmar Consonant Sign M
        (0x01058, 0x01059,),  # Myanmar Vowel Sign Vocal..Myanmar Vowel Sign Vocal
        (0x0105e, 0x01060,),  # Myanmar Consonant Sign M..Myanmar Consonant Sign M
        (0x01071, 0x01074,),  # Myanmar Vowel Sign Geba ..Myanmar Vowel Sign Kayah
        (0x01082, 0x01082,),  # Myanmar Consonant Sign S..Myanmar Consonant Sign S
        (0x01085, 0x01086,),  # Myanmar Vowel Sign Shan ..Myanmar Vowel Sign Shan
        (0x0108d, 0x0108d,),  # Myanmar Sign Shan Counci..Myanmar Sign Shan Counci
        (0x0109d, 0x0109d,),  # Myanmar Vowel Sign Aiton..Myanmar Vowel Sign Aiton
        (0x0135d, 0x0135f,),  # Ethiopic Combining Gemin..Ethiopic Combining Gemin
        (0x01712, 0x01714,),  # Tagalog Vowel Sign I    ..Tagalog Sign Virama
        (0x01732, 0x01734,),  # Hanunoo Vowel Sign I    ..Hanunoo Sign Pamudpod
        (0x01752, 0x01753,),  # Buhid Vowel Sign I      ..Buhid Vowel Sign U
        (0x01772, 0x01773,),  # Tagbanwa Vowel Sign I   ..Tagbanwa Vowel Sign U
        (0x017b4, 0x017b5,),  # Khmer Vowel Inherent Aq ..Khmer Vowel Inherent Aa
        (0x017b7, 0x017bd,),  # Khmer Vowel Sign I      ..Khmer Vowel Sign Ua
        (0x017c6, 0x017c6,),  # Khmer Sign Nikahit      ..Khmer Sign Nikahit
        (0x017c9, 0x017d3,),  # Khmer Sign Muusikatoan  ..Khmer Sign Bathamasat
        (0x017dd, 0x017dd,),  # Khmer Sign Atthacan     ..Khmer Sign Atthacan
        (0x0180b, 0x0180d,),  # Mongolian Free Variation..Mongolian Free Variation
        (0x01885, 0x01886,),  # Mongolian Letter Ali Gal..Mongolian Letter Ali Gal
        (0x018a9, 0x018a9,),  # Mongolian Letter Ali Gal..Mongolian Letter Ali Gal
        (0x01920, 0x01922,),  # Limbu Vowel Sign A      ..Limbu Vowel Sign U
        (0x01927, 0x01928,),  # Limbu Vowel Sign E      ..Limbu Vowel Sign O
        (0x01932, 0x01932,),  # Limbu Small Letter Anusv..Limbu Small Letter Anusv
        (0x01939, 0x0193b,),  # Limbu Sign Mukphreng    ..Limbu Sign Sa-i
        (0x01a17, 0x01a18,),  # Buginese Vowel Sign I   ..Buginese Vowel Sign U
        (0x01a1b, 0x01a1b,),  # Buginese Vowel Sign Ae  ..Buginese Vowel Sign Ae
        (0x01a56, 0x01a56,),  # Tai Tham Consonant Sign ..Tai Tham Consonant Sign
        (0x01a58, 0x01a5e,),  # Tai Tham Sign Mai Kang L..Tai Tham Consonant Sign
        (0x01a60, 0x01a60,),  # Tai Tham Sign Sakot     ..Tai Tham Sign Sakot
        (0x01a62, 0x01a62,),  # Tai Tham Vowel Sign Mai ..Tai Tham Vowel Sign Mai
        (0x01a65, 0x01a6c,),  # Tai Tham Vowel Sign I   ..Tai Tham Vowel Sign Oa B
        (0x01a73, 0x01a7c,),  # Tai Tham Vowel Sign Oa A..Tai Tham Sign Khuen-lue
        (0x01a7f, 0x01a7f,),  # Tai Tham Combining Crypt..Tai Tham Combining Crypt
        (0x01ab0, 0x01abe,),  # Combining Doubled Circum..Combining Parentheses Ov
        (0x01b00, 0x01b03,),  # Balinese Sign Ulu Ricem ..Balinese Sign Surang
        (0x01b34, 0x01b34,),  # Balinese Sign Rerekan   ..Balinese Sign Rerekan
        (0x01b36, 0x01b3a,),  # Balinese Vowel Sign Ulu ..Balinese Vowel Sign Ra R
        (0x01b3c, 0x01b3c,),  # Balinese Vowel Sign La L..Balinese Vowel Sign La L
        (0x01b42, 0x01b42,),  # Balinese Vowel Sign Pepe..Balinese Vowel Sign Pepe
        (0x01b6b, 0x01b73,),  # Balinese Musical Symbol ..Balinese Musical Symbol
        (0x01b80, 0x01b81,),  # Sundanese Sign Panyecek ..Sundanese Sign Panglayar
        (0x01ba2, 0x01ba5,),  # Sundanese Consonant Sign..Sundanese Vowel Sign Pan
        (0x01ba8, 0x01ba9,),  # Sundanese Vowel Sign Pam..Sundanese Vowel Sign Pan
        (0x01bab, 0x01bad,),  # Sundanese Sign Virama   ..Sundanese Consonant Sign
        (0x01be6, 0x01be6,),  # Batak Sign Tompi        ..Batak Sign Tompi
        (0x01be8, 0x01be9,),  # Batak Vowel Sign Pakpak ..Batak Vowel Sign Ee
        (0x01bed, 0x01bed,),  # Batak Vowel Sign Karo O ..Batak Vowel Sign Karo O
        (0x01bef, 0x01bf1,),  # Batak Vowel Sign U For S..Batak Consonant Sign H
        (0x01c2c, 0x01c33,),  # Lepcha Vowel Sign E     ..Lepcha Consonant Sign T
        (0x01c36, 0x01c37,),  # Lepcha Sign Ran         ..Lepcha Sign Nukta
        (0x01cd0, 0x01cd2,),  # Vedic Tone Karshana     ..Vedic Tone Prenkha
        (0x01cd4, 0x01ce0,),  # Vedic Sign Yajurvedic Mi..Vedic Tone Rigvedic Kash
        (0x01ce2, 0x01ce8,),  # Vedic Sign Visarga Svari..Vedic Sign Visarga Anuda
        (0x01ced, 0x01ced,),  # Vedic Sign Tiryak       ..Vedic Sign Tiryak
        (0x01cf4, 0x01cf4,),  # Vedic Tone Candra Above ..Vedic Tone Candra Above
        (0x01cf8, 0x01cf9,),  # Vedic Tone Ring Above   ..Vedic Tone Double Ring A
        (0x01dc0, 0x01df9,),  # Combining Dotted Grave A..Combining Wide Inverted
        (0x01dfb, 0x01dff,),  # Combining Deletion Mark ..Combining Right Arrowhea
        (0x020d0, 0x020f0,),  # Combining Left Harpoon A..Combining Asterisk Above
        (0x02cef, 0x02cf1,),  # Coptic Combining Ni Abov..Coptic Combining Spiritu
        (0x02d7f, 0x02d7f,),  # Tifinagh Consonant Joine..Tifinagh Consonant Joine
        (0x02de0, 0x02dff,),  # Combining Cyrillic Lette..Combining Cyrillic Lette
        (0x0302a, 0x0302d,),  # Ideographic Level Tone M..Ideographic Entering Ton
        (0x03099, 0x0309a,),  # Combining Katakana-hirag..Combining Katakana-hirag
        (0x0a66f, 0x0a672,),  # Combining Cyrillic Vzmet..Combining Cyrillic Thous
        (0x0a674, 0x0a67d,),  # Combining Cyrillic Lette..Combining Cyrillic Payer
        (0x0a69e, 0x0a69f,),  # Combining Cyrillic Lette..Combining Cyrillic Lette
        (0x0a6f0, 0x0a6f1,),  # Bamum Combining Mark Koq..Bamum Combining Mark Tuk
        (0x0a802, 0x0a802,),  # Syloti Nagri Sign Dvisva..Syloti Nagri Sign Dvisva
        (0x0a806, 0x0a806,),  # Syloti Nagri Sign Hasant..Syloti Nagri Sign Hasant
        (0x0a80b, 0x0a80b,),  # Syloti Nagri Sign Anusva..Syloti Nagri Sign Anusva
        (0x0a825, 0x0a826,),  # Syloti Nagri Vowel Sign ..Syloti Nagri Vowel Sign
        (0x0a8c4, 0x0a8c5,),  # Saurashtra Sign Virama  ..Saurashtra Sign Candrabi
        (0x0a8e0, 0x0a8f1,),  # Combining Devanagari Dig..Combining Devanagari Sig
        (0x0a8ff, 0x0a8ff,),  # Devanagari Vowel Sign Ay..Devanagari Vowel Sign Ay
        (0x0a926, 0x0a92d,),  # Kayah Li Vowel Ue       ..Kayah Li Tone Calya Plop
        (0x0a947, 0x0a951,),  # Rejang Vowel Sign I     ..Rejang Consonant Sign R
        (0x0a980, 0x0a982,),  # Javanese Sign Panyangga ..Javanese Sign Layar
        (0x0a9b3, 0x0a9b3,),  # Javanese Sign Cecak Telu..Javanese Sign Cecak Telu
        (0x0a9b6, 0x0a9b9,),  # Javanese Vowel Sign Wulu..Javanese Vowel Sign Suku
        (0x0a9bc, 0x0a9bc,),  # Javanese Vowel Sign Pepe..Javanese Vowel Sign Pepe
        (0x0a9e5, 0x0a9e5,),  # Myanmar Sign Shan Saw   ..Myanmar Sign Shan Saw
        (0x0aa29, 0x0aa2e,),  # Cham Vowel Sign Aa      ..Cham Vowel Sign Oe
        (0x0aa31, 0x0aa32,),  # Cham Vowel Sign Au      ..Cham Vowel Sign Ue
        (0x0aa35, 0x0aa36,),  # Cham Consonant Sign La  ..Cham Consonant Sign Wa
        (0x0aa43, 0x0aa43,),  # Cham Consonant Sign Fina..Cham Consonant Sign Fina
        (0x0aa4c, 0x0aa4c,),  # Cham Consonant Sign Fina..Cham Consonant Sign Fina
        (0x0aa7c, 0x0aa7c,),  # Myanmar Sign Tai Laing T..Myanmar Sign Tai Laing T
        (0x0aab0, 0x0aab0,),  # Tai Viet Mai Kang       ..Tai Viet Mai Kang
        (0x0aab2, 0x0aab4,),  # Tai Viet Vowel I        ..Tai Viet Vowel U
        (0x0aab7, 0x0aab8,),  # Tai Viet Mai Khit       ..Tai Viet Vowel Ia
        (0x0aabe, 0x0aabf,),  # Tai Viet Vowel Am       ..Tai Viet Tone Mai Ek
        (0x0aac1, 0x0aac1,),  # Tai Viet Tone Mai Tho   ..Tai Viet Tone Mai Tho
        (0x0aaec, 0x0aaed,),  # Meetei Mayek Vowel Sign ..Meetei Mayek Vowel Sign
        (0x0aaf6, 0x0aaf6,),  # Meetei Mayek Virama     ..Meetei Mayek Virama
        (0x0abe5, 0x0abe5,),  # Meetei Mayek Vowel Sign ..Meetei Mayek Vowel Sign
        (0x0abe8, 0x0abe8,),  # Meetei Mayek Vowel Sign ..Meetei Mayek Vowel Sign
        (0x0abed, 0x0abed,),  # Meetei Mayek Apun Iyek  ..Meetei Mayek Apun Iyek
        (0x0fb1e, 0x0fb1e,),  # Hebrew Point Judeo-spani..Hebrew Point Judeo-spani
        (0x0fe00, 0x0fe0f,),  # Variation Selector-1    ..Variation Selector-16
        (0x0fe20, 0x0fe2f,),  # Combining Ligature Left ..Combining Cyrillic Titlo
        (0x101fd, 0x101fd,),  # Phaistos Disc Sign Combi..Phaistos Disc Sign Combi
        (0x102e0, 0x102e0,),  # Coptic Epact Thousands M..Coptic Epact Thousands M
        (0x10376, 0x1037a,),  # Combining Old Permic Let..Combining Old Permic Let
        (0x10a01, 0x10a03,),  # Kharoshthi Vowel Sign I ..Kharoshthi Vowel Sign Vo
        (0x10a05, 0x10a06,),  # Kharoshthi Vowel Sign E ..Kharoshthi Vowel Sign O
        (0x10a0c, 0x10a0f,),  # Kharoshthi Vowel Length ..Kharoshthi Sign Visarga
        (0x10a38, 0x10a3a,),  # Kharoshthi Sign Bar Abov..Kharoshthi Sign Dot Belo
        (0x10a3f, 0x10a3f,),  # Kharoshthi Virama       ..Kharoshthi Virama
        (0x10ae5, 0x10ae6,),  # Manichaean Abbreviation ..Manichaean Abbreviation
        (0x10d24, 0x10d27,),  # Hanifi Rohingya Sign Har..Hanifi Rohingya Sign Tas
        (0x10f46, 0x10f50,),  # Sogdian Combining Dot Be..Sogdian Combining Stroke
        (0x11001, 0x11001,),  # Brahmi Sign Anusvara    ..Brahmi Sign Anusvara
        (0x11038, 0x11046,),  # Brahmi Vowel Sign Aa    ..Brahmi Virama
        (0x1107f, 0x11081,),  # Brahmi Number Joiner    ..Kaithi Sign Anusvara
        (0x110b3, 0x110b6,),  # Kaithi Vowel Sign U     ..Kaithi Vowel Sign Ai
        (0x110b9, 0x110ba,),  # Kaithi Sign Virama      ..Kaithi Sign Nukta
        (0x11100, 0x11102,),  # Chakma Sign Candrabindu ..Chakma Sign Visarga
        (0x11127, 0x1112b,),  # Chakma Vowel Sign A     ..Chakma Vowel Sign Uu
        (0x1112d, 0x11134,),  # Chakma Vowel Sign Ai    ..Chakma Maayyaa
        (0x11173, 0x11173,),  # Mahajani Sign Nukta     ..Mahajani Sign Nukta
        (0x11180, 0x11181,),  # Sharada Sign Candrabindu..Sharada Sign Anusvara
        (0x111b6, 0x111be,),  # Sharada Vowel Sign U    ..Sharada Vowel Sign O
        (0x111c9, 0x111cc,),  # Sharada Sandhi Mark     ..Sharada Extra Short Vowe
        (0x1122f, 0x11231,),  # Khojki Vowel Sign U     ..Khojki Vowel Sign Ai
        (0x11234, 0x11234,),  # Khojki Sign Anusvara    ..Khojki Sign Anusvara
        (0x11236, 0x11237,),  # Khojki Sign Nukta       ..Khojki Sign Shadda
        (0x1123e, 0x1123e,),  # Khojki Sign Sukun       ..Khojki Sign Sukun
        (0x112df, 0x112df,),  # Khudawadi Sign Anusvara ..Khudawadi Sign Anusvara
        (0x112e3, 0x112ea,),  # Khudawadi Vowel Sign U  ..Khudawadi Sign Virama
        (0x11300, 0x11301,),  # Grantha Sign Combining A..Grantha Sign Candrabindu
        (0x1133b, 0x1133c,),  # Combining Bindu Below   ..Grantha Sign Nukta
        (0x11340, 0x11340,),  # Grantha Vowel Sign Ii   ..Grantha Vowel Sign Ii
        (0x11366, 0x1136c,),  # Combining Grantha Digit ..Combining Grantha Digit
        (0x11370, 0x11374,),  # Combining Grantha Letter..Combining Grantha Letter
        (0x11438, 0x1143f,),  # Newa Vowel Sign U       ..Newa Vowel Sign Ai
        (0x11442, 0x11444,),  # Newa Sign Virama        ..Newa Sign Anusvara
        (0x11446, 0x11446,),  # Newa Sign Nukta         ..Newa Sign Nukta
        (0x1145e, 0x1145e,),  # Newa Sandhi Mark        ..Newa Sandhi Mark
        (0x114b3, 0x114b8,),  # Tirhuta Vowel Sign U    ..Tirhuta Vowel Sign Vocal
        (0x114ba, 0x114ba,),  # Tirhuta Vowel Sign Short..Tirhuta Vowel Sign Short
        (0x114bf, 0x114c0,),  # Tirhuta Sign Candrabindu..Tirhuta Sign Anusvara
        (0x114c2, 0x114c3,),  # Tirhuta Sign Virama     ..Tirhuta Sign Nukta
        (0x115b2, 0x115b5,),  # Siddham Vowel Sign U    ..Siddham Vowel Sign Vocal
        (0x115bc, 0x115bd,),  # Siddham Sign Candrabindu..Siddham Sign Anusvara
        (0x115bf, 0x115c0,),  # Siddham Sign Virama     ..Siddham Sign Nukta
        (0x115dc, 0x115dd,),  # Siddham Vowel Sign Alter..Siddham Vowel Sign Alter
        (0x11633, 0x1163a,),  # Modi Vowel Sign U       ..Modi Vowel Sign Ai
        (0x1163d, 0x1163d,),  # Modi Sign Anusvara      ..Modi Sign Anusvara
        (0x1163f, 0x11640,),  # Modi Sign Virama        ..Modi Sign Ardhacandra
        (0x116ab, 0x116ab,),  # Takri Sign Anusvara     ..Takri Sign Anusvara
        (0x116ad, 0x116ad,),  # Takri Vowel Sign Aa     ..Takri Vowel Sign Aa
        (0x116b0, 0x116b5,),  # Takri Vowel Sign U      ..Takri Vowel Sign Au
        (0x116b7, 0x116b7,),  # Takri Sign Nukta        ..Takri Sign Nukta
        (0x1171d, 0x1171f,),  # Ahom Consonant Sign Medi..Ahom Consonant Sign Medi
        (0x11722, 0x11725,),  # Ahom Vowel Sign I       ..Ahom Vowel Sign Uu
        (0x11727, 0x1172b,),  # Ahom Vowel Sign Aw      ..Ahom Sign Killer
        (0x1182f, 0x11837,),  # Dogra Vowel Sign U      ..Dogra Sign Anusvara
        (0x11839, 0x1183a,),  # Dogra Sign Virama       ..Dogra Sign Nukta
        (0x11a01, 0x11a0a,),  # Zanabazar Square Vowel S..Zanabazar Square Vowel L
        (0x11a33, 0x11a38,),  # Zanabazar Square Final C..Zanabazar Square Sign An
        (0x11a3b, 0x11a3e,),  # Zanabazar Square Cluster..Zanabazar Square Cluster
        (0x11a47, 0x11a47,),  # Zanabazar Square Subjoin..Zanabazar Square Subjoin
        (0x11a51, 0x11a56,),  # Soyombo Vowel Sign I    ..Soyombo Vowel Sign Oe
        (0x11a59, 0x11a5b,),  # Soyombo Vowel Sign Vocal..Soyombo Vowel Length Mar
        (0x11a8a, 0x11a96,),  # Soyombo Final Consonant ..Soyombo Sign Anusvara
        (0x11a98, 0x11a99,),  # Soyombo Gemination Mark ..Soyombo Subjoiner
        (0x11c30, 0x11c36,),  # Bhaiksuki Vowel Sign I  ..Bhaiksuki Vowel Sign Voc
        (0x11c38, 0x11c3d,),  # Bhaiksuki Vowel Sign E  ..Bhaiksuki Sign Anusvara
        (0x11c3f, 0x11c3f,),  # Bhaiksuki Sign Virama   ..Bhaiksuki Sign Virama
        (0x11c92, 0x11ca7,),  # Marchen Subjoined Letter..Marchen Subjoined Letter
        (0x11caa, 0x11cb0,),  # Marchen Subjoined Letter..Marchen Vowel Sign Aa
        (0x11cb2, 0x11cb3,),  # Marchen Vowel Sign U    ..Marchen Vowel Sign E
        (0x11cb5, 0x11cb6,),  # Marchen Sign Anusvara   ..Marchen Sign Candrabindu
        (0x11d31, 0x11d36,),  # Masaram Gondi Vowel Sign..Masaram Gondi Vowel Sign
        (0x11d3a, 0x11d3a,),  # Masaram Gondi Vowel Sign..Masaram Gondi Vowel Sign
        (0x11d3c, 0x11d3d,),  # Masaram Gondi Vowel Sign..Masaram Gondi Vowel Sign
        (0x11d3f, 0x11d45,),  # Masaram Gondi Vowel Sign..Masaram Gondi Virama
        (0x11d47, 0x11d47,),  # Masaram Gondi Ra-kara   ..Masaram Gondi Ra-kara
        (0x11d90, 0x11d91,),  # Gunjala Gondi Vowel Sign..Gunjala Gondi Vowel Sign
        (0x11d95, 0x11d95,),  # Gunjala Gondi Sign Anusv..Gunjala Gondi Sign Anusv
        (0x11d97, 0x11d97,),  # Gunjala Gondi Virama    ..Gunjala Gondi Virama
        (0x11ef3, 0x11ef4,),  # Makasar Vowel Sign I    ..Makasar Vowel Sign U
        (0x16af0, 0x16af4,),  # Bassa Vah Combining High..Bassa Vah Combining High
        (0x16b30, 0x16b36,),  # Pahawh Hmong Mark Cim Tu..Pahawh Hmong Mark Cim Ta
        (0x16f8f, 0x16f92,),  # Miao Tone Right         ..Miao Tone Below
        (0x1bc9d, 0x1bc9e,),  # Duployan Thick Letter Se..Duployan Double Mark
        (0x1d167, 0x1d169,),  # Musical Symbol Combining..Musical Symbol Combining
        (0x1d17b, 0x1d182,),  # Musical Symbol Combining..Musical Symbol Combining
        (0x1d185, 0x1d18b,),  # Musical Symbol Combining..Musical Symbol Combining
        (0x1d1aa, 0x1d1ad,),  # Musical Symbol Combining..Musical Symbol Combining
        (0x1d242, 0x1d244,),  # Combining Greek Musical ..Combining Greek Musical
        (0x1da00, 0x1da36,),  # Signwriting Head Rim    ..Signwriting Air Sucking
        (0x1da3b, 0x1da6c,),  # Signwriting Mouth Closed..Signwriting Excitement
        (0x1da75, 0x1da75,),  # Signwriting Upper Body T..Signwriting Upper Body T
        (0x1da84, 0x1da84,),  # Signwriting Location Hea..Signwriting Location Hea
        (0x1da9b, 0x1da9f,),  # Signwriting Fill Modifie..Signwriting Fill Modifie
        (0x1daa1, 0x1daaf,),  # Signwriting Rotation Mod..Signwriting Rotation Mod
        (0x1e000, 0x1e006,),  # Combining Glagolitic Let..Combining Glagolitic Let
        (0x1e008, 0x1e018,),  # Combining Glagolitic Let..Combining Glagolitic Let
        (0x1e01b, 0x1e021,),  # Combining Glagolitic Let..Combining Glagolitic Let
        (0x1e023, 0x1e024,),  # Combining Glagolitic Let..Combining Glagolitic Let
        (0x1e026, 0x1e02a,),  # Combining Glagolitic Let..Combining Glagolitic Let
        (0x1e8d0, 0x1e8d6,),  # Mende Kikakui Combining ..Mende Kikakui Combining
        (0x1e944, 0x1e94a,),  # Adlam Alif Lengthener   ..Adlam Nukta
        (0xe0100, 0xe01ef,),  # Variation Selector-17   ..Variation Selector-256
    ),
    '12.0.0': (
        # Source: DerivedGeneralCategory-12.0.0.txt
        # Date:  2019-01-22, 08:18:28 GMT
        #
        (0x00300, 0x0036f,),  # Combining Grave Accent  ..Combining Latin Small Le
        (0x00483, 0x00489,),  # Combining Cyrillic Titlo..Combining Cyrillic Milli
        (0x00591, 0x005bd,),  # Hebrew Accent Etnahta   ..Hebrew Point Meteg
        (0x005bf, 0x005bf,),  # Hebrew Point Rafe       ..Hebrew Point Rafe
        (0x005c1, 0x005c2,),  # Hebrew Point Shin Dot   ..Hebrew Point Sin Dot
        (0x005c4, 0x005c5,),  # Hebrew Mark Upper Dot   ..Hebrew Mark Lower Dot
        (0x005c7, 0x005c7,),  # Hebrew Point Qamats Qata..Hebrew Point Qamats Qata
        (0x00610, 0x0061a,),  # Arabic Sign Sallallahou ..Arabic Small Kasra
        (0x0064b, 0x0065f,),  # Arabic Fathatan         ..Arabic Wavy Hamza Below
        (0x00670, 0x00670,),  # Arabic Letter Superscrip..Arabic Letter Superscrip
        (0x006d6, 0x006dc,),  # Arabic Small High Ligatu..Arabic Small High Seen
        (0x006df, 0x006e4,),  # Arabic Small High Rounde..Arabic Small High Madda
        (0x006e7, 0x006e8,),  # Arabic Small High Yeh   ..Arabic Small High Noon
        (0x006ea, 0x006ed,),  # Arabic Empty Centre Low ..Arabic Small Low Meem
        (0x00711, 0x00711,),  # Syriac Letter Superscrip..Syriac Letter Superscrip
        (0x00730, 0x0074a,),  # Syriac Pthaha Above     ..Syriac Barrekh
        (0x007a6, 0x007b0,),  # Thaana Abafili          ..Thaana Sukun
        (0x007eb, 0x007f3,),  # Nko Combining Short High..Nko Combining Double Dot
        (0x007fd, 0x007fd,),  # Nko Dantayalan          ..Nko Dantayalan
        (0x00816, 0x00819,),  # Samaritan Mark In       ..Samaritan Mark Dagesh
        (0x0081b, 0x00823,),  # Samaritan Mark Epentheti..Samaritan Vowel Sign A
        (0x00825, 0x00827,),  # Samaritan Vowel Sign Sho..Samaritan Vowel Sign U
        (0x00829, 0x0082d,),  # Samaritan Vowel Sign Lon..Samaritan Mark Nequdaa
        (0x00859, 0x0085b,),  # Mandaic Affrication Mark..Mandaic Gemination Mark
        (0x008d3, 0x008e1,),  # Arabic Small Low Waw    ..Arabic Small High Sign S
        (0x008e3, 0x00902,),  # Arabic Turned Damma Belo..Devanagari Sign Anusvara
        (0x0093a, 0x0093a,),  # Devanagari Vowel Sign Oe..Devanagari Vowel Sign Oe
        (0x0093c, 0x0093c,),  # Devanagari Sign Nukta   ..Devanagari Sign Nukta
        (0x00941, 0x00948,),  # Devanagari Vowel Sign U ..Devanagari Vowel Sign Ai
        (0x0094d, 0x0094d,),  # Devanagari Sign Virama  ..Devanagari Sign Virama
        (0x00951, 0x00957,),  # Devanagari Stress Sign U..Devanagari Vowel Sign Uu
        (0x00962, 0x00963,),  # Devanagari Vowel Sign Vo..Devanagari Vowel Sign Vo
        (0x00981, 0x00981,),  # Bengali Sign Candrabindu..Bengali Sign Candrabindu
        (0x009bc, 0x009bc,),  # Bengali Sign Nukta      ..Bengali Sign Nukta
        (0x009c1, 0x009c4,),  # Bengali Vowel Sign U    ..Bengali Vowel Sign Vocal
        (0x009cd, 0x009cd,),  # Bengali Sign Virama     ..Bengali Sign Virama
        (0x009e2, 0x009e3,),  # Bengali Vowel Sign Vocal..Bengali Vowel Sign Vocal
        (0x009fe, 0x009fe,),  # Bengali Sandhi Mark     ..Bengali Sandhi Mark
        (0x00a01, 0x00a02,),  # Gurmukhi Sign Adak Bindi..Gurmukhi Sign Bindi
        (0x00a3c, 0x00a3c,),  # Gurmukhi Sign Nukta     ..Gurmukhi Sign Nukta
        (0x00a41, 0x00a42,),  # Gurmukhi Vowel Sign U   ..Gurmukhi Vowel Sign Uu
        (0x00a47, 0x00a48,),  # Gurmukhi Vowel Sign Ee  ..Gurmukhi Vowel Sign Ai
        (0x00a4b, 0x00a4d,),  # Gurmukhi Vowel Sign Oo  ..Gurmukhi Sign Virama
        (0x00a51, 0x00a51,),  # Gurmukhi Sign Udaat     ..Gurmukhi Sign Udaat
        (0x00a70, 0x00a71,),  # Gurmukhi Tippi          ..Gurmukhi Addak
        (0x00a75, 0x00a75,),  # Gurmukhi Sign Yakash    ..Gurmukhi Sign Yakash
        (0x00a81, 0x00a82,),  # Gujarati Sign Candrabind..Gujarati Sign Anusvara
        (0x00abc, 0x00abc,),  # Gujarati Sign Nukta     ..Gujarati Sign Nukta
        (0x00ac1, 0x00ac5,),  # Gujarati Vowel Sign U   ..Gujarati Vowel Sign Cand
        (0x00ac7, 0x00ac8,),  # Gujarati Vowel Sign E   ..Gujarati Vowel Sign Ai
        (0x00acd, 0x00acd,),  # Gujarati Sign Virama    ..Gujarati Sign Virama
        (0x00ae2, 0x00ae3,),  # Gujarati Vowel Sign Voca..Gujarati Vowel Sign Voca
        (0x00afa, 0x00aff,),  # Gujarati Sign Sukun     ..Gujarati Sign Two-circle
        (0x00b01, 0x00b01,),  # Oriya Sign Candrabindu  ..Oriya Sign Candrabindu
        (0x00b3c, 0x00b3c,),  # Oriya Sign Nukta        ..Oriya Sign Nukta
        (0x00b3f, 0x00b3f,),  # Oriya Vowel Sign I      ..Oriya Vowel Sign I
        (0x00b41, 0x00b44,),  # Oriya Vowel Sign U      ..Oriya Vowel Sign Vocalic
        (0x00b4d, 0x00b4d,),  # Oriya Sign Virama       ..Oriya Sign Virama
        (0x00b56, 0x00b56,),  # Oriya Ai Length Mark    ..Oriya Ai Length Mark
        (0x00b62, 0x00b63,),  # Oriya Vowel Sign Vocalic..Oriya Vowel Sign Vocalic
        (0x00b82, 0x00b82,),  # Tamil Sign Anusvara     ..Tamil Sign Anusvara
        (0x00bc0, 0x00bc0,),  # Tamil Vowel Sign Ii     ..Tamil Vowel Sign Ii
        (0x00bcd, 0x00bcd,),  # Tamil Sign Virama       ..Tamil Sign Virama
        (0x00c00, 0x00c00,),  # Telugu Sign Combining Ca..Telugu Sign Combining Ca
        (0x00c04, 0x00c04,),  # Telugu Sign Combining An..Telugu Sign Combining An
        (0x00c3e, 0x00c40,),  # Telugu Vowel Sign Aa    ..Telugu Vowel Sign Ii
        (0x00c46, 0x00c48,),  # Telugu Vowel Sign E     ..Telugu Vowel Sign Ai
        (0x00c4a, 0x00c4d,),  # Telugu Vowel Sign O     ..Telugu Sign Virama
        (0x00c55, 0x00c56,),  # Telugu Length Mark      ..Telugu Ai Length Mark
        (0x00c62, 0x00c63,),  # Telugu Vowel Sign Vocali..Telugu Vowel Sign Vocali
        (0x00c81, 0x00c81,),  # Kannada Sign Candrabindu..Kannada Sign Candrabindu
        (0x00cbc, 0x00cbc,),  # Kannada Sign Nukta      ..Kannada Sign Nukta
        (0x00cbf, 0x00cbf,),  # Kannada Vowel Sign I    ..Kannada Vowel Sign I
        (0x00cc6, 0x00cc6,),  # Kannada Vowel Sign E    ..Kannada Vowel Sign E
        (0x00ccc, 0x00ccd,),  # Kannada Vowel Sign Au   ..Kannada Sign Virama
        (0x00ce2, 0x00ce3,),  # Kannada Vowel Sign Vocal..Kannada Vowel Sign Vocal
        (0x00d00, 0x00d01,),  # Malayalam Sign Combining..Malayalam Sign Candrabin
        (0x00d3b, 0x00d3c,),  # Malayalam Sign Vertical ..Malayalam Sign Circular
        (0x00d41, 0x00d44,),  # Malayalam Vowel Sign U  ..Malayalam Vowel Sign Voc
        (0x00d4d, 0x00d4d,),  # Malayalam Sign Virama   ..Malayalam Sign Virama
        (0x00d62, 0x00d63,),  # Malayalam Vowel Sign Voc..Malayalam Vowel Sign Voc
        (0x00dca, 0x00dca,),  # Sinhala Sign Al-lakuna  ..Sinhala Sign Al-lakuna
        (0x00dd2, 0x00dd4,),  # Sinhala Vowel Sign Ketti..Sinhala Vowel Sign Ketti
        (0x00dd6, 0x00dd6,),  # Sinhala Vowel Sign Diga ..Sinhala Vowel Sign Diga
        (0x00e31, 0x00e31,),  # Thai Character Mai Han-a..Thai Character Mai Han-a
        (0x00e34, 0x00e3a,),  # Thai Character Sara I   ..Thai Character Phinthu
        (0x00e47, 0x00e4e,),  # Thai Character Maitaikhu..Thai Character Yamakkan
        (0x00eb1, 0x00eb1,),  # Lao Vowel Sign Mai Kan  ..Lao Vowel Sign Mai Kan
        (0x00eb4, 0x00ebc,),  # Lao Vowel Sign I        ..Lao Semivowel Sign Lo
        (0x00ec8, 0x00ecd,),  # Lao Tone Mai Ek         ..Lao Niggahita
        (0x00f18, 0x00f19,),  # Tibetan Astrological Sig..Tibetan Astrological Sig
        (0x00f35, 0x00f35,),  # Tibetan Mark Ngas Bzung ..Tibetan Mark Ngas Bzung
        (0x00f37, 0x00f37,),  # Tibetan Mark Ngas Bzung ..Tibetan Mark Ngas Bzung
        (0x00f39, 0x00f39,),  # Tibetan Mark Tsa -phru  ..Tibetan Mark Tsa -phru
        (0x00f71, 0x00f7e,),  # Tibetan Vowel Sign Aa   ..Tibetan Sign Rjes Su Nga
        (0x00f80, 0x00f84,),  # Tibetan Vowel Sign Rever..Tibetan Mark Halanta
        (0x00f86, 0x00f87,),  # Tibetan Sign Lci Rtags  ..Tibetan Sign Yang Rtags
        (0x00f8d, 0x00f97,),  # Tibetan Subjoined Sign L..Tibetan Subjoined Letter
        (0x00f99, 0x00fbc,),  # Tibetan Subjoined Letter..Tibetan Subjoined Letter
        (0x00fc6, 0x00fc6,),  # Tibetan Symbol Padma Gda..Tibetan Symbol Padma Gda
        (0x0102d, 0x01030,),  # Myanmar Vowel Sign I    ..Myanmar Vowel Sign Uu
        (0x01032, 0x01037,),  # Myanmar Vowel Sign Ai   ..Myanmar Sign Dot Below
        (0x01039, 0x0103a,),  # Myanmar Sign Virama     ..Myanmar Sign Asat
        (0x0103d, 0x0103e,),  # Myanmar Consonant Sign M..Myanmar Consonant Sign M
        (0x01058, 0x01059,),  # Myanmar Vowel Sign Vocal..Myanmar Vowel Sign Vocal
        (0x0105e, 0x01060,),  # Myanmar Consonant Sign M..Myanmar Consonant Sign M
        (0x01071, 0x01074,),  # Myanmar Vowel Sign Geba ..Myanmar Vowel Sign Kayah
        (0x01082, 0x01082,),  # Myanmar Consonant Sign S..Myanmar Consonant Sign S
        (0x01085, 0x01086,),  # Myanmar Vowel Sign Shan ..Myanmar Vowel Sign Shan
        (0x0108d, 0x0108d,),  # Myanmar Sign Shan Counci..Myanmar Sign Shan Counci
        (0x0109d, 0x0109d,),  # Myanmar Vowel Sign Aiton..Myanmar Vowel Sign Aiton
        (0x0135d, 0x0135f,),  # Ethiopic Combining Gemin..Ethiopic Combining Gemin
        (0x01712, 0x01714,),  # Tagalog Vowel Sign I    ..Tagalog Sign Virama
        (0x01732, 0x01734,),  # Hanunoo Vowel Sign I    ..Hanunoo Sign Pamudpod
        (0x01752, 0x01753,),  # Buhid Vowel Sign I      ..Buhid Vowel Sign U
        (0x01772, 0x01773,),  # Tagbanwa Vowel Sign I   ..Tagbanwa Vowel Sign U
        (0x017b4, 0x017b5,),  # Khmer Vowel Inherent Aq ..Khmer Vowel Inherent Aa
        (0x017b7, 0x017bd,),  # Khmer Vowel Sign I      ..Khmer Vowel Sign Ua
        (0x017c6, 0x017c6,),  # Khmer Sign Nikahit      ..Khmer Sign Nikahit
        (0x017c9, 0x017d3,),  # Khmer Sign Muusikatoan  ..Khmer Sign Bathamasat
        (0x017dd, 0x017dd,),  # Khmer Sign Atthacan     ..Khmer Sign Atthacan
        (0x0180b, 0x0180d,),  # Mongolian Free Variation..Mongolian Free Variation
        (0x01885, 0x01886,),  # Mongolian Letter Ali Gal..Mongolian Letter Ali Gal
        (0x018a9, 0x018a9,),  # Mongolian Letter Ali Gal..Mongolian Letter Ali Gal
        (0x01920, 0x01922,),  # Limbu Vowel Sign A      ..Limbu Vowel Sign U
        (0x01927, 0x01928,),  # Limbu Vowel Sign E      ..Limbu Vowel Sign O
        (0x01932, 0x01932,),  # Limbu Small Letter Anusv..Limbu Small Letter Anusv
        (0x01939, 0x0193b,),  # Limbu Sign Mukphreng    ..Limbu Sign Sa-i
        (0x01a17, 0x01a18,),  # Buginese Vowel Sign I   ..Buginese Vowel Sign U
        (0x01a1b, 0x01a1b,),  # Buginese Vowel Sign Ae  ..Buginese Vowel Sign Ae
        (0x01a56, 0x01a56,),  # Tai Tham Consonant Sign ..Tai Tham Consonant Sign
        (0x01a58, 0x01a5e,),  # Tai Tham Sign Mai Kang L..Tai Tham Consonant Sign
        (0x01a60, 0x01a60,),  # Tai Tham Sign Sakot     ..Tai Tham Sign Sakot
        (0x01a62, 0x01a62,),  # Tai Tham Vowel Sign Mai ..Tai Tham Vowel Sign Mai
        (0x01a65, 0x01a6c,),  # Tai Tham Vowel Sign I   ..Tai Tham Vowel Sign Oa B
        (0x01a73, 0x01a7c,),  # Tai Tham Vowel Sign Oa A..Tai Tham Sign Khuen-lue
        (0x01a7f, 0x01a7f,),  # Tai Tham Combining Crypt..Tai Tham Combining Crypt
        (0x01ab0, 0x01abe,),  # Combining Doubled Circum..Combining Parentheses Ov
        (0x01b00, 0x01b03,),  # Balinese Sign Ulu Ricem ..Balinese Sign Surang
        (0x01b34, 0x01b34,),  # Balinese Sign Rerekan   ..Balinese Sign Rerekan
        (0x01b36, 0x01b3a,),  # Balinese Vowel Sign Ulu ..Balinese Vowel Sign Ra R
        (0x01b3c, 0x01b3c,),  # Balinese Vowel Sign La L..Balinese Vowel Sign La L
        (0x01b42, 0x01b42,),  # Balinese Vowel Sign Pepe..Balinese Vowel Sign Pepe
        (0x01b6b, 0x01b73,),  # Balinese Musical Symbol ..Balinese Musical Symbol
        (0x01b80, 0x01b81,),  # Sundanese Sign Panyecek ..Sundanese Sign Panglayar
        (0x01ba2, 0x01ba5,),  # Sundanese Consonant Sign..Sundanese Vowel Sign Pan
        (0x01ba8, 0x01ba9,),  # Sundanese Vowel Sign Pam..Sundanese Vowel Sign Pan
        (0x01bab, 0x01bad,),  # Sundanese Sign Virama   ..Sundanese Consonant Sign
        (0x01be6, 0x01be6,),  # Batak Sign Tompi        ..Batak Sign Tompi
        (0x01be8, 0x01be9,),  # Batak Vowel Sign Pakpak ..Batak Vowel Sign Ee
        (0x01bed, 0x01bed,),  # Batak Vowel Sign Karo O ..Batak Vowel Sign Karo O
        (0x01bef, 0x01bf1,),  # Batak Vowel Sign U For S..Batak Consonant Sign H
        (0x01c2c, 0x01c33,),  # Lepcha Vowel Sign E     ..Lepcha Consonant Sign T
        (0x01c36, 0x01c37,),  # Lepcha Sign Ran         ..Lepcha Sign Nukta
        (0x01cd0, 0x01cd2,),  # Vedic Tone Karshana     ..Vedic Tone Prenkha
        (0x01cd4, 0x01ce0,),  # Vedic Sign Yajurvedic Mi..Vedic Tone Rigvedic Kash
        (0x01ce2, 0x01ce8,),  # Vedic Sign Visarga Svari..Vedic Sign Visarga Anuda
        (0x01ced, 0x01ced,),  # Vedic Sign Tiryak       ..Vedic Sign Tiryak
        (0x01cf4, 0x01cf4,),  # Vedic Tone Candra Above ..Vedic Tone Candra Above
        (0x01cf8, 0x01cf9,),  # Vedic Tone Ring Above   ..Vedic Tone Double Ring A
        (0x01dc0, 0x01df9,),  # Combining Dotted Grave A..Combining Wide Inverted
        (0x01dfb, 0x01dff,),  # Combining Deletion Mark ..Combining Right Arrowhea
        (0x020d0, 0x020f0,),  # Combining Left Harpoon A..Combining Asterisk Above
        (0x02cef, 0x02cf1,),  # Coptic Combining Ni Abov..Coptic Combining Spiritu
        (0x02d7f, 0x02d7f,),  # Tifinagh Consonant Joine..Tifinagh Consonant Joine
        (0x02de0, 0x02dff,),  # Combining Cyrillic Lette..Combining Cyrillic Lette
        (0x0302a, 0x0302d,),  # Ideographic Level Tone M..Ideographic Entering Ton
        (0x03099, 0x0309a,),  # Combining Katakana-hirag..Combining Katakana-hirag
        (0x0a66f, 0x0a672,),  # Combining Cyrillic Vzmet..Combining Cyrillic Thous
        (0x0a674, 0x0a67d,),  # Combining Cyrillic Lette..Combining Cyrillic Payer
        (0x0a69e, 0x0a69f,),  # Combining Cyrillic Lette..Combining Cyrillic Lette
        (0x0a6f0, 0x0a6f1,),  # Bamum Combining Mark Koq..Bamum Combining Mark Tuk
        (0x0a802, 0x0a802,),  # Syloti Nagri Sign Dvisva..Syloti Nagri Sign Dvisva
        (0x0a806, 0x0a806,),  # Syloti Nagri Sign Hasant..Syloti Nagri Sign Hasant
        (0x0a80b, 0x0a80b,),  # Syloti Nagri Sign Anusva..Syloti Nagri Sign Anusva
        (0x0a825, 0x0a826,),  # Syloti Nagri Vowel Sign ..Syloti Nagri Vowel Sign
        (0x0a8c4, 0x0a8c5,),  # Saurashtra Sign Virama  ..Saurashtra Sign Candrabi
        (0x0a8e0, 0x0a8f1,),  # Combining Devanagari Dig..Combining Devanagari Sig
        (0x0a8ff, 0x0a8ff,),  # Devanagari Vowel Sign Ay..Devanagari Vowel Sign Ay
        (0x0a926, 0x0a92d,),  # Kayah Li Vowel Ue       ..Kayah Li Tone Calya Plop
        (0x0a947, 0x0a951,),  # Rejang Vowel Sign I     ..Rejang Consonant Sign R
        (0x0a980, 0x0a982,),  # Javanese Sign Panyangga ..Javanese Sign Layar
        (0x0a9b3, 0x0a9b3,),  # Javanese Sign Cecak Telu..Javanese Sign Cecak Telu
        (0x0a9b6, 0x0a9b9,),  # Javanese Vowel Sign Wulu..Javanese Vowel Sign Suku
        (0x0a9bc, 0x0a9bd,),  # Javanese Vowel Sign Pepe..Javanese Consonant Sign
        (0x0a9e5, 0x0a9e5,),  # Myanmar Sign Shan Saw   ..Myanmar Sign Shan Saw
        (0x0aa29, 0x0aa2e,),  # Cham Vowel Sign Aa      ..Cham Vowel Sign Oe
        (0x0aa31, 0x0aa32,),  # Cham Vowel Sign Au      ..Cham Vowel Sign Ue
        (0x0aa35, 0x0aa36,),  # Cham Consonant Sign La  ..Cham Consonant Sign Wa
        (0x0aa43, 0x0aa43,),  # Cham Consonant Sign Fina..Cham Consonant Sign Fina
        (0x0aa4c, 0x0aa4c,),  # Cham Consonant Sign Fina..Cham Consonant Sign Fina
        (0x0aa7c, 0x0aa7c,),  # Myanmar Sign Tai Laing T..Myanmar Sign Tai Laing T
        (0x0aab0, 0x0aab0,),  # Tai Viet Mai Kang       ..Tai Viet Mai Kang
        (0x0aab2, 0x0aab4,),  # Tai Viet Vowel I        ..Tai Viet Vowel U
        (0x0aab7, 0x0aab8,),  # Tai Viet Mai Khit       ..Tai Viet Vowel Ia
        (0x0aabe, 0x0aabf,),  # Tai Viet Vowel Am       ..Tai Viet Tone Mai Ek
        (0x0aac1, 0x0aac1,),  # Tai Viet Tone Mai Tho   ..Tai Viet Tone Mai Tho
        (0x0aaec, 0x0aaed,),  # Meetei Mayek Vowel Sign ..Meetei Mayek Vowel Sign
        (0x0aaf6, 0x0aaf6,),  # Meetei Mayek Virama     ..Meetei Mayek Virama
        (0x0abe5, 0x0abe5,),  # Meetei Mayek Vowel Sign ..Meetei Mayek Vowel Sign
        (0x0abe8, 0x0abe8,),  # Meetei Mayek Vowel Sign ..Meetei Mayek Vowel Sign
        (0x0abed, 0x0abed,),  # Meetei Mayek Apun Iyek  ..Meetei Mayek Apun Iyek
        (0x0fb1e, 0x0fb1e,),  # Hebrew Point Judeo-spani..Hebrew Point Judeo-spani
        (0x0fe00, 0x0fe0f,),  # Variation Selector-1    ..Variation Selector-16
        (0x0fe20, 0x0fe2f,),  # Combining Ligature Left ..Combining Cyrillic Titlo
        (0x101fd, 0x101fd,),  # Phaistos Disc Sign Combi..Phaistos Disc Sign Combi
        (0x102e0, 0x102e0,),  # Coptic Epact Thousands M..Coptic Epact Thousands M
        (0x10376, 0x1037a,),  # Combining Old Permic Let..Combining Old Permic Let
        (0x10a01, 0x10a03,),  # Kharoshthi Vowel Sign I ..Kharoshthi Vowel Sign Vo
        (0x10a05, 0x10a06,),  # Kharoshthi Vowel Sign E ..Kharoshthi Vowel Sign O
        (0x10a0c, 0x10a0f,),  # Kharoshthi Vowel Length ..Kharoshthi Sign Visarga
        (0x10a38, 0x10a3a,),  # Kharoshthi Sign Bar Abov..Kharoshthi Sign Dot Belo
        (0x10a3f, 0x10a3f,),  # Kharoshthi Virama       ..Kharoshthi Virama
        (0x10ae5, 0x10ae6,),  # Manichaean Abbreviation ..Manichaean Abbreviation
        (0x10d24, 0x10d27,),  # Hanifi Rohingya Sign Har..Hanifi Rohingya Sign Tas
        (0x10f46, 0x10f50,),  # Sogdian Combining Dot Be..Sogdian Combining Stroke
        (0x11001, 0x11001,),  # Brahmi Sign Anusvara    ..Brahmi Sign Anusvara
        (0x11038, 0x11046,),  # Brahmi Vowel Sign Aa    ..Brahmi Virama
        (0x1107f, 0x11081,),  # Brahmi Number Joiner    ..Kaithi Sign Anusvara
        (0x110b3, 0x110b6,),  # Kaithi Vowel Sign U     ..Kaithi Vowel Sign Ai
        (0x110b9, 0x110ba,),  # Kaithi Sign Virama      ..Kaithi Sign Nukta
        (0x11100, 0x11102,),  # Chakma Sign Candrabindu ..Chakma Sign Visarga
        (0x11127, 0x1112b,),  # Chakma Vowel Sign A     ..Chakma Vowel Sign Uu
        (0x1112d, 0x11134,),  # Chakma Vowel Sign Ai    ..Chakma Maayyaa
        (0x11173, 0x11173,),  # Mahajani Sign Nukta     ..Mahajani Sign Nukta
        (0x11180, 0x11181,),  # Sharada Sign Candrabindu..Sharada Sign Anusvara
        (0x111b6, 0x111be,),  # Sharada Vowel Sign U    ..Sharada Vowel Sign O
        (0x111c9, 0x111cc,),  # Sharada Sandhi Mark     ..Sharada Extra Short Vowe
        (0x1122f, 0x11231,),  # Khojki Vowel Sign U     ..Khojki Vowel Sign Ai
        (0x11234, 0x11234,),  # Khojki Sign Anusvara    ..Khojki Sign Anusvara
        (0x11236, 0x11237,),  # Khojki Sign Nukta       ..Khojki Sign Shadda
        (0x1123e, 0x1123e,),  # Khojki Sign Sukun       ..Khojki Sign Sukun
        (0x112df, 0x112df,),  # Khudawadi Sign Anusvara ..Khudawadi Sign Anusvara
        (0x112e3, 0x112ea,),  # Khudawadi Vowel Sign U  ..Khudawadi Sign Virama
        (0x11300, 0x11301,),  # Grantha Sign Combining A..Grantha Sign Candrabindu
        (0x1133b, 0x1133c,),  # Combining Bindu Below   ..Grantha Sign Nukta
        (0x11340, 0x11340,),  # Grantha Vowel Sign Ii   ..Grantha Vowel Sign Ii
        (0x11366, 0x1136c,),  # Combining Grantha Digit ..Combining Grantha Digit
        (0x11370, 0x11374,),  # Combining Grantha Letter..Combining Grantha Letter
        (0x11438, 0x1143f,),  # Newa Vowel Sign U       ..Newa Vowel Sign Ai
        (0x11442, 0x11444,),  # Newa Sign Virama        ..Newa Sign Anusvara
        (0x11446, 0x11446,),  # Newa Sign Nukta         ..Newa Sign Nukta
        (0x1145e, 0x1145e,),  # Newa Sandhi Mark        ..Newa Sandhi Mark
        (0x114b3, 0x114b8,),  # Tirhuta Vowel Sign U    ..Tirhuta Vowel Sign Vocal
        (0x114ba, 0x114ba,),  # Tirhuta Vowel Sign Short..Tirhuta Vowel Sign Short
        (0x114bf, 0x114c0,),  # Tirhuta Sign Candrabindu..Tirhuta Sign Anusvara
        (0x114c2, 0x114c3,),  # Tirhuta Sign Virama     ..Tirhuta Sign Nukta
        (0x115b2, 0x115b5,),  # Siddham Vowel Sign U    ..Siddham Vowel Sign Vocal
        (0x115bc, 0x115bd,),  # Siddham Sign Candrabindu..Siddham Sign Anusvara
        (0x115bf, 0x115c0,),  # Siddham Sign Virama     ..Siddham Sign Nukta
        (0x115dc, 0x115dd,),  # Siddham Vowel Sign Alter..Siddham Vowel Sign Alter
        (0x11633, 0x1163a,),  # Modi Vowel Sign U       ..Modi Vowel Sign Ai
        (0x1163d, 0x1163d,),  # Modi Sign Anusvara      ..Modi Sign Anusvara
        (0x1163f, 0x11640,),  # Modi Sign Virama        ..Modi Sign Ardhacandra
        (0x116ab, 0x116ab,),  # Takri Sign Anusvara     ..Takri Sign Anusvara
        (0x116ad, 0x116ad,),  # Takri Vowel Sign Aa     ..Takri Vowel Sign Aa
        (0x116b0, 0x116b5,),  # Takri Vowel Sign U      ..Takri Vowel Sign Au
        (0x116b7, 0x116b7,),  # Takri Sign Nukta        ..Takri Sign Nukta
        (0x1171d, 0x1171f,),  # Ahom Consonant Sign Medi..Ahom Consonant Sign Medi
        (0x11722, 0x11725,),  # Ahom Vowel Sign I       ..Ahom Vowel Sign Uu
        (0x11727, 0x1172b,),  # Ahom Vowel Sign Aw      ..Ahom Sign Killer
        (0x1182f, 0x11837,),  # Dogra Vowel Sign U      ..Dogra Sign Anusvara
        (0x11839, 0x1183a,),  # Dogra Sign Virama       ..Dogra Sign Nukta
        (0x119d4, 0x119d7,),  # Nandinagari Vowel Sign U..Nandinagari Vowel Sign V
        (0x119da, 0x119db,),  # Nandinagari Vowel Sign E..Nandinagari Vowel Sign A
        (0x119e0, 0x119e0,),  # Nandinagari Sign Virama ..Nandinagari Sign Virama
        (0x11a01, 0x11a0a,),  # Zanabazar Square Vowel S..Zanabazar Square Vowel L
        (0x11a33, 0x11a38,),  # Zanabazar Square Final C..Zanabazar Square Sign An
        (0x11a3b, 0x11a3e,),  # Zanabazar Square Cluster..Zanabazar Square Cluster
        (0x11a47, 0x11a47,),  # Zanabazar Square Subjoin..Zanabazar Square Subjoin
        (0x11a51, 0x11a56,),  # Soyombo Vowel Sign I    ..Soyombo Vowel Sign Oe
        (0x11a59, 0x11a5b,),  # Soyombo Vowel Sign Vocal..Soyombo Vowel Length Mar
        (0x11a8a, 0x11a96,),  # Soyombo Final Consonant ..Soyombo Sign Anusvara
        (0x11a98, 0x11a99,),  # Soyombo Gemination Mark ..Soyombo Subjoiner
        (0x11c30, 0x11c36,),  # Bhaiksuki Vowel Sign I  ..Bhaiksuki Vowel Sign Voc
        (0x11c38, 0x11c3d,),  # Bhaiksuki Vowel Sign E  ..Bhaiksuki Sign Anusvara
        (0x11c3f, 0x11c3f,),  # Bhaiksuki Sign Virama   ..Bhaiksuki Sign Virama
        (0x11c92, 0x11ca7,),  # Marchen Subjoined Letter..Marchen Subjoined Letter
        (0x11caa, 0x11cb0,),  # Marchen Subjoined Letter..Marchen Vowel Sign Aa
        (0x11cb2, 0x11cb3,),  # Marchen Vowel Sign U    ..Marchen Vowel Sign E
        (0x11cb5, 0x11cb6,),  # Marchen Sign Anusvara   ..Marchen Sign Candrabindu
        (0x11d31, 0x11d36,),  # Masaram Gondi Vowel Sign..Masaram Gondi Vowel Sign
        (0x11d3a, 0x11d3a,),  # Masaram Gondi Vowel Sign..Masaram Gondi Vowel Sign
        (0x11d3c, 0x11d3d,),  # Masaram Gondi Vowel Sign..Masaram Gondi Vowel Sign
        (0x11d3f, 0x11d45,),  # Masaram Gondi Vowel Sign..Masaram Gondi Virama
        (0x11d47, 0x11d47,),  # Masaram Gondi Ra-kara   ..Masaram Gondi Ra-kara
        (0x11d90, 0x11d91,),  # Gunjala Gondi Vowel Sign..Gunjala Gondi Vowel Sign
        (0x11d95, 0x11d95,),  # Gunjala Gondi Sign Anusv..Gunjala Gondi Sign Anusv
        (0x11d97, 0x11d97,),  # Gunjala Gondi Virama    ..Gunjala Gondi Virama
        (0x11ef3, 0x11ef4,),  # Makasar Vowel Sign I    ..Makasar Vowel Sign U
        (0x16af0, 0x16af4,),  # Bassa Vah Combining High..Bassa Vah Combining High
        (0x16b30, 0x16b36,),  # Pahawh Hmong Mark Cim Tu..Pahawh Hmong Mark Cim Ta
        (0x16f4f, 0x16f4f,),  # Miao Sign Consonant Modi..Miao Sign Consonant Modi
        (0x16f8f, 0x16f92,),  # Miao Tone Right         ..Miao Tone Below
        (0x1bc9d, 0x1bc9e,),  # Duployan Thick Letter Se..Duployan Double Mark
        (0x1d167, 0x1d169,),  # Musical Symbol Combining..Musical Symbol Combining
        (0x1d17b, 0x1d182,),  # Musical Symbol Combining..Musical Symbol Combining
        (0x1d185, 0x1d18b,),  # Musical Symbol Combining..Musical Symbol Combining
        (0x1d1aa, 0x1d1ad,),  # Musical Symbol Combining..Musical Symbol Combining
        (0x1d242, 0x1d244,),  # Combining Greek Musical ..Combining Greek Musical
        (0x1da00, 0x1da36,),  # Signwriting Head Rim    ..Signwriting Air Sucking
        (0x1da3b, 0x1da6c,),  # Signwriting Mouth Closed..Signwriting Excitement
        (0x1da75, 0x1da75,),  # Signwriting Upper Body T..Signwriting Upper Body T
        (0x1da84, 0x1da84,),  # Signwriting Location Hea..Signwriting Location Hea
        (0x1da9b, 0x1da9f,),  # Signwriting Fill Modifie..Signwriting Fill Modifie
        (0x1daa1, 0x1daaf,),  # Signwriting Rotation Mod..Signwriting Rotation Mod
        (0x1e000, 0x1e006,),  # Combining Glagolitic Let..Combining Glagolitic Let
        (0x1e008, 0x1e018,),  # Combining Glagolitic Let..Combining Glagolitic Let
        (0x1e01b, 0x1e021,),  # Combining Glagolitic Let..Combining Glagolitic Let
        (0x1e023, 0x1e024,),  # Combining Glagolitic Let..Combining Glagolitic Let
        (0x1e026, 0x1e02a,),  # Combining Glagolitic Let..Combining Glagolitic Let
        (0x1e130, 0x1e136,),  # Nyiakeng Puachue Hmong T..Nyiakeng Puachue Hmong T
        (0x1e2ec, 0x1e2ef,),  # Wancho Tone Tup         ..Wancho Tone Koini
        (0x1e8d0, 0x1e8d6,),  # Mende Kikakui Combining ..Mende Kikakui Combining
        (0x1e944, 0x1e94a,),  # Adlam Alif Lengthener   ..Adlam Nukta
        (0xe0100, 0xe01ef,),  # Variation Selector-17   ..Variation Selector-256
    ),
    '12.1.0': (
        # Source: DerivedGeneralCategory-12.1.0.txt
        # Date:  2019-03-10, 10:53:08 GMT
        #
        (0x00300, 0x0036f,),  # Combining Grave Accent  ..Combining Latin Small Le
        (0x00483, 0x00489,),  # Combining Cyrillic Titlo..Combining Cyrillic Milli
        (0x00591, 0x005bd,),  # Hebrew Accent Etnahta   ..Hebrew Point Meteg
        (0x005bf, 0x005bf,),  # Hebrew Point Rafe       ..Hebrew Point Rafe
        (0x005c1, 0x005c2,),  # Hebrew Point Shin Dot   ..Hebrew Point Sin Dot
        (0x005c4, 0x005c5,),  # Hebrew Mark Upper Dot   ..Hebrew Mark Lower Dot
        (0x005c7, 0x005c7,),  # Hebrew Point Qamats Qata..Hebrew Point Qamats Qata
        (0x00610, 0x0061a,),  # Arabic Sign Sallallahou ..Arabic Small Kasra
        (0x0064b, 0x0065f,),  # Arabic Fathatan         ..Arabic Wavy Hamza Below
        (0x00670, 0x00670,),  # Arabic Letter Superscrip..Arabic Letter Superscrip
        (0x006d6, 0x006dc,),  # Arabic Small High Ligatu..Arabic Small High Seen
        (0x006df, 0x006e4,),  # Arabic Small High Rounde..Arabic Small High Madda
        (0x006e7, 0x006e8,),  # Arabic Small High Yeh   ..Arabic Small High Noon
        (0x006ea, 0x006ed,),  # Arabic Empty Centre Low ..Arabic Small Low Meem
        (0x00711, 0x00711,),  # Syriac Letter Superscrip..Syriac Letter Superscrip
        (0x00730, 0x0074a,),  # Syriac Pthaha Above     ..Syriac Barrekh
        (0x007a6, 0x007b0,),  # Thaana Abafili          ..Thaana Sukun
        (0x007eb, 0x007f3,),  # Nko Combining Short High..Nko Combining Double Dot
        (0x007fd, 0x007fd,),  # Nko Dantayalan          ..Nko Dantayalan
        (0x00816, 0x00819,),  # Samaritan Mark In       ..Samaritan Mark Dagesh
        (0x0081b, 0x00823,),  # Samaritan Mark Epentheti..Samaritan Vowel Sign A
        (0x00825, 0x00827,),  # Samaritan Vowel Sign Sho..Samaritan Vowel Sign U
        (0x00829, 0x0082d,),  # Samaritan Vowel Sign Lon..Samaritan Mark Nequdaa
        (0x00859, 0x0085b,),  # Mandaic Affrication Mark..Mandaic Gemination Mark
        (0x008d3, 0x008e1,),  # Arabic Small Low Waw    ..Arabic Small High Sign S
        (0x008e3, 0x00902,),  # Arabic Turned Damma Belo..Devanagari Sign Anusvara
        (0x0093a, 0x0093a,),  # Devanagari Vowel Sign Oe..Devanagari Vowel Sign Oe
        (0x0093c, 0x0093c,),  # Devanagari Sign Nukta   ..Devanagari Sign Nukta
        (0x00941, 0x00948,),  # Devanagari Vowel Sign U ..Devanagari Vowel Sign Ai
        (0x0094d, 0x0094d,),  # Devanagari Sign Virama  ..Devanagari Sign Virama
        (0x00951, 0x00957,),  # Devanagari Stress Sign U..Devanagari Vowel Sign Uu
        (0x00962, 0x00963,),  # Devanagari Vowel Sign Vo..Devanagari Vowel Sign Vo
        (0x00981, 0x00981,),  # Bengali Sign Candrabindu..Bengali Sign Candrabindu
        (0x009bc, 0x009bc,),  # Bengali Sign Nukta      ..Bengali Sign Nukta
        (0x009c1, 0x009c4,),  # Bengali Vowel Sign U    ..Bengali Vowel Sign Vocal
        (0x009cd, 0x009cd,),  # Bengali Sign Virama     ..Bengali Sign Virama
        (0x009e2, 0x009e3,),  # Bengali Vowel Sign Vocal..Bengali Vowel Sign Vocal
        (0x009fe, 0x009fe,),  # Bengali Sandhi Mark     ..Bengali Sandhi Mark
        (0x00a01, 0x00a02,),  # Gurmukhi Sign Adak Bindi..Gurmukhi Sign Bindi
        (0x00a3c, 0x00a3c,),  # Gurmukhi Sign Nukta     ..Gurmukhi Sign Nukta
        (0x00a41, 0x00a42,),  # Gurmukhi Vowel Sign U   ..Gurmukhi Vowel Sign Uu
        (0x00a47, 0x00a48,),  # Gurmukhi Vowel Sign Ee  ..Gurmukhi Vowel Sign Ai
        (0x00a4b, 0x00a4d,),  # Gurmukhi Vowel Sign Oo  ..Gurmukhi Sign Virama
        (0x00a51, 0x00a51,),  # Gurmukhi Sign Udaat     ..Gurmukhi Sign Udaat
        (0x00a70, 0x00a71,),  # Gurmukhi Tippi          ..Gurmukhi Addak
        (0x00a75, 0x00a75,),  # Gurmukhi Sign Yakash    ..Gurmukhi Sign Yakash
        (0x00a81, 0x00a82,),  # Gujarati Sign Candrabind..Gujarati Sign Anusvara
        (0x00abc, 0x00abc,),  # Gujarati Sign Nukta     ..Gujarati Sign Nukta
        (0x00ac1, 0x00ac5,),  # Gujarati Vowel Sign U   ..Gujarati Vowel Sign Cand
        (0x00ac7, 0x00ac8,),  # Gujarati Vowel Sign E   ..Gujarati Vowel Sign Ai
        (0x00acd, 0x00acd,),  # Gujarati Sign Virama    ..Gujarati Sign Virama
        (0x00ae2, 0x00ae3,),  # Gujarati Vowel Sign Voca..Gujarati Vowel Sign Voca
        (0x00afa, 0x00aff,),  # Gujarati Sign Sukun     ..Gujarati Sign Two-circle
        (0x00b01, 0x00b01,),  # Oriya Sign Candrabindu  ..Oriya Sign Candrabindu
        (0x00b3c, 0x00b3c,),  # Oriya Sign Nukta        ..Oriya Sign Nukta
        (0x00b3f, 0x00b3f,),  # Oriya Vowel Sign I      ..Oriya Vowel Sign I
        (0x00b41, 0x00b44,),  # Oriya Vowel Sign U      ..Oriya Vowel Sign Vocalic
        (0x00b4d, 0x00b4d,),  # Oriya Sign Virama       ..Oriya Sign Virama
        (0x00b56, 0x00b56,),  # Oriya Ai Length Mark    ..Oriya Ai Length Mark
        (0x00b62, 0x00b63,),  # Oriya Vowel Sign Vocalic..Oriya Vowel Sign Vocalic
        (0x00b82, 0x00b82,),  # Tamil Sign Anusvara     ..Tamil Sign Anusvara
        (0x00bc0, 0x00bc0,),  # Tamil Vowel Sign Ii     ..Tamil Vowel Sign Ii
        (0x00bcd, 0x00bcd,),  # Tamil Sign Virama       ..Tamil Sign Virama
        (0x00c00, 0x00c00,),  # Telugu Sign Combining Ca..Telugu Sign Combining Ca
        (0x00c04, 0x00c04,),  # Telugu Sign Combining An..Telugu Sign Combining An
        (0x00c3e, 0x00c40,),  # Telugu Vowel Sign Aa    ..Telugu Vowel Sign Ii
        (0x00c46, 0x00c48,),  # Telugu Vowel Sign E     ..Telugu Vowel Sign Ai
        (0x00c4a, 0x00c4d,),  # Telugu Vowel Sign O     ..Telugu Sign Virama
        (0x00c55, 0x00c56,),  # Telugu Length Mark      ..Telugu Ai Length Mark
        (0x00c62, 0x00c63,),  # Telugu Vowel Sign Vocali..Telugu Vowel Sign Vocali
        (0x00c81, 0x00c81,),  # Kannada Sign Candrabindu..Kannada Sign Candrabindu
        (0x00cbc, 0x00cbc,),  # Kannada Sign Nukta      ..Kannada Sign Nukta
        (0x00cbf, 0x00cbf,),  # Kannada Vowel Sign I    ..Kannada Vowel Sign I
        (0x00cc6, 0x00cc6,),  # Kannada Vowel Sign E    ..Kannada Vowel Sign E
        (0x00ccc, 0x00ccd,),  # Kannada Vowel Sign Au   ..Kannada Sign Virama
        (0x00ce2, 0x00ce3,),  # Kannada Vowel Sign Vocal..Kannada Vowel Sign Vocal
        (0x00d00, 0x00d01,),  # Malayalam Sign Combining..Malayalam Sign Candrabin
        (0x00d3b, 0x00d3c,),  # Malayalam Sign Vertical ..Malayalam Sign Circular
        (0x00d41, 0x00d44,),  # Malayalam Vowel Sign U  ..Malayalam Vowel Sign Voc
        (0x00d4d, 0x00d4d,),  # Malayalam Sign Virama   ..Malayalam Sign Virama
        (0x00d62, 0x00d63,),  # Malayalam Vowel Sign Voc..Malayalam Vowel Sign Voc
        (0x00dca, 0x00dca,),  # Sinhala Sign Al-lakuna  ..Sinhala Sign Al-lakuna
        (0x00dd2, 0x00dd4,),  # Sinhala Vowel Sign Ketti..Sinhala Vowel Sign Ketti
        (0x00dd6, 0x00dd6,),  # Sinhala Vowel Sign Diga ..Sinhala Vowel Sign Diga
        (0x00e31, 0x00e31,),  # Thai Character Mai Han-a..Thai Character Mai Han-a
        (0x00e34, 0x00e3a,),  # Thai Character Sara I   ..Thai Character Phinthu
        (0x00e47, 0x00e4e,),  # Thai Character Maitaikhu..Thai Character Yamakkan
        (0x00eb1, 0x00eb1,),  # Lao Vowel Sign Mai Kan  ..Lao Vowel Sign Mai Kan
        (0x00eb4, 0x00ebc,),  # Lao Vowel Sign I        ..Lao Semivowel Sign Lo
        (0x00ec8, 0x00ecd,),  # Lao Tone Mai Ek         ..Lao Niggahita
        (0x00f18, 0x00f19,),  # Tibetan Astrological Sig..Tibetan Astrological Sig
        (0x00f35, 0x00f35,),  # Tibetan Mark Ngas Bzung ..Tibetan Mark Ngas Bzung
        (0x00f37, 0x00f37,),  # Tibetan Mark Ngas Bzung ..Tibetan Mark Ngas Bzung
        (0x00f39, 0x00f39,),  # Tibetan Mark Tsa -phru  ..Tibetan Mark Tsa -phru
        (0x00f71, 0x00f7e,),  # Tibetan Vowel Sign Aa   ..Tibetan Sign Rjes Su Nga
        (0x00f80, 0x00f84,),  # Tibetan Vowel Sign Rever..Tibetan Mark Halanta
        (0x00f86, 0x00f87,),  # Tibetan Sign Lci Rtags  ..Tibetan Sign Yang Rtags
        (0x00f8d, 0x00f97,),  # Tibetan Subjoined Sign L..Tibetan Subjoined Letter
        (0x00f99, 0x00fbc,),  # Tibetan Subjoined Letter..Tibetan Subjoined Letter
        (0x00fc6, 0x00fc6,),  # Tibetan Symbol Padma Gda..Tibetan Symbol Padma Gda
        (0x0102d, 0x01030,),  # Myanmar Vowel Sign I    ..Myanmar Vowel Sign Uu
        (0x01032, 0x01037,),  # Myanmar Vowel Sign Ai   ..Myanmar Sign Dot Below
        (0x01039, 0x0103a,),  # Myanmar Sign Virama     ..Myanmar Sign Asat
        (0x0103d, 0x0103e,),  # Myanmar Consonant Sign M..Myanmar Consonant Sign M
        (0x01058, 0x01059,),  # Myanmar Vowel Sign Vocal..Myanmar Vowel Sign Vocal
        (0x0105e, 0x01060,),  # Myanmar Consonant Sign M..Myanmar Consonant Sign M
        (0x01071, 0x01074,),  # Myanmar Vowel Sign Geba ..Myanmar Vowel Sign Kayah
        (0x01082, 0x01082,),  # Myanmar Consonant Sign S..Myanmar Consonant Sign S
        (0x01085, 0x01086,),  # Myanmar Vowel Sign Shan ..Myanmar Vowel Sign Shan
        (0x0108d, 0x0108d,),  # Myanmar Sign Shan Counci..Myanmar Sign Shan Counci
        (0x0109d, 0x0109d,),  # Myanmar Vowel Sign Aiton..Myanmar Vowel Sign Aiton
        (0x0135d, 0x0135f,),  # Ethiopic Combining Gemin..Ethiopic Combining Gemin
        (0x01712, 0x01714,),  # Tagalog Vowel Sign I    ..Tagalog Sign Virama
        (0x01732, 0x01734,),  # Hanunoo Vowel Sign I    ..Hanunoo Sign Pamudpod
        (0x01752, 0x01753,),  # Buhid Vowel Sign I      ..Buhid Vowel Sign U
        (0x01772, 0x01773,),  # Tagbanwa Vowel Sign I   ..Tagbanwa Vowel Sign U
        (0x017b4, 0x017b5,),  # Khmer Vowel Inherent Aq ..Khmer Vowel Inherent Aa
        (0x017b7, 0x017bd,),  # Khmer Vowel Sign I      ..Khmer Vowel Sign Ua
        (0x017c6, 0x017c6,),  # Khmer Sign Nikahit      ..Khmer Sign Nikahit
        (0x017c9, 0x017d3,),  # Khmer Sign Muusikatoan  ..Khmer Sign Bathamasat
        (0x017dd, 0x017dd,),  # Khmer Sign Atthacan     ..Khmer Sign Atthacan
        (0x0180b, 0x0180d,),  # Mongolian Free Variation..Mongolian Free Variation
        (0x01885, 0x01886,),  # Mongolian Letter Ali Gal..Mongolian Letter Ali Gal
        (0x018a9, 0x018a9,),  # Mongolian Letter Ali Gal..Mongolian Letter Ali Gal
        (0x01920, 0x01922,),  # Limbu Vowel Sign A      ..Limbu Vowel Sign U
        (0x01927, 0x01928,),  # Limbu Vowel Sign E      ..Limbu Vowel Sign O
        (0x01932, 0x01932,),  # Limbu Small Letter Anusv..Limbu Small Letter Anusv
        (0x01939, 0x0193b,),  # Limbu Sign Mukphreng    ..Limbu Sign Sa-i
        (0x01a17, 0x01a18,),  # Buginese Vowel Sign I   ..Buginese Vowel Sign U
        (0x01a1b, 0x01a1b,),  # Buginese Vowel Sign Ae  ..Buginese Vowel Sign Ae
        (0x01a56, 0x01a56,),  # Tai Tham Consonant Sign ..Tai Tham Consonant Sign
        (0x01a58, 0x01a5e,),  # Tai Tham Sign Mai Kang L..Tai Tham Consonant Sign
        (0x01a60, 0x01a60,),  # Tai Tham Sign Sakot     ..Tai Tham Sign Sakot
        (0x01a62, 0x01a62,),  # Tai Tham Vowel Sign Mai ..Tai Tham Vowel Sign Mai
        (0x01a65, 0x01a6c,),  # Tai Tham Vowel Sign I   ..Tai Tham Vowel Sign Oa B
        (0x01a73, 0x01a7c,),  # Tai Tham Vowel Sign Oa A..Tai Tham Sign Khuen-lue
        (0x01a7f, 0x01a7f,),  # Tai Tham Combining Crypt..Tai Tham Combining Crypt
        (0x01ab0, 0x01abe,),  # Combining Doubled Circum..Combining Parentheses Ov
        (0x01b00, 0x01b03,),  # Balinese Sign Ulu Ricem ..Balinese Sign Surang
        (0x01b34, 0x01b34,),  # Balinese Sign Rerekan   ..Balinese Sign Rerekan
        (0x01b36, 0x01b3a,),  # Balinese Vowel Sign Ulu ..Balinese Vowel Sign Ra R
        (0x01b3c, 0x01b3c,),  # Balinese Vowel Sign La L..Balinese Vowel Sign La L
        (0x01b42, 0x01b42,),  # Balinese Vowel Sign Pepe..Balinese Vowel Sign Pepe
        (0x01b6b, 0x01b73,),  # Balinese Musical Symbol ..Balinese Musical Symbol
        (0x01b80, 0x01b81,),  # Sundanese Sign Panyecek ..Sundanese Sign Panglayar
        (0x01ba2, 0x01ba5,),  # Sundanese Consonant Sign..Sundanese Vowel Sign Pan
        (0x01ba8, 0x01ba9,),  # Sundanese Vowel Sign Pam..Sundanese Vowel Sign Pan
        (0x01bab, 0x01bad,),  # Sundanese Sign Virama   ..Sundanese Consonant Sign
        (0x01be6, 0x01be6,),  # Batak Sign Tompi        ..Batak Sign Tompi
        (0x01be8, 0x01be9,),  # Batak Vowel Sign Pakpak ..Batak Vowel Sign Ee
        (0x01bed, 0x01bed,),  # Batak Vowel Sign Karo O ..Batak Vowel Sign Karo O
        (0x01bef, 0x01bf1,),  # Batak Vowel Sign U For S..Batak Consonant Sign H
        (0x01c2c, 0x01c33,),  # Lepcha Vowel Sign E     ..Lepcha Consonant Sign T
        (0x01c36, 0x01c37,),  # Lepcha Sign Ran         ..Lepcha Sign Nukta
        (0x01cd0, 0x01cd2,),  # Vedic Tone Karshana     ..Vedic Tone Prenkha
        (0x01cd4, 0x01ce0,),  # Vedic Sign Yajurvedic Mi..Vedic Tone Rigvedic Kash
        (0x01ce2, 0x01ce8,),  # Vedic Sign Visarga Svari..Vedic Sign Visarga Anuda
        (0x01ced, 0x01ced,),  # Vedic Sign Tiryak       ..Vedic Sign Tiryak
        (0x01cf4, 0x01cf4,),  # Vedic Tone Candra Above ..Vedic Tone Candra Above
        (0x01cf8, 0x01cf9,),  # Vedic Tone Ring Above   ..Vedic Tone Double Ring A
        (0x01dc0, 0x01df9,),  # Combining Dotted Grave A..Combining Wide Inverted
        (0x01dfb, 0x01dff,),  # Combining Deletion Mark ..Combining Right Arrowhea
        (0x020d0, 0x020f0,),  # Combining Left Harpoon A..Combining Asterisk Above
        (0x02cef, 0x02cf1,),  # Coptic Combining Ni Abov..Coptic Combining Spiritu
        (0x02d7f, 0x02d7f,),  # Tifinagh Consonant Joine..Tifinagh Consonant Joine
        (0x02de0, 0x02dff,),  # Combining Cyrillic Lette..Combining Cyrillic Lette
        (0x0302a, 0x0302d,),  # Ideographic Level Tone M..Ideographic Entering Ton
        (0x03099, 0x0309a,),  # Combining Katakana-hirag..Combining Katakana-hirag
        (0x0a66f, 0x0a672,),  # Combining Cyrillic Vzmet..Combining Cyrillic Thous
        (0x0a674, 0x0a67d,),  # Combining Cyrillic Lette..Combining Cyrillic Payer
        (0x0a69e, 0x0a69f,),  # Combining Cyrillic Lette..Combining Cyrillic Lette
        (0x0a6f0, 0x0a6f1,),  # Bamum Combining Mark Koq..Bamum Combining Mark Tuk
        (0x0a802, 0x0a802,),  # Syloti Nagri Sign Dvisva..Syloti Nagri Sign Dvisva
        (0x0a806, 0x0a806,),  # Syloti Nagri Sign Hasant..Syloti Nagri Sign Hasant
        (0x0a80b, 0x0a80b,),  # Syloti Nagri Sign Anusva..Syloti Nagri Sign Anusva
        (0x0a825, 0x0a826,),  # Syloti Nagri Vowel Sign ..Syloti Nagri Vowel Sign
        (0x0a8c4, 0x0a8c5,),  # Saurashtra Sign Virama  ..Saurashtra Sign Candrabi
        (0x0a8e0, 0x0a8f1,),  # Combining Devanagari Dig..Combining Devanagari Sig
        (0x0a8ff, 0x0a8ff,),  # Devanagari Vowel Sign Ay..Devanagari Vowel Sign Ay
        (0x0a926, 0x0a92d,),  # Kayah Li Vowel Ue       ..Kayah Li Tone Calya Plop
        (0x0a947, 0x0a951,),  # Rejang Vowel Sign I     ..Rejang Consonant Sign R
        (0x0a980, 0x0a982,),  # Javanese Sign Panyangga ..Javanese Sign Layar
        (0x0a9b3, 0x0a9b3,),  # Javanese Sign Cecak Telu..Javanese Sign Cecak Telu
        (0x0a9b6, 0x0a9b9,),  # Javanese Vowel Sign Wulu..Javanese Vowel Sign Suku
        (0x0a9bc, 0x0a9bd,),  # Javanese Vowel Sign Pepe..Javanese Consonant Sign
        (0x0a9e5, 0x0a9e5,),  # Myanmar Sign Shan Saw   ..Myanmar Sign Shan Saw
        (0x0aa29, 0x0aa2e,),  # Cham Vowel Sign Aa      ..Cham Vowel Sign Oe
        (0x0aa31, 0x0aa32,),  # Cham Vowel Sign Au      ..Cham Vowel Sign Ue
        (0x0aa35, 0x0aa36,),  # Cham Consonant Sign La  ..Cham Consonant Sign Wa
        (0x0aa43, 0x0aa43,),  # Cham Consonant Sign Fina..Cham Consonant Sign Fina
        (0x0aa4c, 0x0aa4c,),  # Cham Consonant Sign Fina..Cham Consonant Sign Fina
        (0x0aa7c, 0x0aa7c,),  # Myanmar Sign Tai Laing T..Myanmar Sign Tai Laing T
        (0x0aab0, 0x0aab0,),  # Tai Viet Mai Kang       ..Tai Viet Mai Kang
        (0x0aab2, 0x0aab4,),  # Tai Viet Vowel I        ..Tai Viet Vowel U
        (0x0aab7, 0x0aab8,),  # Tai Viet Mai Khit       ..Tai Viet Vowel Ia
        (0x0aabe, 0x0aabf,),  # Tai Viet Vowel Am       ..Tai Viet Tone Mai Ek
        (0x0aac1, 0x0aac1,),  # Tai Viet Tone Mai Tho   ..Tai Viet Tone Mai Tho
        (0x0aaec, 0x0aaed,),  # Meetei Mayek Vowel Sign ..Meetei Mayek Vowel Sign
        (0x0aaf6, 0x0aaf6,),  # Meetei Mayek Virama     ..Meetei Mayek Virama
        (0x0abe5, 0x0abe5,),  # Meetei Mayek Vowel Sign ..Meetei Mayek Vowel Sign
        (0x0abe8, 0x0abe8,),  # Meetei Mayek Vowel Sign ..Meetei Mayek Vowel Sign
        (0x0abed, 0x0abed,),  # Meetei Mayek Apun Iyek  ..Meetei Mayek Apun Iyek
        (0x0fb1e, 0x0fb1e,),  # Hebrew Point Judeo-spani..Hebrew Point Judeo-spani
        (0x0fe00, 0x0fe0f,),  # Variation Selector-1    ..Variation Selector-16
        (0x0fe20, 0x0fe2f,),  # Combining Ligature Left ..Combining Cyrillic Titlo
        (0x101fd, 0x101fd,),  # Phaistos Disc Sign Combi..Phaistos Disc Sign Combi
        (0x102e0, 0x102e0,),  # Coptic Epact Thousands M..Coptic Epact Thousands M
        (0x10376, 0x1037a,),  # Combining Old Permic Let..Combining Old Permic Let
        (0x10a01, 0x10a03,),  # Kharoshthi Vowel Sign I ..Kharoshthi Vowel Sign Vo
        (0x10a05, 0x10a06,),  # Kharoshthi Vowel Sign E ..Kharoshthi Vowel Sign O
        (0x10a0c, 0x10a0f,),  # Kharoshthi Vowel Length ..Kharoshthi Sign Visarga
        (0x10a38, 0x10a3a,),  # Kharoshthi Sign Bar Abov..Kharoshthi Sign Dot Belo
        (0x10a3f, 0x10a3f,),  # Kharoshthi Virama       ..Kharoshthi Virama
        (0x10ae5, 0x10ae6,),  # Manichaean Abbreviation ..Manichaean Abbreviation
        (0x10d24, 0x10d27,),  # Hanifi Rohingya Sign Har..Hanifi Rohingya Sign Tas
        (0x10f46, 0x10f50,),  # Sogdian Combining Dot Be..Sogdian Combining Stroke
        (0x11001, 0x11001,),  # Brahmi Sign Anusvara    ..Brahmi Sign Anusvara
        (0x11038, 0x11046,),  # Brahmi Vowel Sign Aa    ..Brahmi Virama
        (0x1107f, 0x11081,),  # Brahmi Number Joiner    ..Kaithi Sign Anusvara
        (0x110b3, 0x110b6,),  # Kaithi Vowel Sign U     ..Kaithi Vowel Sign Ai
        (0x110b9, 0x110ba,),  # Kaithi Sign Virama      ..Kaithi Sign Nukta
        (0x11100, 0x11102,),  # Chakma Sign Candrabindu ..Chakma Sign Visarga
        (0x11127, 0x1112b,),  # Chakma Vowel Sign A     ..Chakma Vowel Sign Uu
        (0x1112d, 0x11134,),  # Chakma Vowel Sign Ai    ..Chakma Maayyaa
        (0x11173, 0x11173,),  # Mahajani Sign Nukta     ..Mahajani Sign Nukta
        (0x11180, 0x11181,),  # Sharada Sign Candrabindu..Sharada Sign Anusvara
        (0x111b6, 0x111be,),  # Sharada Vowel Sign U    ..Sharada Vowel Sign O
        (0x111c9, 0x111cc,),  # Sharada Sandhi Mark     ..Sharada Extra Short Vowe
        (0x1122f, 0x11231,),  # Khojki Vowel Sign U     ..Khojki Vowel Sign Ai
        (0x11234, 0x11234,),  # Khojki Sign Anusvara    ..Khojki Sign Anusvara
        (0x11236, 0x11237,),  # Khojki Sign Nukta       ..Khojki Sign Shadda
        (0x1123e, 0x1123e,),  # Khojki Sign Sukun       ..Khojki Sign Sukun
        (0x112df, 0x112df,),  # Khudawadi Sign Anusvara ..Khudawadi Sign Anusvara
        (0x112e3, 0x112ea,),  # Khudawadi Vowel Sign U  ..Khudawadi Sign Virama
        (0x11300, 0x11301,),  # Grantha Sign Combining A..Grantha Sign Candrabindu
        (0x1133b, 0x1133c,),  # Combining Bindu Below   ..Grantha Sign Nukta
        (0x11340, 0x11340,),  # Grantha Vowel Sign Ii   ..Grantha Vowel Sign Ii
        (0x11366, 0x1136c,),  # Combining Grantha Digit ..Combining Grantha Digit
        (0x11370, 0x11374,),  # Combining Grantha Letter..Combining Grantha Letter
        (0x11438, 0x1143f,),  # Newa Vowel Sign U       ..Newa Vowel Sign Ai
        (0x11442, 0x11444,),  # Newa Sign Virama        ..Newa Sign Anusvara
        (0x11446, 0x11446,),  # Newa Sign Nukta         ..Newa Sign Nukta
        (0x1145e, 0x1145e,),  # Newa Sandhi Mark        ..Newa Sandhi Mark
        (0x114b3, 0x114b8,),  # Tirhuta Vowel Sign U    ..Tirhuta Vowel Sign Vocal
        (0x114ba, 0x114ba,),  # Tirhuta Vowel Sign Short..Tirhuta Vowel Sign Short
        (0x114bf, 0x114c0,),  # Tirhuta Sign Candrabindu..Tirhuta Sign Anusvara
        (0x114c2, 0x114c3,),  # Tirhuta Sign Virama     ..Tirhuta Sign Nukta
        (0x115b2, 0x115b5,),  # Siddham Vowel Sign U    ..Siddham Vowel Sign Vocal
        (0x115bc, 0x115bd,),  # Siddham Sign Candrabindu..Siddham Sign Anusvara
        (0x115bf, 0x115c0,),  # Siddham Sign Virama     ..Siddham Sign Nukta
        (0x115dc, 0x115dd,),  # Siddham Vowel Sign Alter..Siddham Vowel Sign Alter
        (0x11633, 0x1163a,),  # Modi Vowel Sign U       ..Modi Vowel Sign Ai
        (0x1163d, 0x1163d,),  # Modi Sign Anusvara      ..Modi Sign Anusvara
        (0x1163f, 0x11640,),  # Modi Sign Virama        ..Modi Sign Ardhacandra
        (0x116ab, 0x116ab,),  # Takri Sign Anusvara     ..Takri Sign Anusvara
        (0x116ad, 0x116ad,),  # Takri Vowel Sign Aa     ..Takri Vowel Sign Aa
        (0x116b0, 0x116b5,),  # Takri Vowel Sign U      ..Takri Vowel Sign Au
        (0x116b7, 0x116b7,),  # Takri Sign Nukta        ..Takri Sign Nukta
        (0x1171d, 0x1171f,),  # Ahom Consonant Sign Medi..Ahom Consonant Sign Medi
        (0x11722, 0x11725,),  # Ahom Vowel Sign I       ..Ahom Vowel Sign Uu
        (0x11727, 0x1172b,),  # Ahom Vowel Sign Aw      ..Ahom Sign Killer
        (0x1182f, 0x11837,),  # Dogra Vowel Sign U      ..Dogra Sign Anusvara
        (0x11839, 0x1183a,),  # Dogra Sign Virama       ..Dogra Sign Nukta
        (0x119d4, 0x119d7,),  # Nandinagari Vowel Sign U..Nandinagari Vowel Sign V
        (0x119da, 0x119db,),  # Nandinagari Vowel Sign E..Nandinagari Vowel Sign A
        (0x119e0, 0x119e0,),  # Nandinagari Sign Virama ..Nandinagari Sign Virama
        (0x11a01, 0x11a0a,),  # Zanabazar Square Vowel S..Zanabazar Square Vowel L
        (0x11a33, 0x11a38,),  # Zanabazar Square Final C..Zanabazar Square Sign An
        (0x11a3b, 0x11a3e,),  # Zanabazar Square Cluster..Zanabazar Square Cluster
        (0x11a47, 0x11a47,),  # Zanabazar Square Subjoin..Zanabazar Square Subjoin
        (0x11a51, 0x11a56,),  # Soyombo Vowel Sign I    ..Soyombo Vowel Sign Oe
        (0x11a59, 0x11a5b,),  # Soyombo Vowel Sign Vocal..Soyombo Vowel Length Mar
        (0x11a8a, 0x11a96,),  # Soyombo Final Consonant ..Soyombo Sign Anusvara
        (0x11a98, 0x11a99,),  # Soyombo Gemination Mark ..Soyombo Subjoiner
        (0x11c30, 0x11c36,),  # Bhaiksuki Vowel Sign I  ..Bhaiksuki Vowel Sign Voc
        (0x11c38, 0x11c3d,),  # Bhaiksuki Vowel Sign E  ..Bhaiksuki Sign Anusvara
        (0x11c3f, 0x11c3f,),  # Bhaiksuki Sign Virama   ..Bhaiksuki Sign Virama
        (0x11c92, 0x11ca7,),  # Marchen Subjoined Letter..Marchen Subjoined Letter
        (0x11caa, 0x11cb0,),  # Marchen Subjoined Letter..Marchen Vowel Sign Aa
        (0x11cb2, 0x11cb3,),  # Marchen Vowel Sign U    ..Marchen Vowel Sign E
        (0x11cb5, 0x11cb6,),  # Marchen Sign Anusvara   ..Marchen Sign Candrabindu
        (0x11d31, 0x11d36,),  # Masaram Gondi Vowel Sign..Masaram Gondi Vowel Sign
        (0x11d3a, 0x11d3a,),  # Masaram Gondi Vowel Sign..Masaram Gondi Vowel Sign
        (0x11d3c, 0x11d3d,),  # Masaram Gondi Vowel Sign..Masaram Gondi Vowel Sign
        (0x11d3f, 0x11d45,),  # Masaram Gondi Vowel Sign..Masaram Gondi Virama
        (0x11d47, 0x11d47,),  # Masaram Gondi Ra-kara   ..Masaram Gondi Ra-kara
        (0x11d90, 0x11d91,),  # Gunjala Gondi Vowel Sign..Gunjala Gondi Vowel Sign
        (0x11d95, 0x11d95,),  # Gunjala Gondi Sign Anusv..Gunjala Gondi Sign Anusv
        (0x11d97, 0x11d97,),  # Gunjala Gondi Virama    ..Gunjala Gondi Virama
        (0x11ef3, 0x11ef4,),  # Makasar Vowel Sign I    ..Makasar Vowel Sign U
        (0x16af0, 0x16af4,),  # Bassa Vah Combining High..Bassa Vah Combining High
        (0x16b30, 0x16b36,),  # Pahawh Hmong Mark Cim Tu..Pahawh Hmong Mark Cim Ta
        (0x16f4f, 0x16f4f,),  # Miao Sign Consonant Modi..Miao Sign Consonant Modi
        (0x16f8f, 0x16f92,),  # Miao Tone Right         ..Miao Tone Below
        (0x1bc9d, 0x1bc9e,),  # Duployan Thick Letter Se..Duployan Double Mark
        (0x1d167, 0x1d169,),  # Musical Symbol Combining..Musical Symbol Combining
        (0x1d17b, 0x1d182,),  # Musical Symbol Combining..Musical Symbol Combining
        (0x1d185, 0x1d18b,),  # Musical Symbol Combining..Musical Symbol Combining
        (0x1d1aa, 0x1d1ad,),  # Musical Symbol Combining..Musical Symbol Combining
        (0x1d242, 0x1d244,),  # Combining Greek Musical ..Combining Greek Musical
        (0x1da00, 0x1da36,),  # Signwriting Head Rim    ..Signwriting Air Sucking
        (0x1da3b, 0x1da6c,),  # Signwriting Mouth Closed..Signwriting Excitement
        (0x1da75, 0x1da75,),  # Signwriting Upper Body T..Signwriting Upper Body T
        (0x1da84, 0x1da84,),  # Signwriting Location Hea..Signwriting Location Hea
        (0x1da9b, 0x1da9f,),  # Signwriting Fill Modifie..Signwriting Fill Modifie
        (0x1daa1, 0x1daaf,),  # Signwriting Rotation Mod..Signwriting Rotation Mod
        (0x1e000, 0x1e006,),  # Combining Glagolitic Let..Combining Glagolitic Let
        (0x1e008, 0x1e018,),  # Combining Glagolitic Let..Combining Glagolitic Let
        (0x1e01b, 0x1e021,),  # Combining Glagolitic Let..Combining Glagolitic Let
        (0x1e023, 0x1e024,),  # Combining Glagolitic Let..Combining Glagolitic Let
        (0x1e026, 0x1e02a,),  # Combining Glagolitic Let..Combining Glagolitic Let
        (0x1e130, 0x1e136,),  # Nyiakeng Puachue Hmong T..Nyiakeng Puachue Hmong T
        (0x1e2ec, 0x1e2ef,),  # Wancho Tone Tup         ..Wancho Tone Koini
        (0x1e8d0, 0x1e8d6,),  # Mende Kikakui Combining ..Mende Kikakui Combining
        (0x1e944, 0x1e94a,),  # Adlam Alif Lengthener   ..Adlam Nukta
        (0xe0100, 0xe01ef,),  # Variation Selector-17   ..Variation Selector-256
    ),
    '13.0.0': (
        # Source: DerivedGeneralCategory-13.0.0.txt
        # Date:  2019-10-21, 14:30:32 GMT
        #
        (0x00300, 0x0036f,),  # Combining Grave Accent  ..Combining Latin Small Le
        (0x00483, 0x00489,),  # Combining Cyrillic Titlo..Combining Cyrillic Milli
        (0x00591, 0x005bd,),  # Hebrew Accent Etnahta   ..Hebrew Point Meteg
        (0x005bf, 0x005bf,),  # Hebrew Point Rafe       ..Hebrew Point Rafe
        (0x005c1, 0x005c2,),  # Hebrew Point Shin Dot   ..Hebrew Point Sin Dot
        (0x005c4, 0x005c5,),  # Hebrew Mark Upper Dot   ..Hebrew Mark Lower Dot
        (0x005c7, 0x005c7,),  # Hebrew Point Qamats Qata..Hebrew Point Qamats Qata
        (0x00610, 0x0061a,),  # Arabic Sign Sallallahou ..Arabic Small Kasra
        (0x0064b, 0x0065f,),  # Arabic Fathatan         ..Arabic Wavy Hamza Below
        (0x00670, 0x00670,),  # Arabic Letter Superscrip..Arabic Letter Superscrip
        (0x006d6, 0x006dc,),  # Arabic Small High Ligatu..Arabic Small High Seen
        (0x006df, 0x006e4,),  # Arabic Small High Rounde..Arabic Small High Madda
        (0x006e7, 0x006e8,),  # Arabic Small High Yeh   ..Arabic Small High Noon
        (0x006ea, 0x006ed,),  # Arabic Empty Centre Low ..Arabic Small Low Meem
        (0x00711, 0x00711,),  # Syriac Letter Superscrip..Syriac Letter Superscrip
        (0x00730, 0x0074a,),  # Syriac Pthaha Above     ..Syriac Barrekh
        (0x007a6, 0x007b0,),  # Thaana Abafili          ..Thaana Sukun
        (0x007eb, 0x007f3,),  # Nko Combining Short High..Nko Combining Double Dot
        (0x007fd, 0x007fd,),  # Nko Dantayalan          ..Nko Dantayalan
        (0x00816, 0x00819,),  # Samaritan Mark In       ..Samaritan Mark Dagesh
        (0x0081b, 0x00823,),  # Samaritan Mark Epentheti..Samaritan Vowel Sign A
        (0x00825, 0x00827,),  # Samaritan Vowel Sign Sho..Samaritan Vowel Sign U
        (0x00829, 0x0082d,),  # Samaritan Vowel Sign Lon..Samaritan Mark Nequdaa
        (0x00859, 0x0085b,),  # Mandaic Affrication Mark..Mandaic Gemination Mark
        (0x008d3, 0x008e1,),  # Arabic Small Low Waw    ..Arabic Small High Sign S
        (0x008e3, 0x00902,),  # Arabic Turned Damma Belo..Devanagari Sign Anusvara
        (0x0093a, 0x0093a,),  # Devanagari Vowel Sign Oe..Devanagari Vowel Sign Oe
        (0x0093c, 0x0093c,),  # Devanagari Sign Nukta   ..Devanagari Sign Nukta
        (0x00941, 0x00948,),  # Devanagari Vowel Sign U ..Devanagari Vowel Sign Ai
        (0x0094d, 0x0094d,),  # Devanagari Sign Virama  ..Devanagari Sign Virama
        (0x00951, 0x00957,),  # Devanagari Stress Sign U..Devanagari Vowel Sign Uu
        (0x00962, 0x00963,),  # Devanagari Vowel Sign Vo..Devanagari Vowel Sign Vo
        (0x00981, 0x00981,),  # Bengali Sign Candrabindu..Bengali Sign Candrabindu
        (0x009bc, 0x009bc,),  # Bengali Sign Nukta      ..Bengali Sign Nukta
        (0x009c1, 0x009c4,),  # Bengali Vowel Sign U    ..Bengali Vowel Sign Vocal
        (0x009cd, 0x009cd,),  # Bengali Sign Virama     ..Bengali Sign Virama
        (0x009e2, 0x009e3,),  # Bengali Vowel Sign Vocal..Bengali Vowel Sign Vocal
        (0x009fe, 0x009fe,),  # Bengali Sandhi Mark     ..Bengali Sandhi Mark
        (0x00a01, 0x00a02,),  # Gurmukhi Sign Adak Bindi..Gurmukhi Sign Bindi
        (0x00a3c, 0x00a3c,),  # Gurmukhi Sign Nukta     ..Gurmukhi Sign Nukta
        (0x00a41, 0x00a42,),  # Gurmukhi Vowel Sign U   ..Gurmukhi Vowel Sign Uu
        (0x00a47, 0x00a48,),  # Gurmukhi Vowel Sign Ee  ..Gurmukhi Vowel Sign Ai
        (0x00a4b, 0x00a4d,),  # Gurmukhi Vowel Sign Oo  ..Gurmukhi Sign Virama
        (0x00a51, 0x00a51,),  # Gurmukhi Sign Udaat     ..Gurmukhi Sign Udaat
        (0x00a70, 0x00a71,),  # Gurmukhi Tippi          ..Gurmukhi Addak
        (0x00a75, 0x00a75,),  # Gurmukhi Sign Yakash    ..Gurmukhi Sign Yakash
        (0x00a81, 0x00a82,),  # Gujarati Sign Candrabind..Gujarati Sign Anusvara
        (0x00abc, 0x00abc,),  # Gujarati Sign Nukta     ..Gujarati Sign Nukta
        (0x00ac1, 0x00ac5,),  # Gujarati Vowel Sign U   ..Gujarati Vowel Sign Cand
        (0x00ac7, 0x00ac8,),  # Gujarati Vowel Sign E   ..Gujarati Vowel Sign Ai
        (0x00acd, 0x00acd,),  # Gujarati Sign Virama    ..Gujarati Sign Virama
        (0x00ae2, 0x00ae3,),  # Gujarati Vowel Sign Voca..Gujarati Vowel Sign Voca
        (0x00afa, 0x00aff,),  # Gujarati Sign Sukun     ..Gujarati Sign Two-circle
        (0x00b01, 0x00b01,),  # Oriya Sign Candrabindu  ..Oriya Sign Candrabindu
        (0x00b3c, 0x00b3c,),  # Oriya Sign Nukta        ..Oriya Sign Nukta
        (0x00b3f, 0x00b3f,),  # Oriya Vowel Sign I      ..Oriya Vowel Sign I
        (0x00b41, 0x00b44,),  # Oriya Vowel Sign U      ..Oriya Vowel Sign Vocalic
        (0x00b4d, 0x00b4d,),  # Oriya Sign Virama       ..Oriya Sign Virama
        (0x00b55, 0x00b56,),  # (nil)                   ..Oriya Ai Length Mark
        (0x00b62, 0x00b63,),  # Oriya Vowel Sign Vocalic..Oriya Vowel Sign Vocalic
        (0x00b82, 0x00b82,),  # Tamil Sign Anusvara     ..Tamil Sign Anusvara
        (0x00bc0, 0x00bc0,),  # Tamil Vowel Sign Ii     ..Tamil Vowel Sign Ii
        (0x00bcd, 0x00bcd,),  # Tamil Sign Virama       ..Tamil Sign Virama
        (0x00c00, 0x00c00,),  # Telugu Sign Combining Ca..Telugu Sign Combining Ca
        (0x00c04, 0x00c04,),  # Telugu Sign Combining An..Telugu Sign Combining An
        (0x00c3e, 0x00c40,),  # Telugu Vowel Sign Aa    ..Telugu Vowel Sign Ii
        (0x00c46, 0x00c48,),  # Telugu Vowel Sign E     ..Telugu Vowel Sign Ai
        (0x00c4a, 0x00c4d,),  # Telugu Vowel Sign O     ..Telugu Sign Virama
        (0x00c55, 0x00c56,),  # Telugu Length Mark      ..Telugu Ai Length Mark
        (0x00c62, 0x00c63,),  # Telugu Vowel Sign Vocali..Telugu Vowel Sign Vocali
        (0x00c81, 0x00c81,),  # Kannada Sign Candrabindu..Kannada Sign Candrabindu
        (0x00cbc, 0x00cbc,),  # Kannada Sign Nukta      ..Kannada Sign Nukta
        (0x00cbf, 0x00cbf,),  # Kannada Vowel Sign I    ..Kannada Vowel Sign I
        (0x00cc6, 0x00cc6,),  # Kannada Vowel Sign E    ..Kannada Vowel Sign E
        (0x00ccc, 0x00ccd,),  # Kannada Vowel Sign Au   ..Kannada Sign Virama
        (0x00ce2, 0x00ce3,),  # Kannada Vowel Sign Vocal..Kannada Vowel Sign Vocal
        (0x00d00, 0x00d01,),  # Malayalam Sign Combining..Malayalam Sign Candrabin
        (0x00d3b, 0x00d3c,),  # Malayalam Sign Vertical ..Malayalam Sign Circular
        (0x00d41, 0x00d44,),  # Malayalam Vowel Sign U  ..Malayalam Vowel Sign Voc
        (0x00d4d, 0x00d4d,),  # Malayalam Sign Virama   ..Malayalam Sign Virama
        (0x00d62, 0x00d63,),  # Malayalam Vowel Sign Voc..Malayalam Vowel Sign Voc
        (0x00d81, 0x00d81,),  # (nil)                   ..(nil)
        (0x00dca, 0x00dca,),  # Sinhala Sign Al-lakuna  ..Sinhala Sign Al-lakuna
        (0x00dd2, 0x00dd4,),  # Sinhala Vowel Sign Ketti..Sinhala Vowel Sign Ketti
        (0x00dd6, 0x00dd6,),  # Sinhala Vowel Sign Diga ..Sinhala Vowel Sign Diga
        (0x00e31, 0x00e31,),  # Thai Character Mai Han-a..Thai Character Mai Han-a
        (0x00e34, 0x00e3a,),  # Thai Character Sara I   ..Thai Character Phinthu
        (0x00e47, 0x00e4e,),  # Thai Character Maitaikhu..Thai Character Yamakkan
        (0x00eb1, 0x00eb1,),  # Lao Vowel Sign Mai Kan  ..Lao Vowel Sign Mai Kan
        (0x00eb4, 0x00ebc,),  # Lao Vowel Sign I        ..Lao Semivowel Sign Lo
        (0x00ec8, 0x00ecd,),  # Lao Tone Mai Ek         ..Lao Niggahita
        (0x00f18, 0x00f19,),  # Tibetan Astrological Sig..Tibetan Astrological Sig
        (0x00f35, 0x00f35,),  # Tibetan Mark Ngas Bzung ..Tibetan Mark Ngas Bzung
        (0x00f37, 0x00f37,),  # Tibetan Mark Ngas Bzung ..Tibetan Mark Ngas Bzung
        (0x00f39, 0x00f39,),  # Tibetan Mark Tsa -phru  ..Tibetan Mark Tsa -phru
        (0x00f71, 0x00f7e,),  # Tibetan Vowel Sign Aa   ..Tibetan Sign Rjes Su Nga
        (0x00f80, 0x00f84,),  # Tibetan Vowel Sign Rever..Tibetan Mark Halanta
        (0x00f86, 0x00f87,),  # Tibetan Sign Lci Rtags  ..Tibetan Sign Yang Rtags
        (0x00f8d, 0x00f97,),  # Tibetan Subjoined Sign L..Tibetan Subjoined Letter
        (0x00f99, 0x00fbc,),  # Tibetan Subjoined Letter..Tibetan Subjoined Letter
        (0x00fc6, 0x00fc6,),  # Tibetan Symbol Padma Gda..Tibetan Symbol Padma Gda
        (0x0102d, 0x01030,),  # Myanmar Vowel Sign I    ..Myanmar Vowel Sign Uu
        (0x01032, 0x01037,),  # Myanmar Vowel Sign Ai   ..Myanmar Sign Dot Below
        (0x01039, 0x0103a,),  # Myanmar Sign Virama     ..Myanmar Sign Asat
        (0x0103d, 0x0103e,),  # Myanmar Consonant Sign M..Myanmar Consonant Sign M
        (0x01058, 0x01059,),  # Myanmar Vowel Sign Vocal..Myanmar Vowel Sign Vocal
        (0x0105e, 0x01060,),  # Myanmar Consonant Sign M..Myanmar Consonant Sign M
        (0x01071, 0x01074,),  # Myanmar Vowel Sign Geba ..Myanmar Vowel Sign Kayah
        (0x01082, 0x01082,),  # Myanmar Consonant Sign S..Myanmar Consonant Sign S
        (0x01085, 0x01086,),  # Myanmar Vowel Sign Shan ..Myanmar Vowel Sign Shan
        (0x0108d, 0x0108d,),  # Myanmar Sign Shan Counci..Myanmar Sign Shan Counci
        (0x0109d, 0x0109d,),  # Myanmar Vowel Sign Aiton..Myanmar Vowel Sign Aiton
        (0x0135d, 0x0135f,),  # Ethiopic Combining Gemin..Ethiopic Combining Gemin
        (0x01712, 0x01714,),  # Tagalog Vowel Sign I    ..Tagalog Sign Virama
        (0x01732, 0x01734,),  # Hanunoo Vowel Sign I    ..Hanunoo Sign Pamudpod
        (0x01752, 0x01753,),  # Buhid Vowel Sign I      ..Buhid Vowel Sign U
        (0x01772, 0x01773,),  # Tagbanwa Vowel Sign I   ..Tagbanwa Vowel Sign U
        (0x017b4, 0x017b5,),  # Khmer Vowel Inherent Aq ..Khmer Vowel Inherent Aa
        (0x017b7, 0x017bd,),  # Khmer Vowel Sign I      ..Khmer Vowel Sign Ua
        (0x017c6, 0x017c6,),  # Khmer Sign Nikahit      ..Khmer Sign Nikahit
        (0x017c9, 0x017d3,),  # Khmer Sign Muusikatoan  ..Khmer Sign Bathamasat
        (0x017dd, 0x017dd,),  # Khmer Sign Atthacan     ..Khmer Sign Atthacan
        (0x0180b, 0x0180d,),  # Mongolian Free Variation..Mongolian Free Variation
        (0x01885, 0x01886,),  # Mongolian Letter Ali Gal..Mongolian Letter Ali Gal
        (0x018a9, 0x018a9,),  # Mongolian Letter Ali Gal..Mongolian Letter Ali Gal
        (0x01920, 0x01922,),  # Limbu Vowel Sign A      ..Limbu Vowel Sign U
        (0x01927, 0x01928,),  # Limbu Vowel Sign E      ..Limbu Vowel Sign O
        (0x01932, 0x01932,),  # Limbu Small Letter Anusv..Limbu Small Letter Anusv
        (0x01939, 0x0193b,),  # Limbu Sign Mukphreng    ..Limbu Sign Sa-i
        (0x01a17, 0x01a18,),  # Buginese Vowel Sign I   ..Buginese Vowel Sign U
        (0x01a1b, 0x01a1b,),  # Buginese Vowel Sign Ae  ..Buginese Vowel Sign Ae
        (0x01a56, 0x01a56,),  # Tai Tham Consonant Sign ..Tai Tham Consonant Sign
        (0x01a58, 0x01a5e,),  # Tai Tham Sign Mai Kang L..Tai Tham Consonant Sign
        (0x01a60, 0x01a60,),  # Tai Tham Sign Sakot     ..Tai Tham Sign Sakot
        (0x01a62, 0x01a62,),  # Tai Tham Vowel Sign Mai ..Tai Tham Vowel Sign Mai
        (0x01a65, 0x01a6c,),  # Tai Tham Vowel Sign I   ..Tai Tham Vowel Sign Oa B
        (0x01a73, 0x01a7c,),  # Tai Tham Vowel Sign Oa A..Tai Tham Sign Khuen-lue
        (0x01a7f, 0x01a7f,),  # Tai Tham Combining Crypt..Tai Tham Combining Crypt
        (0x01ab0, 0x01ac0,),  # Combining Doubled Circum..(nil)
        (0x01b00, 0x01b03,),  # Balinese Sign Ulu Ricem ..Balinese Sign Surang
        (0x01b34, 0x01b34,),  # Balinese Sign Rerekan   ..Balinese Sign Rerekan
        (0x01b36, 0x01b3a,),  # Balinese Vowel Sign Ulu ..Balinese Vowel Sign Ra R
        (0x01b3c, 0x01b3c,),  # Balinese Vowel Sign La L..Balinese Vowel Sign La L
        (0x01b42, 0x01b42,),  # Balinese Vowel Sign Pepe..Balinese Vowel Sign Pepe
        (0x01b6b, 0x01b73,),  # Balinese Musical Symbol ..Balinese Musical Symbol
        (0x01b80, 0x01b81,),  # Sundanese Sign Panyecek ..Sundanese Sign Panglayar
        (0x01ba2, 0x01ba5,),  # Sundanese Consonant Sign..Sundanese Vowel Sign Pan
        (0x01ba8, 0x01ba9,),  # Sundanese Vowel Sign Pam..Sundanese Vowel Sign Pan
        (0x01bab, 0x01bad,),  # Sundanese Sign Virama   ..Sundanese Consonant Sign
        (0x01be6, 0x01be6,),  # Batak Sign Tompi        ..Batak Sign Tompi
        (0x01be8, 0x01be9,),  # Batak Vowel Sign Pakpak ..Batak Vowel Sign Ee
        (0x01bed, 0x01bed,),  # Batak Vowel Sign Karo O ..Batak Vowel Sign Karo O
        (0x01bef, 0x01bf1,),  # Batak Vowel Sign U For S..Batak Consonant Sign H
        (0x01c2c, 0x01c33,),  # Lepcha Vowel Sign E     ..Lepcha Consonant Sign T
        (0x01c36, 0x01c37,),  # Lepcha Sign Ran         ..Lepcha Sign Nukta
        (0x01cd0, 0x01cd2,),  # Vedic Tone Karshana     ..Vedic Tone Prenkha
        (0x01cd4, 0x01ce0,),  # Vedic Sign Yajurvedic Mi..Vedic Tone Rigvedic Kash
        (0x01ce2, 0x01ce8,),  # Vedic Sign Visarga Svari..Vedic Sign Visarga Anuda
        (0x01ced, 0x01ced,),  # Vedic Sign Tiryak       ..Vedic Sign Tiryak
        (0x01cf4, 0x01cf4,),  # Vedic Tone Candra Above ..Vedic Tone Candra Above
        (0x01cf8, 0x01cf9,),  # Vedic Tone Ring Above   ..Vedic Tone Double Ring A
        (0x01dc0, 0x01df9,),  # Combining Dotted Grave A..Combining Wide Inverted
        (0x01dfb, 0x01dff,),  # Combining Deletion Mark ..Combining Right Arrowhea
        (0x020d0, 0x020f0,),  # Combining Left Harpoon A..Combining Asterisk Above
        (0x02cef, 0x02cf1,),  # Coptic Combining Ni Abov..Coptic Combining Spiritu
        (0x02d7f, 0x02d7f,),  # Tifinagh Consonant Joine..Tifinagh Consonant Joine
        (0x02de0, 0x02dff,),  # Combining Cyrillic Lette..Combining Cyrillic Lette
        (0x0302a, 0x0302d,),  # Ideographic Level Tone M..Ideographic Entering Ton
        (0x03099, 0x0309a,),  # Combining Katakana-hirag..Combining Katakana-hirag
        (0x0a66f, 0x0a672,),  # Combining Cyrillic Vzmet..Combining Cyrillic Thous
        (0x0a674, 0x0a67d,),  # Combining Cyrillic Lette..Combining Cyrillic Payer
        (0x0a69e, 0x0a69f,),  # Combining Cyrillic Lette..Combining Cyrillic Lette
        (0x0a6f0, 0x0a6f1,),  # Bamum Combining Mark Koq..Bamum Combining Mark Tuk
        (0x0a802, 0x0a802,),  # Syloti Nagri Sign Dvisva..Syloti Nagri Sign Dvisva
        (0x0a806, 0x0a806,),  # Syloti Nagri Sign Hasant..Syloti Nagri Sign Hasant
        (0x0a80b, 0x0a80b,),  # Syloti Nagri Sign Anusva..Syloti Nagri Sign Anusva
        (0x0a825, 0x0a826,),  # Syloti Nagri Vowel Sign ..Syloti Nagri Vowel Sign
        (0x0a82c, 0x0a82c,),  # (nil)                   ..(nil)
        (0x0a8c4, 0x0a8c5,),  # Saurashtra Sign Virama  ..Saurashtra Sign Candrabi
        (0x0a8e0, 0x0a8f1,),  # Combining Devanagari Dig..Combining Devanagari Sig
        (0x0a8ff, 0x0a8ff,),  # Devanagari Vowel Sign Ay..Devanagari Vowel Sign Ay
        (0x0a926, 0x0a92d,),  # Kayah Li Vowel Ue       ..Kayah Li Tone Calya Plop
        (0x0a947, 0x0a951,),  # Rejang Vowel Sign I     ..Rejang Consonant Sign R
        (0x0a980, 0x0a982,),  # Javanese Sign Panyangga ..Javanese Sign Layar
        (0x0a9b3, 0x0a9b3,),  # Javanese Sign Cecak Telu..Javanese Sign Cecak Telu
        (0x0a9b6, 0x0a9b9,),  # Javanese Vowel Sign Wulu..Javanese Vowel Sign Suku
        (0x0a9bc, 0x0a9bd,),  # Javanese Vowel Sign Pepe..Javanese Consonant Sign
        (0x0a9e5, 0x0a9e5,),  # Myanmar Sign Shan Saw   ..Myanmar Sign Shan Saw
        (0x0aa29, 0x0aa2e,),  # Cham Vowel Sign Aa      ..Cham Vowel Sign Oe
        (0x0aa31, 0x0aa32,),  # Cham Vowel Sign Au      ..Cham Vowel Sign Ue
        (0x0aa35, 0x0aa36,),  # Cham Consonant Sign La  ..Cham Consonant Sign Wa
        (0x0aa43, 0x0aa43,),  # Cham Consonant Sign Fina..Cham Consonant Sign Fina
        (0x0aa4c, 0x0aa4c,),  # Cham Consonant Sign Fina..Cham Consonant Sign Fina
        (0x0aa7c, 0x0aa7c,),  # Myanmar Sign Tai Laing T..Myanmar Sign Tai Laing T
        (0x0aab0, 0x0aab0,),  # Tai Viet Mai Kang       ..Tai Viet Mai Kang
        (0x0aab2, 0x0aab4,),  # Tai Viet Vowel I        ..Tai Viet Vowel U
        (0x0aab7, 0x0aab8,),  # Tai Viet Mai Khit       ..Tai Viet Vowel Ia
        (0x0aabe, 0x0aabf,),  # Tai Viet Vowel Am       ..Tai Viet Tone Mai Ek
        (0x0aac1, 0x0aac1,),  # Tai Viet Tone Mai Tho   ..Tai Viet Tone Mai Tho
        (0x0aaec, 0x0aaed,),  # Meetei Mayek Vowel Sign ..Meetei Mayek Vowel Sign
        (0x0aaf6, 0x0aaf6,),  # Meetei Mayek Virama     ..Meetei Mayek Virama
        (0x0abe5, 0x0abe5,),  # Meetei Mayek Vowel Sign ..Meetei Mayek Vowel Sign
        (0x0abe8, 0x0abe8,),  # Meetei Mayek Vowel Sign ..Meetei Mayek Vowel Sign
        (0x0abed, 0x0abed,),  # Meetei Mayek Apun Iyek  ..Meetei Mayek Apun Iyek
        (0x0fb1e, 0x0fb1e,),  # Hebrew Point Judeo-spani..Hebrew Point Judeo-spani
        (0x0fe00, 0x0fe0f,),  # Variation Selector-1    ..Variation Selector-16
        (0x0fe20, 0x0fe2f,),  # Combining Ligature Left ..Combining Cyrillic Titlo
        (0x101fd, 0x101fd,),  # Phaistos Disc Sign Combi..Phaistos Disc Sign Combi
        (0x102e0, 0x102e0,),  # Coptic Epact Thousands M..Coptic Epact Thousands M
        (0x10376, 0x1037a,),  # Combining Old Permic Let..Combining Old Permic Let
        (0x10a01, 0x10a03,),  # Kharoshthi Vowel Sign I ..Kharoshthi Vowel Sign Vo
        (0x10a05, 0x10a06,),  # Kharoshthi Vowel Sign E ..Kharoshthi Vowel Sign O
        (0x10a0c, 0x10a0f,),  # Kharoshthi Vowel Length ..Kharoshthi Sign Visarga
        (0x10a38, 0x10a3a,),  # Kharoshthi Sign Bar Abov..Kharoshthi Sign Dot Belo
        (0x10a3f, 0x10a3f,),  # Kharoshthi Virama       ..Kharoshthi Virama
        (0x10ae5, 0x10ae6,),  # Manichaean Abbreviation ..Manichaean Abbreviation
        (0x10d24, 0x10d27,),  # Hanifi Rohingya Sign Har..Hanifi Rohingya Sign Tas
        (0x10eab, 0x10eac,),  # (nil)                   ..(nil)
        (0x10f46, 0x10f50,),  # Sogdian Combining Dot Be..Sogdian Combining Stroke
        (0x11001, 0x11001,),  # Brahmi Sign Anusvara    ..Brahmi Sign Anusvara
        (0x11038, 0x11046,),  # Brahmi Vowel Sign Aa    ..Brahmi Virama
        (0x1107f, 0x11081,),  # Brahmi Number Joiner    ..Kaithi Sign Anusvara
        (0x110b3, 0x110b6,),  # Kaithi Vowel Sign U     ..Kaithi Vowel Sign Ai
        (0x110b9, 0x110ba,),  # Kaithi Sign Virama      ..Kaithi Sign Nukta
        (0x11100, 0x11102,),  # Chakma Sign Candrabindu ..Chakma Sign Visarga
        (0x11127, 0x1112b,),  # Chakma Vowel Sign A     ..Chakma Vowel Sign Uu
        (0x1112d, 0x11134,),  # Chakma Vowel Sign Ai    ..Chakma Maayyaa
        (0x11173, 0x11173,),  # Mahajani Sign Nukta     ..Mahajani Sign Nukta
        (0x11180, 0x11181,),  # Sharada Sign Candrabindu..Sharada Sign Anusvara
        (0x111b6, 0x111be,),  # Sharada Vowel Sign U    ..Sharada Vowel Sign O
        (0x111c9, 0x111cc,),  # Sharada Sandhi Mark     ..Sharada Extra Short Vowe
        (0x111cf, 0x111cf,),  # (nil)                   ..(nil)
        (0x1122f, 0x11231,),  # Khojki Vowel Sign U     ..Khojki Vowel Sign Ai
        (0x11234, 0x11234,),  # Khojki Sign Anusvara    ..Khojki Sign Anusvara
        (0x11236, 0x11237,),  # Khojki Sign Nukta       ..Khojki Sign Shadda
        (0x1123e, 0x1123e,),  # Khojki Sign Sukun       ..Khojki Sign Sukun
        (0x112df, 0x112df,),  # Khudawadi Sign Anusvara ..Khudawadi Sign Anusvara
        (0x112e3, 0x112ea,),  # Khudawadi Vowel Sign U  ..Khudawadi Sign Virama
        (0x11300, 0x11301,),  # Grantha Sign Combining A..Grantha Sign Candrabindu
        (0x1133b, 0x1133c,),  # Combining Bindu Below   ..Grantha Sign Nukta
        (0x11340, 0x11340,),  # Grantha Vowel Sign Ii   ..Grantha Vowel Sign Ii
        (0x11366, 0x1136c,),  # Combining Grantha Digit ..Combining Grantha Digit
        (0x11370, 0x11374,),  # Combining Grantha Letter..Combining Grantha Letter
        (0x11438, 0x1143f,),  # Newa Vowel Sign U       ..Newa Vowel Sign Ai
        (0x11442, 0x11444,),  # Newa Sign Virama        ..Newa Sign Anusvara
        (0x11446, 0x11446,),  # Newa Sign Nukta         ..Newa Sign Nukta
        (0x1145e, 0x1145e,),  # Newa Sandhi Mark        ..Newa Sandhi Mark
        (0x114b3, 0x114b8,),  # Tirhuta Vowel Sign U    ..Tirhuta Vowel Sign Vocal
        (0x114ba, 0x114ba,),  # Tirhuta Vowel Sign Short..Tirhuta Vowel Sign Short
        (0x114bf, 0x114c0,),  # Tirhuta Sign Candrabindu..Tirhuta Sign Anusvara
        (0x114c2, 0x114c3,),  # Tirhuta Sign Virama     ..Tirhuta Sign Nukta
        (0x115b2, 0x115b5,),  # Siddham Vowel Sign U    ..Siddham Vowel Sign Vocal
        (0x115bc, 0x115bd,),  # Siddham Sign Candrabindu..Siddham Sign Anusvara
        (0x115bf, 0x115c0,),  # Siddham Sign Virama     ..Siddham Sign Nukta
        (0x115dc, 0x115dd,),  # Siddham Vowel Sign Alter..Siddham Vowel Sign Alter
        (0x11633, 0x1163a,),  # Modi Vowel Sign U       ..Modi Vowel Sign Ai
        (0x1163d, 0x1163d,),  # Modi Sign Anusvara      ..Modi Sign Anusvara
        (0x1163f, 0x11640,),  # Modi Sign Virama        ..Modi Sign Ardhacandra
        (0x116ab, 0x116ab,),  # Takri Sign Anusvara     ..Takri Sign Anusvara
        (0x116ad, 0x116ad,),  # Takri Vowel Sign Aa     ..Takri Vowel Sign Aa
        (0x116b0, 0x116b5,),  # Takri Vowel Sign U      ..Takri Vowel Sign Au
        (0x116b7, 0x116b7,),  # Takri Sign Nukta        ..Takri Sign Nukta
        (0x1171d, 0x1171f,),  # Ahom Consonant Sign Medi..Ahom Consonant Sign Medi
        (0x11722, 0x11725,),  # Ahom Vowel Sign I       ..Ahom Vowel Sign Uu
        (0x11727, 0x1172b,),  # Ahom Vowel Sign Aw      ..Ahom Sign Killer
        (0x1182f, 0x11837,),  # Dogra Vowel Sign U      ..Dogra Sign Anusvara
        (0x11839, 0x1183a,),  # Dogra Sign Virama       ..Dogra Sign Nukta
        (0x1193b, 0x1193c,),  # (nil)                   ..(nil)
        (0x1193e, 0x1193e,),  # (nil)                   ..(nil)
        (0x11943, 0x11943,),  # (nil)                   ..(nil)
        (0x119d4, 0x119d7,),  # Nandinagari Vowel Sign U..Nandinagari Vowel Sign V
        (0x119da, 0x119db,),  # Nandinagari Vowel Sign E..Nandinagari Vowel Sign A
        (0x119e0, 0x119e0,),  # Nandinagari Sign Virama ..Nandinagari Sign Virama
        (0x11a01, 0x11a0a,),  # Zanabazar Square Vowel S..Zanabazar Square Vowel L
        (0x11a33, 0x11a38,),  # Zanabazar Square Final C..Zanabazar Square Sign An
        (0x11a3b, 0x11a3e,),  # Zanabazar Square Cluster..Zanabazar Square Cluster
        (0x11a47, 0x11a47,),  # Zanabazar Square Subjoin..Zanabazar Square Subjoin
        (0x11a51, 0x11a56,),  # Soyombo Vowel Sign I    ..Soyombo Vowel Sign Oe
        (0x11a59, 0x11a5b,),  # Soyombo Vowel Sign Vocal..Soyombo Vowel Length Mar
        (0x11a8a, 0x11a96,),  # Soyombo Final Consonant ..Soyombo Sign Anusvara
        (0x11a98, 0x11a99,),  # Soyombo Gemination Mark ..Soyombo Subjoiner
        (0x11c30, 0x11c36,),  # Bhaiksuki Vowel Sign I  ..Bhaiksuki Vowel Sign Voc
        (0x11c38, 0x11c3d,),  # Bhaiksuki Vowel Sign E  ..Bhaiksuki Sign Anusvara
        (0x11c3f, 0x11c3f,),  # Bhaiksuki Sign Virama   ..Bhaiksuki Sign Virama
        (0x11c92, 0x11ca7,),  # Marchen Subjoined Letter..Marchen Subjoined Letter
        (0x11caa, 0x11cb0,),  # Marchen Subjoined Letter..Marchen Vowel Sign Aa
        (0x11cb2, 0x11cb3,),  # Marchen Vowel Sign U    ..Marchen Vowel Sign E
        (0x11cb5, 0x11cb6,),  # Marchen Sign Anusvara   ..Marchen Sign Candrabindu
        (0x11d31, 0x11d36,),  # Masaram Gondi Vowel Sign..Masaram Gondi Vowel Sign
        (0x11d3a, 0x11d3a,),  # Masaram Gondi Vowel Sign..Masaram Gondi Vowel Sign
        (0x11d3c, 0x11d3d,),  # Masaram Gondi Vowel Sign..Masaram Gondi Vowel Sign
        (0x11d3f, 0x11d45,),  # Masaram Gondi Vowel Sign..Masaram Gondi Virama
        (0x11d47, 0x11d47,),  # Masaram Gondi Ra-kara   ..Masaram Gondi Ra-kara
        (0x11d90, 0x11d91,),  # Gunjala Gondi Vowel Sign..Gunjala Gondi Vowel Sign
        (0x11d95, 0x11d95,),  # Gunjala Gondi Sign Anusv..Gunjala Gondi Sign Anusv
        (0x11d97, 0x11d97,),  # Gunjala Gondi Virama    ..Gunjala Gondi Virama
        (0x11ef3, 0x11ef4,),  # Makasar Vowel Sign I    ..Makasar Vowel Sign U
        (0x16af0, 0x16af4,),  # Bassa Vah Combining High..Bassa Vah Combining High
        (0x16b30, 0x16b36,),  # Pahawh Hmong Mark Cim Tu..Pahawh Hmong Mark Cim Ta
        (0x16f4f, 0x16f4f,),  # Miao Sign Consonant Modi..Miao Sign Consonant Modi
        (0x16f8f, 0x16f92,),  # Miao Tone Right         ..Miao Tone Below
        (0x16fe4, 0x16fe4,),  # (nil)                   ..(nil)
        (0x1bc9d, 0x1bc9e,),  # Duployan Thick Letter Se..Duployan Double Mark
        (0x1d167, 0x1d169,),  # Musical Symbol Combining..Musical Symbol Combining
        (0x1d17b, 0x1d182,),  # Musical Symbol Combining..Musical Symbol Combining
        (0x1d185, 0x1d18b,),  # Musical Symbol Combining..Musical Symbol Combining
        (0x1d1aa, 0x1d1ad,),  # Musical Symbol Combining..Musical Symbol Combining
        (0x1d242, 0x1d244,),  # Combining Greek Musical ..Combining Greek Musical
        (0x1da00, 0x1da36,),  # Signwriting Head Rim    ..Signwriting Air Sucking
        (0x1da3b, 0x1da6c,),  # Signwriting Mouth Closed..Signwriting Excitement
        (0x1da75, 0x1da75,),  # Signwriting Upper Body T..Signwriting Upper Body T
        (0x1da84, 0x1da84,),  # Signwriting Location Hea..Signwriting Location Hea
        (0x1da9b, 0x1da9f,),  # Signwriting Fill Modifie..Signwriting Fill Modifie
        (0x1daa1, 0x1daaf,),  # Signwriting Rotation Mod..Signwriting Rotation Mod
        (0x1e000, 0x1e006,),  # Combining Glagolitic Let..Combining Glagolitic Let
        (0x1e008, 0x1e018,),  # Combining Glagolitic Let..Combining Glagolitic Let
        (0x1e01b, 0x1e021,),  # Combining Glagolitic Let..Combining Glagolitic Let
        (0x1e023, 0x1e024,),  # Combining Glagolitic Let..Combining Glagolitic Let
        (0x1e026, 0x1e02a,),  # Combining Glagolitic Let..Combining Glagolitic Let
        (0x1e130, 0x1e136,),  # Nyiakeng Puachue Hmong T..Nyiakeng Puachue Hmong T
        (0x1e2ec, 0x1e2ef,),  # Wancho Tone Tup         ..Wancho Tone Koini
        (0x1e8d0, 0x1e8d6,),  # Mende Kikakui Combining ..Mende Kikakui Combining
        (0x1e944, 0x1e94a,),  # Adlam Alif Lengthener   ..Adlam Nukta
        (0xe0100, 0xe01ef,),  # Variation Selector-17   ..Variation Selector-256
    ),
}
