/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util.url;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import org.apache.ivy.util.Credentials;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.url.CredentialsStore;

public final class IvyAuthenticator
extends Authenticator {
    private Authenticator original;
    private static boolean securityWarningLogged = false;

    private IvyAuthenticator(Authenticator authenticator) {
        this.original = authenticator;
    }

    public static void install() {
        block3: {
            String[] stringArray = System.getProperty("java.specification.version").split("\\.");
            int n = Integer.parseInt(stringArray[0]);
            Authenticator authenticator = (n == 1 ? Integer.parseInt(stringArray[1]) : n) > 8 ? IvyAuthenticator.getDefaultAuthenticator() : IvyAuthenticator.getTheAuthenticator();
            if (!(authenticator instanceof IvyAuthenticator)) {
                try {
                    Authenticator.setDefault(new IvyAuthenticator(authenticator));
                    return;
                }
                catch (SecurityException securityException) {
                    if (securityWarningLogged) break block3;
                    securityWarningLogged = true;
                    Message.warn("Not enough permissions to set the IvyAuthenticator. HTTP(S) authentication will be disabled!");
                }
            }
        }
    }

    @Override
    protected final PasswordAuthentication getPasswordAuthentication() {
        PasswordAuthentication passwordAuthentication = null;
        if (this.isProxyAuthentication()) {
            String string = System.getProperty("http.proxyUser");
            if (string != null && string.trim().length() > 0) {
                String string2 = System.getProperty("http.proxyPassword", "");
                Message.debug("authenicating to proxy server with username [" + string + "]");
                passwordAuthentication = new PasswordAuthentication(string, string2.toCharArray());
            }
        } else {
            Credentials credentials = CredentialsStore.getCredentials(this.getRequestingPrompt(), this.getRequestingHost());
            Message.debug("authentication: k='" + Credentials.buildKey(this.getRequestingPrompt(), this.getRequestingHost()) + "' c='" + credentials + "'");
            if (credentials == null) {
                credentials = CredentialsStore.getCredentials(null, this.getRequestingHost());
                Message.debug("authentication: k='" + Credentials.buildKey(null, this.getRequestingHost()) + "' c='" + credentials + "'");
            }
            if (credentials != null) {
                String string = credentials.getPasswd() == null ? "" : credentials.getPasswd();
                passwordAuthentication = new PasswordAuthentication(credentials.getUserName(), string.toCharArray());
            }
        }
        if (passwordAuthentication == null && this.original != null) {
            Authenticator.setDefault(this.original);
            try {
                passwordAuthentication = Authenticator.requestPasswordAuthentication(this.getRequestingHost(), this.getRequestingSite(), this.getRequestingPort(), this.getRequestingProtocol(), this.getRequestingPrompt(), this.getRequestingScheme());
            }
            finally {
                Authenticator.setDefault(this);
            }
        }
        return passwordAuthentication;
    }

    private boolean isProxyAuthentication() {
        try {
            Object var1_1 = null;
            Object object = Authenticator.class.getDeclaredMethod("getRequestorType", null).invoke((Object)this, null);
            return "PROXY".equals(String.valueOf(object));
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (Throwable throwable) {
            Message.debug("Error occurred while checking if the authentication request is for the proxy server: " + throwable.getMessage());
        }
        StackTraceElement[] stackTraceElementArray = new Exception().getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            if ("getHttpProxyAuthentication".equals(stackTraceElementArray[i].getMethodName())) {
                return true;
            }
            if (!"getServerAuthentication".equals(stackTraceElementArray[i].getMethodName())) continue;
            return false;
        }
        String string = System.getProperty("http.proxyHost");
        return this.getRequestingHost().equals(string);
    }

    private static Authenticator getTheAuthenticator() {
        try {
            Field field = Authenticator.class.getDeclaredField("theAuthenticator");
            field.setAccessible(true);
            return (Authenticator)field.get(null);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            IvyAuthenticator.handleReflectionException(noSuchFieldException);
        }
        catch (IllegalAccessException illegalAccessException) {
            IvyAuthenticator.handleReflectionException(illegalAccessException);
        }
        catch (RuntimeException runtimeException) {
            IvyAuthenticator.handleReflectionException0(runtimeException);
        }
        return null;
    }

    private static Authenticator getDefaultAuthenticator() {
        try {
            return (Authenticator)Authenticator.class.getDeclaredMethod("getDefault", new Class[0]).invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            IvyAuthenticator.handleReflectionException(noSuchMethodException);
        }
        catch (InvocationTargetException invocationTargetException) {
            IvyAuthenticator.handleReflectionException(invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            IvyAuthenticator.handleReflectionException(illegalAccessException);
        }
        catch (RuntimeException runtimeException) {
            IvyAuthenticator.handleReflectionException0(runtimeException);
        }
        return null;
    }

    private static void handleReflectionException0(RuntimeException runtimeException) {
        try {
            throw runtimeException;
        }
        catch (SecurityException securityException) {
            IvyAuthenticator.handleReflectionException(securityException);
            return;
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            IvyAuthenticator.handleReflectionException(exceptionInInitializerError);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            IvyAuthenticator.handleReflectionException(illegalArgumentException);
            return;
        }
        catch (ClassCastException classCastException) {
            IvyAuthenticator.handleReflectionException(classCastException);
            return;
        }
        catch (NullPointerException nullPointerException) {
            IvyAuthenticator.handleReflectionException(nullPointerException);
            return;
        }
    }

    private static void handleReflectionException(Throwable throwable) {
        Message.debug("Error occurred while getting the original authenticator: " + throwable.getMessage());
    }
}

