/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTree;
import net.sf.sdedit.ui.components.JTreeSearcher;
import net.sf.sdedit.util.UIUtilities;

public class JTreeSearcherUI
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 4696321804222233601L;
    private JTreeSearcher searcher;
    private JButton button;
    private JTree tree;
    private JTextField textField;

    public JTreeSearcherUI(JTreeSearcher searcher, JTree tree, String caption) {
        this.searcher = searcher;
        this.button = new JButton(caption);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BorderLayout());
        buttonPanel.add((Component)this.button, "Center");
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 2));
        this.textField = new JTextField();
        this.setLayout(new BorderLayout());
        JPanel textPanel = UIUtilities.borderedPanel(this.textField, 2, 2, 2, 0, true);
        this.add((Component)textPanel, "Center");
        this.add((Component)buttonPanel, "West");
        this.textField.addActionListener(this);
        this.button.addActionListener(this);
        this.tree = tree;
        searcher.register(this);
    }

    public void DESTROY() {
        this.searcher.deregister(this);
        this.tree = null;
        this.searcher = null;
        this.textField.removeActionListener(this);
        this.button.removeActionListener(this);
        this.textField = null;
        this.button = null;
    }

    public JTreeSearcherUI(JTreeSearcher searcher, String caption) {
        this(searcher, null, caption);
    }

    public JTextField getTextField() {
        return this.textField;
    }

    public JTree getTree() {
        return this.tree;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        e.setSource(this);
        this.searcher.actionPerformed(e);
    }

    public void setSearchText(String text) {
        this.textField.setText(text);
    }

    public String getSearchText() {
        return this.textField.getText();
    }
}

