/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.renderer;

import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jdesktop.swingx.plaf.UIDependent;
import org.jdesktop.swingx.renderer.CellContext;
import org.jdesktop.swingx.renderer.DefaultVisuals;
import org.jdesktop.swingx.renderer.IconValue;
import org.jdesktop.swingx.renderer.StringValue;
import org.jdesktop.swingx.renderer.StringValues;

public abstract class ComponentProvider<T extends JComponent>
implements Serializable,
UIDependent {
    protected T rendererComponent;
    protected DefaultVisuals<T> defaultVisuals;
    protected int alignment;
    protected StringValue formatter;

    public ComponentProvider() {
        this(null, 10);
    }

    public ComponentProvider(StringValue converter) {
        this(converter, 10);
    }

    public ComponentProvider(StringValue converter, int alignment) {
        this.setHorizontalAlignment(alignment);
        this.setStringValue(converter);
        this.rendererComponent = this.createRendererComponent();
        this.defaultVisuals = this.createDefaultVisuals();
    }

    public T getRendererComponent(CellContext context) {
        if (context != null) {
            this.configureVisuals(context);
            this.configureContent(context);
        }
        return this.rendererComponent;
    }

    public void setHorizontalAlignment(int alignment) {
        this.alignment = alignment;
    }

    public int getHorizontalAlignment() {
        return this.alignment;
    }

    public void setStringValue(StringValue formatter) {
        if (formatter == null) {
            formatter = StringValues.TO_STRING;
        }
        this.formatter = formatter;
    }

    public StringValue getStringValue() {
        return this.formatter;
    }

    public String getString(Object value) {
        return this.formatter.getString(value);
    }

    protected String getValueAsString(CellContext context) {
        Object value = context.getValue();
        return this.formatter.getString(value);
    }

    protected Icon getValueAsIcon(CellContext context) {
        Object value = context.getValue();
        if (this.formatter instanceof IconValue) {
            return ((IconValue)((Object)this.formatter)).getIcon(value);
        }
        return null;
    }

    protected void configureVisuals(CellContext context) {
        this.defaultVisuals.configureVisuals(this.rendererComponent, context);
    }

    protected void configureContent(CellContext context) {
        this.configureState(context);
        this.format(context);
    }

    protected abstract void format(CellContext var1);

    protected abstract void configureState(CellContext var1);

    protected abstract T createRendererComponent();

    protected DefaultVisuals<T> createDefaultVisuals() {
        return new DefaultVisuals();
    }

    protected DefaultVisuals<T> getDefaultVisuals() {
        return this.defaultVisuals;
    }

    @Override
    public void updateUI() {
        SwingUtilities.updateComponentTreeUI(this.rendererComponent);
    }
}

