/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.hsqldb.error.Error;
import org.hsqldb.lib.StringConverter;

public class Crypto {
    final SecretKeySpec key;
    final Cipher outCipher;
    final Cipher inCipher;
    final Cipher inStreamCipher;
    final Cipher outStreamCipher;
    final IvParameterSpec ivSpec;

    public Crypto(String string, String string2, String string3, String string4) {
        String string5 = string3.contains("/") ? string3.substring(0, string3.indexOf("/")) : string3;
        try {
            byte[] byArray = StringConverter.hexStringToByteArray(string);
            if (string2 != null && !string2.isEmpty()) {
                byte[] byArray2 = StringConverter.hexStringToByteArray(string2);
                this.ivSpec = new IvParameterSpec(byArray2);
            } else {
                this.ivSpec = null;
            }
            this.key = new SecretKeySpec(byArray, string5);
            Cipher cipher = this.outCipher = string4 == null ? Cipher.getInstance(string3) : Cipher.getInstance(string3, string4);
            if (this.ivSpec == null) {
                this.outCipher.init(1, this.key);
            } else {
                this.outCipher.init(1, (Key)this.key, this.ivSpec);
            }
            Cipher cipher2 = this.outStreamCipher = string4 == null ? Cipher.getInstance(string3) : Cipher.getInstance(string3, string4);
            if (this.ivSpec == null) {
                this.outStreamCipher.init(1, this.key);
            } else {
                this.outStreamCipher.init(1, (Key)this.key, this.ivSpec);
            }
            Cipher cipher3 = this.inCipher = string4 == null ? Cipher.getInstance(string3) : Cipher.getInstance(string3, string4);
            if (this.ivSpec == null) {
                this.inCipher.init(2, this.key);
            } else {
                this.inCipher.init(2, (Key)this.key, this.ivSpec);
            }
            Cipher cipher4 = this.inStreamCipher = string4 == null ? Cipher.getInstance(string3) : Cipher.getInstance(string3, string4);
            if (this.ivSpec == null) {
                this.inStreamCipher.init(2, this.key);
            } else {
                this.inStreamCipher.init(2, (Key)this.key, this.ivSpec);
            }
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw Error.error(331, noSuchPaddingException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw Error.error(331, noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw Error.error(331, invalidKeyException);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw Error.error(331, noSuchProviderException);
        }
        catch (IOException iOException) {
            throw Error.error(331, iOException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw Error.error(331, invalidAlgorithmParameterException);
        }
    }

    public synchronized InputStream getInputStream(InputStream inputStream) {
        if (this.inCipher == null) {
            return inputStream;
        }
        try {
            if (this.ivSpec == null) {
                this.inStreamCipher.init(2, this.key);
            } else {
                this.inStreamCipher.init(2, (Key)this.key, this.ivSpec);
            }
            return new CipherInputStream(inputStream, this.inStreamCipher);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw Error.error(331, invalidKeyException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw Error.error(331, invalidAlgorithmParameterException);
        }
    }

    public synchronized OutputStream getOutputStream(OutputStream outputStream) {
        if (this.outCipher == null) {
            return outputStream;
        }
        try {
            if (this.ivSpec == null) {
                this.outStreamCipher.init(1, this.key);
            } else {
                this.outStreamCipher.init(1, (Key)this.key, this.ivSpec);
            }
            return new CipherOutputStream(outputStream, this.outStreamCipher);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw Error.error(331, invalidKeyException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw Error.error(331, invalidAlgorithmParameterException);
        }
    }

    public synchronized int decode(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        if (this.inCipher == null) {
            return n2;
        }
        try {
            if (this.ivSpec == null) {
                this.inCipher.init(2, this.key);
            } else {
                this.inCipher.init(2, (Key)this.key, this.ivSpec);
            }
            return this.inCipher.doFinal(byArray, n, n2, byArray2, n3);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw Error.error(331, invalidKeyException);
        }
        catch (BadPaddingException badPaddingException) {
            throw Error.error(331, badPaddingException);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw Error.error(331, illegalBlockSizeException);
        }
        catch (ShortBufferException shortBufferException) {
            throw Error.error(331, shortBufferException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw Error.error(331, invalidAlgorithmParameterException);
        }
    }

    public synchronized int encode(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        if (this.outCipher == null) {
            return n2;
        }
        try {
            if (this.ivSpec == null) {
                this.outCipher.init(1, this.key);
            } else {
                this.outCipher.init(1, (Key)this.key, this.ivSpec);
            }
            return this.outCipher.doFinal(byArray, n, n2, byArray2, n3);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw Error.error(331, invalidKeyException);
        }
        catch (BadPaddingException badPaddingException) {
            throw Error.error(331, badPaddingException);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw Error.error(331, illegalBlockSizeException);
        }
        catch (ShortBufferException shortBufferException) {
            throw Error.error(331, shortBufferException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw Error.error(331, invalidAlgorithmParameterException);
        }
    }

    public static byte[] getNewKey(String string, String string2) {
        try {
            KeyGenerator keyGenerator = string2 == null ? KeyGenerator.getInstance(string) : KeyGenerator.getInstance(string, string2);
            SecretKey secretKey = keyGenerator.generateKey();
            byte[] byArray = secretKey.getEncoded();
            return byArray;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw Error.error(331, noSuchAlgorithmException);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw Error.error(331, noSuchProviderException);
        }
    }

    public synchronized int getEncodedSize(int n) {
        try {
            return this.outCipher.getOutputSize(n);
        }
        catch (IllegalStateException illegalStateException) {
            try {
                if (this.ivSpec == null) {
                    this.outCipher.init(1, this.key);
                } else {
                    this.outCipher.init(1, (Key)this.key, this.ivSpec);
                }
                return this.outCipher.getOutputSize(n);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw Error.error(331, invalidKeyException);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw Error.error(331, invalidAlgorithmParameterException);
            }
        }
    }
}

