export = EventBridgeStore;
/**
 * Construct a store suitable for event mapping information. Data is stored
 * as {@link StoredEvent}s.
 * @constructor
 * @param {Datastore} db The connected NEDB database instance
 */
declare function EventBridgeStore(db: any): void;
declare class EventBridgeStore {
    /**
     * Construct a store suitable for event mapping information. Data is stored
     * as {@link StoredEvent}s.
     * @constructor
     * @param {Datastore} db The connected NEDB database instance
     */
    constructor(db: any);
    db: any;
    upsertEvent(event: import("../models/events/event")): Promise<any>;
    getEntryByMatrixId(roomId: string, eventId: string): import("../models/events/event") | null;
    getEntryByRemoteId(roomId: string, eventId: string): import("../models/events/event") | null;
    removeEvent(event: import("../models/events/event")): Promise<any>;
    removeEventByMatrixId(roomId: string, eventId: string): Promise<any>;
    removeEventByRemoteId(roomId: string, eventId: string): Promise<any>;
}
