export = MatrixUser;
/**
 * Construct a Matrix user.
 * @constructor
 * @param {string} userId The user_id of the user.
 * @param {Object=} data Serialized data values
 * @param {boolean} escape [true] Escape the user's localpart. Modify {@link MatrixUser~ESCAPE_DEFAULT}
 *                  to change the default value.
 */
declare function MatrixUser(userId: string, data?: Object | undefined, escape?: boolean): void;
declare class MatrixUser {
    /**
     * Construct a Matrix user.
     * @constructor
     * @param {string} userId The user_id of the user.
     * @param {Object=} data Serialized data values
     * @param {boolean} escape [true] Escape the user's localpart. Modify {@link MatrixUser~ESCAPE_DEFAULT}
     *                  to change the default value.
     */
    constructor(userId: string, data?: Object | undefined, escape?: boolean);
    userId: any;
    localpart: any;
    host: any;
    _data: Object;
    getId(): string;
    getDisplayName(): string | null;
    setDisplayName(name: string): void;
    set(key: string, val: any): void;
    get(key: string): any;
    serialize(): Object;
    escapeUserId(): void;
}
declare namespace MatrixUser {
    export const ESCAPE_DEFAULT: boolean;
}
