export = RemoteUser;
/**
 * Construct a new Remote user.
 * @constructor
 * @param {string} identifier The unique ID for this user.
 * @param {Object=} data The serialized key-value data object to assign to this user.
 * @throws If identifier is not supplied.
 */
declare function RemoteUser(identifier: string, data?: Object | undefined): void;
declare class RemoteUser {
    /**
     * Construct a new Remote user.
     * @constructor
     * @param {string} identifier The unique ID for this user.
     * @param {Object=} data The serialized key-value data object to assign to this user.
     * @throws If identifier is not supplied.
     */
    constructor(identifier: string, data?: Object | undefined);
    id: string;
    data: Object;
    getId(): string;
    serialize(): Object;
    get(key: string): any;
    set(key: string, val: any): void;
}
