complete -c hyperfine -n "__fish_use_subcommand" -s w -l warmup -d 'Perform NUM warmup runs before the actual benchmark. This can be used to fill (disk) caches for I/O-heavy programs.'
complete -c hyperfine -n "__fish_use_subcommand" -s m -l min-runs -d 'Perform at least NUM runs for each command (default: 10).'
complete -c hyperfine -n "__fish_use_subcommand" -s M -l max-runs -d 'Perform at most NUM runs for each command. By default, there is no limit.'
complete -c hyperfine -n "__fish_use_subcommand" -s r -l runs -d 'Perform exactly NUM runs for each command. If this option is not specified, hyperfine automatically determines the number of runs.'
complete -c hyperfine -n "__fish_use_subcommand" -s p -l prepare -d 'Execute CMD before each timing run. This is useful for clearing disk caches, for example.
The --prepare option can be specified once for all commands or multiple times, once for each command. In the latter case, each preparation command will be run prior to the corresponding benchmark command.'
complete -c hyperfine -n "__fish_use_subcommand" -s c -l cleanup -d 'Execute CMD after the completion of all benchmarking runs for each individual command to be benchmarked. This is useful if the commands to be benchmarked produce artifacts that need to be cleaned up.'
complete -c hyperfine -n "__fish_use_subcommand" -s P -l parameter-scan -d 'Perform benchmark runs for each value in the range MIN..MAX. Replaces the string \'{VAR}\' in each command by the current parameter value.

  Example:  hyperfine -P threads 1 8 \'make -j {threads}\'

This performs benchmarks for \'make -j 1\', \'make -j 2\', …, \'make -j 8\'.'
complete -c hyperfine -n "__fish_use_subcommand" -s D -l parameter-step-size -d 'This argument requires --parameter-scan to be specified as well. Traverse the range MIN..MAX in steps of DELTA.

  Example:  hyperfine -P delay 0.3 0.7 -D 0.2 \'sleep {delay}\'

This performs benchmarks for \'sleep 0.3\', \'sleep 0.5\' and \'sleep 0.7\'.'
complete -c hyperfine -n "__fish_use_subcommand" -s L -l parameter-list -d 'Perform benchmark runs for each value in the comma-separated list VALUES. Replaces the string \'{VAR}\' in each command by the current parameter value.

Example:  hyperfine -L compiler gcc,clang \'{compiler} -O2 main.cpp\'

This performs benchmarks for \'gcc -O2 main.cpp\' and \'clang -O2 main.cpp\'.'
complete -c hyperfine -n "__fish_use_subcommand" -s s -l style -d 'Set output style type (default: auto). Set this to \'basic\' to disable output coloring and interactive elements. Set it to \'full\' to enable all effects even if no interactive terminal was detected. Set this to \'nocolor\' to keep the interactive output without any colors. Set this to \'color\' to keep the colors without any interactive output. Set this to \'none\' to disable all the output of the tool.' -r -f -a "auto basic full nocolor color none"
complete -c hyperfine -n "__fish_use_subcommand" -s S -l shell -d 'Set the shell to use for executing benchmarked commands.'
complete -c hyperfine -n "__fish_use_subcommand" -s u -l time-unit -d 'Set the time unit to be used. Possible values: millisecond, second.' -r -f -a "millisecond second"
complete -c hyperfine -n "__fish_use_subcommand" -l export-asciidoc -d 'Export the timing summary statistics as an AsciiDoc table to the given FILE.'
complete -c hyperfine -n "__fish_use_subcommand" -l export-csv -d 'Export the timing summary statistics as CSV to the given FILE. If you need the timing results for each individual run, use the JSON export format.'
complete -c hyperfine -n "__fish_use_subcommand" -l export-json -d 'Export the timing summary statistics and timings of individual runs as JSON to the given FILE.'
complete -c hyperfine -n "__fish_use_subcommand" -l export-markdown -d 'Export the timing summary statistics as a Markdown table to the given FILE.'
complete -c hyperfine -n "__fish_use_subcommand" -s i -l ignore-failure -d 'Ignore non-zero exit codes of the benchmarked programs.'
complete -c hyperfine -n "__fish_use_subcommand" -l show-output -d 'Print the stdout and stderr of the benchmark instead of suppressing it. This will increase the time it takes for benchmarks to run, so it should only be used for debugging purposes or when trying to benchmark output speed.'
complete -c hyperfine -n "__fish_use_subcommand" -s h -l help -d 'Print this help message.'
complete -c hyperfine -n "__fish_use_subcommand" -s V -l version -d 'Show version information.'
