/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.Processor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.utils.JsLibrary;
import org.jetbrains.kotlin.utils.KotlinJavascriptMetadataUtils;
import org.jetbrains.kotlin.utils.LibraryUtils;
import org.jetbrains.kotlin.utils.fileUtils.FileUtilsKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0002J(\u0010\u000e\u001a\u00020\b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00102\u0006\u0010\u000b\u001a\u00020\u00062\b\b\u0002\u0010\f\u001a\u00020\rH\u0007J \u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0018\u001a\u00020\u0006H\u0002J\u0010\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\nH\u0007J\u0010\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\nH\u0007J\u0010\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\nH\u0002J\u0010\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\nH\u0002J$\u0010\u001e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\b0 H\u0002J$\u0010!\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\n2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\b0 H\u0002J$\u0010\"\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\b0 H\u0002J*\u0010#\u001a\u00020\b2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\n0\u00102\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\b0 H\u0007J$\u0010%\u001a\u00020\b2\u0006\u0010&\u001a\u00020\n2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\b0 H\u0007J\u000e\u0010'\u001a\u0004\u0018\u00010\u0006*\u00020\nH\u0002J\f\u0010(\u001a\u00020\n*\u00020\nH\u0002J(\u0010)\u001a\u00020\b*\u00020\n2\u0006\u0010*\u001a\u00020\u00062\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\b0 H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/utils/JsLibraryUtils;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "META_INF_RESOURCES", "", "copyJsFilesFromDirectory", "", "dir", "Ljava/io/File;", "outputLibraryJsPath", "copySourceMap", "", "copyJsFilesFromLibraries", "libraries", "", "copyJsFilesFromZip", "file", "copyLibrary", "outputPath", "library", "Lorg/jetbrains/kotlin/utils/JsLibrary;", "getSuggestedPath", "path", "isKotlinJavascriptIrLibrary", "candidate", "isKotlinJavascriptLibrary", "isZippedKlib", "isZippedKlibInZip", "processDirectory", "action", "Lkotlin/Function1;", "traverseArchive", "traverseDirectory", "traverseJsLibraries", "libs", "traverseJsLibrary", "lib", "contentIfExists", "correspondingSourceMapFile", "runIfFileExists", "relativePath", "js.config"})
public final class JsLibraryUtils {
    private static final Logger LOG;
    private static final String META_INF_RESOURCES;
    public static final JsLibraryUtils INSTANCE;

    @JvmStatic
    public static final boolean isKotlinJavascriptLibrary(@NotNull File library) {
        Intrinsics.checkNotNullParameter(library, "library");
        Collection collection = KotlinJavascriptMetadataUtils.loadMetadata(library);
        boolean bl = false;
        return !collection.isEmpty();
    }

    @JvmStatic
    public static final boolean isKotlinJavascriptIrLibrary(@NotNull File candidate2) {
        Intrinsics.checkNotNullParameter(candidate2, "candidate");
        return INSTANCE.isZippedKlib(candidate2) ? true : (FileUtil.isJarOrZip(candidate2) ? INSTANCE.isZippedKlibInZip(candidate2) : (!new File(candidate2, "manifest").isFile() ? false : new File(candidate2, "ir").isDirectory()));
    }

    @JvmStatic
    public static final void copyJsFilesFromLibraries(@NotNull List<String> libraries, @NotNull String outputLibraryJsPath, boolean copySourceMap) {
        Intrinsics.checkNotNullParameter(libraries, "libraries");
        Intrinsics.checkNotNullParameter(outputLibraryJsPath, "outputLibraryJsPath");
        for (String library : libraries) {
            File file2 = new File(library);
            boolean bl = file2.exists();
            boolean bl2 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string2 = "Library " + library + " not found";
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
            if (file2.isDirectory()) {
                INSTANCE.copyJsFilesFromDirectory(file2, outputLibraryJsPath, copySourceMap);
                continue;
            }
            INSTANCE.copyJsFilesFromZip(file2, outputLibraryJsPath, copySourceMap);
        }
    }

    public static /* synthetic */ void copyJsFilesFromLibraries$default(List list2, String string2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        JsLibraryUtils.copyJsFilesFromLibraries(list2, string2, bl);
    }

    @JvmStatic
    public static final void traverseJsLibraries(@NotNull List<? extends File> libs, @NotNull Function1<? super JsLibrary, Unit> action) {
        Intrinsics.checkNotNullParameter(libs, "libs");
        Intrinsics.checkNotNullParameter(action, "action");
        Iterable $this$forEach$iv = libs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            JsLibraryUtils.traverseJsLibrary(it, action);
        }
    }

    @JvmStatic
    public static final void traverseJsLibrary(@NotNull File lib, @NotNull Function1<? super JsLibrary, Unit> action) {
        block2: {
            File jsFile;
            block3: {
                block1: {
                    Intrinsics.checkNotNullParameter(lib, "lib");
                    Intrinsics.checkNotNullParameter(action, "action");
                    if (!lib.isDirectory()) break block1;
                    INSTANCE.traverseDirectory(lib, action);
                    break block2;
                }
                if (!FileUtil.isJarOrZip(lib)) break block3;
                INSTANCE.traverseArchive(lib, action);
                break block2;
            }
            String string2 = lib.getName();
            Intrinsics.checkNotNullExpressionValue(string2, "lib.name");
            if (!StringsKt.endsWith$default(string2, ".js", false, 2, null)) break block2;
            String string3 = lib.getPath();
            Intrinsics.checkNotNullExpressionValue(string3, "lib.path");
            INSTANCE.runIfFileExists(lib, string3, action);
            File file2 = jsFile = FileUtilsKt.withReplacedExtensionOrNull(lib, ".meta.js", ".js");
            if (file2 != null) {
                String string4 = jsFile.getPath();
                Intrinsics.checkNotNullExpressionValue(string4, "jsFile.path");
                INSTANCE.runIfFileExists(file2, string4, action);
            }
        }
    }

    private final boolean isZippedKlibInZip(File candidate2) {
        boolean manifestFound = false;
        boolean irFound = false;
        Iterator<? extends ZipEntry> iterator2 = CollectionsKt.iterator(new ZipFile(candidate2).entries());
        while (iterator2.hasNext()) {
            ZipEntry entry;
            ZipEntry zipEntry = entry = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(zipEntry, "entry");
            if (Intrinsics.areEqual(zipEntry.getName(), "manifest")) {
                manifestFound = true;
            }
            if (!Intrinsics.areEqual(entry.getName(), "ir/")) continue;
            irFound = true;
        }
        return manifestFound && irFound;
    }

    private final boolean isZippedKlib(File candidate2) {
        return Intrinsics.areEqual(FilesKt.getExtension(candidate2), "klib");
    }

    private final void runIfFileExists(File $this$runIfFileExists, String relativePath, Function1<? super JsLibrary, Unit> action) {
        if ($this$runIfFileExists.isFile()) {
            action.invoke(new JsLibrary(FilesKt.readText$default($this$runIfFileExists, null, 1, null), relativePath, this.contentIfExists(this.correspondingSourceMapFile($this$runIfFileExists)), $this$runIfFileExists));
        }
    }

    private final void copyJsFilesFromDirectory(File dir, String outputLibraryJsPath, boolean copySourceMap) {
        this.traverseDirectory(dir, (Function1<? super JsLibrary, Unit>)new Function1<JsLibrary, Unit>(outputLibraryJsPath, copySourceMap){
            final /* synthetic */ String $outputLibraryJsPath;
            final /* synthetic */ boolean $copySourceMap;

            public final void invoke(@NotNull JsLibrary it) {
                Intrinsics.checkNotNullParameter(it, "it");
                JsLibraryUtils.access$copyLibrary(JsLibraryUtils.INSTANCE, this.$outputLibraryJsPath, it, this.$copySourceMap);
            }
            {
                this.$outputLibraryJsPath = string2;
                this.$copySourceMap = bl;
                super(1);
            }
        });
    }

    private final String contentIfExists(File $this$contentIfExists) {
        return $this$contentIfExists.exists() ? FilesKt.readText$default($this$contentIfExists, null, 1, null) : null;
    }

    private final File correspondingSourceMapFile(File $this$correspondingSourceMapFile) {
        return new File($this$correspondingSourceMapFile.getParentFile(), $this$correspondingSourceMapFile.getName() + ".map");
    }

    private final void processDirectory(File dir, Function1<? super JsLibrary, Unit> action) {
        FileUtil.processFilesRecursively(dir, (Processor<? super File>)new Processor<File>(dir, action){
            final /* synthetic */ File $dir;
            final /* synthetic */ Function1 $action;

            public final boolean process(File file2) {
                String string2 = FileUtil.getRelativePath(this.$dir, file2);
                if (string2 == null) {
                    throw (Throwable)new IllegalArgumentException("relativePath should not be null " + this.$dir + ' ' + file2);
                }
                Intrinsics.checkNotNullExpressionValue(string2, "FileUtil.getRelativePath\u2026 not be null $dir $file\")");
                String relativePath = string2;
                if (StringsKt.endsWith$default(relativePath, ".js", false, 2, null)) {
                    String string3 = JsLibraryUtils.access$getSuggestedPath(JsLibraryUtils.INSTANCE, relativePath);
                    if (string3 == null) {
                        return true;
                    }
                    String suggestedRelativePath = string3;
                    File file3 = file2;
                    Intrinsics.checkNotNullExpressionValue(file3, "file");
                    JsLibraryUtils.access$runIfFileExists(JsLibraryUtils.INSTANCE, file3, suggestedRelativePath, this.$action);
                }
                return true;
            }
            {
                this.$dir = file2;
                this.$action = function1;
            }
        });
    }

    private final void traverseDirectory(File dir, Function1<? super JsLibrary, Unit> action) {
        try {
            this.processDirectory(dir, action);
        }
        catch (IOException ex) {
            LOG.error("Could not read files from directory " + dir.getName() + ": " + ex.getMessage());
        }
    }

    private final void copyJsFilesFromZip(File file2, String outputLibraryJsPath, boolean copySourceMap) {
        this.traverseArchive(file2, (Function1<? super JsLibrary, Unit>)new Function1<JsLibrary, Unit>(outputLibraryJsPath, copySourceMap){
            final /* synthetic */ String $outputLibraryJsPath;
            final /* synthetic */ boolean $copySourceMap;

            public final void invoke(@NotNull JsLibrary it) {
                Intrinsics.checkNotNullParameter(it, "it");
                JsLibraryUtils.access$copyLibrary(JsLibraryUtils.INSTANCE, this.$outputLibraryJsPath, it, this.$copySourceMap);
            }
            {
                this.$outputLibraryJsPath = string2;
                this.$copySourceMap = bl;
                super(1);
            }
        });
    }

    private final void copyLibrary(String outputPath, JsLibrary library, boolean copySourceMap) {
        block1: {
            File targetFile = new File(outputPath, library.getPath());
            targetFile.getParentFile().mkdirs();
            FilesKt.writeText$default(targetFile, library.getContent(), null, 2, null);
            if (!copySourceMap) break block1;
            String string2 = library.getSourceMapContent();
            if (string2 != null) {
                String string3 = string2;
                boolean bl = false;
                boolean bl2 = false;
                String it = string3;
                boolean bl3 = false;
                FilesKt.writeText$default(new File(targetFile.getParent(), targetFile.getName() + ".map"), it, null, 2, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void traverseArchive(File file2, Function1<? super JsLibrary, Unit> action) {
        ZipFile zipFile2;
        try {
            zipFile2 = new ZipFile(file2.getPath());
        }
        catch (ZipException e) {
            throw (Throwable)new IOException("Failed to open zip file: " + file2, e);
        }
        try (ZipFile zipFile3 = zipFile2;){
            void $this$mapTo$iv$iv;
            Object correspondingJsPath;
            Enumeration<? extends ZipEntry> zipEntries = zipFile3.entries();
            boolean bl = false;
            List librariesWithoutSourceMaps = new ArrayList();
            boolean bl2 = false;
            Map possibleMapFiles = new LinkedHashMap();
            while (zipEntries.hasMoreElements()) {
                ZipEntry entry;
                ZipEntry zipEntry = entry = zipEntries.nextElement();
                Intrinsics.checkNotNullExpressionValue(zipEntry, "entry");
                String entryName = zipEntry.getName();
                if (entry.isDirectory()) continue;
                String string2 = entryName;
                Intrinsics.checkNotNullExpressionValue(string2, "entryName");
                if (StringsKt.endsWith$default(string2, ".js", false, 2, null)) {
                    String relativePath;
                    String content;
                    if (this.getSuggestedPath(entryName) == null) {
                        continue;
                    }
                    InputStream stream = zipFile3.getInputStream(entry);
                    Intrinsics.checkNotNullExpressionValue(FileUtil.loadTextAndClose(stream), "FileUtil.loadTextAndClose(stream)");
                    Collection collection = librariesWithoutSourceMaps;
                    JsLibrary jsLibrary = new JsLibrary(content, relativePath, null, null);
                    boolean bl3 = false;
                    collection.add(jsLibrary);
                    continue;
                }
                if (!StringsKt.endsWith$default(entryName, ".js.map", false, 2, null)) continue;
                correspondingJsPath = StringsKt.removeSuffix(entryName, (CharSequence)".js.map") + ".js";
                possibleMapFiles.put(correspondingJsPath, entry);
            }
            Iterable $this$map$iv = librariesWithoutSourceMaps;
            boolean $i$f$map = false;
            correspondingJsPath = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                JsLibrary jsLibrary;
                void it;
                JsLibrary jsLibrary2 = (JsLibrary)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                ZipEntry zipEntry = (ZipEntry)possibleMapFiles.get(it.getPath());
                if (zipEntry != null) {
                    String content;
                    InputStream stream = zipFile3.getInputStream(zipEntry);
                    Intrinsics.checkNotNullExpressionValue(FileUtil.loadTextAndClose(stream), "FileUtil.loadTextAndClose(stream)");
                    jsLibrary = JsLibrary.copy$default((JsLibrary)it, null, null, content, null, 11, null);
                } else {
                    jsLibrary = it;
                }
                void var20_29 = jsLibrary;
                collection.add(var20_29);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                action.invoke((JsLibrary)element$iv);
            }
        }
    }

    private final String getSuggestedPath(String path2) {
        String string2 = FileUtil.toSystemIndependentName(path2);
        Intrinsics.checkNotNullExpressionValue(string2, "FileUtil.toSystemIndependentName(path)");
        String systemIndependentPath = string2;
        if (StringsKt.startsWith$default(systemIndependentPath, LibraryUtils.INSTANCE.getMETA_INF(), false, 2, null)) {
            if (StringsKt.startsWith$default(systemIndependentPath, META_INF_RESOURCES, false, 2, null)) {
                String string3 = path2;
                int n = META_INF_RESOURCES.length();
                boolean bl = false;
                String string4 = string3;
                if (string4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string5 = string4.substring(n);
                Intrinsics.checkNotNullExpressionValue(string5, "(this as java.lang.String).substring(startIndex)");
                return string5;
            }
            return null;
        }
        return path2;
    }

    private JsLibraryUtils() {
    }

    static {
        JsLibraryUtils jsLibraryUtils;
        INSTANCE = jsLibraryUtils = new JsLibraryUtils();
        Logger logger = Logger.getInstance(JsLibraryUtils.class);
        Intrinsics.checkNotNullExpressionValue(logger, "Logger.getInstance(JsLibraryUtils::class.java)");
        LOG = logger;
        META_INF_RESOURCES = LibraryUtils.INSTANCE.getMETA_INF() + "resources/";
    }

    public static final /* synthetic */ void access$copyLibrary(JsLibraryUtils $this, String outputPath, JsLibrary library, boolean copySourceMap) {
        $this.copyLibrary(outputPath, library, copySourceMap);
    }

    public static final /* synthetic */ String access$getSuggestedPath(JsLibraryUtils $this, String path2) {
        return $this.getSuggestedPath(path2);
    }

    public static final /* synthetic */ void access$runIfFileExists(JsLibraryUtils $this, File $this$access_u24runIfFileExists, String relativePath, Function1 action) {
        $this.runIfFileExists($this$access_u24runIfFileExists, relativePath, action);
    }
}

