export = RoomBridgeStore;
/**
 * Construct a store suitable for room bridging information. Data is stored
 * as {@link RoomBridgeStore~Entry}s which have the following
 * <i>serialized</i> format:
 * <pre>
 * {
 *   id: "unique_id",      // customisable
 *   matrix_id: "room_id",
 *   remote_id: "remote_room_id",
 *   matrix: { serialised matrix room info },
 *   remote: { serialised remote room info },
 *   data: { ... any additional info ... }
 * }
 * </pre>
 * <p>If a unique 'id' is not given, the store will generate one by concatenating
 * the <code>matrix_id</code> and the <code>remote_id</code>. The delimiter
 * used is a property on this store and can be modified.</p>
 * <p>The structure of Entry objects means that it is efficient to select based
 * off the 'id', 'matrix_id' or 'remote_id'. Additional indexes can be added
 * manually.</p>
 * @constructor
 * @param {Datastore} db The connected NEDB database instance
 * @param {Object} opts Options for this store.
 * @property {string} delimiter The delimiter between matrix and
 * remote IDs. Defaults to three spaces. If the schema of your remote IDs
 * allows spaces, you will need to change this.
 */
declare function RoomBridgeStore(db: any, opts: Object): void;
declare class RoomBridgeStore {
    /**
     * Construct a store suitable for room bridging information. Data is stored
     * as {@link RoomBridgeStore~Entry}s which have the following
     * <i>serialized</i> format:
     * <pre>
     * {
     *   id: "unique_id",      // customisable
     *   matrix_id: "room_id",
     *   remote_id: "remote_room_id",
     *   matrix: { serialised matrix room info },
     *   remote: { serialised remote room info },
     *   data: { ... any additional info ... }
     * }
     * </pre>
     * <p>If a unique 'id' is not given, the store will generate one by concatenating
     * the <code>matrix_id</code> and the <code>remote_id</code>. The delimiter
     * used is a property on this store and can be modified.</p>
     * <p>The structure of Entry objects means that it is efficient to select based
     * off the 'id', 'matrix_id' or 'remote_id'. Additional indexes can be added
     * manually.</p>
     * @constructor
     * @param {Datastore} db The connected NEDB database instance
     * @param {Object} opts Options for this store.
     * @property {string} delimiter The delimiter between matrix and
     * remote IDs. Defaults to three spaces. If the schema of your remote IDs
     * allows spaces, you will need to change this.
     */
    constructor(db: any, opts: Object);
    db: any;
    delimiter: string;
    upsertEntry(entry: any): Promise<any>;
    getEntryById(id: string): RoomBridgeStore | null;
    getEntriesByMatrixId(matrixId: string): RoomBridgeStore;
    getEntriesByMatrixIds(ids: string[]): {
        [x: string]: RoomBridgeStore;
    };
    getEntriesByRemoteId(remoteId: string): RoomBridgeStore;
    linkRooms(matrixRoom: import("../models/rooms/matrix"), remoteRoom: import("../models/rooms/remote"), data?: Object | undefined, linkId?: string | undefined): Promise<any>;
    setMatrixRoom(matrixRoom: import("../models/rooms/matrix")): Promise<any>;
    getMatrixRoom(roomId: string): import("../models/rooms/matrix") | null;
    getLinkedMatrixRooms(remoteId: string): import("../models/rooms/matrix")[];
    getLinkedRemoteRooms(matrixId: string): import("../models/rooms/remote")[];
    batchGetLinkedRemoteRooms(matrixIds: string[]): {
        [x: string]: import("../models/rooms/remote");
    };
    getEntriesByRemoteRoomData(data: Object): RoomBridgeStore;
    getEntriesByMatrixRoomData(data: Object): RoomBridgeStore;
    getEntriesByLinkData(data: Object): RoomBridgeStore;
    removeEntriesByRemoteRoomData(data: Object): Promise<any>;
    removeEntriesByRemoteRoomId(remoteId: Object): Promise<any>;
    removeEntriesByMatrixRoomData(data: Object): Promise<any>;
    removeEntriesByMatrixRoomId(matrixId: Object): Promise<any>;
    removeEntriesByLinkData(data: Object): Promise<any>;
    removeEntryById(id: string): Promise<any>;
}
declare namespace RoomBridgeStore {
    export { RoomBridgeStore };
}
/**
 * ~Entry
 */
type RoomBridgeStore = {
    /**
     * The unique ID for this entry.
     */
    id: string;
    /**
     * The matrix room, if applicable.
     */
    matrix: import("../models/rooms/matrix") | null;
    /**
     * The remote room, if applicable.
     */
    remote: import("../models/rooms/remote") | null;
    /**
     * Information about this mapping, which may be an empty.
     */
    data: Object | null;
};
