/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.binary;

import com.google.protobuf.CodedOutputStream;
import gnu.trove.iterator.TIntObjectIterator;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.list.array.TLongArrayList;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.osmand.ResultMatcher;
import net.osmand.binary.BinaryIndexPart;
import net.osmand.binary.BinaryMapAddressReaderAdapter;
import net.osmand.binary.BinaryMapDataObject;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.binary.BinaryMapPoiReaderAdapter;
import net.osmand.binary.BinaryMapRouteReaderAdapter;
import net.osmand.binary.BinaryMapTransportReaderAdapter;
import net.osmand.binary.RouteDataObject;
import net.osmand.data.Amenity;
import net.osmand.data.Building;
import net.osmand.data.City;
import net.osmand.data.MapObject;
import net.osmand.data.Street;
import net.osmand.osm.PoiCategory;
import net.osmand.util.MapUtils;

public class BinaryInspector {
    public static final int BUFFER_SIZE = 0x100000;
    private VerboseInfo vInfo;
    private static int OSM_ID = 1;

    public static void main(String[] args) throws IOException {
        BinaryInspector in = new BinaryInspector();
        if (args.length == 1 && "test".equals(args[0])) {
            in.inspector(new String[]{"-vmap", "-vmapobjects", "-vmapcoordinates", "/home/foltin/.OffRoad/Germany_berlin_europe.obf"});
        } else {
            in.inspector(args);
        }
    }

    private void printToFile(String s) throws IOException {
        if (this.vInfo.osmOut != null) {
            this.vInfo.osmOut.write(s.getBytes());
        } else {
            System.out.println(s);
        }
    }

    private void println(String s) {
        if (this.vInfo == null || !this.vInfo.osm || this.vInfo.osmOut != null) {
            System.out.println(s);
        }
    }

    private void print(String s) {
        if (this.vInfo == null || !this.vInfo.osm || this.vInfo.osmOut != null) {
            System.out.print(s);
        }
    }

    public void inspector(String[] args) throws IOException {
        if (args == null || args.length == 0) {
            this.printUsage(null);
            return;
        }
        String f = args[0];
        if (f.charAt(0) == '-') {
            if (f.equals("-c") || f.equals("-combine")) {
                if (args.length < 4) {
                    this.printUsage("Too few parameters to extract (require minimum 4)");
                } else {
                    HashMap<File, String> parts = new HashMap<File, String>();
                    for (int i = 2; i < args.length; ++i) {
                        File file = new File(args[i]);
                        if (!file.exists()) {
                            System.err.println("File to extract from doesn't exist " + args[i]);
                            return;
                        }
                        parts.put(file, null);
                        if (i >= args.length - 1 || !args[i + 1].startsWith("-") && !args[i + 1].startsWith("+")) continue;
                        parts.put(file, args[i + 1]);
                        ++i;
                    }
                    List<Float> extracted = BinaryInspector.combineParts(new File(args[1]), parts);
                    if (extracted != null) {
                        this.println("\n" + extracted.size() + " parts were successfully extracted to " + args[1]);
                    }
                }
            } else if (f.startsWith("-v")) {
                if (args.length < 2) {
                    this.printUsage("Missing file parameter");
                } else {
                    this.vInfo = new VerboseInfo(args);
                    this.printFileInformation(args[args.length - 1]);
                    this.vInfo.close();
                }
            } else {
                this.printUsage("Unknown command : " + f);
            }
        } else {
            this.vInfo = null;
            this.printFileInformation(f);
        }
    }

    public static final void writeInt(CodedOutputStream ous, int v) throws IOException {
        ous.writeRawByte(v >>> 24 & 0xFF);
        ous.writeRawByte(v >>> 16 & 0xFF);
        ous.writeRawByte(v >>> 8 & 0xFF);
        ous.writeRawByte(v & 0xFF);
    }

    public static List<Float> combineParts(File fileToExtract, Map<File, String> partsToExtractFrom) throws IOException {
        BinaryMapIndexReader[] indexes = new BinaryMapIndexReader[partsToExtractFrom.size()];
        RandomAccessFile[] rafs = new RandomAccessFile[partsToExtractFrom.size()];
        LinkedHashSet[] partsSet = new LinkedHashSet[partsToExtractFrom.size()];
        int c = 0;
        LinkedHashSet<String> addressNames = new LinkedHashSet<String>();
        int version = -1;
        for (File f : partsToExtractFrom.keySet()) {
            if (f.getAbsolutePath().equals(fileToExtract.getAbsolutePath())) {
                System.err.println("Error : Input file is equal to output file " + f.getAbsolutePath());
                return null;
            }
            rafs[c] = new RandomAccessFile(f.getAbsolutePath(), "r");
            indexes[c] = new BinaryMapIndexReader(rafs[c], f);
            partsSet[c] = new LinkedHashSet();
            if (version == -1) {
                version = indexes[c].getVersion();
            } else if (indexes[c].getVersion() != version) {
                System.err.println("Error : Different input files has different input versions " + indexes[c].getVersion() + " != " + version);
                return null;
            }
            LinkedHashSet<Float> temp = new LinkedHashSet<Float>();
            String pattern = partsToExtractFrom.get(f);
            boolean minus = true;
            for (int i = 0; i < indexes[c].getIndexes().size(); ++i) {
                partsSet[c].add(Float.valueOf((float)i + 1.0f));
                BinaryIndexPart binaryIndexPart = indexes[c].getIndexes().get(i);
                if (!(binaryIndexPart instanceof BinaryMapIndexReader.MapIndex)) continue;
                List<BinaryMapIndexReader.MapRoot> roots = ((BinaryMapIndexReader.MapIndex)binaryIndexPart).getRoots();
                int rsize = roots.size();
                for (int j = 0; j < rsize; ++j) {
                    partsSet[c].add(Float.valueOf((float)i + 1.0f + (float)(j + 1) / 10.0f));
                }
            }
            if (pattern != null) {
                String[] split;
                minus = pattern.startsWith("-");
                for (String s : split = pattern.substring(1).split(",")) {
                    temp.add(Float.valueOf(s));
                }
            }
            Iterator p = partsSet[c].iterator();
            while (p.hasNext()) {
                Float f2 = (Float)p.next();
                if (minus) {
                    if (!temp.contains(f2)) continue;
                    p.remove();
                    continue;
                }
                if (temp.contains(f2)) continue;
                p.remove();
            }
            ++c;
        }
        FileOutputStream fout = new FileOutputStream(fileToExtract);
        CodedOutputStream ous = CodedOutputStream.newInstance(fout, 0x100000);
        ArrayList<Float> list = new ArrayList<Float>();
        byte[] BUFFER_TO_READ = new byte[0x100000];
        ous.writeInt32(1, version);
        ous.writeInt64(18, System.currentTimeMillis());
        for (int k = 0; k < indexes.length; ++k) {
            LinkedHashSet partSet = partsSet[k];
            BinaryMapIndexReader binaryMapIndexReader = indexes[k];
            RandomAccessFile raf = rafs[k];
            for (int i = 0; i < binaryMapIndexReader.getIndexes().size(); ++i) {
                String map;
                if (!partSet.contains(Float.valueOf((float)i + 1.0f))) continue;
                list.add(Float.valueOf((float)i + 1.0f));
                BinaryIndexPart part = binaryMapIndexReader.getIndexes().get(i);
                if (part instanceof BinaryMapIndexReader.MapIndex) {
                    ous.writeTag(6, 6);
                    map = "Map";
                } else if (part instanceof BinaryMapAddressReaderAdapter.AddressRegion) {
                    ous.writeTag(7, 6);
                    map = "Address";
                    if (addressNames.contains(part.getName())) {
                        System.err.println("Error : going to merge 2 addresses with same names. Skip " + part.getName());
                        continue;
                    }
                    addressNames.add(part.getName());
                } else if (part instanceof BinaryMapTransportReaderAdapter.TransportIndex) {
                    ous.writeTag(4, 6);
                    map = "Transport";
                } else if (part instanceof BinaryMapPoiReaderAdapter.PoiRegion) {
                    ous.writeTag(8, 6);
                    map = "POI";
                } else if (part instanceof BinaryMapRouteReaderAdapter.RouteRegion) {
                    ous.writeTag(9, 6);
                    map = "Routing";
                } else {
                    throw new UnsupportedOperationException();
                }
                BinaryInspector.writeInt(ous, part.getLength());
                BinaryInspector.copyBinaryPart(ous, BUFFER_TO_READ, raf, part.getFilePointer(), part.getLength());
                System.out.println(MessageFormat.format("{2} part {0} is extracted {1} bytes", part.getName(), part.getLength(), map));
            }
        }
        ous.writeInt32(32, version);
        ous.flush();
        fout.close();
        return list;
    }

    public static void copyBinaryPart(CodedOutputStream ous, byte[] BUFFER, RandomAccessFile raf, long fp, int length) throws IOException {
        int read;
        raf.seek(fp);
        for (int toRead = length; toRead > 0; toRead -= read) {
            read = raf.read(BUFFER);
            if (read == -1) {
                throw new IllegalArgumentException("Unexpected end of file");
            }
            if (toRead < read) {
                read = toRead;
            }
            ous.writeRawBytes(BUFFER, 0, read);
        }
    }

    protected String formatBounds(int left, int right, int top, int bottom) {
        double l = MapUtils.get31LongitudeX(left);
        double r = MapUtils.get31LongitudeX(right);
        double t = MapUtils.get31LatitudeY(top);
        double b = MapUtils.get31LatitudeY(bottom);
        return this.formatLatBounds(l, r, t, b);
    }

    protected String formatLatBounds(double l, double r, double t, double b) {
        MessageFormat format = new MessageFormat("(left top - right bottom) : {0,number,#.####}, {1,number,#.####} NE - {2,number,#.####}, {3,number,#.####} NE", new Locale("EN", "US"));
        return format.format(new Object[]{l, t, r, b});
    }

    public void printFileInformation(String fileName) throws IOException {
        File file = new File(fileName);
        if (!file.exists()) {
            this.println("Binary OsmAnd index " + fileName + " was not found.");
            return;
        }
        this.printFileInformation(file);
    }

    public void printFileInformation(File file) throws IOException {
        RandomAccessFile r = new RandomAccessFile(file.getAbsolutePath(), "r");
        this.printFileInformation(r, file);
    }

    public void printFileInformation(RandomAccessFile r, File file) throws IOException {
        String filename = file.getName();
        try {
            BinaryMapIndexReader index = new BinaryMapIndexReader(r, file);
            int i = 1;
            this.println("Binary index " + filename + " version = " + index.getVersion() + " edition = " + new Date(index.getDateCreated()));
            for (BinaryIndexPart p : index.getIndexes()) {
                String partname = "";
                if (p instanceof BinaryMapIndexReader.MapIndex) {
                    partname = "Map";
                } else if (p instanceof BinaryMapTransportReaderAdapter.TransportIndex) {
                    partname = "Transport";
                } else if (p instanceof BinaryMapRouteReaderAdapter.RouteRegion) {
                    partname = "Routing";
                } else if (p instanceof BinaryMapPoiReaderAdapter.PoiRegion) {
                    partname = "Poi";
                } else if (p instanceof BinaryMapAddressReaderAdapter.AddressRegion) {
                    partname = "Address";
                }
                String name = p.getName() == null ? "" : p.getName();
                this.println(MessageFormat.format("{0} {1} data {3} - {2,number,#} bytes", i, partname, p.getLength(), name));
                if (p instanceof BinaryMapTransportReaderAdapter.TransportIndex) {
                    BinaryMapTransportReaderAdapter.TransportIndex ti = (BinaryMapTransportReaderAdapter.TransportIndex)p;
                    int sh = 7;
                    this.println("\tBounds " + this.formatBounds(ti.getLeft() << sh, ti.getRight() << sh, ti.getTop() << sh, ti.getBottom() << sh));
                } else if (p instanceof BinaryMapRouteReaderAdapter.RouteRegion) {
                    BinaryMapRouteReaderAdapter.RouteRegion ri = (BinaryMapRouteReaderAdapter.RouteRegion)p;
                    this.println("\tBounds " + this.formatLatBounds(ri.getLeftLongitude(), ri.getRightLongitude(), ri.getTopLatitude(), ri.getBottomLatitude()));
                    if (this.vInfo != null && this.vInfo.isVrouting()) {
                        this.printRouteDetailInfo(index, (BinaryMapRouteReaderAdapter.RouteRegion)p);
                    }
                } else if (p instanceof BinaryMapIndexReader.MapIndex) {
                    BinaryMapIndexReader.MapIndex m = (BinaryMapIndexReader.MapIndex)p;
                    int j = 1;
                    for (BinaryMapIndexReader.MapRoot mi : m.getRoots()) {
                        this.println(MessageFormat.format("\t{4}.{5} Map level minZoom = {0}, maxZoom = {1}, size = {2,number,#} bytes \n\t\tBounds {3}", mi.getMinZoom(), mi.getMaxZoom(), mi.getLength(), this.formatBounds(mi.getLeft(), mi.getRight(), mi.getTop(), mi.getBottom()), i, j++));
                    }
                    if (this.vInfo != null && this.vInfo.isVmap()) {
                        this.printMapDetailInfo(index, m);
                    }
                } else if (p instanceof BinaryMapPoiReaderAdapter.PoiRegion && this.vInfo != null && this.vInfo.isVpoi()) {
                    this.printPOIDetailInfo(this.vInfo, index, (BinaryMapPoiReaderAdapter.PoiRegion)p);
                } else if (p instanceof BinaryMapAddressReaderAdapter.AddressRegion) {
                    List<BinaryMapAddressReaderAdapter.CitiesBlock> cities = ((BinaryMapAddressReaderAdapter.AddressRegion)p).cities;
                    for (BinaryMapAddressReaderAdapter.CitiesBlock c : cities) {
                        this.println("\t" + i + "." + c.type + " Address part size=" + c.length + " bytes");
                    }
                    if (this.vInfo != null && this.vInfo.isVaddress()) {
                        this.printAddressDetailedInfo(this.vInfo, index, (BinaryMapAddressReaderAdapter.AddressRegion)p);
                    }
                }
                ++i;
            }
        }
        catch (IOException e) {
            System.err.println("File doesn't have valid structure : " + filename + " " + e.getMessage());
            throw e;
        }
    }

    private void printRouteDetailInfo(BinaryMapIndexReader index, BinaryMapRouteReaderAdapter.RouteRegion p) throws IOException {
        final DamnCounter mapObjectsCounter = new DamnCounter();
        final StringBuilder b = new StringBuilder();
        List<BinaryMapRouteReaderAdapter.RouteSubregion> regions = index.searchRouteIndexTree(BinaryMapIndexReader.buildSearchRequest(MapUtils.get31TileNumberX(this.vInfo.lonleft), MapUtils.get31TileNumberX(this.vInfo.lonright), MapUtils.get31TileNumberY(this.vInfo.lattop), MapUtils.get31TileNumberY(this.vInfo.latbottom), this.vInfo.getZoom(), null), p.getSubregions());
        index.loadRouteIndexData(regions, new ResultMatcher<RouteDataObject>(){

            @Override
            public boolean publish(RouteDataObject obj) {
                ++mapObjectsCounter.value;
                b.setLength(0);
                b.append("Road ");
                b.append(obj.id);
                for (int i = 0; i < obj.getTypes().length; ++i) {
                    BinaryMapRouteReaderAdapter.RouteTypeRule rr = obj.region.quickGetEncodingRule(obj.getTypes()[i]);
                    b.append(" ").append(rr.getTag()).append("='").append(rr.getValue()).append("'");
                }
                int[] nameIds = obj.getNameIds();
                if (nameIds != null) {
                    for (int key : nameIds) {
                        BinaryMapRouteReaderAdapter.RouteTypeRule rr = obj.region.quickGetEncodingRule(key);
                        b.append(" ").append(rr.getTag()).append("='").append((String)obj.getNames().get(key)).append("'");
                    }
                }
                BinaryInspector.this.println(b.toString());
                return false;
            }

            @Override
            public boolean isCancelled() {
                return false;
            }
        });
        this.println("\tTotal map objects: " + mapObjectsCounter.value);
    }

    private void printAddressDetailedInfo(VerboseInfo verbose, BinaryMapIndexReader index, BinaryMapAddressReaderAdapter.AddressRegion region) throws IOException {
        String[] cityType_String = new String[]{"Cities/Towns section", "Villages section", "Postcodes section"};
        int[] cityType = new int[]{1, 3, 2};
        String lang = "en";
        for (int j = 0; j < cityType.length; ++j) {
            int type = cityType[j];
            List<City> cities = index.getCities(region, null, type);
            this.print(MessageFormat.format("\t{0}, {1,number,#} group(s)", cityType_String[j], cities.size()));
            if (1 == type) {
                if (!verbose.vstreetgroups && !verbose.vcities) {
                    this.println("");
                    continue;
                }
            } else if (!verbose.vstreetgroups) {
                this.println("");
                continue;
            }
            this.println(":");
            for (City c : cities) {
                int size = index.preloadStreets(c, null);
                ArrayList<Street> streets = new ArrayList<Street>(c.getStreets());
                this.print(MessageFormat.format("\t\t''{0}'' [{1,number,#}], {2,number,#} street(s) size {3,number,#} bytes", c.getName(lang), c.getId(), streets.size(), size));
                if (!verbose.vstreets) {
                    this.println("");
                    continue;
                }
                this.println(":");
                if (!verbose.contains(c)) continue;
                for (Street t : streets) {
                    if (!verbose.contains(t)) continue;
                    index.preloadBuildings(t, null);
                    List<Building> buildings = t.getBuildings();
                    List<Street> intersections = t.getIntersectedStreets();
                    this.println(MessageFormat.format("\t\t\t''{0}'' [{1,number,#}], {2,number,#} building(s), {3,number,#} intersections(s)", t.getName(lang), t.getId(), buildings.size(), intersections.size()));
                    if (buildings != null && !buildings.isEmpty() && verbose.vbuildings) {
                        this.println("\t\t\t\tBuildings:");
                        for (Building b : buildings) {
                            this.println(MessageFormat.format("\t\t\t\t{0} [{1,number,#}]", b.getName(lang), b.getId()));
                        }
                    }
                    if (intersections == null || intersections.isEmpty() || !verbose.vintersections) continue;
                    this.print("\t\t\t\tIntersects with:");
                    for (Street s : intersections) {
                        this.println("\t\t\t\t\t" + s.getName(lang));
                    }
                }
            }
        }
    }

    private void printMapDetailInfo(BinaryMapIndexReader index, BinaryMapIndexReader.MapIndex mapIndex) throws IOException {
        final StringBuilder b = new StringBuilder();
        final DamnCounter mapObjectsCounter = new DamnCounter();
        final MapStats mapObjectStats = new MapStats();
        if (this.vInfo.osm) {
            this.printToFile("<?xml version='1.0' encoding='UTF-8'?>\n<osm version='0.6'>\n");
        }
        if (this.vInfo.isVStats()) {
            BinaryMapIndexReader.READ_STATS = true;
        }
        BinaryMapIndexReader.SearchRequest<BinaryMapDataObject> req = BinaryMapIndexReader.buildSearchRequest(MapUtils.get31TileNumberX(this.vInfo.lonleft), MapUtils.get31TileNumberX(this.vInfo.lonright), MapUtils.get31TileNumberY(this.vInfo.lattop), MapUtils.get31TileNumberY(this.vInfo.latbottom), this.vInfo.getZoom(), new BinaryMapIndexReader.SearchFilter(){

            @Override
            public boolean accept(TIntArrayList types, BinaryMapIndexReader.MapIndex index) {
                return true;
            }
        }, new ResultMatcher<BinaryMapDataObject>(){
            private int sCounter;

            @Override
            public boolean publish(BinaryMapDataObject obj) {
                ++mapObjectsCounter.value;
                if (BinaryInspector.this.vInfo.isVStats()) {
                    mapObjectStats.process(obj);
                } else if (((BinaryInspector)BinaryInspector.this).vInfo.vmapObjects) {
                    b.setLength(0);
                    if (((BinaryInspector)BinaryInspector.this).vInfo.osm) {
                        BinaryInspector.this.printOsmMapDetails(obj, b);
                        try {
                            BinaryInspector.this.printToFile(b.toString());
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    } else {
                        BinaryInspector.printMapDetails(obj, b, ((BinaryInspector)BinaryInspector.this).vInfo.vmapCoordinates);
                        if (b.length() > 0) {
                            ++this.sCounter;
                            BinaryInspector.this.println(this.sCounter + ": " + b.toString());
                        }
                    }
                }
                return false;
            }

            @Override
            public boolean isCancelled() {
                return false;
            }
        });
        if (this.vInfo.vstats) {
            mapObjectStats.setReq(req);
        }
        index.searchMapIndex(req, mapIndex);
        if (this.vInfo.osm) {
            this.printToFile("</osm >\n");
        }
        if (this.vInfo.vstats) {
            mapObjectStats.print();
        }
        this.println("\tTotal map objects: " + mapObjectsCounter.value);
    }

    private static void printMapDetails(BinaryMapDataObject obj, StringBuilder b, boolean vmapCoordinates) {
        BinaryMapIndexReader.TagValuePair pair;
        int j;
        boolean multipolygon;
        boolean bl = multipolygon = obj.getPolygonInnerCoordinates() != null && obj.getPolygonInnerCoordinates().length > 0;
        if (multipolygon) {
            b.append("Multipolygon");
        } else {
            if (!obj.area) {
                return;
            }
            b.append(obj.area ? "Area" : (obj.getPointsLength() > 1 ? "Way" : "Point"));
        }
        int[] types = obj.getTypes();
        b.append(" types [");
        for (j = 0; j < types.length; ++j) {
            if (j > 0) {
                b.append(", ");
            }
            if ((pair = obj.getMapIndex().decodeType(types[j])) == null) {
                System.err.println("Type " + types[j] + "was not found");
                continue;
            }
            b.append(pair.toSimpleString() + " (" + types[j] + ")");
        }
        b.append("]");
        if (obj.getAdditionalTypes() != null && obj.getAdditionalTypes().length > 0) {
            b.append(" add_types [");
            for (j = 0; j < obj.getAdditionalTypes().length; ++j) {
                if (j > 0) {
                    b.append(", ");
                }
                if ((pair = obj.getMapIndex().decodeType(obj.getAdditionalTypes()[j])) == null) {
                    System.err.println("Type " + obj.getAdditionalTypes()[j] + "was not found");
                    continue;
                }
                b.append(pair.toSimpleString() + "(" + obj.getAdditionalTypes()[j] + ")");
            }
            b.append("]");
        }
        TIntObjectHashMap<String> names = obj.getObjectNames();
        TIntArrayList order = obj.getNamesOrder();
        if (names != null && !names.isEmpty()) {
            b.append(" Names [");
            b.append("{" + obj.getMapIndex().nameEncodingType + "}");
            for (int j2 = 0; j2 < order.size(); ++j2) {
                BinaryMapIndexReader.TagValuePair pair2;
                int type;
                if (j2 > 0) {
                    b.append(", ");
                }
                if ((type = order.get(j2)) == obj.getMapIndex().nameEncodingType) {
                    b.append("*");
                }
                if (type == obj.getMapIndex().nameEnEncodingType) {
                    b.append("X");
                }
                if ((pair2 = obj.getMapIndex().decodeType(type)) == null) {
                    throw new NullPointerException("Type " + type + "was not found");
                }
                b.append(pair2.toSimpleString() + "(" + type + ")");
                b.append(" - ").append((String)names.get(type));
            }
            b.append("]");
        }
        b.append(" id ").append(obj.getId() >> 1);
        if (vmapCoordinates) {
            b.append(" lat/lon : ");
            for (int i = 0; i < obj.getPointsLength(); ++i) {
                float x = (float)MapUtils.get31LongitudeX(obj.getPoint31XTile(i));
                float y = (float)MapUtils.get31LatitudeY(obj.getPoint31YTile(i));
                b.append(y).append(" / ").append(x).append(" , ");
            }
        }
    }

    private void printOsmMapDetails(BinaryMapDataObject obj, StringBuilder b) {
        TIntObjectHashMap<String> names;
        BinaryMapIndexReader.TagValuePair pair;
        int j;
        boolean multipolygon = obj.getPolygonInnerCoordinates() != null && obj.getPolygonInnerCoordinates().length > 0;
        boolean point = obj.getPointsLength() == 1;
        StringBuilder tags = new StringBuilder();
        int[] types = obj.getTypes();
        for (j = 0; j < types.length; ++j) {
            pair = obj.getMapIndex().decodeType(types[j]);
            if (pair == null) {
                throw new NullPointerException("Type " + types[j] + "was not found");
            }
            tags.append("\t<tag k='").append(pair.tag).append("' v='").append(pair.value).append("' />\n");
        }
        if (obj.getAdditionalTypes() != null && obj.getAdditionalTypes().length > 0) {
            for (j = 0; j < obj.getAdditionalTypes().length; ++j) {
                pair = obj.getMapIndex().decodeType(obj.getAdditionalTypes()[j]);
                if (pair == null) {
                    throw new NullPointerException("Type " + obj.getAdditionalTypes()[j] + "was not found");
                }
                tags.append("\t<tag k='").append(pair.tag).append("' v='").append(pair.value).append("' />\n");
            }
        }
        if ((names = obj.getObjectNames()) != null && !names.isEmpty()) {
            int[] keys = names.keys();
            for (int j2 = 0; j2 < keys.length; ++j2) {
                BinaryMapIndexReader.TagValuePair pair2 = obj.getMapIndex().decodeType(keys[j2]);
                if (pair2 == null) {
                    throw new NullPointerException("Type " + keys[j2] + "was not found");
                }
                String name = (String)names.get(keys[j2]);
                name = name.replace("'", "&apos;");
                name = name.replace("&", "&amp;");
                tags.append("\t<tag k='").append(pair2.tag).append("' v='").append(name).append("' />\n");
            }
        }
        tags.append("\t<tag k='").append("original_id").append("' v='").append(obj.getId() >> 1).append("'/>\n");
        if (point) {
            float lon = (float)MapUtils.get31LongitudeX(obj.getPoint31XTile(0));
            float lat = (float)MapUtils.get31LatitudeY(obj.getPoint31YTile(0));
            b.append("<node id = '" + OSM_ID++ + "' version='1' lat='" + lat + "' lon='" + lon + "' >\n");
            b.append((CharSequence)tags);
            b.append("</node>\n");
        } else {
            int id2;
            TLongArrayList innerIds = new TLongArrayList();
            TLongArrayList ids = new TLongArrayList();
            for (int i = 0; i < obj.getPointsLength(); ++i) {
                float lon = (float)MapUtils.get31LongitudeX(obj.getPoint31XTile(i));
                float lat = (float)MapUtils.get31LatitudeY(obj.getPoint31YTile(i));
                ++OSM_ID;
                b.append("\t<node id = '" + id2 + "' version='1' lat='" + lat + "' lon='" + lon + "' />\n");
                ids.add((long)id2);
            }
            long outerId = this.printWay(ids, b, multipolygon ? null : tags);
            if (multipolygon) {
                int[][] polygonInnerCoordinates = obj.getPolygonInnerCoordinates();
                for (int j3 = 0; j3 < polygonInnerCoordinates.length; ++j3) {
                    ids.clear();
                    for (int i = 0; i < polygonInnerCoordinates[j3].length; i += 2) {
                        int id3;
                        float lon = (float)MapUtils.get31LongitudeX(polygonInnerCoordinates[j3][i]);
                        float lat = (float)MapUtils.get31LatitudeY(polygonInnerCoordinates[j3][i + 1]);
                        ++OSM_ID;
                        b.append("<node id = '" + id3 + "' version='1' lat='" + lat + "' lon='" + lon + "' />\n");
                        ids.add((long)id3);
                    }
                    innerIds.add(this.printWay(ids, b, null));
                }
                id2 = OSM_ID++;
                b.append("<relation id = '" + id2 + "' version='1'>\n");
                b.append((CharSequence)tags);
                b.append("\t<member type='way' role='outer' ref= '" + outerId + "'/>\n");
                for (long ref : innerIds) {
                    b.append("<member type='way' role='inner' ref= '" + ref + "'/>\n");
                }
                b.append("</relation>\n");
            }
        }
    }

    private long printWay(TLongArrayList ids, StringBuilder b, StringBuilder tags) {
        int id2 = OSM_ID++;
        b.append("<way id = '" + id2 + "' version='1'>\n");
        if (tags != null) {
            b.append((CharSequence)tags);
        }
        for (long ref : ids) {
            b.append("\t<nd ref = '" + ref + "'/>\n");
        }
        b.append("</way>\n");
        return id2;
    }

    private void printPOIDetailInfo(VerboseInfo verbose, BinaryMapIndexReader index, BinaryMapPoiReaderAdapter.PoiRegion p) throws IOException {
        int i;
        BinaryMapIndexReader.SearchRequest<Amenity> req = BinaryMapIndexReader.buildSearchPoiRequest(MapUtils.get31TileNumberX(verbose.lonleft), MapUtils.get31TileNumberX(verbose.lonright), MapUtils.get31TileNumberY(verbose.lattop), MapUtils.get31TileNumberY(verbose.latbottom), verbose.getZoom(), new BinaryMapIndexReader.SearchPoiTypeFilter(){

            @Override
            public boolean accept(PoiCategory type, String subcategory) {
                return true;
            }

            @Override
            public boolean isEmpty() {
                return false;
            }
        }, new ResultMatcher<Amenity>(){

            @Override
            public boolean publish(Amenity object) {
                Iterator<Map.Entry<String, String>> it = object.getAdditionalInfo().entrySet().iterator();
                String s = "";
                while (it.hasNext()) {
                    Map.Entry<String, String> e = it.next();
                    if (e.getValue().startsWith(" gz ")) {
                        s = s + " " + e.getKey() + "=...";
                        continue;
                    }
                    s = s + " " + e.getKey() + "=" + e.getValue();
                }
                BinaryInspector.this.println(object.getType().getKeyName() + " : " + object.getSubType() + " " + object.getName("de", true) + " " + object.getLocation() + " id=" + (object.getId() >> 1) + " " + s);
                return false;
            }

            @Override
            public boolean isCancelled() {
                return false;
            }
        });
        index.initCategories(p);
        this.println("\tRegion: " + p.name);
        this.println("\t\tBounds " + this.formatLatBounds(p.getLeftLongitude(), p.getRightLongitude(), p.getTopLatitude(), p.getBottomLatitude()));
        this.println("\t\tCategories:");
        for (i = 0; i < p.categories.size(); ++i) {
            this.println("\t\t\t" + p.categories.get(i));
            for (int j = 0; j < p.subcategories.get(i).size(); ++j) {
                this.println("\t\t\t\t" + p.subcategories.get(i).get(j));
            }
        }
        this.println("\t\tSubtypes:");
        for (i = 0; i < p.subTypes.size(); ++i) {
            BinaryMapPoiReaderAdapter.PoiSubType st = p.subTypes.get(i);
            this.println("\t\t\t" + st.name + " " + (st.text ? "text" : " encoded " + st.possibleValues.size()));
        }
        index.searchPoi(p, req);
    }

    public void printUsage(String warning) {
        if (warning != null) {
            this.println(warning);
        }
        this.println("Inspector is console utility for working with binary indexes of OsmAnd.");
        this.println("It allows print info about file, extract parts and merge indexes.");
        this.println("\nUsage for print info : inspector [-vaddress] [-vstreetgroups] [-vstreets] [-vbuildings] [-vintersections] [-vmap] [-vmapobjects] [-vmapcoordinates] [-osm] [-vpoi] [-vrouting] [-vtransport] [-zoom=Zoom] [-bbox=LeftLon,TopLat,RightLon,BottomLat] [file]");
        this.println("  Prints information about [file] binary index of OsmAnd.");
        this.println("  -v.. more verbouse output (like all cities and their streets or all map objects with tags/values and coordinates)");
        this.println("\nUsage for combining indexes : inspector -c file_to_create (file_from_extract ((+|-)parts_to_extract)? )*");
        this.println("\tCreate new file of extracted parts from input file. [parts_to_extract] could be parts to include or exclude.");
        this.println("  Example : inspector -c output_file input_file +1,2,3\n\tExtracts 1, 2, 3 parts (could be find in print info)");
        this.println("  Example : inspector -c output_file input_file -2,3\n\tExtracts all  parts excluding 2, 3");
        this.println("  Example : inspector -c output_file input_file1 input_file2 input_file3\n\tSimply combine 3 files");
        this.println("  Example : inspector -c output_file input_file1 input_file2 -4\n\tCombine all parts of 1st file and all parts excluding 4th part of 2nd file");
    }

    private class MapStats {
        public int lastStringNamesSize;
        public int lastObjectIdSize;
        public int lastObjectHeaderInfo;
        public int lastObjectAdditionalTypes;
        public int lastObjectTypes;
        public int lastObjectCoordinates;
        public int lastObjectCoordinatesCount;
        public int lastObjectSize;
        private Map<String, MapStatKey> types = new LinkedHashMap<String, MapStatKey>();
        private BinaryMapIndexReader.SearchRequest<BinaryMapDataObject> req;

        private MapStats() {
        }

        public void processKey(String simpleString, BinaryMapIndexReader.MapObjectStat st, TIntObjectHashMap<String> objectNames, int coordinates, boolean names) {
            TIntObjectIterator it = objectNames.iterator();
            int nameLen = 0;
            while (it.hasNext()) {
                it.advance();
                ++nameLen;
                nameLen += ((String)it.value()).length();
            }
            if (!this.types.containsKey(simpleString)) {
                MapStatKey stt = new MapStatKey();
                stt.key = simpleString;
                this.types.put(simpleString, stt);
            }
            MapStatKey key = this.types.get(simpleString);
            if (names) {
                key.namesLength += nameLen;
            } else {
                key.statCoordinates += (long)st.lastObjectCoordinates;
                key.statCoordinatesCount += (long)coordinates;
                key.statObjectSize += (long)st.lastObjectSize;
                ++key.count;
            }
        }

        public void process(BinaryMapDataObject obj) {
            boolean names;
            BinaryMapIndexReader.MapObjectStat st = this.req.stat;
            int cnt = 0;
            boolean bl = names = st.lastObjectCoordinates == 0;
            if (!names) {
                this.lastStringNamesSize += st.lastStringNamesSize;
                this.lastObjectIdSize += st.lastObjectIdSize;
                this.lastObjectHeaderInfo += st.lastObjectHeaderInfo;
                this.lastObjectAdditionalTypes += st.lastObjectAdditionalTypes;
                this.lastObjectTypes += st.lastObjectTypes;
                this.lastObjectCoordinates += st.lastObjectCoordinates;
                cnt = obj.getPointsLength();
                this.lastObjectSize += st.lastObjectSize;
                if (obj.getPolygonInnerCoordinates() != null) {
                    for (int[] i : obj.getPolygonInnerCoordinates()) {
                        cnt += i.length;
                    }
                }
                this.lastObjectCoordinatesCount += cnt;
            }
            for (int i = 0; i < obj.getTypes().length; ++i) {
                int tp = obj.getTypes()[i];
                BinaryMapIndexReader.TagValuePair pair = obj.mapIndex.decodeType(tp);
                if (pair == null) continue;
                this.processKey(pair.toSimpleString(), st, obj.getObjectNames(), cnt, names);
            }
            st.clearObjectStats();
            st.lastObjectSize = 0;
        }

        public void print() {
            BinaryMapIndexReader.MapObjectStat st = this.req.stat;
            BinaryInspector.this.println("MAP BLOCK INFO:");
            long b = 0L;
            b += this.out("Header", st.lastBlockHeaderInfo);
            b += this.out("String table", st.lastBlockStringTableSize);
            this.out("TOTAL", b += this.out("Map Objects", this.lastObjectSize));
            BinaryInspector.this.println("\nMAP OBJECTS INFO:");
            b = 0L;
            b += this.out("Header", this.lastObjectHeaderInfo);
            b += this.out("Coordinates", this.lastObjectCoordinates);
            this.out("Coordinates Count(pair)", this.lastObjectCoordinatesCount);
            b += this.out("Types", this.lastObjectTypes);
            b += this.out("Additonal Types", this.lastObjectAdditionalTypes);
            b += this.out("Ids", this.lastObjectIdSize);
            this.out("TOTAL", b += this.out("String names", this.lastStringNamesSize));
            BinaryInspector.this.println("\n\nOBJECT BY TYPE STATS: ");
            ArrayList<MapStatKey> stats = new ArrayList<MapStatKey>(this.types.values());
            Collections.sort(stats, new Comparator<MapStatKey>(){

                @Override
                public int compare(MapStatKey o1, MapStatKey o2) {
                    return this.compare(o1.statObjectSize, o2.statObjectSize);
                }

                @Override
                public int compare(long x, long y) {
                    return x < y ? -1 : (x == y ? 0 : 1);
                }
            });
            for (MapStatKey s : stats) {
                BinaryInspector.this.println(s.key + " (" + s.count + ") \t " + s.statObjectSize + " bytes \t coord=" + s.statCoordinatesCount + " (" + s.statCoordinates + " bytes)  names " + s.namesLength + " bytes");
            }
        }

        private long out(String s, long i) {
            while (s.length() < 25) {
                s = s + " ";
            }
            DecimalFormat df = new DecimalFormat("0,000,000,000");
            BinaryInspector.this.println(s + ": " + df.format(i));
            return i;
        }

        public void setReq(BinaryMapIndexReader.SearchRequest<BinaryMapDataObject> req) {
            this.req = req;
        }
    }

    private static class MapStatKey {
        String key = "";
        long statCoordinates;
        long statCoordinatesCount;
        long statObjectSize;
        int count;
        int namesLength;

        private MapStatKey() {
        }
    }

    private static class DamnCounter {
        int value;

        private DamnCounter() {
        }
    }

    protected static class VerboseInfo {
        boolean vaddress;
        boolean vcities;
        boolean vstreetgroups;
        boolean vstreets;
        boolean vbuildings;
        boolean vintersections;
        boolean vtransport;
        boolean vpoi;
        boolean vmap;
        boolean vrouting;
        boolean vmapObjects;
        boolean vmapCoordinates;
        boolean vstats;
        boolean osm;
        FileOutputStream osmOut = null;
        double lattop = 85.0;
        double latbottom = -85.0;
        double lonleft = -180.0;
        double lonright = 180.0;
        int zoom = -1;

        public boolean isVaddress() {
            return this.vaddress;
        }

        public int getZoom() {
            return this.zoom;
        }

        public boolean isVmap() {
            return this.vmap;
        }

        public boolean isVrouting() {
            return this.vrouting;
        }

        public boolean isVpoi() {
            return this.vpoi;
        }

        public boolean isVtransport() {
            return this.vtransport;
        }

        public boolean isVStats() {
            return this.vstats;
        }

        public VerboseInfo(String[] params) throws FileNotFoundException {
            for (int i = 0; i < params.length; ++i) {
                if (params[i].equals("-vaddress")) {
                    this.vaddress = true;
                    continue;
                }
                if (params[i].equals("-vstreets")) {
                    this.vstreets = true;
                    continue;
                }
                if (params[i].equals("-vstreetgroups")) {
                    this.vstreetgroups = true;
                    continue;
                }
                if (params[i].equals("-vcities")) {
                    this.vcities = true;
                    continue;
                }
                if (params[i].equals("-vbuildings")) {
                    this.vbuildings = true;
                    continue;
                }
                if (params[i].equals("-vintersections")) {
                    this.vintersections = true;
                    continue;
                }
                if (params[i].equals("-vmap")) {
                    this.vmap = true;
                    continue;
                }
                if (params[i].equals("-vstats")) {
                    this.vstats = true;
                    continue;
                }
                if (params[i].equals("-vrouting")) {
                    this.vrouting = true;
                    continue;
                }
                if (params[i].equals("-vmapobjects")) {
                    this.vmapObjects = true;
                    continue;
                }
                if (params[i].equals("-vmapcoordinates")) {
                    this.vmapCoordinates = true;
                    continue;
                }
                if (params[i].equals("-vpoi")) {
                    this.vpoi = true;
                    continue;
                }
                if (params[i].startsWith("-osm")) {
                    this.osm = true;
                    if (!params[i].startsWith("-osm=")) continue;
                    this.osmOut = new FileOutputStream(params[i].substring(5));
                    continue;
                }
                if (params[i].equals("-vtransport")) {
                    this.vtransport = true;
                    continue;
                }
                if (params[i].startsWith("-zoom=")) {
                    this.zoom = Integer.parseInt(params[i].substring("-zoom=".length()));
                    continue;
                }
                if (!params[i].startsWith("-bbox=")) continue;
                String[] values = params[i].substring("-bbox=".length()).split(",");
                this.lonleft = Double.parseDouble(values[0]);
                this.lattop = Double.parseDouble(values[1]);
                this.lonright = Double.parseDouble(values[2]);
                this.latbottom = Double.parseDouble(values[3]);
            }
        }

        public boolean contains(MapObject o) {
            return this.lattop >= o.getLocation().getLatitude() && this.latbottom <= o.getLocation().getLatitude() && this.lonleft <= o.getLocation().getLongitude() && this.lonright >= o.getLocation().getLongitude();
        }

        public void close() throws IOException {
            if (this.osmOut != null) {
                this.osmOut.close();
                this.osmOut = null;
            }
        }
    }
}

