/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole.rosetta;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.creole.rosetta.ReaderAbstractWiki;
import net.sourceforge.plantuml.creole.rosetta.ReaderCreole;
import net.sourceforge.plantuml.creole.rosetta.ReaderDokuwiki;
import net.sourceforge.plantuml.creole.rosetta.WikiLanguage;
import net.sourceforge.plantuml.creole.rosetta.WriterWiki;
import net.sourceforge.plantuml.cucadiagram.Display;

public class Rosetta {
    private final List<String> unicodeHtml;

    public static Rosetta fromUnicodeHtml(List<String> lines) {
        return new Rosetta(lines);
    }

    public static Rosetta fromSyntax(WikiLanguage syntaxSource, String ... wiki) {
        return new Rosetta(syntaxSource, Arrays.asList(wiki));
    }

    public static Rosetta fromSyntax(WikiLanguage syntaxSource, List<String> wiki) {
        return new Rosetta(syntaxSource, wiki);
    }

    public static Rosetta fromSyntax(WikiLanguage syntaxSource, Display display) {
        return new Rosetta(syntaxSource, Rosetta.from(display));
    }

    private static List<String> from(Display display) {
        ArrayList<String> result = new ArrayList<String>();
        for (CharSequence cs : display) {
            result.add(cs.toString());
        }
        return result;
    }

    private Rosetta(List<String> lines) {
        this.unicodeHtml = new ArrayList<String>(lines);
    }

    private Rosetta(WikiLanguage syntaxSource, List<String> wiki) {
        ReaderAbstractWiki reader;
        if (syntaxSource == WikiLanguage.DOKUWIKI) {
            reader = new ReaderDokuwiki();
        } else if (syntaxSource == WikiLanguage.CREOLE) {
            reader = new ReaderCreole();
        } else {
            throw new UnsupportedOperationException();
        }
        this.unicodeHtml = reader.transform(wiki);
    }

    public List<String> translateTo(WikiLanguage syntaxDestination) {
        ArrayList<String> html = new ArrayList<String>();
        WriterWiki writer = new WriterWiki(syntaxDestination);
        html.addAll(writer.transform(this.unicodeHtml));
        return Collections.unmodifiableList(html);
    }
}

