/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.servlet.internal;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.servlet.ServletContext;
import org.restlet.Context;
import org.restlet.data.MediaType;
import org.restlet.engine.local.Entity;
import org.restlet.representation.InputRepresentation;
import org.restlet.representation.Representation;
import org.restlet.service.MetadataService;

public class ServletWarEntity
extends Entity {
    private List<Entity> children = null;
    private final boolean directory;
    private final String fullName;
    private final String path;
    private final ServletContext servletContext;

    public ServletWarEntity(ServletContext servletContext, String path, MetadataService metadataService) {
        super(metadataService);
        this.servletContext = servletContext;
        this.path = path;
        if (path.endsWith("/")) {
            this.directory = true;
            this.fullName = path.substring(0, path.length() - 1);
            Set childPaths = this.getServletContext().getResourcePaths(path);
            if (childPaths != null && !childPaths.isEmpty()) {
                this.children = new ArrayList<Entity>();
                for (Object childPath : childPaths) {
                    if (childPath.equals(this.path)) continue;
                    this.children.add(new ServletWarEntity(this.servletContext, (String)childPath, metadataService));
                }
            }
        } else {
            this.fullName = path;
            Set childPaths = this.getServletContext().getResourcePaths(path);
            if (childPaths != null && !childPaths.isEmpty()) {
                this.directory = true;
                this.children = new ArrayList<Entity>();
                for (Object childPath : childPaths) {
                    if (childPath.equals(this.path)) continue;
                    this.children.add(new ServletWarEntity(this.servletContext, (String)childPath, metadataService));
                }
            } else {
                this.directory = false;
            }
        }
    }

    @Override
    public boolean exists() {
        boolean result = false;
        try {
            result = this.isDirectory() && this.getChildren() != null || this.isNormal() && this.getServletContext().getResource(this.path) != null;
        }
        catch (MalformedURLException e) {
            Context.getCurrentLogger().log(Level.WARNING, "Unable to test the existence of the WAR resource", e);
        }
        return result;
    }

    @Override
    public List<Entity> getChildren() {
        return this.children;
    }

    @Override
    public String getName() {
        int index = this.fullName.lastIndexOf("/");
        if (index != -1) {
            return this.fullName.substring(index + 1);
        }
        return this.fullName;
    }

    @Override
    public Entity getParent() {
        ServletWarEntity result = null;
        int index = this.fullName.lastIndexOf("/");
        if (index != -1) {
            result = new ServletWarEntity(this.getServletContext(), this.fullName.substring(0, index + 1), this.getMetadataService());
        }
        return result;
    }

    @Override
    public Representation getRepresentation(MediaType defaultMediaType, int timeToLive) {
        InputRepresentation result = null;
        try {
            URL resource = this.getServletContext().getResource(this.path);
            if (resource != null) {
                URLConnection connection = resource.openConnection();
                result = new InputRepresentation(connection.getInputStream(), defaultMediaType);
                result.setModificationDate(new Date(connection.getLastModified()));
                if (timeToLive == 0) {
                    result.setExpirationDate(null);
                } else if (timeToLive > 0) {
                    result.setExpirationDate(new Date(System.currentTimeMillis() + 1000L * (long)timeToLive));
                }
            }
        }
        catch (IOException e) {
            Context.getCurrentLogger().log(Level.WARNING, "Error getting the WAR resource.", e);
        }
        return result;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    @Override
    public boolean isDirectory() {
        return this.directory;
    }

    @Override
    public boolean isNormal() {
        return !this.isDirectory();
    }
}

