/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.util.HashSet;
import java.util.Set;
import org.apache.solr.core.PluginInfo;

public class MetricsConfig {
    private final PluginInfo[] metricReporters;
    private final Set<String> hiddenSysProps;
    private final PluginInfo counterSupplier;
    private final PluginInfo meterSupplier;
    private final PluginInfo timerSupplier;
    private final PluginInfo histogramSupplier;
    private final PluginInfo historyHandler;

    private MetricsConfig(PluginInfo[] metricReporters, Set<String> hiddenSysProps, PluginInfo counterSupplier, PluginInfo meterSupplier, PluginInfo timerSupplier, PluginInfo histogramSupplier, PluginInfo historyHandler) {
        this.metricReporters = metricReporters;
        this.hiddenSysProps = hiddenSysProps;
        this.counterSupplier = counterSupplier;
        this.meterSupplier = meterSupplier;
        this.timerSupplier = timerSupplier;
        this.histogramSupplier = histogramSupplier;
        this.historyHandler = historyHandler;
    }

    public PluginInfo[] getMetricReporters() {
        return this.metricReporters;
    }

    public Set<String> getHiddenSysProps() {
        return this.hiddenSysProps;
    }

    public PluginInfo getCounterSupplier() {
        return this.counterSupplier;
    }

    public PluginInfo getMeterSupplier() {
        return this.meterSupplier;
    }

    public PluginInfo getTimerSupplier() {
        return this.timerSupplier;
    }

    public PluginInfo getHistogramSupplier() {
        return this.histogramSupplier;
    }

    public PluginInfo getHistoryHandler() {
        return this.historyHandler;
    }

    public static class MetricsConfigBuilder {
        private PluginInfo[] metricReporterPlugins = new PluginInfo[0];
        private Set<String> hiddenSysProps = new HashSet<String>();
        private PluginInfo counterSupplier;
        private PluginInfo meterSupplier;
        private PluginInfo timerSupplier;
        private PluginInfo histogramSupplier;
        private PluginInfo historyHandler;

        public MetricsConfigBuilder setHiddenSysProps(Set<String> hiddenSysProps) {
            if (hiddenSysProps != null && !hiddenSysProps.isEmpty()) {
                this.hiddenSysProps.clear();
                this.hiddenSysProps.addAll(hiddenSysProps);
            }
            return this;
        }

        public MetricsConfigBuilder setMetricReporterPlugins(PluginInfo[] metricReporterPlugins) {
            this.metricReporterPlugins = metricReporterPlugins != null ? metricReporterPlugins : new PluginInfo[]{};
            return this;
        }

        public MetricsConfigBuilder setCounterSupplier(PluginInfo info) {
            this.counterSupplier = info;
            return this;
        }

        public MetricsConfigBuilder setMeterSupplier(PluginInfo info) {
            this.meterSupplier = info;
            return this;
        }

        public MetricsConfigBuilder setTimerSupplier(PluginInfo info) {
            this.timerSupplier = info;
            return this;
        }

        public MetricsConfigBuilder setHistogramSupplier(PluginInfo info) {
            this.histogramSupplier = info;
            return this;
        }

        public MetricsConfigBuilder setHistoryHandler(PluginInfo info) {
            this.historyHandler = info;
            return this;
        }

        public MetricsConfig build() {
            return new MetricsConfig(this.metricReporterPlugins, this.hiddenSysProps, this.counterSupplier, this.meterSupplier, this.timerSupplier, this.histogramSupplier, this.historyHandler);
        }
    }
}

